package com.ejianc.business.zjkjcost.finish.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.zjkjcost.finish.bean.ApproveEntity;
import com.ejianc.business.zjkjcost.finish.mapper.ApproveMapper;
import com.ejianc.business.zjkjcost.finish.service.IApproveService;
import com.ejianc.business.zjkjcost.finish.vo.ApproveVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 竣工考核-目标责任书竣工兑现审批-主表
 * 
 * @author generator
 * 
 */
@Service("approveService")
public class ApproveServiceImpl extends BaseServiceImpl<ApproveMapper, ApproveEntity> implements IApproveService{

    @Override
    public ApproveVO getApproveByContractId(Long contractId) {
        List<Integer> statusList = new ArrayList<>();
        statusList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        statusList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        LambdaQueryWrapper<ApproveEntity> lambda = Wrappers.<ApproveEntity>lambdaQuery();
        lambda.eq(ApproveEntity::getContractId, contractId);
        lambda.in(ApproveEntity::getBillState, statusList);

        List<ApproveEntity> list = super.list(lambda);
        ApproveEntity approveEntity = new ApproveEntity();
        if (CollectionUtils.isNotEmpty(list)){
            approveEntity = list.get(0);
        }
        return BeanMapper.map(approveEntity, ApproveVO.class);
    }
}
