package com.ejianc.business.zjkjcost.reserve.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 变更类型
 */
public enum ChangeTypeEnum {


    /**
     * 变更类型: 0-未变更
     */
    未变更(0, "未变更"),

    /**
     * 变更类型: 1-新增项
     */
    新增项(1, "新增项"),

    /**
     * 变更类型: 2-变更项
     */
    变更项(2, "变更项"),

    /**
     * 变更类型: 3-删除项
     */
    删除项(3, "删除项");

    private Integer code;
    private String description;
    private static Map<Integer, ChangeTypeEnum> enumMap = new HashMap<>();

    ChangeTypeEnum(Integer code, String description){
        this.code = code;
        this.description = description;
    }
    public Integer getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    static {
        enumMap = EnumSet.allOf(ChangeTypeEnum.class).stream().collect(Collectors.toMap(ChangeTypeEnum::getCode, Function.identity(), (k1, k2) -> k2));
    }

    public static ChangeTypeEnum getEnumByCode(Integer billStateCode) {
        return enumMap.get(billStateCode);
    }

}

