package com.ejianc.business.zjkjcost.reserve.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zjkjcost.reserve.bean.AllocateDetailEntity;
import com.ejianc.business.zjkjcost.reserve.bean.AllocateEntity;
import com.ejianc.business.zjkjcost.reserve.enums.ChangeStateEnum;
import com.ejianc.business.zjkjcost.reserve.service.IAllocateService;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

@Service("allocate")
public class AllocateBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBillTypeApi billTypeApi;
	@Autowired
	private IAllocateService service;

	@Autowired
	private IParamConfigApi paramConfigApi;

	private Logger logger = LoggerFactory.getLogger(this.getClass());
	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
		logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());
		if(!res.isSuccess()) {
			return CommonResponse.error("当前单据已被下游业务引用，不能弃审！");
		}
		AllocateEntity allocateEntity = service.selectById(billId);
		logger.info("变更状态----"+allocateEntity.getChangeState());
		if(ChangeStateEnum.未变更.getCode()!=allocateEntity.getChangeState()){
			return CommonResponse.error("当前单据已变更，不能弃审！");
		}
		List<AllocateEntity> entities = service.list(new QueryWrapper<AllocateEntity>().eq("project_id", allocateEntity.getProjectId()).gt("create_time", allocateEntity.getCreateTime()));
		if (CollectionUtils.isNotEmpty(entities)) {
			return CommonResponse.error("该项目已生成新单据，不能弃审！");
		}
//		for (AllocateDetailEntity detailEntity : allocateEntity.getDetailList()) {
//			if (detailEntity.getReturnMortgageMny() != null && detailEntity.getReturnMortgageMny().compareTo(BigDecimal.ZERO) != 0) {
//				return CommonResponse.error("下游单据已回写返还金额，不能弃审！");
//			}
//			if (detailEntity.getMortgageMny() != null && detailEntity.getMortgageMny().compareTo(BigDecimal.ZERO) != 0) {
//				return CommonResponse.error("下游单据已回写转抵金额，不能弃审！");
//			}
//		}

		//报表已生成, 数据已被抓取的不能撤回
		CommonResponse<ParamRegisterSetVO> byCode = paramConfigApi.getByCode("P-P29C0z0304");
		if (!byCode.isSuccess()){
			throw new BusinessException("获取参数失败");
		}
		ParamRegisterSetVO paramRegisterSetVO = byCode.getData();
		String valueData = paramRegisterSetVO.getValueData();
		Date reportingTime = allocateEntity.getMonth();
//获取对应数据的报表生成日期
		Calendar calendar = Calendar.getInstance();
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
		calendar.setTime(reportingTime);
		calendar.add(Calendar.MONTH, 1);
		Date date = calendar.getTime();
		String period = sdf.format(date);
		String limit = period + "-"+valueData;
		SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM-dd");
		try {
			Date limitDate = ft.parse(limit);
			if (new Date().after(limitDate)){
				return CommonResponse.error("当前单据已生成运营分析报表,不能撤回!");
			}
		} catch (ParseException e) {
			e.printStackTrace();
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }*/
		return CommonResponse.success();
	}

}
