package com.ejianc.foundation.material.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 物资（周转）进场验证记录
 *
 * @author generator
 *
 */
public class MaterialapproachVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    private String billCode; // 单据编号
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date approveTime; // 审批日期
    private String remarks; // 备注
    private Long agentId; // 经办人
    private String agentName; // 经办人姓名
    private Long agentdepId; // 经办部门
    private String agentdepName; // 经办部门名称
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date billTime; // 单据日期
    private Long contractId; // 合同id
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private Long projectDepartmentId; // 项目部id
    private String contractName; // 合同名称
    private String projectName; // 项目名称
    private String contractCode; // 合同编号
    private Long supplierId; // 供应商id
    private String supplierName; // 供应商名称
    private String brandName; // 品牌
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date enterTime; // 进场日期
    private String projectMaterial; // 项目物资部
    private String projectEngineering; // 项目工程部
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date verificationTime; // 验证日期
    private Long subcontractorId; // 分包方id
    private String subcontractorName; // 分包方（使用单位）

    private String num; // 序号
    private String billTimeShow; //单据日期时间显示
    private String enterTimeShow; // 进场日期时间显示
    private String billStateStr; // 单据状态文本显示
    private String createTimeShow;
    private Long projectId; // 项目id
    private BigDecimal notStorageNum; // 未入库数量

    private Integer contractType; // 合同类型: 0物资采购；1周转材租赁

    private java.lang.Integer useFlag; // 引用标识0-未引用 1-已引用
    private java.lang.Integer checkType; // 验收类型1-自制验收,2-零星材料验收，3-发货验收
    private java.lang.Long sourceId; // 来源Id

    @ReferSerialTransfer(referCode="ejc-zjkj-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getCreateTimeShow() {
        return createTimeShow;
    }

    public void setCreateTimeShow(String createTimeShow) {
        this.createTimeShow = createTimeShow;
    }

    private List<MaterialapproachdetailVO> materialapproachdetailEntities = new ArrayList<>(); // 物资（周转）进场验证记录子表

    public String getNum() {
        return num;
    }

    public void setNum(String num) {
        this.num = num;
    }

    public String getBillTimeShow() {
        return billTimeShow;
    }

    public void setBillTimeShow(String billTimeShow) {
        this.billTimeShow = billTimeShow;
    }

    public String getEnterTimeShow() {
        return enterTimeShow;
    }

    public void setEnterTimeShow(String enterTimeShow) {
        this.enterTimeShow = enterTimeShow;
    }

    public String getBillStateStr() {
        return billStateStr;
    }

    public void setBillStateStr(String billStateStr) {
        this.billStateStr = billStateStr;
    }

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 审批日期
     */
    public java.util.Date getApproveTime() {
        return approveTime;
    }

    /**
     * 审批日期
     */
    public void setApproveTime(java.util.Date approveTime) {
        this.approveTime = approveTime;
    }
    /**
     * 备注
     */
    public String getRemarks() {
        return remarks;
    }

    /**
     * 备注
     */
    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }
    /**
     * 经办人
     */
    @ReferSerialTransfer(referCode = "idm-user")
    public Long getAgentId() {
        return agentId;
    }

    /**
     * 经办人
     */
    @ReferDeserialTransfer
    public void setAgentId(Long agentId) {
        this.agentId = agentId;
    }
    /**
     * 经办人姓名
     */
    public String getAgentName() {
        return agentName;
    }

    /**
     * 经办人姓名
     */
    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }
    /**
     * 经办部门
     */
    @ReferSerialTransfer(referCode = "idm-dept")
    public Long getAgentdepId() {
        return agentdepId;
    }

    /**
     * 经办部门
     */
    @ReferDeserialTransfer
    public void setAgentdepId(Long agentdepId) {
        this.agentdepId = agentdepId;
    }
    /**
     * 经办部门名称
     */
    public String getAgentdepName() {
        return agentdepName;
    }

    /**
     * 经办部门名称
     */
    public void setAgentdepName(String agentdepName) {
        this.agentdepName = agentdepName;
    }
    /**
     * 单据日期
     */
    public java.util.Date getBillTime() {
        return billTime;
    }

    /**
     * 单据日期
     */
    public void setBillTime(java.util.Date billTime) {
        this.billTime = billTime;
    }
    /**
     * 合同id
     */
    @ReferSerialTransfer(referCode = "ejc-zjkj-outcontract")
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同id
     */
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 所属组织id
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 所属组织id
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 所属组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 所属组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部id
     */
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    /**
     * 项目部id
     */
    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    /**
     * 合同id
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同id
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同编号
     */
    public String getContractCode() {
        return contractCode;
    }

    /**
     * 合同编号
     */
    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    /**
     * 供应商名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 供应商名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 品牌
     */
    public String getBrandName() {
        return brandName;
    }

    /**
     * 品牌
     */
    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }
    /**
     * 进场日期
     */
    public java.util.Date getEnterTime() {
        return enterTime;
    }

    /**
     * 进场日期
     */
    public void setEnterTime(java.util.Date enterTime) {
        this.enterTime = enterTime;
    }
    /**
     * 项目物资部
     */
    public String getProjectMaterial() {
        return projectMaterial;
    }

    /**
     * 项目物资部
     */
    public void setProjectMaterial(String projectMaterial) {
        this.projectMaterial = projectMaterial;
    }
    /**
     * 项目工程部
     */
    public String getProjectEngineering() {
        return projectEngineering;
    }

    /**
     * 项目工程部
     */
    public void setProjectEngineering(String projectEngineering) {
        this.projectEngineering = projectEngineering;
    }
    /**
     * 验证日期
     */
    public java.util.Date getVerificationTime() {
        return verificationTime;
    }

    /**
     * 验证日期
     */
    public void setVerificationTime(java.util.Date verificationTime) {
        this.verificationTime = verificationTime;
    }
    /**
     * 分包方id
     */
    @ReferSerialTransfer(referCode = "support-supplier")
    public Long getSubcontractorId() {
        return subcontractorId;
    }

    /**
     * 分包方id
     */
    @ReferDeserialTransfer
    public void setSubcontractorId(Long subcontractorId) {
        this.subcontractorId = subcontractorId;
    }
    /**
     * 分包方（使用单位）
     */
    public String getSubcontractorName() {
        return subcontractorName;
    }

    /**
     * 分包方（使用单位）
     */
    public void setSubcontractorName(String subcontractorName) {
        this.subcontractorName = subcontractorName;
    }

    public List<MaterialapproachdetailVO> getMaterialapproachdetailEntities() {
        return materialapproachdetailEntities;
    }

    public void setMaterialapproachdetailEntities(List<MaterialapproachdetailVO> materialapproachdetailEntities) {
        this.materialapproachdetailEntities = materialapproachdetailEntities;
    }

    public BigDecimal getNotStorageNum() {
        return notStorageNum;
    }

    public void setNotStorageNum(BigDecimal notStorageNum) {
        this.notStorageNum = notStorageNum;
    }

    public Integer getContractType() {
        return contractType;
    }

    public void setContractType(Integer contractType) {
        this.contractType = contractType;
    }

    public Integer getUseFlag() {
        return useFlag;
    }

    public void setUseFlag(Integer useFlag) {
        this.useFlag = useFlag;
    }

    public Integer getCheckType() {
        return checkType;
    }

    public void setCheckType(Integer checkType) {
        this.checkType = checkType;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
}
