package com.ejianc.foundation.material.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;


/**
 * 物资（周转）进场验证记录子表
 *
 * @author generator
 *
 */
public class MaterialapproachdetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long mid; // 主表id
    private String billCode; // 单据编号
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private String remarks; // 备注
    private Long agentId; // 经办人
    private String agentName; // 经办人姓名
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private Long projectDepartmentId; // 项目部id
    private String name; // 物资名称
    private String spec; // 规格型号
    private String unit; // 单位
    private BigDecimal enterCount; // 进场数量
    private BigDecimal verificationCount; // 验证数量
    private BigDecimal exitAccount; // 退场数量
    private BigDecimal repairAccount; // 维修数量
    private BigDecimal loseAccount; // 丢失数量
    private String verificationWay; // 验证方式
    private String code; // 质保资料及编号
    private String conclusion; // 验证结论
    private Long materialId; // 物资主键
    private String materialCode; // 物资编码
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private Long materialClassId; // 物资分类id
    private String materialClassCode; // 物资分类编码
    private String materialClassName; // 物资分类名称
    private BigDecimal notStorageNum; // 未入库数量
    private BigDecimal unitPriceIncluetax; // 单价（含税）（元）


    /**
     * 冗余字段
     */
    private BigDecimal amountIncluetax; // 含税金额
    private BigDecimal taxRate; // 税率
    private BigDecimal unitPriceEncluetax; // 单价（不含税）（元）
    private BigDecimal amountEncluetax; // 不含税金额


    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }

    private String errorMsg; // 导入错误信息

    public String getErrorMsg() {
        return errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    /**
     * 主表id
     */
    public Long getMid() {
        return mid;
    }

    /**
     * 主表id
     */
    public void setMid(Long mid) {
        this.mid = mid;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 备注
     */
    public String getRemarks() {
        return remarks;
    }

    /**
     * 备注
     */
    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }
    /**
     * 经办人
     */
    @ReferSerialTransfer(referCode = "idm-user")
    public Long getAgentId() {
        return agentId;
    }

    /**
     * 经办人
     */
    @ReferDeserialTransfer
    public void setAgentId(Long agentId) {
        this.agentId = agentId;
    }
    /**
     * 经办人姓名
     */
    public String getAgentName() {
        return agentName;
    }

    /**
     * 经办人姓名
     */
    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }
    /**
     * 所属组织id
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 所属组织id
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 所属组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 所属组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部id
     */
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    /**
     * 项目部id
     */
    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    /**
     * 物资名称
     */
    public String getName() {
        return name;
    }

    /**
     * 物资名称
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 规格型号
     */
    public String getSpec() {
        return spec;
    }

    /**
     * 规格型号
     */
    public void setSpec(String spec) {
        this.spec = spec;
    }
    /**
     * 单位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 单位
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }
    /**
     * 进场数量
     */
    public BigDecimal getEnterCount() {
        return enterCount;
    }

    /**
     * 进场数量
     */
    public void setEnterCount(BigDecimal enterCount) {
        this.enterCount = enterCount;
    }
    /**
     * 验证数量
     */
    public BigDecimal getVerificationCount() {
        return verificationCount;
    }

    /**
     * 验证数量
     */
    public void setVerificationCount(BigDecimal verificationCount) {
        this.verificationCount = verificationCount;
    }
    /**
     * 验证方式
     */
    public String getVerificationWay() {
        return verificationWay;
    }

    /**
     * 验证方式
     */
    public void setVerificationWay(String verificationWay) {
        this.verificationWay = verificationWay;
    }
    /**
     * 质保资料及编号
     */
    public String getCode() {
        return code;
    }

    /**
     * 质保资料及编号
     */
    public void setCode(String code) {
        this.code = code;
    }
    /**
     * 验证结论
     */
    public String getConclusion() {
        return conclusion;
    }

    /**
     * 验证结论
     */
    public void setConclusion(String conclusion) {
        this.conclusion = conclusion;
    }

    @ReferSerialTransfer(referCode="ejc-zjkj-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getMaterialClassId() {
        return materialClassId;
    }

    public void setMaterialClassId(Long materialClassId) {
        this.materialClassId = materialClassId;
    }

    public String getMaterialClassCode() {
        return materialClassCode;
    }

    public void setMaterialClassCode(String materialClassCode) {
        this.materialClassCode = materialClassCode;
    }

    public String getMaterialClassName() {
        return materialClassName;
    }

    public void setMaterialClassName(String materialClassName) {
        this.materialClassName = materialClassName;
    }

    public BigDecimal getNotStorageNum() {
        return notStorageNum;
    }

    public void setNotStorageNum(BigDecimal notStorageNum) {
        this.notStorageNum = notStorageNum;
    }

    public BigDecimal getExitAccount() {
        return exitAccount;
    }

    public void setExitAccount(BigDecimal exitAccount) {
        this.exitAccount = exitAccount;
    }

    public BigDecimal getRepairAccount() {
        return repairAccount;
    }

    public void setRepairAccount(BigDecimal repairAccount) {
        this.repairAccount = repairAccount;
    }

    public BigDecimal getLoseAccount() {
        return loseAccount;
    }

    public void setLoseAccount(BigDecimal loseAccount) {
        this.loseAccount = loseAccount;
    }

    public BigDecimal getUnitPriceIncluetax() {
        return unitPriceIncluetax;
    }

    public void setUnitPriceIncluetax(BigDecimal unitPriceIncluetax) {
        this.unitPriceIncluetax = unitPriceIncluetax;
    }

    public BigDecimal getAmountIncluetax() {
        return amountIncluetax;
    }

    public void setAmountIncluetax(BigDecimal amountIncluetax) {
        this.amountIncluetax = amountIncluetax;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getUnitPriceEncluetax() {
        return unitPriceEncluetax;
    }

    public void setUnitPriceEncluetax(BigDecimal unitPriceEncluetax) {
        this.unitPriceEncluetax = unitPriceEncluetax;
    }

    public BigDecimal getAmountEncluetax() {
        return amountEncluetax;
    }

    public void setAmountEncluetax(BigDecimal amountEncluetax) {
        this.amountEncluetax = amountEncluetax;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
}
