package com.ejianc.foundation.material.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 物资结存(新)
 *
 * @author generator
 *
 */
public class CheckVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String billCode; // 单据编号
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private Long projectDepartmentId; // 项目部id
    private String remarks; // 备注
    private Long agentId; // 经办人
    private String agentName; // 经办人姓名
    private Long deptId; // 经办部门id
    private String deptName; // 经办部门名称
    private Long storeId; // 仓库id
    private String storeName; // 仓库名称
    private BigDecimal lastCheckNum; // 上月结存数量
    private BigDecimal lastCheckTaxMny; // 上月结存金额（含税）
    private BigDecimal lastCheckMny; // 上月结存金额（无税）
    private BigDecimal checkNum; // 本月结存数量
    private BigDecimal checkTaxMny; // 本月结存金额（含税）
    private BigDecimal checkMny; // 本月结存金额（无税）
    private BigDecimal useNum; // 本月消耗数量
    private BigDecimal useTaxMny; // 本月消耗金额（含税）
    private BigDecimal useMny; // 本月消耗金额（无税）
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM", timezone = "GMT+8")
    private Date checkMonth; // 结存月份
    private Integer isSettlement; // 是否归集标记

    private List<CheckDetailVO> detailList = new ArrayList<>(); // 物资结存子表(新)

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode="ejc-zjkj-project")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }
    @ReferSerialTransfer(referCode="idm-user")
    public Long getAgentId() {
        return agentId;
    }
    @ReferDeserialTransfer
    public void setAgentId(Long agentId) {
        this.agentId = agentId;
    }
    public String getAgentName() {
        return agentName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }
    @ReferSerialTransfer(referCode = "idm-dept")
    public Long getDeptId() {
        return deptId;
    }
    @ReferDeserialTransfer
    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    @ReferSerialTransfer(referCode="StoreRef")
    public Long getStoreId() {
        return storeId;
    }
    @ReferDeserialTransfer
    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }
    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }
    public BigDecimal getLastCheckNum() {
        return lastCheckNum;
    }

    public void setLastCheckNum(BigDecimal lastCheckNum) {
        this.lastCheckNum = lastCheckNum;
    }
    public BigDecimal getLastCheckTaxMny() {
        return lastCheckTaxMny;
    }

    public void setLastCheckTaxMny(BigDecimal lastCheckTaxMny) {
        this.lastCheckTaxMny = lastCheckTaxMny;
    }
    public BigDecimal getLastCheckMny() {
        return lastCheckMny;
    }

    public void setLastCheckMny(BigDecimal lastCheckMny) {
        this.lastCheckMny = lastCheckMny;
    }
    public BigDecimal getCheckNum() {
        return checkNum;
    }

    public void setCheckNum(BigDecimal checkNum) {
        this.checkNum = checkNum;
    }
    public BigDecimal getCheckTaxMny() {
        return checkTaxMny;
    }

    public void setCheckTaxMny(BigDecimal checkTaxMny) {
        this.checkTaxMny = checkTaxMny;
    }
    public BigDecimal getCheckMny() {
        return checkMny;
    }

    public void setCheckMny(BigDecimal checkMny) {
        this.checkMny = checkMny;
    }

    public BigDecimal getUseNum() {
        return useNum;
    }

    public void setUseNum(BigDecimal useNum) {
        this.useNum = useNum;
    }

    public BigDecimal getUseTaxMny() {
        return useTaxMny;
    }

    public void setUseTaxMny(BigDecimal useTaxMny) {
        this.useTaxMny = useTaxMny;
    }

    public BigDecimal getUseMny() {
        return useMny;
    }

    public void setUseMny(BigDecimal useMny) {
        this.useMny = useMny;
    }

    public Date getCheckMonth() {
        return checkMonth;
    }

    public void setCheckMonth(Date checkMonth) {
        this.checkMonth = checkMonth;
    }
    public Integer getIsSettlement() {
        return isSettlement;
    }

    public void setIsSettlement(Integer isSettlement) {
        this.isSettlement = isSettlement;
    }

     public List<CheckDetailVO> getDetailList() {
        return detailList;
     }

     public void setDetailList(List<CheckDetailVO> checkDetailList) {
        this.detailList = checkDetailList;
     }
}
