package com.ejianc.foundation.material.api;

import com.ejianc.foundation.material.hystrix.MaterialapproachHystrix;
import com.ejianc.foundation.material.vo.CheckDetailVO;
import com.ejianc.foundation.material.vo.MaterialapproachVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;
import java.util.Map;

/**
 * 物资结存rpc服务
 *
 * @author cJ
 *
 */
@FeignClient(name= "ejc-zjkjmaterial-web", url="${common.env.feign-client-url}", path="ejc-zjkjmaterial-web", fallback = MaterialapproachHystrix.class)
public interface IMaterialapproachApi {

	/**
	 * 推送
	 */
	@PostMapping(value = "/api/materialapproach/push")
	CommonResponse<Long> push(@RequestBody MaterialapproachVO materialapproachVO);

	/**
	 * @Description 查询详情
	 **/
	@GetMapping(value = "/api/materialapproach/queryByCheckId")
	CommonResponse<MaterialapproachVO> queryByCheckId(@RequestParam(value = "checkId")Long checkId);

	/**
	 * 删除推送
	 */
	@GetMapping(value = "/api/materialapproach/delPush")
	CommonResponse<String> delPush(@RequestParam(value = "checkId")Long checkId);
	/**
	 * 获取验收量--总计划使用
	 */
	@GetMapping(value = "/api/materialapproach/getNumByProjectId")
	CommonResponse<Map<Long, BigDecimal>> getNumByProjectId(@RequestParam(value = "projectId") Long projectId);
}
