package com.ejianc.foundation.panhuo.order.vo;

import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 调拨订单操作记录表
 * 
 * @author generator
 * 
 */
public class AllotOrderOperationRecordVO extends BaseVO {

    private static final long serialVersionUID = 6716275939269192704L;

    public static final String EVENT_OUT_ORDER_COMMIT = "订单提交审批";
    public static final String EVENT_OUT_ORDER_PASTED = "订单审批通过";
    public static final String EVENT_OUT_ORDER_ABANDON = "调出方订单审批驳回";
    public static final String EVENT_ORDER_CANCEL = "调入/出方调拨订单取消";
    public static final String EVENT_ORDER_SAVE_EDIT = "调拨订单编辑/入库编辑";
    public static final String EVENT_ORDER_SAVE_INSTORE = "调拨订单收货入库";
    public static final String EVENT_IN_ORDER_COMFIRM = "调入方调拨订单确认";

    public static final Integer OPR_USER_TYPE_OUT = 1;
    public static final Integer OPR_USER_TYPE_IN = 2;

    private Long orderId; // 订单Id
    private String orderCode; //订单编码
    private Long oprUserId; // 操作人id
    private String event; //事件
    private String oprUserName; // 操作人名称
    private String oprUserCode; // 操作人编码
    private Integer oprUseType; //操作方：1-调出方，2-调入方
    private String oprDesc; // 操作描述
    private Integer beforeBusinessStatus; // 操作前订单状态：1-调出方待确认，2-调入方洽商待确认，3-调入方洽商已确认，4-调出方审批中，5-调入方待收货，6-交易完成， 7-调出方取消，8-调入方取消

    /**
     * 实现 Cloneable 克隆拷贝
     * 创建一个 默认 对象，用于作为克隆的源数据
     */
    private static final AllotOrderOperationRecordVO record = new AllotOrderOperationRecordVO();

    /**
     * 获取克隆对象, 避免new的方式创建
     * @return {@link AllotOrderOperationRecordVO}
     */
    public static AllotOrderOperationRecordVO getInstance(){
        try {
            return record.clone();
        } catch (CloneNotSupportedException e) {
            return new AllotOrderOperationRecordVO();
        }
    }

    /**
     * 重写克隆方法
     * @return {@link AllotOrderOperationRecordVO}
     */
    public AllotOrderOperationRecordVO clone() throws CloneNotSupportedException {
        return (AllotOrderOperationRecordVO) super.clone();
    }

    private AllotOrderOperationRecordVO(){
    }

    public String getOrderCode() {
        return orderCode;
    }

    public void setOrderCode(String orderCode) {
        this.orderCode = orderCode;
    }

    public Integer getOprUseType() {
        return oprUseType;
    }

    public void setOprUseType(Integer oprUseType) {
        this.oprUseType = oprUseType;
    }

    public String getEvent() {
        return event;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public Long getOrderId() {
        return orderId;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }
    public Long getOprUserId() {
        return oprUserId;
    }

    public void setOprUserId(Long oprUserId) {
        this.oprUserId = oprUserId;
    }
    public String getOprUserName() {
        return oprUserName;
    }

    public void setOprUserName(String oprUserName) {
        this.oprUserName = oprUserName;
    }
    public String getOprUserCode() {
        return oprUserCode;
    }

    public void setOprUserCode(String oprUserCode) {
        this.oprUserCode = oprUserCode;
    }
    public String getOprDesc() {
        return oprDesc;
    }

    public void setOprDesc(String oprDesc) {
        this.oprDesc = oprDesc;
    }
    public Integer getBeforeBusinessStatus() {
        return beforeBusinessStatus;
    }

    public void setBeforeBusinessStatus(Integer beforeBusinessStatus) {
        this.beforeBusinessStatus = beforeBusinessStatus;
    }
    
}
