package com.ejianc.foundation.material.api;

import com.ejianc.foundation.material.hystrix.StoreBalanceHystrix;
import com.ejianc.foundation.material.vo.CostanalysistaxVO;
import com.ejianc.foundation.material.vo.StoreBalanceDetailVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

/**
 * 物资结存rpc服务
 *
 * @author cJ
 *
 */
@FeignClient(name= "ejc-zjkjmaterial-web", url="${common.env.feign-client-url}", path="ejc-zjkjmaterial-web", fallback = StoreBalanceHystrix.class)
public interface IStoreBalanceApi {

	/**
	 * 根据合同id查询物资结存-该月消耗
	 *
	 * @param projectId
	 * @param month
	 * @param materialCategoryCode 物资分类code
	 * @return
	 */
	@GetMapping("/api/storeBalance/queryOutStore")
	CommonResponse<StoreBalanceDetailVO> queryOutStore(@RequestParam(value = "projectId") Long projectId, @RequestParam(value = "month") String month, @RequestParam(value = "materialCategoryCode") String materialCategoryCode);


	/**
	 * 成本管理-项目成本月度分析报告-税金
	 *
	 * @param projectId
	 * @param time
	 * @return
	 */
	@GetMapping("/api/storeBalance/queryCostanalysisTax")
	CommonResponse<CostanalysistaxVO> queryCostanalysisTax(@RequestParam(value = "projectId") Long projectId, @RequestParam(value = "time") String time);
	/**
	 * 根据项目id和月度查询物资结存本月消耗
	 * @param projectId 项目id
	 * @param month     月份
	 * @return
	 */
	@GetMapping(value = "/api/storeBalance/queryMaterialConsumeMonth")
	CommonResponse<Map<String,StoreBalanceDetailVO>> queryMaterialConsumeMonth(@RequestParam(value = "projectId") Long projectId, @RequestParam(value = "month") String month);
	/**
	 * @Description //TODO 月度成本分析物资结存单据更新归集状态字段
	 *
	 * @param projectId 项目id
	 * @param state    归集状态
	 * @param monthStr 要归集单据数据的时间范围
	 * @return com.ejianc.framework.core.response.CommonResponse
	 * @createDate 2023/1/12
	 * @author yupengjie
	 **/
	@GetMapping(value = "/api/storeBalance/updateSettlementState")
	CommonResponse<String> updateMidSettlementState(@RequestParam(value = "projectId")Long projectId,
													@RequestParam(value = "state")Integer state,
													@RequestParam(value = "monthStr")String monthStr);
	/**
	 * @Description //TODO 查询校验物资结存单据是否存在往期单据中未归集的数据
	 *
	 * @param projectId 项目id
	 * @param monthStr 要归集单据数据的时间范围
	 * @return com.ejianc.framework.core.response.CommonResponse
	 * @createDate 2023/1/12
	 * @author yupengjie
	 **/
	@GetMapping(value = "/api/storeBalance/queryIsSettlement")
	CommonResponse<String> queryIsSettlement(@RequestParam(value = "projectId")Long projectId,
											 @RequestParam(value = "monthStr")String monthStr);
}
