package com.ejianc.foundation.panhuo.shelf.api;

import com.ejianc.foundation.panhuo.shelf.hystrix.ZjkjGoodsHystrix;
import com.ejianc.foundation.panhuo.shelf.vo.GoodsVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author yqls
 * @version 1.0
 * @description: 闲置物资上架api
 * @date 2024/01/04
 */
@FeignClient(name = "ejc-zjkjmaterial-web", url = "${common.env.feign-client-url}", path = "ejc-zjkjmaterial-web", fallback = ZjkjGoodsHystrix.class)
public interface IZjkjGoodsApi {

    /**
     * 根据组织主键，查询本下云仓，汇总剩余上架金额
     *
     * @param storeIds
     * @return
     * @Author yqls
     */
    @PostMapping(value = "/api/goods/querySurplusShelfMny")
    CommonResponse<List<GoodsVO>> querySurplusShelfMny(@RequestBody List<Long> storeIds);

}
