package com.ejianc.foundation.material.api;

import com.ejianc.foundation.material.hystrix.CheckHystrix;
import com.ejianc.foundation.material.vo.CheckDetailVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * 物资结存rpc服务
 *
 * @author cJ
 *
 */
@FeignClient(name= "ejc-zjkjmaterial-web", url="${common.env.feign-client-url}", path="ejc-zjkjmaterial-web", fallback = CheckHystrix.class)
public interface ICheckApi {

	/**
	 * 根据项目id和月度查询物资结存本月消耗
	 * @param projectId 项目id
	 * @param checkMonth     月份
	 * @return
	 */
	@GetMapping(value = "/api/check/queryCheckByMonth")
	CommonResponse<Map<String, CheckDetailVO>> queryCheckByMonth(@RequestParam(value = "projectId")Long projectId,
										@RequestParam(value = "checkMonth")String checkMonth);
	/**
	 * @Description 月度成本分析物资结存单据更新归集状态字段
	 *
	 * @param projectId 项目id
	 * @param checkMonth 要归集单据数据的时间范围
	 * @return com.ejianc.framework.core.response.CommonResponse
	 * @createDate 2023/1/12
	 * @author yupengjie
	 **/
	@GetMapping(value = "/api/check/getCheckFlag")
	CommonResponse<String> getCheckFlag(@RequestParam(value = "projectId")Long projectId,
													@RequestParam(value = "checkMonth")String checkMonth);
	/**
	 * @Description 月度成本分析物资结存单据更新归集状态字段
	 *
	 * @param projectId 项目id
	 * @param state    归集状态
	 * @param checkMonth 要归集单据数据的时间范围
	 * @return com.ejianc.framework.core.response.CommonResponse
	 * @createDate 2023/1/12
	 * @author yupengjie
	 **/
	@GetMapping(value = "/api/check/updateSettlementState")
	CommonResponse<String> updateSettlementState(@RequestParam(value = "projectId")Long projectId,
													@RequestParam(value = "state")Integer state,
													@RequestParam(value = "checkMonth")String checkMonth);
	/**
	 * @Description 根据物资验收入库id更新引用状态
	 *
	 * @param ids 物资验收入库id
	 *            useStatus 占用状态 1-未占用,2-全部占用
	 **/
	@GetMapping(value = "/api/check/updateWareHousingUseStatus")
	CommonResponse<String> updateWareHousingUseStatus(@RequestParam(value = "ids")List<Long> ids,Integer useStatus);
}
