package com.ejianc.foundation.panhuo.shelf.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 物资上架申请
 *
 * @author generator
 *
 */
public class ShelfVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String createUserName; // 创建人名称
    private Integer billState; // 单据状态（审批必须字段）
    private String billCode; // 单据编号
    private Long projectId; // 项目主键
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private Long orgId; // 组织主键
    private String orgCode; // 所属单位编码
    private String orgName; // 组织名称
    private Long parentOrgId; // 上级组织id
    private String parentOrgCode; // 上级组织编码
    private String parentOrgName; // 上级组织name
    private String materialTypeNames; // 物料分类名称
    private String address; // 地址
    private Long sellUserId; // 联系人
    private String sellerUserCode; // 联系人编码
    private String sellUserName; // 联系人名称
    private String sellUserPhone; // 联系人电话
    private BigDecimal nums; // 上架数量
    private BigDecimal shelfMny; // 上架总金额
    private BigDecimal shelfTaxMny; // 上架总金额(含税)
    private Long employeeId; // 经办人id
    private String employeeName; // 经办人名称
    private Long corpId; // 分子公司
    private String corpCode; // 分子公司编码
    private String corpName; // 分子公司名称
    private Integer storeType; // 仓库类型 1-项目；2-大区
    private Long cloudStoreId; // 云仓id
    private String cloudStoreName; // 云仓名称
    private String memo; // 备注
    private Long createUserId;// 制单人Id

    private String billStateName; // 单据状态名称

    private List<ShelfDetailVO> detailList = new ArrayList<>(); // 物资上架申请清单

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @ReferSerialTransfer(referCode="ejc-zjkj-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getMaterialTypeNames() {
        return materialTypeNames;
    }

    public void setMaterialTypeNames(String materialTypeNames) {
        this.materialTypeNames = materialTypeNames;
    }
    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getSellUserId() {
        return sellUserId;
    }

    @ReferDeserialTransfer
    public void setSellUserId(Long sellUserId) {
        this.sellUserId = sellUserId;
    }

    public String getSellerUserCode() {
        return sellerUserCode;
    }

    public void setSellerUserCode(String sellerUserCode) {
        this.sellerUserCode = sellerUserCode;
    }
    public String getSellUserName() {
        return sellUserName;
    }

    public void setSellUserName(String sellUserName) {
        this.sellUserName = sellUserName;
    }
    public String getSellUserPhone() {
        return sellUserPhone;
    }

    public void setSellUserPhone(String sellUserPhone) {
        this.sellUserPhone = sellUserPhone;
    }
    public BigDecimal getNums() {
        return nums;
    }

    public void setNums(BigDecimal nums) {
        this.nums = nums;
    }
    public BigDecimal getShelfMny() {
        return shelfMny;
    }

    public void setShelfMny(BigDecimal shelfMny) {
        this.shelfMny = shelfMny;
    }
    public BigDecimal getShelfTaxMny() {
        return shelfTaxMny;
    }

    public void setShelfTaxMny(BigDecimal shelfTaxMny) {
        this.shelfTaxMny = shelfTaxMny;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getCorpId() {
        return corpId;
    }

    public void setCorpId(Long corpId) {
        this.corpId = corpId;
    }
    public String getCorpCode() {
        return corpCode;
    }

    public void setCorpCode(String corpCode) {
        this.corpCode = corpCode;
    }
    public String getCorpName() {
        return corpName;
    }

    public void setCorpName(String corpName) {
        this.corpName = corpName;
    }
    public Integer getStoreType() {
        return storeType;
    }

    public void setStoreType(Integer storeType) {
        this.storeType = storeType;
    }
    public Long getCloudStoreId() {
        return cloudStoreId;
    }

    public void setCloudStoreId(Long cloudStoreId) {
        this.cloudStoreId = cloudStoreId;
    }
    public String getCloudStoreName() {
        return cloudStoreName;
    }

    public void setCloudStoreName(String cloudStoreName) {
        this.cloudStoreName = cloudStoreName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }

    public List<ShelfDetailVO> getDetailList() {
        return detailList;
     }

     public void setDetailList(List<ShelfDetailVO> detailList) {
        this.detailList = detailList;
     }
}
