/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.material.bean.FlowmeterEntity;
import com.ejianc.business.material.bean.RealtimebalanceEntity;
import com.ejianc.business.material.bean.WastematerialresultEntity;
import com.ejianc.business.material.bean.WastematerialresulttailEntity;
import com.ejianc.business.material.service.IFlowmeterService;
import com.ejianc.business.material.service.IRealtimebalanceService;
import com.ejianc.business.material.service.IWastematerialresultService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="wastematerialresult")
public class WastematerialresultBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IWastematerialresultService wastematerialresultService;
    @Autowired
    private IRealtimebalanceService realtimebalanceService;
    @Autowired
    private IFlowmeterService flowmeterService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u51fa\u5e93\u63d0\u4ea4--------------");
        WastematerialresultEntity wastematerialresultEntity = (WastematerialresultEntity)((Object)this.wastematerialresultService.selectById(billId));
        ArrayList<FlowmeterEntity> list = new ArrayList<FlowmeterEntity>();
        ArrayList<RealtimebalanceEntity> realList = new ArrayList<RealtimebalanceEntity>();
        ArrayList realList1 = new ArrayList();
        List<WastematerialresulttailEntity> wastematerialresulttailEntities = wastematerialresultEntity.getWastematerialresulttailEntities();
        if (wastematerialresulttailEntities != null && wastematerialresulttailEntities.size() > 0) {
            for (WastematerialresulttailEntity entity : wastematerialresulttailEntities) {
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"project_id", (Object)entity.getProjectId());
                queryWrapper.eq((Object)"material_code", (Object)entity.getMaterialCode());
                queryWrapper.eq((Object)"material_category_code", (Object)entity.getMaterialCategoryCode());
                queryWrapper.eq((Object)"store_id", (Object)entity.getStoreId());
                RealtimebalanceEntity realtimebalanceEntity = (RealtimebalanceEntity)((Object)this.realtimebalanceService.getOne((Wrapper)queryWrapper));
                if (realtimebalanceEntity != null) {
                    if (realtimebalanceEntity.getQuantity().compareTo(BigDecimal.ZERO) == 0 || realtimebalanceEntity.getQuantity().compareTo(entity.getMaterialNumber()) < 0) {
                        throw new BusinessException("\u7269\u8d44\u7f16\u7801:" + entity.getMaterialCode() + ",\u7269\u8d44\u540d\u79f0:" + entity.getMaterialName() + "\u5e93\u5b58\u4e0d\u8db3\uff0c\u65e0\u6cd5\u5904\u7f6e\u786e\u8ba4!");
                    }
                    FlowmeterEntity flowmeterEntity = this.createrFlowmeter(wastematerialresultEntity, entity);
                    list.add(flowmeterEntity);
                    realtimebalanceEntity.setQuantity(realtimebalanceEntity.getQuantity().subtract(entity.getMaterialNumber()));
                    if (realtimebalanceEntity.getQuantity().compareTo(BigDecimal.ZERO) != 0) {
                        realtimebalanceEntity.setAmountIncluetax(realtimebalanceEntity.getAmountIncluetax().subtract(entity.getAmountIncluetax()));
                        realtimebalanceEntity.setAmountExcluetax(realtimebalanceEntity.getAmountExcluetax().subtract(entity.getAmountExcluetax()));
                        realtimebalanceEntity.setUnitPriceIncluetax(realtimebalanceEntity.getAmountIncluetax().divide(realtimebalanceEntity.getQuantity(), 8, 4));
                        realtimebalanceEntity.setUnitPriceExcluetax(realtimebalanceEntity.getAmountExcluetax().divide(realtimebalanceEntity.getQuantity(), 8, 4));
                    } else {
                        realtimebalanceEntity.setAmountIncluetax(new BigDecimal(0.0));
                        realtimebalanceEntity.setAmountExcluetax(new BigDecimal(0.0));
                        realtimebalanceEntity.setUnitPriceIncluetax(new BigDecimal(0.0));
                        realtimebalanceEntity.setUnitPriceExcluetax(new BigDecimal(0.0));
                    }
                    realList.add(realtimebalanceEntity);
                    continue;
                }
                throw new BusinessException("\u8be5\u7269\u8d44\u7f16\u7801:" + entity.getMaterialCode() + "\uff0c\u7269\u8d44\u540d\u79f0:" + entity.getMaterialName() + "\u6ca1\u6709\u5e93\u5b58\uff0c\u65e0\u6cd5\u5904\u7f6e\u786e\u8ba4!");
            }
            if (list.size() > 0) {
                this.flowmeterService.saveBatch(list, list.size());
            }
            if (realList.size() > 0) {
                this.realtimebalanceService.updateBatchById(realList, realList.size());
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u5904\u7f6e\u64a4\u56de--------------");
        WastematerialresultEntity wastematerialresultEntity = (WastematerialresultEntity)((Object)this.wastematerialresultService.selectById(billId));
        ArrayList<FlowmeterEntity> list = new ArrayList<FlowmeterEntity>();
        ArrayList<RealtimebalanceEntity> realList = new ArrayList<RealtimebalanceEntity>();
        ArrayList realList1 = new ArrayList();
        List<WastematerialresulttailEntity> wastematerialresulttailEntities = wastematerialresultEntity.getWastematerialresulttailEntities();
        if (wastematerialresulttailEntities.size() > 0 && wastematerialresulttailEntities != null) {
            for (WastematerialresulttailEntity entity : wastematerialresulttailEntities) {
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"detail_id", (Object)entity.getId());
                FlowmeterEntity flowmeterEntity = (FlowmeterEntity)((Object)this.flowmeterService.getOne((Wrapper)queryWrapper));
                list.add(flowmeterEntity);
                QueryWrapper queryWrapper1 = new QueryWrapper();
                queryWrapper1.eq((Object)"project_id", (Object)wastematerialresultEntity.getProjectId());
                queryWrapper1.eq((Object)"material_category_code", (Object)entity.getMaterialCategoryCode());
                queryWrapper1.eq((Object)"material_code", (Object)entity.getMaterialCode());
                queryWrapper1.eq((Object)"store_id", (Object)entity.getStoreId());
                RealtimebalanceEntity realtimebalanceEntity = (RealtimebalanceEntity)((Object)this.realtimebalanceService.getOne((Wrapper)queryWrapper1));
                realtimebalanceEntity.setQuantity(realtimebalanceEntity.getQuantity().add(entity.getMaterialNumber()));
                realtimebalanceEntity.setAmountIncluetax(realtimebalanceEntity.getAmountIncluetax().add(entity.getAmountIncluetax()));
                realtimebalanceEntity.setAmountExcluetax(realtimebalanceEntity.getAmountExcluetax().add(entity.getAmountExcluetax()));
                if (realtimebalanceEntity.getQuantity().compareTo(BigDecimal.ZERO) != 0) {
                    realtimebalanceEntity.setUnitPriceIncluetax(realtimebalanceEntity.getAmountIncluetax().divide(realtimebalanceEntity.getQuantity(), 8, 4));
                    realtimebalanceEntity.setUnitPriceExcluetax(realtimebalanceEntity.getAmountExcluetax().divide(realtimebalanceEntity.getQuantity(), 8, 4));
                } else {
                    realtimebalanceEntity.setUnitPriceIncluetax(new BigDecimal(0.0));
                    realtimebalanceEntity.setUnitPriceExcluetax(new BigDecimal(0.0));
                }
                realList.add(realtimebalanceEntity);
            }
            if (list.size() > 0) {
                this.flowmeterService.removeByIds(list.stream().map(BaseEntity::getId).collect(Collectors.toList()), true);
            }
            if (realList.size() > 0) {
                this.realtimebalanceService.updateBatchById(realList, realList.size());
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u5904\u7f6e\u5f03\u5ba1--------------");
        WastematerialresultEntity wastematerialresultEntity = (WastematerialresultEntity)((Object)this.wastematerialresultService.selectById(billId));
        ArrayList<FlowmeterEntity> list = new ArrayList<FlowmeterEntity>();
        ArrayList<RealtimebalanceEntity> realList = new ArrayList<RealtimebalanceEntity>();
        ArrayList realList1 = new ArrayList();
        List<WastematerialresulttailEntity> wastematerialresulttailEntities = wastematerialresultEntity.getWastematerialresulttailEntities();
        if (wastematerialresulttailEntities.size() > 0 && wastematerialresulttailEntities != null) {
            for (WastematerialresulttailEntity entity : wastematerialresulttailEntities) {
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"detail_id", (Object)entity.getId());
                FlowmeterEntity flowmeterEntity = (FlowmeterEntity)((Object)this.flowmeterService.getOne((Wrapper)queryWrapper));
                list.add(flowmeterEntity);
                QueryWrapper queryWrapper1 = new QueryWrapper();
                queryWrapper1.eq((Object)"project_id", (Object)wastematerialresultEntity.getProjectId());
                queryWrapper1.eq((Object)"material_category_code", (Object)entity.getMaterialCategoryCode());
                queryWrapper1.eq((Object)"material_code", (Object)entity.getMaterialCode());
                queryWrapper1.eq((Object)"store_id", (Object)entity.getStoreId());
                RealtimebalanceEntity realtimebalanceEntity = (RealtimebalanceEntity)((Object)this.realtimebalanceService.getOne((Wrapper)queryWrapper1));
                realtimebalanceEntity.setQuantity(realtimebalanceEntity.getQuantity().add(entity.getMaterialNumber()));
                realtimebalanceEntity.setAmountIncluetax(realtimebalanceEntity.getAmountIncluetax().add(entity.getAmountIncluetax()));
                realtimebalanceEntity.setAmountExcluetax(realtimebalanceEntity.getAmountExcluetax().add(entity.getAmountExcluetax()));
                if (realtimebalanceEntity.getQuantity().compareTo(BigDecimal.ZERO) != 0) {
                    realtimebalanceEntity.setUnitPriceIncluetax(realtimebalanceEntity.getAmountIncluetax().divide(realtimebalanceEntity.getQuantity(), 8, 4));
                    realtimebalanceEntity.setUnitPriceExcluetax(realtimebalanceEntity.getAmountExcluetax().divide(realtimebalanceEntity.getQuantity(), 8, 4));
                } else {
                    realtimebalanceEntity.setUnitPriceIncluetax(new BigDecimal(0.0));
                    realtimebalanceEntity.setUnitPriceExcluetax(new BigDecimal(0.0));
                }
                realList.add(realtimebalanceEntity);
            }
            if (list.size() > 0) {
                this.flowmeterService.removeByIds(list.stream().map(BaseEntity::getId).collect(Collectors.toList()), true);
            }
            if (realList.size() > 0) {
                this.realtimebalanceService.updateBatchById(realList, realList.size());
            }
        }
        return CommonResponse.success();
    }

    private FlowmeterEntity createrFlowmeter(WastematerialresultEntity wastematerialresultEntity, WastematerialresulttailEntity entity) {
        FlowmeterEntity flowmeterEntity = new FlowmeterEntity();
        flowmeterEntity.setMid(wastematerialresultEntity.getId());
        flowmeterEntity.setDetailId(entity.getId());
        flowmeterEntity.setBillCode(wastematerialresultEntity.getBillCode());
        flowmeterEntity.setProjectId(entity.getProjectId());
        flowmeterEntity.setProjectName(entity.getProjectName());
        flowmeterEntity.setStoreId(entity.getStoreId());
        flowmeterEntity.setStoreName(entity.getStoreName());
        flowmeterEntity.setMaterialCode(entity.getMaterialCode());
        flowmeterEntity.setMaterialName(entity.getMaterialName());
        flowmeterEntity.setMaterialCategoryId(entity.getMaterialCategoryId());
        flowmeterEntity.setMaterialCategoryCode(entity.getMaterialCategoryCode());
        flowmeterEntity.setMaterialCategoryName(entity.getMaterialCategoryName());
        flowmeterEntity.setOperationType("\u51fa\u5e93");
        flowmeterEntity.setAccessType("\u5904\u7f6e");
        flowmeterEntity.setQuantity(entity.getMaterialNumber());
        flowmeterEntity.setUnitPriceIncluetax(entity.getUnitPriceIncluetax());
        flowmeterEntity.setUnitPriceExcluetax(entity.getUnitPriceExcluetax());
        flowmeterEntity.setAmountIncluetax(entity.getAmountIncluetax());
        flowmeterEntity.setAmountExcluetax(entity.getAmountExcluetax());
        flowmeterEntity.setTime(entity.getPuinTime());
        flowmeterEntity.setOrgId(wastematerialresultEntity.getOrgId());
        flowmeterEntity.setOrgName(wastematerialresultEntity.getOrgName());
        flowmeterEntity.setMeasurementUnit(entity.getMaterialUnit());
        flowmeterEntity.setSpecialModel(entity.getMaterialSpecifications());
        flowmeterEntity.setProjectDepartmentId(wastematerialresultEntity.getProjectDepartmentId());
        return flowmeterEntity;
    }
}

