/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.excel;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.material.service.IDeliveryrecorddetailService;
import com.ejianc.business.material.vo.DeliveryrecorddetailVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"deliveryrecorddetailExport"})
public class ExeclMaterialDeliveryrecordController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IDeliveryrecorddetailService iDeliveryrecorddetailService;

    @RequestMapping(value={"/downloadDeliveryrecorddetail"})
    @ResponseBody
    public void downloadDeliveryrecorddetaildetail(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"deliveryrecorddetail-import.xlsx", (String)"\u7269\u8d44\u51fa\u5e93\u8bb0\u5f55\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportDeliveryrecorddetail"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportDeliveryrecorddetail(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<DeliveryrecorddetailVO> successList = new ArrayList<DeliveryrecorddetailVO>();
        ArrayList<DeliveryrecorddetailVO> errorList = new ArrayList<DeliveryrecorddetailVO>();
        HashMap map = new HashMap();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            for (int i = 1; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                StringBuilder errorsMsgBuilder = new StringBuilder();
                String materialCategoryCode = (String)datas.get(0);
                String materialCategoryName = (String)datas.get(1);
                String materialCode = (String)datas.get(2);
                String materialName = (String)datas.get(3);
                String specialModel = (String)datas.get(4);
                String measurementUnit = (String)datas.get(5);
                String deliveryQuantity = (String)datas.get(6);
                String unitPriceIncluetax = (String)datas.get(7);
                String taxRate = (String)datas.get(8);
                String unitPriceExcluetax = (String)datas.get(9);
                String amountIncluetax = (String)datas.get(10);
                String amountExcluetax = (String)datas.get(11);
                String remarks = (String)datas.get(12);
                DeliveryrecorddetailVO deliveryrecorddetailVO = new DeliveryrecorddetailVO();
                deliveryrecorddetailVO.setId(IdWorker.getId());
                deliveryrecorddetailVO.setMaterialCategoryCode(StringUtils.isNotBlank((CharSequence)materialCategoryCode) ? materialCategoryCode : null);
                deliveryrecorddetailVO.setMaterialCategoryName(StringUtils.isNotBlank((CharSequence)materialCategoryName) ? materialCategoryName : null);
                deliveryrecorddetailVO.setMaterialCode(StringUtils.isNotBlank((CharSequence)materialCode) ? materialCode : null);
                deliveryrecorddetailVO.setMaterialName(StringUtils.isNotBlank((CharSequence)materialName) ? materialName : null);
                deliveryrecorddetailVO.setSpecialModel(StringUtils.isNotBlank((CharSequence)specialModel) ? specialModel : null);
                deliveryrecorddetailVO.setMeasurementUnit(StringUtils.isNotBlank((CharSequence)measurementUnit) ? measurementUnit : null);
                if (!TextUtils.isEmpty((CharSequence)deliveryQuantity) && !NumberUtil.isNumber((String)deliveryQuantity)) {
                    deliveryrecorddetailVO.setErrorMsg("\u51fa\u5e93\u6570\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u51fa\u5e93\u6570\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    deliveryrecorddetailVO.setDeliveryQuantity(StringUtils.isNotBlank((CharSequence)deliveryQuantity) ? new BigDecimal(deliveryQuantity) : null);
                }
                if (!TextUtils.isEmpty((CharSequence)unitPriceIncluetax) && !NumberUtil.isNumber((String)unitPriceIncluetax)) {
                    deliveryrecorddetailVO.setErrorMsg("\u5355\u4ef7\uff08\u542b\u7a0e\uff09\uff08\u5143\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u5355\u4ef7\uff08\u542b\u7a0e\uff09\uff08\u5143\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    deliveryrecorddetailVO.setUnitPriceIncluetax(StringUtils.isNotBlank((CharSequence)unitPriceIncluetax) ? new BigDecimal(unitPriceIncluetax) : null);
                }
                if (!TextUtils.isEmpty((CharSequence)taxRate) && !NumberUtil.isNumber((String)taxRate)) {
                    deliveryrecorddetailVO.setErrorMsg("\u7a0e\u7387\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u7a0e\u7387\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    deliveryrecorddetailVO.setTaxRate(StringUtils.isNotBlank((CharSequence)taxRate) ? new BigDecimal(taxRate) : null);
                }
                if (!TextUtils.isEmpty((CharSequence)unitPriceExcluetax) && !NumberUtil.isNumber((String)unitPriceExcluetax)) {
                    deliveryrecorddetailVO.setErrorMsg("\u5355\u4ef7\uff08\u65e0\u7a0e\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u5355\u4ef7\uff08\u65e0\u7a0e\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    deliveryrecorddetailVO.setUnitPriceExcluetax(StringUtils.isNotBlank((CharSequence)unitPriceExcluetax) ? new BigDecimal(unitPriceExcluetax) : null);
                }
                if (!TextUtils.isEmpty((CharSequence)amountIncluetax) && !NumberUtil.isNumber((String)amountIncluetax)) {
                    deliveryrecorddetailVO.setErrorMsg("\u91d1\u989d\uff08\u542b\u7a0e\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u91d1\u989d\uff08\u542b\u7a0e\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    deliveryrecorddetailVO.setAmountIncluetax(StringUtils.isNotBlank((CharSequence)amountIncluetax) ? new BigDecimal(amountIncluetax) : null);
                }
                if (!TextUtils.isEmpty((CharSequence)amountExcluetax) && !NumberUtil.isNumber((String)amountExcluetax)) {
                    deliveryrecorddetailVO.setErrorMsg("\u91d1\u989d\uff08\u65e0\u7a0e\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u91d1\u989d\uff08\u65e0\u7a0e\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    deliveryrecorddetailVO.setAmountExcluetax(StringUtils.isNotBlank((CharSequence)amountExcluetax) ? new BigDecimal(amountExcluetax) : null);
                }
                if (!TextUtils.isEmpty((CharSequence)remarks) && !NumberUtil.isNumber((String)remarks)) {
                    deliveryrecorddetailVO.setErrorMsg("\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u8d28\u91cf\u8bc1\u660e\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    deliveryrecorddetailVO.setRemarks(StringUtils.isNotBlank((CharSequence)remarks) ? new String(remarks) : null);
                }
                if (errorsMsgBuilder.length() > 0) {
                    errorList.add(deliveryrecorddetailVO);
                    continue;
                }
                successList.add(deliveryrecorddetailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        DeliveryrecorddetailVO resVo = new DeliveryrecorddetailVO();
        json.put("total", successList);
        json.put("total", (Object)resVo);
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/excelExportDeliveryrecorddetailFromDatabase"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportDeliveryrecorddetailFromDatabase(@RequestBody DeliveryrecorddetailVO deliveryrecorddetailVO, HttpServletResponse response) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"mid", (Object)deliveryrecorddetailVO.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.iDeliveryrecorddetailService.list((Wrapper)queryWrapper);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("deliveryrecorddetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExportDeliveryrecorddetailFromPage"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportDeliveryrecorddetailFromPage(@RequestBody List<DeliveryrecorddetailVO> list, HttpServletResponse response) {
        ArrayList<DeliveryrecorddetailVO> concatList = new ArrayList<DeliveryrecorddetailVO>();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                DeliveryrecorddetailVO deliveryrecorddetailVO = list.get(i);
                concatList.add(deliveryrecorddetailVO);
            }
        }
        List<DeliveryrecorddetailVO> allList = this.handleList(list, concatList);
        HashMap<String, List<DeliveryrecorddetailVO>> beans = new HashMap<String, List<DeliveryrecorddetailVO>>();
        beans.put("records", allList);
        ExcelExport.getInstance().export("deliveryrecorddetail-export.xlsx", beans, response);
    }

    private List<DeliveryrecorddetailVO> handleList(List<DeliveryrecorddetailVO> list, List<DeliveryrecorddetailVO> concatList) {
        if (list == null || list.size() == 0) {
            return concatList;
        }
        for (int i = 0; i < list.size(); ++i) {
            DeliveryrecorddetailVO deliveryrecorddetailVO = list.get(i);
            List<DeliveryrecorddetailVO> children = deliveryrecorddetailVO.getChildren();
            if (children == null || children.size() <= 0) continue;
            concatList.addAll(children);
            this.handleList(children, concatList);
        }
        return concatList;
    }
}

