/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.service.impl;

import com.ejianc.business.material.bean.MaterialapproachEntity;
import com.ejianc.business.material.bean.MaterialapproachdetailEntity;
import com.ejianc.business.material.bean.ProcurementplandetailEntity;
import com.ejianc.business.material.mapper.MaterialapproachMapper;
import com.ejianc.business.material.service.IMaterialapproachService;
import com.ejianc.business.material.service.IMaterialapproachdetailService;
import com.ejianc.business.material.service.IProcurementplanService;
import com.ejianc.business.material.service.IProcurementplandetailService;
import com.ejianc.business.material.vo.MaterialapproachVO;
import com.ejianc.business.material.vo.MaterialapproachdetailVO;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="materialapproachService")
public class MaterialapproachServiceImpl
extends BaseServiceImpl<MaterialapproachMapper, MaterialapproachEntity>
implements IMaterialapproachService {
    @Autowired
    private IProcurementplanService planService;
    @Autowired
    private IProcurementplandetailService planDetailService;
    @Autowired
    private IMaterialapproachdetailService detailService;

    @Override
    public String validatePlan(MaterialapproachVO vo) {
        Map<String, BigDecimal> planNumMap = this.getPlanNumMap(vo.getProjectId());
        Map<String, BigDecimal> inNumMap = this.getInNumMap(vo.getProjectId(), vo.getId());
        StringBuffer buffer = new StringBuffer();
        List<MaterialapproachdetailVO> detailList = vo.getMaterialapproachdetailEntities();
        for (MaterialapproachdetailVO detail : detailList) {
            BigDecimal planNum = BigDecimal.ZERO;
            BigDecimal inNum = BigDecimal.ZERO;
            if (planNumMap.containsKey(detail.getMaterialCode())) {
                planNum = planNumMap.get(detail.getMaterialCode());
            }
            if (inNumMap.containsKey(detail.getMaterialCode())) {
                inNum = inNumMap.get(detail.getMaterialCode());
            }
            if (!ComputeUtil.isGreaterThan((BigDecimal)(inNum = ComputeUtil.safeAdd((BigDecimal)detail.getEnterCount(), (BigDecimal)inNum)), (BigDecimal)planNum)) continue;
            buffer.append("\u3010" + detail.getName() + "\u3011");
            buffer.append("\u7269\u8d44\u8ba1\u5212\u603b\u91cf" + ComputeUtil.scale((BigDecimal)planNum, (int)3) + "\uff0c");
            buffer.append("\u7d2f\u8ba1\u8fdb\u573a" + ComputeUtil.scale((BigDecimal)inNum, (int)3) + "\uff0c");
            buffer.append("\u8d85\u8ba1\u5212" + ComputeUtil.scale((BigDecimal)ComputeUtil.safeSub((BigDecimal)inNum, (BigDecimal)planNum), (int)3) + "\uff1b");
        }
        if (buffer.length() > 0) {
            buffer.delete(buffer.length() - 1, buffer.length());
        }
        return buffer.toString();
    }

    private Map<String, BigDecimal> getPlanNumMap(Long projectId) {
        QueryParam param = new QueryParam();
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        param.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        List list = this.planService.queryList(param);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new HashMap<String, BigDecimal>();
        }
        List ids = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
        QueryParam detailParam = new QueryParam();
        detailParam.getParams().put("mid", new Parameter("in", ids));
        List detailList = this.planDetailService.queryList(detailParam);
        Map<String, BigDecimal> numMap = detailList.stream().collect(Collectors.groupingBy(ProcurementplandetailEntity::getItemCode, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getPurchaseQuantity()).reduce(BigDecimal.ZERO, BigDecimal::add))));
        return numMap;
    }

    private Map<String, BigDecimal> getInNumMap(Long projectId, Long id) {
        List list;
        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        if (id != null) {
            param.getParams().put("id", new Parameter("ne", (Object)id));
        }
        if (CollectionUtils.isEmpty((Collection)(list = super.queryList(param)))) {
            return new HashMap<String, BigDecimal>();
        }
        List ids = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
        QueryParam detailParam = new QueryParam();
        detailParam.getParams().put("mid", new Parameter("in", ids));
        List detailList = this.detailService.queryList(detailParam);
        Map<String, BigDecimal> numMap = detailList.stream().collect(Collectors.groupingBy(MaterialapproachdetailEntity::getMaterialCode, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getEnterCount()).reduce(BigDecimal.ZERO, BigDecimal::add))));
        return numMap;
    }
}

