/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.excel;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.material.service.IMaterialinventorydetailService;
import com.ejianc.business.material.vo.MaterialInventoryVO;
import com.ejianc.business.material.vo.MaterialinventorydetailVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"materialinventorydetailExport"})
public class ExeclMaterialinventoryController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IMaterialinventorydetailService iMaterialinventorydetailService;

    @RequestMapping(value={"/downloadMaterialinventorydetail"})
    @ResponseBody
    public void downloadMaterialMaterialinventorydetail(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"materialinventorydetail-import.xlsx", (String)"\u7269\u8d44\u5e93\u5b58\u53ca\u53ef\u8c03\u62e8\u6750\u6599\u8bb0\u5f55\u5355\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportMaterialinventorydetail"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportMaterialinventorydetail(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<MaterialinventorydetailVO> successList = new ArrayList<MaterialinventorydetailVO>();
        ArrayList<MaterialinventorydetailVO> errorList = new ArrayList<MaterialinventorydetailVO>();
        HashMap map = new HashMap();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            for (int i = 1; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                StringBuilder errorsMsgBuilder = new StringBuilder();
                String materialCode = (String)datas.get(0);
                String materialName = (String)datas.get(1);
                String specialModel = (String)datas.get(2);
                String measurementUnit = (String)datas.get(3);
                String indeliveryQuantity = (String)datas.get(4);
                String deliveryQuantity = (String)datas.get(5);
                String remainingQuantity = (String)datas.get(6);
                String materialsIncludingtax = (String)datas.get(7);
                String remainingTotalamount = (String)datas.get(8);
                String remarks = (String)datas.get(9);
                MaterialinventorydetailVO materialinventorydetailVO = new MaterialinventorydetailVO();
                materialinventorydetailVO.setId(IdWorker.getId());
                if (!TextUtils.isEmpty((CharSequence)materialCode) && !NumberUtil.isNumber((String)materialCode)) {
                    materialinventorydetailVO.setErrorMsg("\u6750\u6599\u7f16\u7801\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u6750\u6599\u7f16\u7801\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    materialinventorydetailVO.setMaterialCode(StringUtils.isNotBlank((CharSequence)materialCode) ? new String(materialCode) : null);
                }
                if (!TextUtils.isEmpty((CharSequence)materialName) && !NumberUtil.isNumber((String)materialName)) {
                    materialinventorydetailVO.setErrorMsg("\u7269\u8d44\u540d\u79f0\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u7269\u8d44\u540d\u79f0\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    materialinventorydetailVO.setMaterialName(StringUtils.isNotBlank((CharSequence)materialName) ? new String(materialName) : null);
                }
                if (!TextUtils.isEmpty((CharSequence)specialModel) && !NumberUtil.isNumber((String)specialModel)) {
                    materialinventorydetailVO.setErrorMsg("\u89c4\u683c\u578b\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u89c4\u683c\u578b\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    materialinventorydetailVO.setSpecialModel(StringUtils.isNotBlank((CharSequence)specialModel) ? new String(specialModel) : null);
                }
                if (!TextUtils.isEmpty((CharSequence)measurementUnit) && !NumberUtil.isNumber((String)measurementUnit)) {
                    materialinventorydetailVO.setErrorMsg("\u8ba1\u91cf\u5355\u4f4d\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u8ba1\u91cf\u5355\u4f4d\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    materialinventorydetailVO.setMeasurementUnit(StringUtils.isNotBlank((CharSequence)measurementUnit) ? new String(measurementUnit) : null);
                }
                if (!TextUtils.isEmpty((CharSequence)indeliveryQuantity) && !NumberUtil.isNumber((String)indeliveryQuantity)) {
                    materialinventorydetailVO.setErrorMsg("\u5165\u5e93\u6570\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u5165\u5e93\u6570\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    materialinventorydetailVO.setIndeliveryQuantity(StringUtils.isNotBlank((CharSequence)indeliveryQuantity) ? new BigDecimal(indeliveryQuantity) : null);
                }
                if (!TextUtils.isEmpty((CharSequence)deliveryQuantity) && !NumberUtil.isNumber((String)deliveryQuantity)) {
                    materialinventorydetailVO.setErrorMsg("\u51fa\u5e93\u6570\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u51fa\u5e93\u6570\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    materialinventorydetailVO.setDeliveryQuantity(StringUtils.isNotBlank((CharSequence)deliveryQuantity) ? new BigDecimal(deliveryQuantity) : null);
                }
                if (!TextUtils.isEmpty((CharSequence)remainingQuantity) && !NumberUtil.isNumber((String)remainingQuantity)) {
                    materialinventorydetailVO.setErrorMsg("\u5269\u4f59\u6570\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u5269\u4f59\u6570\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    materialinventorydetailVO.setRemainingQuantity(StringUtils.isNotBlank((CharSequence)remainingQuantity) ? new BigDecimal(remainingQuantity) : null);
                }
                if (!TextUtils.isEmpty((CharSequence)materialsIncludingtax) && !NumberUtil.isNumber((String)materialsIncludingtax)) {
                    materialinventorydetailVO.setErrorMsg("\u6750\u6599\u5355\u4ef7\uff08\u542b\u7a0e\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u6750\u6599\u5355\u4ef7\uff08\u542b\u7a0e\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    materialinventorydetailVO.setMaterialsIncludingtax(StringUtils.isNotBlank((CharSequence)materialsIncludingtax) ? new BigDecimal(materialsIncludingtax) : null);
                }
                if (!TextUtils.isEmpty((CharSequence)remainingTotalamount) && !NumberUtil.isNumber((String)remainingTotalamount)) {
                    materialinventorydetailVO.setErrorMsg("\u5269\u4f59\u603b\u91d1\u989d\uff08\u542b\u7a0e\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u5269\u4f59\u603b\u91d1\u989d\uff08\u542b\u7a0e\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    materialinventorydetailVO.setRemainingTotalamount(StringUtils.isNotBlank((CharSequence)remainingTotalamount) ? new BigDecimal(remainingTotalamount) : null);
                }
                if (!TextUtils.isEmpty((CharSequence)remarks) && !NumberUtil.isNumber((String)remarks)) {
                    materialinventorydetailVO.setErrorMsg("\u5907\u6ce8\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u5907\u6ce8\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    materialinventorydetailVO.setRemarks(StringUtils.isNotBlank((CharSequence)remarks) ? new String(remarks) : null);
                }
                if (errorsMsgBuilder.length() > 0) {
                    errorList.add(materialinventorydetailVO);
                    continue;
                }
                successList.add(materialinventorydetailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        MaterialinventorydetailVO resVo = new MaterialinventorydetailVO();
        json.put("total", successList);
        json.put("total", (Object)resVo);
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/excelExportMaterialinventorydetailFromDatabase"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportMaterialinventoryFromDatabase(@RequestBody MaterialInventoryVO materialInventoryVO, HttpServletResponse response) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"mid", (Object)materialInventoryVO.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.iMaterialinventorydetailService.list((Wrapper)queryWrapper);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("materialinventorydetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExportMaterialinventorydetailFromPage"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportMaterialinventorydetailFromPage(@RequestBody List<MaterialinventorydetailVO> list, HttpServletResponse response) {
        ArrayList<MaterialinventorydetailVO> concatList = new ArrayList<MaterialinventorydetailVO>();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                MaterialinventorydetailVO materialinventorydetailVO = list.get(i);
                concatList.add(materialinventorydetailVO);
            }
        }
        List<MaterialinventorydetailVO> allList = this.handleList(list, concatList);
        HashMap<String, List<MaterialinventorydetailVO>> beans = new HashMap<String, List<MaterialinventorydetailVO>>();
        beans.put("records", allList);
        ExcelExport.getInstance().export("materialinventorydetail-export.xlsx", beans, response);
    }

    private List<MaterialinventorydetailVO> handleList(List<MaterialinventorydetailVO> list, List<MaterialinventorydetailVO> concatList) {
        if (list == null || list.size() == 0) {
            return concatList;
        }
        for (int i = 0; i < list.size(); ++i) {
            MaterialinventorydetailVO materialinventorydetailVO = list.get(i);
            List<MaterialinventorydetailVO> children = materialinventorydetailVO.getChildren();
            if (children == null || children.size() <= 0) continue;
            concatList.addAll(children);
            this.handleList(children, concatList);
        }
        return concatList;
    }
}

