/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.material.bean.FlowmeterEntity;
import com.ejianc.business.material.bean.SurplusmaterialrecordEntity;
import com.ejianc.business.material.bean.SurplusmaterialrecordtailEntity;
import com.ejianc.business.material.mapper.SurplusmaterialrecordMapper;
import com.ejianc.business.material.service.IFlowmeterService;
import com.ejianc.business.material.service.IRealtimebalanceService;
import com.ejianc.business.material.service.ISurplusmaterialrecordService;
import com.ejianc.business.material.service.impl.SurplusmaterialrecordBpmServiceImpl;
import com.ejianc.business.material.vo.SurplusmaterialrecordVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="surplusmaterialrecordService")
public class SurplusmaterialrecordServiceImpl
extends BaseServiceImpl<SurplusmaterialrecordMapper, SurplusmaterialrecordEntity>
implements ISurplusmaterialrecordService {
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IRealtimebalanceService realtimebalanceService;
    @Autowired
    private IFlowmeterService flowmeterService;
    @Autowired
    private SurplusmaterialrecordBpmServiceImpl surplusmaterialrecordBpmService;

    @Override
    public SurplusmaterialrecordVO saveOrUpdate(SurplusmaterialrecordVO saveorUpdateVO) {
        SurplusmaterialrecordEntity entity = (SurplusmaterialrecordEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), SurplusmaterialrecordEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        super.saveOrUpdate((Object)entity, false);
        SurplusmaterialrecordVO vo = (SurplusmaterialrecordVO)((Object)BeanMapper.map((Object)((Object)entity), SurplusmaterialrecordVO.class));
        List<SurplusmaterialrecordtailEntity> surplusmaterialrecordtailEntities = entity.getSurplusmaterialrecordtailEntities();
        ArrayList<FlowmeterEntity> flowmeterList = new ArrayList<FlowmeterEntity>();
        LambdaQueryWrapper lambdaFlower = Wrappers.lambdaQuery();
        lambdaFlower.eq(FlowmeterEntity::getMid, (Object)entity.getId());
        this.flowmeterService.remove((Wrapper)lambdaFlower);
        List materialIds = surplusmaterialrecordtailEntities.stream().map(SurplusmaterialrecordtailEntity::getMaterialId).collect(Collectors.toList());
        LambdaQueryWrapper lambdaFlow = Wrappers.lambdaQuery();
        lambdaFlow.eq(FlowmeterEntity::getStoreId, (Object)entity.getStoreId());
        lambdaFlow.in(FlowmeterEntity::getMaterialId, materialIds);
        if (saveorUpdateVO.getId() != null) {
            lambdaFlow.ne(FlowmeterEntity::getMid, (Object)saveorUpdateVO.getId());
        }
        List flowmeterEntityList = this.flowmeterService.list((Wrapper)lambdaFlow);
        Map<Long, BigDecimal> numInMap = flowmeterEntityList.stream().filter(s -> s.getOperationType().equals("\u5165\u5e93")).collect(Collectors.groupingBy(FlowmeterEntity::getMaterialId, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getQuantity()).reduce(BigDecimal.ZERO, BigDecimal::add))));
        Map<Long, BigDecimal> numOutMap = flowmeterEntityList.stream().filter(s -> s.getOperationType().equals("\u51fa\u5e93")).collect(Collectors.groupingBy(FlowmeterEntity::getMaterialId, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getQuantity()).reduce(BigDecimal.ZERO, BigDecimal::add))));
        BigDecimal inNum = BigDecimal.ZERO;
        BigDecimal outNum = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(surplusmaterialrecordtailEntities)) {
            for (SurplusmaterialrecordtailEntity surplusmaterialrecordtailEntity : surplusmaterialrecordtailEntities) {
                FlowmeterEntity flowmeterEntity = this.surplusmaterialrecordBpmService.createrFlowmeter(entity, surplusmaterialrecordtailEntity, 0, null);
                flowmeterList.add(flowmeterEntity);
                inNum = BigDecimal.ZERO;
                outNum = BigDecimal.ZERO;
                if (numInMap.containsKey(surplusmaterialrecordtailEntity.getMaterialId())) {
                    inNum = numInMap.get(surplusmaterialrecordtailEntity.getMaterialId());
                }
                if (numOutMap.containsKey(surplusmaterialrecordtailEntity.getMaterialId())) {
                    outNum = numOutMap.get(surplusmaterialrecordtailEntity.getMaterialId());
                }
                BigDecimal subtract = inNum.subtract(outNum);
                BigDecimal num = BigDecimal.ZERO;
                num = saveorUpdateVO.getIsRebarManagement() == 0 ? surplusmaterialrecordtailEntity.getSuttle() : surplusmaterialrecordtailEntity.getMaterialNumber();
                if (num.compareTo(subtract) != 1) continue;
                throw new BusinessException("\u7269\u8d44\u7f16\u53f7:" + surplusmaterialrecordtailEntity.getMaterialCode() + ",\u7269\u8d44\u540d\u79f0:" + surplusmaterialrecordtailEntity.getMaterialName() + "\u5e93\u5b58\u4e0d\u8db3\uff0c\u4e0d\u80fd\u51fa\u5e93!");
            }
            this.flowmeterService.saveBatch(flowmeterList);
            this.realtimebalanceService.updateRealtimeBalance(entity.getStoreId());
        }
        return vo;
    }

    @Override
    @Transactional
    public void delete(List<SurplusmaterialrecordVO> vos) {
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        LambdaQueryWrapper lambdaRecord = Wrappers.lambdaQuery();
        lambdaRecord.in(BaseEntity::getId, ids);
        List deliveryrecordEntities = super.list((Wrapper)lambdaRecord);
        LambdaQueryWrapper lambdaFlower = Wrappers.lambdaQuery();
        lambdaFlower.in(FlowmeterEntity::getMid, ids);
        this.flowmeterService.remove((Wrapper)lambdaFlower);
        for (SurplusmaterialrecordEntity surplusmaterialrecordEntity : deliveryrecordEntities) {
            this.realtimebalanceService.updateRealtimeBalance(surplusmaterialrecordEntity.getStoreId());
        }
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
    }
}

