/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.material.bean.DeliveryrecorddetailEntity;
import com.ejianc.business.material.bean.MaterialWarehousingdetailEntity;
import com.ejianc.business.material.bean.StoreEntity;
import com.ejianc.business.material.mapper.StoreMapper;
import com.ejianc.business.material.service.IDeliveryrecorddetailService;
import com.ejianc.business.material.service.IMaterialWarehousingdetailService;
import com.ejianc.business.material.service.IStoreService;
import com.ejianc.business.material.vo.StoreVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StoreService
extends BaseServiceImpl<StoreMapper, StoreEntity>
implements IStoreService {
    @Autowired
    IMaterialWarehousingdetailService instoreMaterialService;
    @Autowired
    IDeliveryrecorddetailService iOutStoreSubService;

    @Override
    public IPage<StoreVO> queryForList(QueryParam queryParam, boolean isEs) {
        Page voPage = null;
        IPage entityPage = super.queryPage(queryParam, isEs);
        if (entityPage != null) {
            voPage = new Page();
            voPage.setCurrent(entityPage.getCurrent());
            voPage.setPages(entityPage.getPages());
            voPage.setTotal(entityPage.getTotal());
            voPage.setSize((long)queryParam.getPageSize());
            voPage.setRecords(BeanMapper.mapList((Iterable)entityPage.getRecords(), StoreVO.class));
        }
        return voPage;
    }

    @Override
    public BigDecimal calculateCanUseNum(Long inStoreSubId, Long materialId, Long outSubId) {
        MaterialWarehousingdetailEntity inEntity = (MaterialWarehousingdetailEntity)((Object)this.instoreMaterialService.selectById(inStoreSubId));
        if (inEntity == null) {
            throw new BusinessException("\u6ca1\u6709\u627e\u5230\u8be5\u7269\u8d44\u5165\u5e93\u8bb0\u5f55\uff01");
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("sourceSubId", new Parameter("eq", (Object)inStoreSubId));
        List subs = this.iOutStoreSubService.queryList(queryParam, false);
        BigDecimal canUseNum = inEntity.getQuantity();
        BigDecimal cannotUseNum = BigDecimal.ZERO;
        if (!ListUtil.isEmpty((List)subs)) {
            for (DeliveryrecorddetailEntity s : subs) {
                if (outSubId != null && Objects.equals(outSubId, s.getId())) continue;
                cannotUseNum = ComputeUtil.safeAdd((BigDecimal)cannotUseNum, (BigDecimal)s.getDeliveryQuantity());
            }
        }
        canUseNum = ComputeUtil.safeSub((BigDecimal)canUseNum, (BigDecimal)cannotUseNum);
        return canUseNum;
    }

    @Override
    public CommonResponse<String> delete(List<StoreVO> vos) {
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        this.removeByIds(ids, true);
        return CommonResponse.success((String)"\u5220\u9664\u4ed3\u5e93\u6210\u529f");
    }

    @Override
    public StoreVO queryNewestStoreByOrgId(Long orgId) {
        QueryParam param = new QueryParam();
        param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        param.getParams().put("state", new Parameter("eq", (Object)1));
        param.getOrderMap().put("createTime", "desc");
        List list = this.queryList(param, false);
        if (ListUtil.isNotEmpty((List)list)) {
            return (StoreVO)((Object)BeanMapper.map(list.get(0), StoreVO.class));
        }
        return null;
    }

    @Override
    public Integer queryStoreType(Long storeId) {
        LambdaQueryWrapper lambdaReal = Wrappers.lambdaQuery();
        lambdaReal.eq(BaseEntity::getId, (Object)storeId);
        StoreEntity storeEntity = (StoreEntity)((Object)this.getOne((Wrapper)lambdaReal, false));
        if (storeEntity != null) {
            return storeEntity.getStoreType();
        }
        return null;
    }
}

