/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.material.bean.DeliveryrecordEntity;
import com.ejianc.business.material.bean.DeliveryrecorddetailEntity;
import com.ejianc.business.material.bean.FlowmeterEntity;
import com.ejianc.business.material.mapper.DeliveryrecordMapper;
import com.ejianc.business.material.service.IDeliveryrecordService;
import com.ejianc.business.material.service.IDeliveryrecorddetailService;
import com.ejianc.business.material.service.IFlowmeterService;
import com.ejianc.business.material.service.IRealtimebalanceService;
import com.ejianc.business.material.service.impl.DeliveryrecordBpmServiceImpl;
import com.ejianc.business.material.service.impl.MaterialWarehousingBpmServiceImpl;
import com.ejianc.business.material.vo.DeliveryrecordReportVO;
import com.ejianc.business.material.vo.DeliveryrecordSubVO;
import com.ejianc.business.material.vo.DeliveryrecordVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="deliveryrecordService")
public class DeliveryrecordServiceImpl
extends BaseServiceImpl<DeliveryrecordMapper, DeliveryrecordEntity>
implements IDeliveryrecordService {
    @Autowired
    private DeliveryrecordMapper deliveryrecordMapper;
    @Autowired
    private IFlowmeterService flowmeterService;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private DeliveryrecordBpmServiceImpl deliveryrecordBpmService;
    @Autowired
    private MaterialWarehousingBpmServiceImpl materialWarehousingBpmService;
    @Autowired
    private IDeliveryrecorddetailService deliveryrecorddetailService;
    @Autowired
    private IRealtimebalanceService realtimebalanceService;

    @Override
    public List<DeliveryrecordSubVO> selectSub(String materialCode, String projectId) {
        List<DeliveryrecordSubVO> list = this.deliveryrecordMapper.selectSub(materialCode, projectId);
        return list;
    }

    @Override
    public List<DeliveryrecordReportVO> subDetail(Long projectId, String materialCode, String supplierName) {
        List<DeliveryrecordReportVO> deliveryrecordReportVOS = this.deliveryrecordMapper.subDetail(projectId, materialCode, supplierName);
        return deliveryrecordReportVOS;
    }

    @Override
    @Transactional
    public DeliveryrecordVO saveOrUpdate(DeliveryrecordVO saveorUpdateVO) {
        DeliveryrecordEntity entity = (DeliveryrecordEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), DeliveryrecordEntity.class));
        List<DeliveryrecorddetailEntity> deliveryrecorddetailList = entity.getDeliveryrecorddetailEntities();
        BigDecimal outMny = deliveryrecorddetailList.stream().map(DeliveryrecorddetailEntity::getAmountExcluetax).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal outMnyTax = deliveryrecorddetailList.stream().map(DeliveryrecorddetailEntity::getAmountIncluetax).reduce(BigDecimal.ZERO, BigDecimal::add);
        entity.setOutMny(outMny);
        entity.setOutMnyTax(outMnyTax);
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setDeliveryType(1);
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        List<DeliveryrecorddetailEntity> deliveryrecorddetailEntities = entity.getDeliveryrecorddetailEntities();
        for (DeliveryrecorddetailEntity deliveryrecorddetail : deliveryrecorddetailEntities) {
            if ("del".equals(deliveryrecorddetail.getRowState())) continue;
            deliveryrecorddetail.setProjectId(entity.getProjectId());
            deliveryrecorddetail.setStoreId(entity.getStoreId());
            deliveryrecorddetail.setPickingTime(entity.getPickingTime());
            deliveryrecorddetail.setProjectName(entity.getProjectName());
            deliveryrecorddetail.setTenantId(entity.getTenantId());
            deliveryrecorddetail.setOrgId(entity.getOrgId());
            deliveryrecorddetail.setUnitId(entity.getPickingunitId());
            deliveryrecorddetail.setUnitName(entity.getPickingUnit());
            deliveryrecorddetail.setProjectDepartmentId(entity.getProjectDepartmentId());
        }
        List<DeliveryrecorddetailEntity> deliveryrecorddetailEntityList = entity.getDeliveryrecorddetailEntities();
        if ((entity.getDeliveryTypes() == 1 || entity.getDeliveryTypes() == 5 || entity.getDeliveryTypes() == 6 || entity.getDeliveryTypes() == 7) && CollectionUtils.isNotEmpty(deliveryrecorddetailEntityList)) {
            List deliveryDetailIds = deliveryrecorddetailEntityList.stream().map(DeliveryrecorddetailEntity::getDeliveryDetailId).collect(Collectors.toList());
            LambdaQueryWrapper lambdaWareDetail = Wrappers.lambdaQuery();
            lambdaWareDetail.in(DeliveryrecorddetailEntity::getDeliveryDetailId, deliveryDetailIds);
            if (saveorUpdateVO.getId() != null) {
                lambdaWareDetail.ne(DeliveryrecorddetailEntity::getMid, (Object)entity.getId());
            }
            List warehousingdetailEntityList = this.deliveryrecorddetailService.list((Wrapper)lambdaWareDetail);
            Map<Long, BigDecimal> numMap = new HashMap();
            if (CollectionUtils.isNotEmpty((Collection)warehousingdetailEntityList)) {
                numMap = warehousingdetailEntityList.stream().filter(s -> s.getDeliveryQuantity().compareTo(BigDecimal.ZERO) == -1).collect(Collectors.groupingBy(DeliveryrecorddetailEntity::getDeliveryDetailId, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getDeliveryQuantity()).reduce(BigDecimal.ZERO, BigDecimal::add))));
            }
            for (DeliveryrecorddetailEntity deliveryrecorddetailEntity : deliveryrecorddetailEntityList) {
                BigDecimal allZy;
                BigDecimal num = BigDecimal.ZERO;
                BigDecimal numDelivery = BigDecimal.ZERO;
                BigDecimal numAll = BigDecimal.ZERO;
                if (numMap.containsKey(deliveryrecorddetailEntity.getDeliveryDetailId())) {
                    num = numMap.get(deliveryrecorddetailEntity.getDeliveryDetailId());
                }
                if (entity.getDeliveryTypes() == 1 || entity.getDeliveryTypes() == 5 || entity.getDeliveryTypes() == 6) {
                    numDelivery = deliveryrecorddetailEntity.getDeliveryNum();
                    numAll = deliveryrecorddetailEntity.getDeliveryQuantity();
                }
                if (entity.getDeliveryTypes() == 7) {
                    numDelivery = deliveryrecorddetailEntity.getDeliveryQuantity();
                    numAll = deliveryrecorddetailEntity.getNotReturnedQuantity();
                }
                if ((allZy = numDelivery.add(num).multiply(new BigDecimal(-1.0))).compareTo(numAll) != 1) continue;
                throw new BusinessException("\u7269\u8d44\u7f16\u53f7:" + deliveryrecorddetailEntity.getMaterialCode() + ",\u7269\u8d44\u540d\u79f0:" + deliveryrecorddetailEntity.getMaterialName() + "\u8d85\u8fc7\u5269\u4f59\u53ef\u9000\u5e93\u6570\u91cf,\u4e0d\u80fd\u4fdd\u5b58!");
            }
        }
        super.saveOrUpdate((Object)entity, false);
        ArrayList<FlowmeterEntity> flowmeterList = new ArrayList<FlowmeterEntity>();
        LambdaQueryWrapper lambdaFlower = Wrappers.lambdaQuery();
        lambdaFlower.eq(FlowmeterEntity::getMid, (Object)entity.getId());
        this.flowmeterService.remove((Wrapper)lambdaFlower);
        if ((entity.getDeliveryTypes() == 0 || entity.getDeliveryTypes() == 4) && CollectionUtils.isNotEmpty(deliveryrecorddetailEntityList)) {
            ArrayList realList = new ArrayList();
            for (DeliveryrecorddetailEntity deliveryrecorddetailEntity : deliveryrecorddetailEntityList) {
                FlowmeterEntity flowmeterEntity = this.deliveryrecordBpmService.createrFlowmeter(entity, deliveryrecorddetailEntity, 0, null);
                flowmeterList.add(flowmeterEntity);
            }
            List materialIds = deliveryrecorddetailEntityList.stream().map(DeliveryrecorddetailEntity::getMaterialId).collect(Collectors.toList());
            LambdaQueryWrapper lambdaFlow = Wrappers.lambdaQuery();
            lambdaFlow.eq(FlowmeterEntity::getStoreId, (Object)entity.getStoreId());
            lambdaFlow.in(FlowmeterEntity::getMaterialId, materialIds);
            if (saveorUpdateVO.getId() != null) {
                lambdaFlow.ne(FlowmeterEntity::getMid, (Object)saveorUpdateVO.getId());
            }
            List flowmeterEntityList = this.flowmeterService.list((Wrapper)lambdaFlow);
            Map<Long, BigDecimal> numInMap = flowmeterEntityList.stream().filter(s -> s.getOperationType().equals("\u5165\u5e93")).collect(Collectors.groupingBy(FlowmeterEntity::getMaterialId, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getQuantity()).reduce(BigDecimal.ZERO, BigDecimal::add))));
            Map<Long, BigDecimal> numOutMap = flowmeterEntityList.stream().filter(s -> s.getOperationType().equals("\u51fa\u5e93")).collect(Collectors.groupingBy(FlowmeterEntity::getMaterialId, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getQuantity()).reduce(BigDecimal.ZERO, BigDecimal::add))));
            BigDecimal inNum = BigDecimal.ZERO;
            BigDecimal outNum = BigDecimal.ZERO;
            for (DeliveryrecorddetailEntity deliveryrecorddetailEntity : deliveryrecorddetailEntityList) {
                inNum = BigDecimal.ZERO;
                outNum = BigDecimal.ZERO;
                if (numInMap.containsKey(deliveryrecorddetailEntity.getMaterialId())) {
                    inNum = numInMap.get(deliveryrecorddetailEntity.getMaterialId());
                }
                if (numOutMap.containsKey(deliveryrecorddetailEntity.getMaterialId())) {
                    outNum = numOutMap.get(deliveryrecorddetailEntity.getMaterialId());
                }
                BigDecimal subtract = inNum.subtract(outNum);
                if (deliveryrecorddetailEntity.getDeliveryQuantity().compareTo(subtract) != 1) continue;
                throw new BusinessException("\u7269\u8d44\u7f16\u53f7:" + deliveryrecorddetailEntity.getMaterialCode() + ",\u7269\u8d44\u540d\u79f0:" + deliveryrecorddetailEntity.getMaterialName() + "\u5e93\u5b58\u4e0d\u8db3\uff0c\u4e0d\u80fd\u51fa\u5e93!");
            }
            this.flowmeterService.saveBatch(flowmeterList);
            this.realtimebalanceService.updateRealtimeBalance(entity.getStoreId());
        }
        DeliveryrecordVO vo = (DeliveryrecordVO)((Object)BeanMapper.map((Object)((Object)entity), DeliveryrecordVO.class));
        return vo;
    }

    @Override
    @Transactional
    public void delete(List<DeliveryrecordVO> vos) {
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        LambdaQueryWrapper lambdaDelivery = Wrappers.lambdaQuery();
        lambdaDelivery.in(BaseEntity::getId, ids);
        List deliveryrecordEntities = super.list((Wrapper)lambdaDelivery);
        LambdaQueryWrapper lambdaFlower = Wrappers.lambdaQuery();
        lambdaFlower.in(FlowmeterEntity::getMid, ids);
        this.flowmeterService.remove((Wrapper)lambdaFlower);
        for (DeliveryrecordEntity deliveryrecordEntity : deliveryrecordEntities) {
            if (deliveryrecordEntity.getDeliveryTypes() != 0 && deliveryrecordEntity.getDeliveryTypes() != 4) continue;
            this.realtimebalanceService.updateRealtimeBalance(deliveryrecordEntity.getStoreId());
        }
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
    }
}

