package com.ejianc.business.material.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.material.bean.DeliveryrecordEntity;
import com.ejianc.business.material.bean.DeliveryrecorddetailEntity;
import com.ejianc.business.material.bean.MaterialWarehousingdetailEntity;
import com.ejianc.business.material.bean.MaterialapproachdetailEntity;
import com.ejianc.business.material.service.IDeliveryrecordService;
import com.ejianc.business.material.service.IDeliveryrecorddetailService;
import com.ejianc.business.material.service.impl.DeliveryrecordBpmServiceImpl;
import com.ejianc.business.material.utils.DateUtils;
import com.ejianc.business.material.vo.DeliveryrecordReportVO;
import com.ejianc.business.material.vo.DeliveryrecordSubVO;
import com.ejianc.business.material.vo.DeliveryrecordVO;
import com.ejianc.business.material.vo.DeliveryrecorddetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 物资出库记录
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("deliveryrecord")
public class DeliveryrecordController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IDeliveryrecordService service;

    @Autowired
    private IDeliveryrecorddetailService detailService;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private DeliveryrecordBpmServiceImpl deliveryrecordBpmService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DeliveryrecordVO> saveOrUpdate(@RequestBody DeliveryrecordVO saveorUpdateVO) {
        DeliveryrecordVO vo = service.saveOrUpdate(saveorUpdateVO);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    /**
     * @Description saveOrUpdate 审批接口
     */
    @RequestMapping(value = "/afterApprovalProcessor", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> afterApprovalProcessor(Long billId) {
        deliveryrecordBpmService.afterApprovalProcessor(billId,null,null);
    	return CommonResponse.success("保存或修改单据成功！");
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DeliveryrecordVO> queryDetail(Long id) {
    	DeliveryrecordEntity entity = service.selectById(id);
    	DeliveryrecordVO vo = BeanMapper.map(entity, DeliveryrecordVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DeliveryrecordVO> vos) {
        service.delete(vos);

        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<DeliveryrecordVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("pickingUnit");

        UserContext userContextCache = sessionManager.getUserContext();


        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });

        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        IPage<DeliveryrecordEntity> page = service.queryPage(param,false);
        IPage<DeliveryrecordVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), DeliveryrecordVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    @RequestMapping(value = "/queryReport", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<DeliveryrecordReportVO>> queryReport(Long projectId, String materialCode, String supplierName) {
        List<DeliveryrecordReportVO> resList = service.subDetail(projectId, materialCode, supplierName);
        return CommonResponse.success("查询成功", resList);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }



    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("pickingUnit");
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        UserContext userContextCache = sessionManager.getUserContext();


        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });

        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        List<DeliveryrecordEntity> list = service.queryList(param);
        //todo:字段翻译等等
        List<DeliveryrecordVO> deliveryrecordList = BeanMapper.mapList(list, DeliveryrecordVO.class);
        for (int i = 0; i < deliveryrecordList.size(); i++) {
            DeliveryrecordVO deliveryrecordVO = deliveryrecordList.get(i);
            deliveryrecordVO.setNum(String.valueOf(i + 1));
            if (deliveryrecordVO.getCreateTime() != null) {
                deliveryrecordVO.setCreateTimeShow(DateUtils.dateSimple2(deliveryrecordVO.getCreateTime()));
            }
            String billStateStr = deliveryrecordVO.getBillState().toString();
            if (billStateStr != null) {
                if ("0".equals(billStateStr)) {//自由态
                    billStateStr = "自由态";
                } else if ("1".equals(billStateStr)) {//已提交
                    billStateStr = "已提交";
                } else if ("2".equals(billStateStr) || "5".equals(billStateStr)) {//审批中
                    billStateStr = "审批中";
                } else if ("3".equals(billStateStr)) {//审批通过
                    billStateStr = "审批通过";
                } else if ("4".equals(billStateStr)) {//驳回
                    billStateStr = "驳回";
                }

                deliveryrecordVO.setBillStateStr(billStateStr);
            }
            if (deliveryrecordVO.getDeliveryType() != null) {
                //出库单类型 0-自动出库单 1-手动出库单
                if (deliveryrecordVO.getDeliveryType() == 1) {
                    deliveryrecordVO.setDeliveryTypeName("手动出库");
                }else {
                    deliveryrecordVO.setDeliveryTypeName("自动出库");

                }
            }

            if (deliveryrecordVO.getDeliveryTypes() != null){
                //出库类型 0-成品出库 1-成品退库    4-资产出库 5-废旧物资退库 6-资产退库7-直入直出退供应商 8-无来源退库
                if (deliveryrecordVO.getDeliveryTypes() == 0) {
                    deliveryrecordVO.setDeliveryTypesName("成品出库");
                }
                if (deliveryrecordVO.getDeliveryTypes() == 1) {
                    deliveryrecordVO.setDeliveryTypesName("成品退库");
                }
                if (deliveryrecordVO.getDeliveryTypes() == 4) {
                    deliveryrecordVO.setDeliveryTypesName("资产出库");
                }
                if (deliveryrecordVO.getDeliveryTypes() == 5) {
                    deliveryrecordVO.setDeliveryTypesName("废旧物资退库");
                }
                if (deliveryrecordVO.getDeliveryTypes() == 6) {
                    deliveryrecordVO.setDeliveryTypesName("资产退库");
                }
                if (deliveryrecordVO.getDeliveryTypes() == 7) {
                    deliveryrecordVO.setDeliveryTypesName("直入直出退供应商");
                }
                if (deliveryrecordVO.getDeliveryTypes() == 8) {
                    deliveryrecordVO.setDeliveryTypesName("无来源退库");
                }
            }

        }

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", deliveryrecordList);
        ExcelExport.getInstance().export("Deliveryrecord-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refDeliveryrecordData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<DeliveryrecordVO>> refDeliveryrecordData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if(_con.get("status") != null && _con.get("status").equals("1")){//退库操作
                param.getParams().put("deliveryType", new Parameter(QueryParam.IN, "0,1"));
//                param.getParams().put("notDeliveryQuantity", new Parameter(QueryParam.GT, BigDecimal.ZERO));
                param.getParams().put("billState", new Parameter(QueryParam.IN,"1,3"));
            }

//            if(_con.get("types") != null) {//退库操作
//
//                if(_con.get("types").equals("1") || _con.get("types").equals("4")){
//                    param.getParams().put("deliveryTypes", new Parameter(QueryParam.IN,_con.get("types") + ",0"));
//                }else{
//                    param.getParams().put("deliveryTypes", new Parameter(QueryParam.EQ,_con.get("types")));
//                }
//            }
            if(_con.get("types") != null) {//退库操作
                if(_con.get("types").equals("1")){
                    param.getParams().put("deliveryTypes", new Parameter(QueryParam.EQ,0));
                }
                if(_con.get("types").equals("5")){
                    param.getParams().put("deliveryTypes", new Parameter(QueryParam.IN,"0,3,4"));
                }
                if(_con.get("types").equals("6")){
                    param.getParams().put("deliveryTypes", new Parameter(QueryParam.EQ,4));
                }
            }
            if(_con.get("projectId") != null){
                param.getParams().put("projectId", new Parameter(QueryParam.EQ,_con.get("projectId")));
            }
            if(_con.get("orgId") != null){
                UserContext userContextCache =sessionManager.getUserContext();
                //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
                String authOrgIds = userContextCache.getAuthOrgIds();
                List<OrgVO> orgVOList = null;
                if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
                    orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
                }else {//pc端查询
                    orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(Long.parseLong( _con.get("orgId").toString())), true, "查询失败，获取当前本下组织信息失败。");
                }
                //普通组织 id
                List<Long> commonOrgIds = new ArrayList<>();
                //项目部 id
                List<Long> departmentIds = new ArrayList<>();
                orgVOList.stream().forEach(org -> {
                    if(5 == org.getOrgType()) {
                        //项目部
                        departmentIds.add(org.getId());
                    } else {
                        //普通组织
                        commonOrgIds.add(org.getId());
                    }
                });
                if(CollectionUtils.isNotEmpty(commonOrgIds)) {
                    /** 要求主表有orgId字段，保存单据所属组织 */
                    param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
                } else if(CollectionUtils.isNotEmpty(departmentIds)) {
                    /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
                    param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
                }
            }
        }
        IPage<DeliveryrecordEntity> page = service.queryPage(param,false);
        IPage<DeliveryrecordVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), DeliveryrecordVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    @RequestMapping(value = "/queryProject", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> queryProject(Long id, Long projectId) {
        QueryWrapper<DeliveryrecordEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", 0);
        queryWrapper.eq("project_id", projectId);
        if (id != null && id != 0) {
            queryWrapper.ne("id", id);
        }
        List<DeliveryrecordEntity> entityList = service.list(queryWrapper);

        return CommonResponse.success("查询成功", "1");
    }

    /**
     *  出库单中出库单参照和入库单参照使用
     * @param deliveryId 出库单id或者入库单id
     * @param status 类型 0-出库单 1-入库单
     * @return
     */
    @RequestMapping(value = "/queryDeliverDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<DeliveryrecorddetailVO>> queryDeliverDetail(Long deliveryId,String status,Long id) {
        List<DeliveryrecorddetailEntity> list = new ArrayList<>();
        List<DeliveryrecorddetailEntity> materialapproachdetailEntities = new ArrayList<>();
        List<DeliveryrecorddetailVO> deliveryrecorddetailVOS = new ArrayList<>();

        if(status.equals("0")){//出库单
            QueryWrapper<DeliveryrecorddetailEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("mid",deliveryId);
//            queryWrapper.gt("not_returned_quantity",BigDecimal.ZERO);
            list = detailService.list(queryWrapper);

        }
        if(status.equals("1")){//入库单
            QueryWrapper<DeliveryrecordEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("warehousing_id",deliveryId);
            queryWrapper.eq("bill_state",3);
            DeliveryrecordEntity deliveryrecordEntity = service.getOne(queryWrapper);
            deliveryId = deliveryrecordEntity.getId();
            QueryWrapper<DeliveryrecorddetailEntity> queryWrapper1 = new QueryWrapper<>();
            queryWrapper1.eq("mid",deliveryrecordEntity.getId());
//            queryWrapper1.gt("not_returned_quantity",BigDecimal.ZERO);
            list = detailService.list(queryWrapper1);
//            deliveryrecorddetailVOS = BeanMapper.mapList(list, DeliveryrecorddetailVO.class);

        }
//        if (status.equals("0")){
            //查询剩余可退库数量

        QueryWrapper<DeliveryrecorddetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", deliveryId);
        List<DeliveryrecorddetailEntity> materialapproachdetailEntityList = detailService.list(queryWrapper);
        //查询所有验收数量
        if (CollectionUtils.isNotEmpty(materialapproachdetailEntityList)){
            List<Long> approachIds = materialapproachdetailEntityList.stream().map(DeliveryrecorddetailEntity::getId).collect(Collectors.toList());

            //查询所有下游引用的数据,获取退场数量
            LambdaQueryWrapper<DeliveryrecorddetailEntity> houseDetailScheme = Wrappers.<DeliveryrecorddetailEntity>lambdaQuery();
            houseDetailScheme.in(DeliveryrecorddetailEntity::getDeliveryDetailId, approachIds);
            if (id != null){
                houseDetailScheme.ne(DeliveryrecorddetailEntity::getMid,id);
            }
            List<DeliveryrecorddetailEntity> materialWarehousingdetailEntities = detailService.list(houseDetailScheme);
            Map<Long, BigDecimal> checkMap = new HashMap<>();
            if (CollectionUtils.isNotEmpty(materialWarehousingdetailEntities)){
                // 分组后汇总
                checkMap = materialWarehousingdetailEntities.stream().filter(s->s.getDeliveryQuantity().compareTo(BigDecimal.ZERO) == -1).collect(Collectors.groupingBy(DeliveryrecorddetailEntity::getDeliveryDetailId,
                        Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getDeliveryQuantity()).reduce(BigDecimal.ZERO, BigDecimal::add))));
            }

            for (DeliveryrecorddetailEntity deliveryrecorddetailEntity : list){
                deliveryrecorddetailEntity.setDeliveryDetailId(deliveryrecorddetailEntity.getId());
                deliveryrecorddetailEntity.setDeliveryNum(deliveryrecorddetailEntity.getDeliveryQuantity());

                deliveryrecorddetailEntity.setAmountIncluetax(deliveryrecorddetailEntity.getAmountIncluetax().multiply(new BigDecimal(-1.00)));
                deliveryrecorddetailEntity.setAmountExcluetax(deliveryrecorddetailEntity.getAmountExcluetax().multiply(new BigDecimal(-1.00)));
                if(checkMap.containsKey(deliveryrecorddetailEntity.getId())){
                    BigDecimal checkNum = checkMap.get(deliveryrecorddetailEntity.getId());
                    deliveryrecorddetailEntity.setNotReturnedQuantity(deliveryrecorddetailEntity.getDeliveryQuantity().add(checkNum));
                }else{
                    deliveryrecorddetailEntity.setNotReturnedQuantity(deliveryrecorddetailEntity.getDeliveryQuantity());
                }
                deliveryrecorddetailEntity.setId(IdWorker.getId());
                deliveryrecorddetailEntity.setDeliveryQuantity(deliveryrecorddetailEntity.getNotReturnedQuantity().multiply(new BigDecimal(-1.00)));
            }

            materialapproachdetailEntities = list.stream().filter(it -> it.getNotReturnedQuantity().compareTo(BigDecimal.ZERO) == 1).collect(Collectors.toList());
            deliveryrecorddetailVOS = BeanMapper.mapList(materialapproachdetailEntities, DeliveryrecorddetailVO.class);

        }
//        }


//        List<DeliveryrecorddetailVO> deliveryrecorddetailVOS = BeanMapper.mapList(materialapproachdetailEntities, DeliveryrecorddetailVO.class);
        return CommonResponse.success("查询成功!",deliveryrecorddetailVOS);
    }

    @RequestMapping(value = "/querySub", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<DeliveryrecordSubVO>> querySub(Long projectId, String materialCode) {
        List<DeliveryrecordSubVO> resList = service.selectSub(materialCode, String.valueOf(projectId));
        return CommonResponse.success("查询成功", resList);
    }

}
