package com.ejianc.business.material.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.material.service.IEnterService;
import com.ejianc.business.material.vo.EnterVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * 进场台账
 * @author biying
 */

@Controller
@RequestMapping("enter")
public class EnterController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IEnterService service;

    @Autowired
    private IOrgApi iOrgApi;


    /**
     * 查询列表数据
     * @return
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<EnterVO>> queryReportList(@RequestBody QueryParam param, @RequestParam("projectId") String projectId ) {
        List<EnterVO> vo = new ArrayList<>();
        List<EnterVO> enterVoIpage = service.selectAll(projectId);
        for (EnterVO enterVO : enterVoIpage){
            enterVO.setId(IdWorker.getId());
            enterVO.setProjectId(enterVO.getProjectId());
            enterVO.setMaterialCode(enterVO.getMaterialCode());
            enterVO.setProjectName(enterVO.getProjectName());
            enterVO.setName(enterVO.getName());
            enterVO.setSpec(enterVO.getSpec());
            enterVO.setEnterCount(enterVO.getEnterCount());
//            enterVO.setCreateUserCode(enterVO.getCreateUserCode());
            vo.add(enterVO);
        }

        IPage<EnterVO> pageData = new Page<>(param.getPageIndex(), param.getPageSize(), enterVoIpage.size());
        pageData.setRecords(enterVoIpage);

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

}
