package com.ejianc.business.material.excel;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.material.bean.MaterialapproachdetailEntity;
import com.ejianc.business.material.service.IDeviceverificationrecordsdetailService;
import com.ejianc.business.material.service.IMaterialapproachdetailService;
import com.ejianc.business.material.vo.DeviceverificationrecordsdetailVO;
import com.ejianc.business.material.vo.MaterialapproachdetailVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;


/**
 * 物资（周转）进场验证记录子表导入导出
 */
@Controller
@RequestMapping("materialapproachdetailExport")
public class ExcelMaterialapproachdetailController {
    private static final long   serialVersionUID= 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IMaterialapproachdetailService service;
    @Autowired
    private IDeviceverificationrecordsdetailService deviceverificationrecordsdetailService;
    @Autowired
    private IShareMaterialApi shareMaterialApi;
    /**
     * 导出模板下载
     */
    @RequestMapping(value = "/downloadMaterialapproachdetail")
    @ResponseBody
    public void downloadMaterialapproachdetail (HttpServletRequest request, HttpServletResponse response){
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "Materialapproachdetail-import.xlsx", "物资进场验证记录明细");
    }
    /**
     * 从Excel导入
     */
    @RequestMapping(value = "/excelImportMaterialapproachdetail", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportMaterialapproachdetail(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<MaterialapproachdetailVO> successList = new ArrayList<>();
        List<MaterialapproachdetailVO> errorList = new ArrayList<>();
        Map<String, MaterialapproachdetailVO> map = new HashMap<>();
        DateFormat sdf=new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if(isFailed) {
            return CommonResponse.error("文件格式不合法");
        }else{
            List<List<String>> result = ExcelReader.readExcel(mf);
            if(result != null && result.size() > 0) {
                for(int i=1;i<result.size();i++) {
                    List<String> datas = result.get(i);
                    StringBuilder errorsMsgBuilder = new StringBuilder();

                    String materialClassCode = datas.get(0);
                    String materialClassName = datas.get(1);
                    String materialCode = datas.get(2);
                    String name = datas.get(3);
                    String spec = datas.get(4);
                    String unit = datas.get(5);
                    String enterCount = datas.get(6);//
                    String verificationCount = datas.get(7);//
                    String verificationWay = datas.get(8);
                    String code = datas.get(9);
                    String conclusion = datas.get(10);
                    String remarks = datas.get(11);
                    //循环进来TPID
                    MaterialapproachdetailVO MaterialapproachdetailVO = new MaterialapproachdetailVO();
                    MaterialapproachdetailVO.setId(IdWorker.getId());//id
                    //三目判断值是否空
                    MaterialapproachdetailVO.setMaterialClassCode(StringUtils.isNotBlank(materialClassCode) ? materialClassCode : null);
                    MaterialapproachdetailVO.setMaterialClassName(StringUtils.isNotBlank(materialClassName) ? materialClassName : null);
                    MaterialapproachdetailVO.setMaterialCode(StringUtils.isNotBlank(materialCode) ? materialCode : null);
                    MaterialapproachdetailVO.setName(StringUtils.isNotBlank(name) ? name : null);
                    MaterialapproachdetailVO.setSpec(StringUtils.isNotBlank(spec) ? spec : null);
                    MaterialapproachdetailVO.setUnit(StringUtils.isNotBlank(unit) ? unit : null);
                    MaterialapproachdetailVO.setVerificationWay(StringUtils.isNotBlank(verificationWay) ? verificationWay : null);
                    MaterialapproachdetailVO.setCode(StringUtils.isNotBlank(code) ? code : null);
                    MaterialapproachdetailVO.setConclusion(StringUtils.isNotBlank(conclusion) ? conclusion : null);
                    MaterialapproachdetailVO.setRemarks(StringUtils.isNotBlank(remarks) ? remarks : null); // 备注

                    Long categoryId = deviceverificationrecordsdetailService.queryCategoryByCode(materialCode);
                    CommonResponse<MaterialVO> materialVO = shareMaterialApi.queryMaterialByCode(materialCode);
                    if (categoryId == null || materialVO.getData() == null) {
                        MaterialapproachdetailVO.setErrorMsg("物资编码错误！");
                        errorsMsgBuilder.append("物资编码错误！");
                    } else if (!materialVO.getData().getCategoryCode().equals(materialClassCode)) {
                        MaterialapproachdetailVO.setErrorMsg("物资分类编码错误！");
                        errorsMsgBuilder.append("物资分类编码错误！");
                    } else if (materialVO.getData() != null) {
                        MaterialapproachdetailVO.setMaterialId(materialVO.getData().getId());
                        MaterialapproachdetailVO.setMaterialClassId(materialVO.getData().getCategoryId());
                    }
                    //CommonResponse<MaterialCategoryVO> materialCategoryVO = materialApi.queryCategoryById(categoryId);
                    //if (!materialCategoryVO.getData().getCode().equals(materialClassCode)) {
                    //    MaterialapproachdetailVO.setErrorMsg("物资分类编码错误！");
                    //    errorsMsgBuilder.append("物资分类编码错误！");
                    //}
                    //必填项校验
                    if (name == null || TextUtils.isEmpty(name)) {
                        MaterialapproachdetailVO.setErrorMsg("物资名称不能为空！");
                        errorsMsgBuilder.append("物资名称不能为空！");
                    }

                    //格式校验
                    if (!TextUtils.isEmpty(enterCount) && !NumberUtil.isNumber(enterCount)) {
                        MaterialapproachdetailVO.setErrorMsg("进场数量格式不正确！");
                        errorsMsgBuilder.append("进场数量格式不正确！");
                    } else {
                        MaterialapproachdetailVO.setEnterCount(StringUtils.isNotBlank(enterCount) ? new BigDecimal(enterCount) : null); //进场数量
                    }
                    if (!TextUtils.isEmpty(verificationCount) && !NumberUtil.isNumber(verificationCount)) {
                        MaterialapproachdetailVO.setErrorMsg("验证数量格式不正确！");
                        errorsMsgBuilder.append("验证数量格式不正确！");
                    } else {
                        MaterialapproachdetailVO.setVerificationCount(StringUtils.isNotBlank(verificationCount) ? new BigDecimal(verificationCount) : null); //验证数量
                    }
                    if(errorsMsgBuilder.length() > 0){
                        errorList.add(MaterialapproachdetailVO);
                    }else {
                        successList.add(MaterialapproachdetailVO);
                    }
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());

        MaterialapproachdetailVO resVo = new MaterialapproachdetailVO();
//        json.put("total", resList);
        json.put("total", resVo);
        return CommonResponse.success(json);
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportMaterialapproachdetailFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportMaterialapproachdetailFromDatabase(@RequestBody MaterialapproachdetailVO MaterialapproachdetailVO, HttpServletResponse response) {
        QueryWrapper<MaterialapproachdetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", MaterialapproachdetailVO.getId());
        queryWrapper.eq("dr", 0);
        List<MaterialapproachdetailEntity> list = service.list(queryWrapper);
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Materialapproachdetail-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportMaterialapproachdetailFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportMaterialapproachdetailFromPage(@RequestBody List<MaterialapproachdetailVO> list, HttpServletResponse response) {

        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Materialapproachdetail-export.xlsx", beans, response);
    }
}
