package com.ejianc.business.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.material.bean.*;
import com.ejianc.business.material.service.*;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

@Service("deliveryrecord")
public class DeliveryrecordBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());
	private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改
	@Autowired
	private IBillCodeApi billCodeApi;
	@Autowired
	private IDeliveryrecordService deliveryrecordService;
	@Autowired
	private IDeliveryrecorddetailService detailService;
	@Autowired
	private IRealtimebalanceService realtimebalanceService;
	@Autowired
	private IFlowmeterService flowmeterService;
	@Autowired
	private IMaterialWarehousingService materialWarehousingService;
	@Autowired
	private IMaterialWarehousingdetailService materialWarehousingdetailService;
	@Autowired
	private MaterialWarehousingBpmServiceImpl materialWarehousingBpmServiceImpl;
	@Autowired
	private IStoreService storeService;

	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	@Transactional(rollbackFor = Exception.class)
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	@Transactional(rollbackFor = Exception.class)
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		DeliveryrecordEntity deliveryrecordEntity = deliveryrecordService.selectById(billId);
		List<FlowmeterEntity> list = new ArrayList<>();//出入库流水记录表
		BigDecimal bigDecimal = new BigDecimal(0.00);
		MaterialWarehousingEntity materialWarehousingEntity = null;//入库单主表
		List<MaterialWarehousingdetailEntity> warehousingdetailList = new ArrayList<>();//入库单子表
		List<DeliveryrecorddetailEntity> deliveryrecorddetailEntity = deliveryrecordEntity.getDeliveryrecorddetailEntities();
		if(deliveryrecordEntity.getDeliveryTypes() == 7){//直入直出退供应商
			//自动生成退供应商入库单
			materialWarehousingEntity = materialWarehousingService.getById(deliveryrecordEntity.getReceiptDocId());
			materialWarehousingEntity.setId(null);
			materialWarehousingEntity.setMaterialapproachId(null);
			materialWarehousingEntity.setMaterialapproach(null);
			materialWarehousingEntity.setWarehousingType(1);
			materialWarehousingEntity.setWarehouseingId(deliveryrecordEntity.getReceiptDocId());
			materialWarehousingEntity.setAcceptanceType(null);
			materialWarehousingEntity.setSubContract(null);
			materialWarehousingEntity.setSubContractId(null);
			materialWarehousingEntity.setNotReturnedQuantity(null);
			materialWarehousingEntity.setBillState(3);
			materialWarehousingEntity.setBillsTime(new Date());
			materialWarehousingEntity.setPlantTime(null);
			materialWarehousingEntity.setPuinTime(deliveryrecordEntity.getReturnedStoreDate());
			materialWarehousingEntity.setDeliveryrecordId(deliveryrecordEntity.getId());
			CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
			if(billCode.isSuccess()) {
				materialWarehousingEntity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
			}else{
				throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
			}
		}
		if(deliveryrecorddetailEntity.size() > 0 && deliveryrecorddetailEntity != null){
			for(DeliveryrecorddetailEntity entity : deliveryrecorddetailEntity){
				if(deliveryrecordEntity.getDeliveryTypes() == 7){ //直入直出退供应商生成子表
					MaterialWarehousingdetailEntity entity1 = new MaterialWarehousingdetailEntity();
					entity1.setMaterialCategoryId(entity.getMaterialCategoryId());
					entity1.setMaterialCategoryCode(entity.getMaterialCategoryCode());
					entity1.setMaterialCategoryName(entity.getMaterialCategoryName());
					entity1.setMaterialCode(entity.getMaterialCode());
					entity1.setMaterialName(entity.getMaterialName());
					entity1.setSpecialModel(entity.getSpecialModel());
					entity1.setMaterialId(entity.getMaterialId());
					entity1.setUnit(entity.getMeasurementUnit());
					entity1.setQuantity(entity.getDeliveryQuantity());
					entity1.setUnitPriceIncluetax(entity.getUnitPriceIncluetax());
					entity1.setUnitPriceExcluetax(entity.getUnitPriceExcluetax());
					QueryWrapper<MaterialWarehousingdetailEntity> queryWrapper = new QueryWrapper<>();
					queryWrapper.eq("mid",deliveryrecordEntity.getReceiptDocId());
					queryWrapper.eq("material_category_code",entity.getMaterialCategoryCode());
					queryWrapper.eq("material_code",entity.getMaterialCode());
					queryWrapper.eq("material_name",entity.getMaterialName());
					logger.info(entity.getMaterialName()+entity.getMaterialCode()+entity.getMaterialId());
					List<MaterialWarehousingdetailEntity> warehousingdetailEntityList = materialWarehousingdetailService.list(queryWrapper);
					MaterialWarehousingdetailEntity one = warehousingdetailEntityList.stream().findFirst().get();
					entity1.setTaxRate(one.getTaxRate());
					entity1.setAmountIncluetax(entity.getAmountIncluetax());
					entity1.setAmountExcluetax(entity.getAmountExcluetax());
					entity1.setQuantityNum(one.getQuantityNum());
					entity1.setProjectId(one.getProjectId());
					entity1.setProjectName(one.getProjectName());
					entity1.setOrgId(one.getOrgId());
					entity1.setOrgName(one.getOrgName());
					entity1.setProjectDepartmentId(one.getProjectDepartmentId());
					entity1.setStoreId(one.getStoreId());
					entity1.setSupplierName(one.getSupplierName());
					entity1.setWarehouseingDetailId(one.getId());
					warehousingdetailList.add(entity1);
				}
				if(deliveryrecordEntity.getDeliveryTypes() == 0 ||  deliveryrecordEntity.getDeliveryTypes() == 4){//出库
				}else{
					FlowmeterEntity flowmeterEntity = this.createrFlowmeter(deliveryrecordEntity,entity,1,new Date());
					//出入库流水表
					list.add(flowmeterEntity);
				}
			}
			if(deliveryrecordEntity.getDeliveryTypes() == 0 || deliveryrecordEntity.getDeliveryTypes() == 3 ||  deliveryrecordEntity.getDeliveryTypes() == 4){//出库
//				deliveryrecordEntity.setNotDeliveryQuantity(bigDecimal);
//				deliveryrecordService.updateById(deliveryrecordEntity);
			}
			if(deliveryrecordEntity.getDeliveryTypes() == 1 || deliveryrecordEntity.getDeliveryTypes() == 5 || deliveryrecordEntity.getDeliveryTypes() == 6) {//退库
//				DeliveryrecordEntity byId = deliveryrecordService.getById(deliveryrecordEntity.getDeliveryId());//退库时选的出库单id
//				byId.setNotDeliveryQuantity(byId.getNotDeliveryQuantity().subtract(bigDecimal.multiply(new BigDecimal(-1.00))));
//				deliveryrecordService.updateById(byId);
			}
			if(deliveryrecordEntity.getDeliveryTypes() == 2 || deliveryrecordEntity.getDeliveryTypes() == 7){//直入直出退库或直入直出退供应商
//				MaterialWarehousingEntity byId = materialWarehousingService.getById(deliveryrecordEntity.getReceiptDocId());//退库时选的入库单id
//				QueryWrapper<DeliveryrecordEntity> queryWrapper = new QueryWrapper<>();
//				queryWrapper.eq("warehousing_id",byId.getId());
//				DeliveryrecordEntity one = deliveryrecordService.getOne(queryWrapper);//直入直出时生成的出库单
//				byId.setNotReturnedQuantity(byId.getNotReturnedQuantity().subtract(bigDecimal.multiply(new BigDecimal(-1.00))));//入库单减少未退库数量
//				materialWarehousingService.updateById(byId);
//				one.setNotDeliveryQuantity(one.getNotDeliveryQuantity().subtract(bigDecimal.multiply(new BigDecimal(-1.00))));//出库单减少未退库数量
//				deliveryrecordService.updateById(one);
			}

			if(deliveryrecordEntity.getDeliveryTypes() == 7){
				materialWarehousingEntity.setMaterialWarehousingdetailEntities(warehousingdetailList);
				boolean success = materialWarehousingService.saveOrUpdate(materialWarehousingEntity, false);
				BigDecimal bigDecimal1 = new BigDecimal(0.00);
				if(success == true){
					for(MaterialWarehousingdetailEntity entity : materialWarehousingEntity.getMaterialWarehousingdetailEntities()){
						bigDecimal1 = bigDecimal1.add(entity.getQuantity());
						MaterialWarehousingdetailEntity byId = materialWarehousingdetailService.getById(entity.getWarehouseingDetailId());//退供应商时选中的出库单子表数据
						byId.setNotReturnedQuantity(byId.getNotReturnedQuantity().subtract(entity.getQuantity().multiply(new BigDecimal(-1.00))));
						materialWarehousingdetailService.updateById(byId);

						//出入库流水
						FlowmeterEntity flowmeterEntity = materialWarehousingBpmServiceImpl.createrFlowmeter(materialWarehousingEntity, entity);
						flowmeterEntity.setApproveTime(new Date());
						flowmeterEntity.setBillStatus(1);
						list.add(flowmeterEntity);
					}
					MaterialWarehousingEntity byId = materialWarehousingService.getById(deliveryrecordEntity.getReceiptDocId());//入库单信息
					byId.setNotReturnedQuantity(byId.getNotReturnedQuantity().subtract(bigDecimal.multiply(new BigDecimal(-1.00))));
					materialWarehousingService.updateById(byId);
				}
			}
		}
		if(list.size() > 0){
			flowmeterService.saveBatch(list,list.size());
			if (deliveryrecordEntity.getDeliveryTypes() == 1 || deliveryrecordEntity.getDeliveryTypes() == 5 || deliveryrecordEntity.getDeliveryTypes() == 6 || deliveryrecordEntity.getDeliveryTypes() == 7 ||deliveryrecordEntity.getDeliveryTypes() == 8) {
				realtimebalanceService.updateRealtimeBalance(deliveryrecordEntity.getReturnedStoreId());
			}
		}

		if (deliveryrecordEntity.getDeliveryTypes() == 0 || deliveryrecordEntity.getDeliveryTypes() == 4){
			flowmeterService.updateFlow(billId,new Date(),1);
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	@Transactional(rollbackFor = Exception.class)
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("出库撤回--------------");
		DeliveryrecordEntity deliveryrecordEntity = deliveryrecordService.selectById(billId);
		BigDecimal bigDecimal = new BigDecimal(0.00);
		List<DeliveryrecorddetailEntity> deliveryrecorddetailEntity = deliveryrecordEntity.getDeliveryrecorddetailEntities();
		if(deliveryrecorddetailEntity.size() > 0 && deliveryrecorddetailEntity != null){
			for(DeliveryrecorddetailEntity entity : deliveryrecorddetailEntity){
				if(deliveryrecordEntity.getDeliveryTypes() == 0 || deliveryrecordEntity.getDeliveryTypes() == 3 ||  deliveryrecordEntity.getDeliveryTypes() == 4){//出库
					bigDecimal = bigDecimal.add(entity.getDeliveryQuantity());
					entity.setNotReturnedQuantity(entity.getNotReturnedQuantity().subtract(entity.getDeliveryQuantity()));
					detailService.updateById(entity);
				}
				if(deliveryrecordEntity.getDeliveryTypes() == 1 || deliveryrecordEntity.getDeliveryTypes() == 5 || deliveryrecordEntity.getDeliveryTypes() == 6){//退库
					bigDecimal = bigDecimal.add(entity.getDeliveryQuantity());
					DeliveryrecorddetailEntity byId = detailService.getById(entity.getDeliveryDetailId());//退库时选中的出库单子表数据
					byId.setNotReturnedQuantity(byId.getNotReturnedQuantity().add(entity.getDeliveryQuantity().multiply(new BigDecimal(-1.00))));
					detailService.updateById(byId);
				}
				if(deliveryrecordEntity.getDeliveryTypes() == 2 || deliveryrecordEntity.getDeliveryTypes() == 7){//直入直出退库
					bigDecimal = bigDecimal.add(entity.getDeliveryQuantity());
					DeliveryrecorddetailEntity byId = detailService.getById(entity.getDeliveryDetailId());//直入直出退库时选中的出库单子表数据
					byId.setNotReturnedQuantity(byId.getNotReturnedQuantity().add(entity.getDeliveryQuantity().multiply(new BigDecimal(-1.00))));
					detailService.updateById(byId);
				}
			}
			if(deliveryrecordEntity.getDeliveryTypes() == 0 || deliveryrecordEntity.getDeliveryTypes() == 3 ||  deliveryrecordEntity.getDeliveryTypes() == 4){//出库
				deliveryrecordEntity.setNotDeliveryQuantity((deliveryrecordEntity.getNotDeliveryQuantity() != null ? deliveryrecordEntity.getNotDeliveryQuantity() : BigDecimal.ZERO).subtract(bigDecimal));
				deliveryrecordService.updateById(deliveryrecordEntity);
			}
			if(deliveryrecordEntity.getDeliveryTypes() == 1 || deliveryrecordEntity.getDeliveryTypes() == 5 || deliveryrecordEntity.getDeliveryTypes() == 6){//退库
				DeliveryrecordEntity byId = deliveryrecordService.getById(deliveryrecordEntity.getDeliveryId());
				byId.setNotDeliveryQuantity(byId.getNotDeliveryQuantity().add(bigDecimal.multiply(new BigDecimal(-1.00))));
				deliveryrecordService.updateById(byId);
			}
			if(deliveryrecordEntity.getDeliveryTypes() == 2 || deliveryrecordEntity.getDeliveryTypes() == 7){//直入直出退库
				MaterialWarehousingEntity byId = materialWarehousingService.getById(deliveryrecordEntity.getReceiptDocId());//退库时选的入库单id
				QueryWrapper<DeliveryrecordEntity> queryWrapper = new QueryWrapper<>();
				queryWrapper.eq("warehousing_id",byId.getId());
				DeliveryrecordEntity one = deliveryrecordService.getOne(queryWrapper);//查询直入直出时自动生成的退库单
				byId.setNotReturnedQuantity(byId.getNotReturnedQuantity().add(bigDecimal.multiply(new BigDecimal(-1.00))));//修改入库单上的未退库数量
				materialWarehousingService.updateById(byId);
				one.setNotDeliveryQuantity(one.getNotDeliveryQuantity().add(bigDecimal.multiply(new BigDecimal(-1.00))));//修改直入直出时自动生成出库单的未退库数量
				deliveryrecordService.updateById(one);
			}
			if(deliveryrecordEntity.getDeliveryTypes() == 7){//直入直出退供应商  撤回直接删除
				List<FlowmeterEntity> flowmeterList = new ArrayList<>();
				List<RealtimebalanceEntity> realtimebalanceList = new ArrayList<>();
				QueryWrapper<MaterialWarehousingEntity> queryWrapper = new QueryWrapper<>();
				queryWrapper.eq("deliveryrecord_id",deliveryrecordEntity.getId());
				List<MaterialWarehousingEntity> list1 = materialWarehousingService.list(queryWrapper);
				for(MaterialWarehousingEntity materialWarehousingEntity : list1){
					QueryWrapper<MaterialWarehousingdetailEntity> queryWrapper1 = new QueryWrapper<>();
					queryWrapper1.eq("mid",materialWarehousingEntity.getId());
					List<MaterialWarehousingdetailEntity> list2 = materialWarehousingdetailService.list(queryWrapper1);
					for(MaterialWarehousingdetailEntity materialWarehousingdetailEntity : list2){
						QueryWrapper<FlowmeterEntity> queryWrapper2 = new QueryWrapper<>();
						queryWrapper2.eq("detail_id",materialWarehousingdetailEntity.getId());
						FlowmeterEntity flowmeterEntity = flowmeterService.getOne(queryWrapper2);
						flowmeterList.add(flowmeterEntity);
					}
				}
				if(list1.size() > 0){
					materialWarehousingService.removeByIds(list1.stream().map(MaterialWarehousingEntity::getId).collect(Collectors.toList()),true);
				}
			}

			//处理出入库流水记录
			if (deliveryrecordEntity.getDeliveryTypes() == 0 || deliveryrecordEntity.getDeliveryTypes() == 4){
				flowmeterService.updateFlow(billId,null,0);
			}else {
				LambdaQueryWrapper<FlowmeterEntity> lambdaFlower = Wrappers.<FlowmeterEntity>lambdaQuery();
				lambdaFlower.eq(FlowmeterEntity::getMid,billId);
				flowmeterService.remove(lambdaFlower);
				if (deliveryrecordEntity.getDeliveryTypes() == 1 || deliveryrecordEntity.getDeliveryTypes() == 5 || deliveryrecordEntity.getDeliveryTypes() == 6 || deliveryrecordEntity.getDeliveryTypes() == 7 ||deliveryrecordEntity.getDeliveryTypes() == 8){
					realtimebalanceService.updateRealtimeBalance(deliveryrecordEntity.getReturnedStoreId());
				}
			}
		}
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 创建出入库流水记录
	 * @param deliveryrecordEntity  出库表信息
	 * @param entity  出库表子表信息
	 * @return
	 */
	public FlowmeterEntity createrFlowmeter(DeliveryrecordEntity deliveryrecordEntity,DeliveryrecorddetailEntity entity,Integer billStatus,Date approveTime){
		FlowmeterEntity flowmeterEntity = new FlowmeterEntity();
		flowmeterEntity.setMid(deliveryrecordEntity.getId());
		flowmeterEntity.setDetailId(entity.getId());
		flowmeterEntity.setMaterialId(entity.getMaterialId());
		flowmeterEntity.setBillCode(deliveryrecordEntity.getBillCode());
		flowmeterEntity.setProjectId(deliveryrecordEntity.getProjectId());
		flowmeterEntity.setProjectName(deliveryrecordEntity.getProjectName());
		if (deliveryrecordEntity.getDeliveryTypes() == 1 || deliveryrecordEntity.getDeliveryTypes() == 5 || deliveryrecordEntity.getDeliveryTypes() == 6 || deliveryrecordEntity.getDeliveryTypes() == 7 ||deliveryrecordEntity.getDeliveryTypes() == 8){
			flowmeterEntity.setStoreId(deliveryrecordEntity.getReturnedStoreId());
			flowmeterEntity.setStoreType(storeService.queryStoreType(deliveryrecordEntity.getReturnedStoreId()));
			flowmeterEntity.setStoreName(deliveryrecordEntity.getReturnedStoreName());
		}else {
			flowmeterEntity.setStoreId(deliveryrecordEntity.getStoreId());
			flowmeterEntity.setStoreType(storeService.queryStoreType(deliveryrecordEntity.getStoreId()));
			flowmeterEntity.setStoreName(deliveryrecordEntity.getStoreName());
		}
		flowmeterEntity.setSupplierId(deliveryrecordEntity.getPickingunitId());
		flowmeterEntity.setSupplierName(deliveryrecordEntity.getPickingUnit());
		flowmeterEntity.setMaterialCode(entity.getMaterialCode());
		flowmeterEntity.setMaterialName(entity.getMaterialName());
		flowmeterEntity.setMaterialCategoryId(entity.getMaterialCategoryId());
		flowmeterEntity.setMaterialCategoryCode(entity.getMaterialCategoryCode());
		flowmeterEntity.setMaterialCategoryName(entity.getMaterialCategoryName());
		flowmeterEntity.setBillStatus(billStatus);
		flowmeterEntity.setBillTime(deliveryrecordEntity.getCreateTime());
		flowmeterEntity.setSubUnitId(deliveryrecordEntity.getPickingunitId());
		flowmeterEntity.setSubUnitName(deliveryrecordEntity.getPickingUnit());
		if(deliveryrecordEntity.getDeliveryTypes() == 0 || deliveryrecordEntity.getDeliveryTypes() == 3 ||  deliveryrecordEntity.getDeliveryTypes() == 4){//出库
			flowmeterEntity.setOperationType("出库");
			if(deliveryrecordEntity.getDeliveryTypes() == 0){
				flowmeterEntity.setAccessType("成品出库");
			}else if(deliveryrecordEntity.getDeliveryTypes() == 3){
				flowmeterEntity.setAccessType("废旧物资出库");
			}else if (deliveryrecordEntity.getDeliveryTypes() == 4){
				flowmeterEntity.setAccessType("资产出库");
			}
			flowmeterEntity.setTime(deliveryrecordEntity.getPickingTime());
			flowmeterEntity.setQuantity(entity.getDeliveryQuantity());
			flowmeterEntity.setAmountIncluetax(entity.getAmountIncluetax());
			flowmeterEntity.setAmountExcluetax(entity.getAmountExcluetax());
		}else{
			flowmeterEntity.setTime(deliveryrecordEntity.getReturnedStoreDate());
			flowmeterEntity.setApproveTime(approveTime);
			flowmeterEntity.setOperationType("入库");
			if(deliveryrecordEntity.getDeliveryTypes() == 1){
				flowmeterEntity.setOperationType("出库");
				flowmeterEntity.setAccessType("成品退库");
			}else if(deliveryrecordEntity.getDeliveryTypes() == 5){
				flowmeterEntity.setOperationType("出库");
				flowmeterEntity.setAccessType("废旧物资退库");
			}else if (deliveryrecordEntity.getDeliveryTypes() == 6){
				flowmeterEntity.setOperationType("出库");
				flowmeterEntity.setAccessType("资产退库");
			}else if(deliveryrecordEntity.getDeliveryTypes() == 2){
				flowmeterEntity.setAccessType("直入直出退库");
			}else if (deliveryrecordEntity.getDeliveryTypes() == 7){
				flowmeterEntity.setOperationType("出库");
				flowmeterEntity.setAccessType("直入直出退供应商");
			}else if (deliveryrecordEntity.getDeliveryTypes() == 8){
				flowmeterEntity.setOperationType("出库");
				flowmeterEntity.setAccessType("无来源退库");
			}
			flowmeterEntity.setQuantity(entity.getDeliveryQuantity());
			flowmeterEntity.setAmountIncluetax(entity.getAmountIncluetax());
			flowmeterEntity.setAmountExcluetax(entity.getAmountExcluetax());
		}
		flowmeterEntity.setUnitPriceIncluetax(entity.getUnitPriceIncluetax());
		flowmeterEntity.setUnitPriceExcluetax(entity.getUnitPriceExcluetax());
		flowmeterEntity.setOrgId(deliveryrecordEntity.getOrgId());
		flowmeterEntity.setOrgName(deliveryrecordEntity.getOrgName());
		flowmeterEntity.setMeasurementUnit(entity.getMeasurementUnit());
		flowmeterEntity.setSpecialModel(entity.getSpecialModel());
		flowmeterEntity.setProjectDepartmentId(deliveryrecordEntity.getProjectDepartmentId());
		//查询仓库类型
		StoreEntity storeEntity = storeService.selectById(flowmeterEntity.getStoreId());
		flowmeterEntity.setStoreType(storeEntity.getStoreType());
		flowmeterEntity.setSupplierId(deliveryrecordEntity.getPickingunitId());
		flowmeterEntity.setSupplierName(deliveryrecordEntity.getPickingUnit());
		if(deliveryrecordEntity.getDeliveryTypes() == 7 && deliveryrecordEntity.getReceiptDocId() != null){
			//根据入库单查询对应的出库单信息
			QueryWrapper<DeliveryrecordEntity> queryWrapper = new QueryWrapper<>();
			queryWrapper.eq("warehousing_id",deliveryrecordEntity.getReceiptDocId());
			DeliveryrecordEntity deliveryrecordEntityOut = deliveryrecordService.getOne(queryWrapper);
			flowmeterEntity.setOutId(deliveryrecordEntityOut.getId());
		}else{
			flowmeterEntity.setOutId(deliveryrecordEntity.getDeliveryId());
		}


		flowmeterEntity.setBillType(1);
		return  flowmeterEntity;
	}


}
