package com.ejianc.business.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.material.bean.*;
import com.ejianc.business.material.service.IDeliveryrecorddetailService;
import com.ejianc.business.material.service.IFlowmeterService;
import com.ejianc.business.material.service.IRealtimebalanceService;
import com.ejianc.business.material.vo.DeliveryrecordReportVO;
import com.ejianc.business.material.vo.DeliveryrecordSubVO;
import com.ejianc.business.material.vo.DeliveryrecordVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.material.mapper.DeliveryrecordMapper;
import com.ejianc.business.material.service.IDeliveryrecordService;
import org.springframework.transaction.annotation.Transactional;

import java.util.function.Function;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 物资出库记录
 * 
 * @author generator
 * 
 */
@Service("deliveryrecordService")
public class DeliveryrecordServiceImpl extends BaseServiceImpl<DeliveryrecordMapper, DeliveryrecordEntity> implements IDeliveryrecordService{

    @Autowired
    private DeliveryrecordMapper deliveryrecordMapper;
    @Autowired
    private IFlowmeterService flowmeterService;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private DeliveryrecordBpmServiceImpl deliveryrecordBpmService;
    @Autowired
    private MaterialWarehousingBpmServiceImpl materialWarehousingBpmService;
    @Autowired
    private IDeliveryrecorddetailService deliveryrecorddetailService;
    @Autowired
    private IRealtimebalanceService realtimebalanceService;

    @Override
    public List<DeliveryrecordSubVO> selectSub(String materialCode, String projectId) {
        List<DeliveryrecordSubVO> list = deliveryrecordMapper.selectSub(materialCode,projectId);
        return list;
    }

    @Override
    public List<DeliveryrecordReportVO> subDetail(Long projectId,String materialCode,String supplierName) {
        List<DeliveryrecordReportVO> deliveryrecordReportVOS = deliveryrecordMapper.subDetail(projectId, materialCode, supplierName);
        return deliveryrecordReportVOS;
    }
    @Transactional
    @Override
    public DeliveryrecordVO saveOrUpdate(DeliveryrecordVO saveorUpdateVO) {
        DeliveryrecordEntity entity = BeanMapper.map(saveorUpdateVO, DeliveryrecordEntity.class);
        List<DeliveryrecorddetailEntity> deliveryrecorddetailList = entity.getDeliveryrecorddetailEntities();
        BigDecimal outMny = deliveryrecorddetailList.stream().map(DeliveryrecorddetailEntity::getAmountExcluetax).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal outMnyTax = deliveryrecorddetailList.stream().map(DeliveryrecorddetailEntity::getAmountIncluetax).reduce(BigDecimal.ZERO, BigDecimal::add);
        entity.setOutMny(outMny);
        entity.setOutMnyTax(outMnyTax);
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setDeliveryType(1);
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        List<DeliveryrecorddetailEntity> deliveryrecorddetailEntities = entity.getDeliveryrecorddetailEntities();

        for (DeliveryrecorddetailEntity deliveryrecorddetail:deliveryrecorddetailEntities){
            if("del".equals(deliveryrecorddetail.getRowState())){
                continue;
            }

            //方便报表查询
            deliveryrecorddetail.setProjectId(entity.getProjectId());
            deliveryrecorddetail.setStoreId(entity.getStoreId());
            deliveryrecorddetail.setPickingTime(entity.getPickingTime());
            deliveryrecorddetail.setProjectName(entity.getProjectName());
            deliveryrecorddetail.setTenantId(entity.getTenantId());
            deliveryrecorddetail.setOrgId(entity.getOrgId());
            deliveryrecorddetail.setUnitId(entity.getPickingunitId());
            deliveryrecorddetail.setUnitName(entity.getPickingUnit());
            deliveryrecorddetail.setProjectDepartmentId(entity.getProjectDepartmentId());
        }
        List<DeliveryrecorddetailEntity> deliveryrecorddetailEntityList = entity.getDeliveryrecorddetailEntities();
        //        废旧物资退库,成品退库,资产退库的数量+成品退库+资产退库不能超过出库单本身的数量,包括自由态
        if (entity.getDeliveryTypes() == 1 || entity.getDeliveryTypes() == 5 || entity.getDeliveryTypes() == 6 || entity.getDeliveryTypes() == 7){
            //查询所有状态的进场验收数量,编辑保存时去掉本身
            if (CollectionUtils.isNotEmpty(deliveryrecorddetailEntityList)) {
                List<Long> deliveryDetailIds = deliveryrecorddetailEntityList.stream().map(DeliveryrecorddetailEntity::getDeliveryDetailId).collect(Collectors.toList());
                LambdaQueryWrapper<DeliveryrecorddetailEntity> lambdaWareDetail = Wrappers.<DeliveryrecorddetailEntity>lambdaQuery();
                lambdaWareDetail.in(DeliveryrecorddetailEntity::getDeliveryDetailId,deliveryDetailIds);
                if (saveorUpdateVO.getId() != null){
                    lambdaWareDetail.ne(DeliveryrecorddetailEntity::getMid,entity.getId());
                }
                List<DeliveryrecorddetailEntity> warehousingdetailEntityList = deliveryrecorddetailService.list(lambdaWareDetail);
                Map<Long, BigDecimal> numMap = new HashMap<>();
                if (CollectionUtils.isNotEmpty(warehousingdetailEntityList)){
                    numMap = warehousingdetailEntityList.stream().filter(s->s.getDeliveryQuantity().compareTo(BigDecimal.ZERO) == -1).collect(Collectors.groupingBy(DeliveryrecorddetailEntity::getDeliveryDetailId,
                            Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getDeliveryQuantity()).reduce(BigDecimal.ZERO, BigDecimal::add))));
                }

                for (DeliveryrecorddetailEntity deliveryrecorddetailEntity : deliveryrecorddetailEntityList){
                    BigDecimal num = BigDecimal.ZERO;
                    BigDecimal numDelivery = BigDecimal.ZERO;
                    BigDecimal numAll = BigDecimal.ZERO;
                    if (numMap.containsKey(deliveryrecorddetailEntity.getDeliveryDetailId())){
                        num = numMap.get(deliveryrecorddetailEntity.getDeliveryDetailId());
                    }

                    if (entity.getDeliveryTypes() == 1 || entity.getDeliveryTypes() == 5 || entity.getDeliveryTypes() == 6){
                        numDelivery = deliveryrecorddetailEntity.getDeliveryNum();
                        numAll = deliveryrecorddetailEntity.getDeliveryQuantity();
                    }
                    if (entity.getDeliveryTypes() == 7){
                        numDelivery = deliveryrecorddetailEntity.getDeliveryQuantity();
                        numAll = deliveryrecorddetailEntity.getNotReturnedQuantity();
                    }
                    BigDecimal allZy = numDelivery.add(num).multiply(new BigDecimal(-1.00));
                    if(allZy.compareTo(numAll) ==1){
                        throw new BusinessException("物资编号:" + deliveryrecorddetailEntity.getMaterialCode() + ",物资名称:" + deliveryrecorddetailEntity.getMaterialName() + "超过剩余可退库数量,不能保存!");
                    }
                }
            }
        }
//        //直入直出推供应商不能超过入库单的数量
//        if (entity.getDeliveryTypes() == 8){
//            //查询所有状态的进场验收数量,编辑保存时去掉本身
//            if (CollectionUtils.isNotEmpty(deliveryrecorddetailEntityList)) {
//                List<Long> deliveryDetailIds = deliveryrecorddetailEntityList.stream().map(DeliveryrecorddetailEntity::getDeliveryDetailId).collect(Collectors.toList());
//                LambdaQueryWrapper<DeliveryrecorddetailEntity> lambdaWareDetail = Wrappers.<DeliveryrecorddetailEntity>lambdaQuery();
//                lambdaWareDetail.in(DeliveryrecorddetailEntity::getDeliveryDetailId,deliveryDetailIds);
//                if (saveorUpdateVO.getId() != null){
//                    lambdaWareDetail.ne(DeliveryrecorddetailEntity::getMid,entity.getId());
//                }
//                List<DeliveryrecorddetailEntity> warehousingdetailEntityList = deliveryrecorddetailService.list(lambdaWareDetail);
//                Map<Long, BigDecimal> numMap = new HashMap<>();
//                if (CollectionUtils.isNotEmpty(warehousingdetailEntityList)){
//                    numMap = warehousingdetailEntityList.stream().filter(s->s.getDeliveryQuantity().compareTo(BigDecimal.ZERO) == -1).collect(Collectors.groupingBy(DeliveryrecorddetailEntity::getDeliveryDetailId,
//                            Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getDeliveryQuantity()).reduce(BigDecimal.ZERO, BigDecimal::add))));
//                }
//
//                for (DeliveryrecorddetailEntity deliveryrecorddetailEntity : deliveryrecorddetailEntityList){
//                    BigDecimal num = BigDecimal.ZERO;
//                    if (numMap.containsKey(deliveryrecorddetailEntity.getDeliveryDetailId())){
//                        num = numMap.get(deliveryrecorddetailEntity.getDeliveryDetailId());
//                    }
//                    BigDecimal allZy = deliveryrecorddetailEntity.getDeliveryNum().add(num).multiply(new BigDecimal(-1.00));
//                    if(allZy.compareTo(deliveryrecorddetailEntity.getDeliveryQuantity()) ==1){
//                        throw new BusinessException("物资编号:" + deliveryrecorddetailEntity.getMaterialCode() + ",物资名称:" + deliveryrecorddetailEntity.getMaterialName() + "超过剩余可退库数量,不能保存!");
//                    }
//                }
//            }
//        }

        super.saveOrUpdate(entity, false);


        //库存流水处理,出库操作保存推送流水
        List<FlowmeterEntity> flowmeterList = new ArrayList<>();//出入库流水表
        //先删后增
        LambdaQueryWrapper<FlowmeterEntity> lambdaFlower = Wrappers.<FlowmeterEntity>lambdaQuery();
        lambdaFlower.eq(FlowmeterEntity::getMid,entity.getId());
        flowmeterService.remove(lambdaFlower);
//        涉及出库的操作:
//        0-成品出库,4-资产出库,7-直入直出推供应商(入库-退供应商,负数,实际是出库),
        if(entity.getDeliveryTypes() == 0 || entity.getDeliveryTypes() == 4){
            if (CollectionUtils.isNotEmpty(deliveryrecorddetailEntityList)){
                List<RealtimebalanceEntity> realList = new ArrayList<>();//修改实时物资结存
                for (DeliveryrecorddetailEntity deliveryrecorddetailEntity : deliveryrecorddetailEntityList){
                    FlowmeterEntity flowmeterEntity = deliveryrecordBpmService.createrFlowmeter(entity, deliveryrecorddetailEntity,0,null);
                    flowmeterList.add(flowmeterEntity);
                }
                //校验是否超出剩余库存
                //通过流水校验
                //汇总数据
                List<Long> materialIds = deliveryrecorddetailEntityList.stream().map(DeliveryrecorddetailEntity::getMaterialId).collect(Collectors.toList());
                LambdaQueryWrapper<FlowmeterEntity> lambdaFlow = Wrappers.<FlowmeterEntity>lambdaQuery();
                lambdaFlow.eq(FlowmeterEntity::getStoreId, entity.getStoreId());
                lambdaFlow.in(FlowmeterEntity::getMaterialId, materialIds);
                if (saveorUpdateVO.getId() != null) {
                    lambdaFlow.ne(FlowmeterEntity::getMid, saveorUpdateVO.getId());
                }
                List<FlowmeterEntity> flowmeterEntityList = flowmeterService.list(lambdaFlow);
                Map<Long, BigDecimal> numInMap = flowmeterEntityList.stream().filter(s -> s.getOperationType().equals("入库")).collect(Collectors.groupingBy(FlowmeterEntity::getMaterialId,
                        Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getQuantity()).reduce(BigDecimal.ZERO, BigDecimal::add))));
                Map<Long, BigDecimal> numOutMap = flowmeterEntityList.stream().filter(s -> s.getOperationType().equals("出库")).collect(Collectors.groupingBy(FlowmeterEntity::getMaterialId,
                        Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getQuantity()).reduce(BigDecimal.ZERO, BigDecimal::add))));
                BigDecimal inNum = BigDecimal.ZERO;
                BigDecimal outNum = BigDecimal.ZERO;
                for (DeliveryrecorddetailEntity deliveryrecorddetailEntity : deliveryrecorddetailEntityList){
                    inNum = BigDecimal.ZERO;
                    outNum = BigDecimal.ZERO;
                    if (numInMap.containsKey(deliveryrecorddetailEntity.getMaterialId())){
                        inNum = numInMap.get(deliveryrecorddetailEntity.getMaterialId());
                    }
                    if (numOutMap.containsKey(deliveryrecorddetailEntity.getMaterialId())){
                        outNum = numOutMap.get(deliveryrecorddetailEntity.getMaterialId());
                    }
                    BigDecimal subtract = inNum.subtract(outNum);
                    if (deliveryrecorddetailEntity.getDeliveryQuantity().compareTo(subtract) == 1){
                        throw new BusinessException("物资编号:" + deliveryrecorddetailEntity.getMaterialCode() + ",物资名称:" + deliveryrecorddetailEntity.getMaterialName() + "库存不足，不能出库!");
                    }

                }

                flowmeterService.saveBatch(flowmeterList);
                //更新实时物资结存表
                realtimebalanceService.updateRealtimeBalance(entity.getStoreId());
            }
        }



        DeliveryrecordVO vo = BeanMapper.map(entity, DeliveryrecordVO.class);
        return vo;
    }

    @Transactional
    @Override
    public void delete(List<DeliveryrecordVO> vos) {
        //删除流水
        //先删后增
        List<Long> ids = vos.stream().map(DeliveryrecordVO::getId).collect(Collectors.toList());
        LambdaQueryWrapper<DeliveryrecordEntity> lambdaDelivery = Wrappers.<DeliveryrecordEntity>lambdaQuery();
        lambdaDelivery.in(DeliveryrecordEntity::getId,ids);
        List<DeliveryrecordEntity> deliveryrecordEntities = super.list(lambdaDelivery);

        LambdaQueryWrapper<FlowmeterEntity> lambdaFlower = Wrappers.<FlowmeterEntity>lambdaQuery();
        lambdaFlower.in(FlowmeterEntity::getMid,ids);
        flowmeterService.remove(lambdaFlower);
        //刷新实时库存
        for (DeliveryrecordEntity deliveryrecordEntity : deliveryrecordEntities){
            if (deliveryrecordEntity.getDeliveryTypes() == 0 || deliveryrecordEntity.getDeliveryTypes() == 4){
                realtimebalanceService.updateRealtimeBalance(deliveryrecordEntity.getStoreId());
            }
        }
        super.removeByIds(vos.stream().map(DeliveryrecordVO::getId).collect(Collectors.toList()),true);

    }
}
