package com.ejianc.business.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.material.bean.*;
import com.ejianc.business.material.service.IFlowmeterService;
import com.ejianc.business.material.service.IRealtimebalanceService;
import com.ejianc.business.material.vo.DeliveryrecordVO;
import com.ejianc.business.material.vo.SurplusmaterialrecordVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.material.mapper.SurplusmaterialrecordMapper;
import com.ejianc.business.material.service.ISurplusmaterialrecordService;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 剩余/废旧物资处理记录
 * 
 * @author generator
 * 
 */
@Service("surplusmaterialrecordService")
public class SurplusmaterialrecordServiceImpl extends BaseServiceImpl<SurplusmaterialrecordMapper, SurplusmaterialrecordEntity> implements ISurplusmaterialrecordService{
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IRealtimebalanceService realtimebalanceService;
    @Autowired
    private IFlowmeterService flowmeterService;
    @Autowired
    private SurplusmaterialrecordBpmServiceImpl surplusmaterialrecordBpmService;
    @Override
    public SurplusmaterialrecordVO saveOrUpdate(SurplusmaterialrecordVO saveorUpdateVO) {
        SurplusmaterialrecordEntity entity = BeanMapper.map(saveorUpdateVO, SurplusmaterialrecordEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        super.saveOrUpdate(entity, false);
        SurplusmaterialrecordVO vo = BeanMapper.map(entity, SurplusmaterialrecordVO.class);
        List<SurplusmaterialrecordtailEntity> surplusmaterialrecordtailEntities = entity.getSurplusmaterialrecordtailEntities();
        //库存流水处理,出库操作保存推送流水
        List<FlowmeterEntity> flowmeterList = new ArrayList<>();//出入库流水表
        //先删后增
        LambdaQueryWrapper<FlowmeterEntity> lambdaFlower = Wrappers.<FlowmeterEntity>lambdaQuery();
        lambdaFlower.eq(FlowmeterEntity::getMid,entity.getId());
        flowmeterService.remove(lambdaFlower);
        //校验是否超出剩余库存
        //通过流水校验
        //汇总数据
        List<Long> materialIds = surplusmaterialrecordtailEntities.stream().map(SurplusmaterialrecordtailEntity::getMaterialId).collect(Collectors.toList());
        LambdaQueryWrapper<FlowmeterEntity> lambdaFlow = Wrappers.<FlowmeterEntity>lambdaQuery();
        lambdaFlow.eq(FlowmeterEntity::getStoreId, entity.getStoreId());
        lambdaFlow.in(FlowmeterEntity::getMaterialId, materialIds);
        if (saveorUpdateVO.getId() != null) {
            lambdaFlow.ne(FlowmeterEntity::getMid, saveorUpdateVO.getId());
        }
        List<FlowmeterEntity> flowmeterEntityList = flowmeterService.list(lambdaFlow);
        Map<Long, BigDecimal> numInMap = flowmeterEntityList.stream().filter(s -> s.getOperationType().equals("入库")).collect(Collectors.groupingBy(FlowmeterEntity::getMaterialId,
                Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getQuantity()).reduce(BigDecimal.ZERO, BigDecimal::add))));
        Map<Long, BigDecimal> numOutMap = flowmeterEntityList.stream().filter(s -> s.getOperationType().equals("出库")).collect(Collectors.groupingBy(FlowmeterEntity::getMaterialId,
                Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getQuantity()).reduce(BigDecimal.ZERO, BigDecimal::add))));
        BigDecimal inNum = BigDecimal.ZERO;
        BigDecimal outNum = BigDecimal.ZERO;

        if (CollectionUtils.isNotEmpty(surplusmaterialrecordtailEntities)){
            for (SurplusmaterialrecordtailEntity surplusmaterialrecordtailEntity : surplusmaterialrecordtailEntities){
                FlowmeterEntity flowmeterEntity = surplusmaterialrecordBpmService.createrFlowmeter(entity, surplusmaterialrecordtailEntity,0,null);
                flowmeterList.add(flowmeterEntity);
                inNum = BigDecimal.ZERO;
                outNum = BigDecimal.ZERO;
                if (numInMap.containsKey(surplusmaterialrecordtailEntity.getMaterialId())){
                    inNum = numInMap.get(surplusmaterialrecordtailEntity.getMaterialId());
                }
                if (numOutMap.containsKey(surplusmaterialrecordtailEntity.getMaterialId())){
                    outNum = numOutMap.get(surplusmaterialrecordtailEntity.getMaterialId());
                }
                BigDecimal subtract = inNum.subtract(outNum);
                BigDecimal num = BigDecimal.ZERO;
                if (saveorUpdateVO.getIsRebarManagement() == 0){
                    num = surplusmaterialrecordtailEntity.getSuttle();
                }else {
                    num = surplusmaterialrecordtailEntity.getMaterialNumber();
                }
                if (num.compareTo(subtract) == 1){
                    throw new BusinessException("物资编号:" + surplusmaterialrecordtailEntity.getMaterialCode() + ",物资名称:" + surplusmaterialrecordtailEntity.getMaterialName() + "库存不足，不能出库!");
                }
            }

            flowmeterService.saveBatch(flowmeterList);
            realtimebalanceService.updateRealtimeBalance(entity.getStoreId());
        }
        return vo;
    }
    @Transactional
    @Override
    public void delete(List<SurplusmaterialrecordVO> vos) {
        //删除流水
        //先删后增
        List<Long> ids = vos.stream().map(SurplusmaterialrecordVO::getId).collect(Collectors.toList());
        LambdaQueryWrapper<SurplusmaterialrecordEntity> lambdaRecord = Wrappers.<SurplusmaterialrecordEntity>lambdaQuery();
        lambdaRecord.in(SurplusmaterialrecordEntity::getId,ids);
        List<SurplusmaterialrecordEntity> deliveryrecordEntities = super.list(lambdaRecord);

        LambdaQueryWrapper<FlowmeterEntity> lambdaFlower = Wrappers.<FlowmeterEntity>lambdaQuery();
        lambdaFlower.in(FlowmeterEntity::getMid,ids);
        flowmeterService.remove(lambdaFlower);
        //刷新实时库存
        for (SurplusmaterialrecordEntity surplusmaterialrecordEntity : deliveryrecordEntities){
            realtimebalanceService.updateRealtimeBalance(surplusmaterialrecordEntity.getStoreId());
        }
        super.removeByIds(vos.stream().map(SurplusmaterialrecordVO::getId).collect(Collectors.toList()),true);
    }

}
