package com.ejianc.business.material.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 物资（周转）进场验证记录
 *
 * @author generator
 *
 */
public class MaterialapproachVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    private java.lang.String billCode; // 单据编号
    private java.lang.Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date approveTime; // 审批日期
    private java.lang.String remarks; // 备注
    private java.lang.Long agentId; // 经办人
    private java.lang.String agentName; // 经办人姓名
    private java.lang.Long agentdepId; // 经办部门
    private java.lang.String agentdepName; // 经办部门名称
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date billTime; // 单据日期
    private java.lang.Long contractId; // 合同id
    private java.lang.Long orgId; // 所属组织id
    private java.lang.String orgName; // 所属组织名称
    private java.lang.Long projectDepartmentId; // 项目部id
    private java.lang.String contractName; // 合同名称
    private java.lang.String projectName; // 项目名称
    private java.lang.String contractCode; // 合同编号
    private java.lang.Long supplierId; // 供应商id
    private java.lang.String supplierName; // 供应商名称
    private java.lang.String brandName; // 品牌
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date enterTime; // 进场日期
    private java.lang.String projectMaterial; // 项目物资部
    private java.lang.String projectEngineering; // 项目工程部
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date verificationTime; // 验证日期
    private java.lang.Long subcontractorId; // 分包方id
    private java.lang.String subcontractorName; // 分包方（使用单位）

    private java.lang.String num; // 序号
    private java.lang.String billTimeShow; //单据日期时间显示
    private java.lang.String enterTimeShow; // 进场日期时间显示
    private java.lang.String billStateStr; // 单据状态文本显示
    private java.lang.String createTimeShow;
    private java.lang.Long projectId; // 项目id
    private java.math.BigDecimal notStorageNum; // 未入库数量

    private java.lang.Integer contractType; // 合同类型: 0物资采购；1周转材租赁

    @ReferSerialTransfer(referCode="ejc-zjkj-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getCreateTimeShow() {
        return createTimeShow;
    }

    public void setCreateTimeShow(String createTimeShow) {
        this.createTimeShow = createTimeShow;
    }

    private List<MaterialapproachdetailVO> materialapproachdetailEntities = new ArrayList<>(); // 物资（周转）进场验证记录子表

    public String getNum() {
        return num;
    }

    public void setNum(String num) {
        this.num = num;
    }

    public String getBillTimeShow() {
        return billTimeShow;
    }

    public void setBillTimeShow(String billTimeShow) {
        this.billTimeShow = billTimeShow;
    }

    public String getEnterTimeShow() {
        return enterTimeShow;
    }

    public void setEnterTimeShow(String enterTimeShow) {
        this.enterTimeShow = enterTimeShow;
    }

    public String getBillStateStr() {
        return billStateStr;
    }

    public void setBillStateStr(String billStateStr) {
        this.billStateStr = billStateStr;
    }

    /**
     * 单据编号
     */
    public java.lang.String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(java.lang.String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public java.lang.Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public void setBillState(java.lang.Integer billState) {
        this.billState = billState;
    }
    /**
     * 审批日期
     */
    public java.util.Date getApproveTime() {
        return approveTime;
    }

    /**
     * 审批日期
     */
    public void setApproveTime(java.util.Date approveTime) {
        this.approveTime = approveTime;
    }
    /**
     * 备注
     */
    public java.lang.String getRemarks() {
        return remarks;
    }

    /**
     * 备注
     */
    public void setRemarks(java.lang.String remarks) {
        this.remarks = remarks;
    }
    /**
     * 经办人
     */
    @ReferSerialTransfer(referCode = "idm-user")
    public java.lang.Long getAgentId() {
        return agentId;
    }

    /**
     * 经办人
     */
    @ReferDeserialTransfer
    public void setAgentId(java.lang.Long agentId) {
        this.agentId = agentId;
    }
    /**
     * 经办人姓名
     */
    public java.lang.String getAgentName() {
        return agentName;
    }

    /**
     * 经办人姓名
     */
    public void setAgentName(java.lang.String agentName) {
        this.agentName = agentName;
    }
    /**
     * 经办部门
     */
    @ReferSerialTransfer(referCode = "idm-dept")
    public java.lang.Long getAgentdepId() {
        return agentdepId;
    }

    /**
     * 经办部门
     */
    @ReferDeserialTransfer
    public void setAgentdepId(java.lang.Long agentdepId) {
        this.agentdepId = agentdepId;
    }
    /**
     * 经办部门名称
     */
    public java.lang.String getAgentdepName() {
        return agentdepName;
    }

    /**
     * 经办部门名称
     */
    public void setAgentdepName(java.lang.String agentdepName) {
        this.agentdepName = agentdepName;
    }
    /**
     * 单据日期
     */
    public java.util.Date getBillTime() {
        return billTime;
    }

    /**
     * 单据日期
     */
    public void setBillTime(java.util.Date billTime) {
        this.billTime = billTime;
    }
    /**
     * 合同id
     */
    @ReferSerialTransfer(referCode = "ejc-zjkj-outcontract")
    public java.lang.Long getContractId() {
        return contractId;
    }

    /**
     * 合同id
     */
    @ReferDeserialTransfer
    public void setContractId(java.lang.Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 所属组织id
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public java.lang.Long getOrgId() {
        return orgId;
    }

    /**
     * 所属组织id
     */
    @ReferDeserialTransfer
    public void setOrgId(java.lang.Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 所属组织名称
     */
    public java.lang.String getOrgName() {
        return orgName;
    }

    /**
     * 所属组织名称
     */
    public void setOrgName(java.lang.String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部id
     */
    public java.lang.Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    /**
     * 项目部id
     */
    public void setProjectDepartmentId(java.lang.Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    /**
     * 合同id
     */
    public java.lang.String getContractName() {
        return contractName;
    }

    /**
     * 合同id
     */
    public void setContractName(java.lang.String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同编号
     */
    public java.lang.String getContractCode() {
        return contractCode;
    }

    /**
     * 合同编号
     */
    public void setContractCode(java.lang.String contractCode) {
        this.contractCode = contractCode;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    /**
     * 供应商名称
     */
    public java.lang.String getSupplierName() {
        return supplierName;
    }

    /**
     * 供应商名称
     */
    public void setSupplierName(java.lang.String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 品牌
     */
    public java.lang.String getBrandName() {
        return brandName;
    }

    /**
     * 品牌
     */
    public void setBrandName(java.lang.String brandName) {
        this.brandName = brandName;
    }
    /**
     * 进场日期
     */
    public java.util.Date getEnterTime() {
        return enterTime;
    }

    /**
     * 进场日期
     */
    public void setEnterTime(java.util.Date enterTime) {
        this.enterTime = enterTime;
    }
    /**
     * 项目物资部
     */
    public java.lang.String getProjectMaterial() {
        return projectMaterial;
    }

    /**
     * 项目物资部
     */
    public void setProjectMaterial(java.lang.String projectMaterial) {
        this.projectMaterial = projectMaterial;
    }
    /**
     * 项目工程部
     */
    public java.lang.String getProjectEngineering() {
        return projectEngineering;
    }

    /**
     * 项目工程部
     */
    public void setProjectEngineering(java.lang.String projectEngineering) {
        this.projectEngineering = projectEngineering;
    }
    /**
     * 验证日期
     */
    public java.util.Date getVerificationTime() {
        return verificationTime;
    }

    /**
     * 验证日期
     */
    public void setVerificationTime(java.util.Date verificationTime) {
        this.verificationTime = verificationTime;
    }
    /**
     * 分包方id
     */
    @ReferSerialTransfer(referCode = "support-supplier")
    public java.lang.Long getSubcontractorId() {
        return subcontractorId;
    }

    /**
     * 分包方id
     */
    @ReferDeserialTransfer
    public void setSubcontractorId(java.lang.Long subcontractorId) {
        this.subcontractorId = subcontractorId;
    }
    /**
     * 分包方（使用单位）
     */
    public java.lang.String getSubcontractorName() {
        return subcontractorName;
    }

    /**
     * 分包方（使用单位）
     */
    public void setSubcontractorName(java.lang.String subcontractorName) {
        this.subcontractorName = subcontractorName;
    }

    public List<MaterialapproachdetailVO> getMaterialapproachdetailEntities() {
        return materialapproachdetailEntities;
    }

    public void setMaterialapproachdetailEntities(List<MaterialapproachdetailVO> materialapproachdetailEntities) {
        this.materialapproachdetailEntities = materialapproachdetailEntities;
    }

    public BigDecimal getNotStorageNum() {
        return notStorageNum;
    }

    public void setNotStorageNum(BigDecimal notStorageNum) {
        this.notStorageNum = notStorageNum;
    }

    public Integer getContractType() {
        return contractType;
    }

    public void setContractType(Integer contractType) {
        this.contractType = contractType;
    }
}
