/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.excel;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.material.service.IProcurementplandetailService;
import com.ejianc.business.material.utils.DateUtils;
import com.ejianc.business.material.vo.ProcurementplandetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"procurementplandetailExport"})
public class ExcelProcurementplandetailController {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IProcurementplandetailService service;

    @RequestMapping(value={"/downloadProcurementplandetail"})
    @ResponseBody
    public void downloadProcurementplandetail(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"Procurementplandetail-import.xlsx", (String)"\u9879\u76ee\u603b\u91c7\u8d2d\u8ba1\u5212\u660e\u7ec6\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportProcurementplandetail"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportProcurementplandetail(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<ProcurementplandetailVO> successList = new ArrayList<ProcurementplandetailVO>();
        ArrayList<ProcurementplandetailVO> errorList = new ArrayList<ProcurementplandetailVO>();
        HashMap map = new HashMap();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            for (int i = 1; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                StringBuilder errorsMsgBuilder = new StringBuilder();
                String itemCode = (String)datas.get(0);
                String itemName = (String)datas.get(1);
                String unit = (String)datas.get(2);
                String model = (String)datas.get(3);
                String category = (String)datas.get(4);
                String purchaseQuantity = (String)datas.get(5);
                String budgetPrice = (String)datas.get(6);
                String profitEstimates = (String)datas.get(7);
                String tenderingMethods = (String)datas.get(8);
                String cycle = (String)datas.get(9);
                String scheduleTenderTimes = (String)datas.get(10);
                String plannedStartDate = (String)datas.get(11);
                String plannedCompletionDate = (String)datas.get(12);
                String quantity = (String)datas.get(13);
                ProcurementplandetailVO procurementplandetailVO = new ProcurementplandetailVO();
                procurementplandetailVO.setId(IdWorker.getId());
                if (StringUtils.isBlank((CharSequence)itemCode)) {
                    procurementplandetailVO.setErrorMsg("\u7269\u6599\u7f16\u7801\u5fc5\u586b\u9879");
                    errorsMsgBuilder.append("\u7269\u6599\u7f16\u7801\u5fc5\u586b\u9879\uff01");
                } else {
                    procurementplandetailVO.setItemCode(itemCode);
                }
                if (StringUtils.isBlank((CharSequence)itemName)) {
                    procurementplandetailVO.setErrorMsg("\u7269\u6599\u540d\u79f0\u5fc5\u586b\u9879");
                    errorsMsgBuilder.append("\u7269\u6599\u540d\u79f0\u5fc5\u586b\u9879\uff01");
                } else {
                    procurementplandetailVO.setItemName(itemName);
                }
                if (StringUtils.isBlank((CharSequence)unit)) {
                    procurementplandetailVO.setErrorMsg("\u8ba1\u91cf\u5355\u4f4d\u5fc5\u586b\u9879");
                    errorsMsgBuilder.append("\u8ba1\u91cf\u5355\u4f4d\u5fc5\u586b\u9879\uff01");
                } else {
                    procurementplandetailVO.setUnit(unit);
                }
                if (StringUtils.isBlank((CharSequence)model)) {
                    procurementplandetailVO.setErrorMsg("\u89c4\u683c\u578b\u53f7\u5fc5\u586b\u9879");
                    errorsMsgBuilder.append("\u89c4\u683c\u578b\u53f7\u5fc5\u586b\u9879\uff01");
                } else {
                    procurementplandetailVO.setModel(model);
                }
                if (StringUtils.isBlank((CharSequence)category)) {
                    procurementplandetailVO.setErrorMsg("\u91c7\u8d2d\u7c7b\u522b\u5fc5\u586b\u9879");
                    errorsMsgBuilder.append("\u91c7\u8d2d\u7c7b\u522b\u5fc5\u586b\u9879\uff01");
                } else {
                    procurementplandetailVO.setCategory(category);
                }
                if (!StringUtils.isBlank((CharSequence)scheduleTenderTimes)) {
                    if (DateUtils.grepDate(scheduleTenderTimes)) {
                        procurementplandetailVO.setScheduleTenderTimes(DateUtils.Date(scheduleTenderTimes));
                    } else {
                        procurementplandetailVO.setErrorMsg("\u8ba1\u5212\u62db\u6807\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorsMsgBuilder.append("\u8ba1\u5212\u62db\u6807\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    }
                }
                if (!StringUtils.isBlank((CharSequence)plannedStartDate)) {
                    if (DateUtils.grepDate(plannedStartDate)) {
                        procurementplandetailVO.setPlannedStartDate(DateUtils.Date(plannedStartDate));
                    } else {
                        procurementplandetailVO.setErrorMsg("\u8ba1\u5212\u5f00\u5de5\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorsMsgBuilder.append("\u8ba1\u5212\u5f00\u5de5\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    }
                }
                if (!StringUtils.isBlank((CharSequence)plannedCompletionDate)) {
                    if (DateUtils.grepDate(plannedCompletionDate)) {
                        procurementplandetailVO.setPlannedCompletionDate(DateUtils.Date(plannedCompletionDate));
                    } else {
                        procurementplandetailVO.setErrorMsg("\u8ba1\u5212\u5b8c\u5de5\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                        errorsMsgBuilder.append("\u8ba1\u5212\u5b8c\u5de5\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    }
                }
                if (!TextUtils.isEmpty((CharSequence)purchaseQuantity) && !NumberUtil.isNumber((String)purchaseQuantity)) {
                    procurementplandetailVO.setErrorMsg("\u91c7\u8d2d\u6570\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u91c7\u8d2d\u6570\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    procurementplandetailVO.setPurchaseQuantity(StringUtils.isNotBlank((CharSequence)purchaseQuantity) ? new BigDecimal(purchaseQuantity) : null);
                }
                if (!TextUtils.isEmpty((CharSequence)budgetPrice) && !NumberUtil.isNumber((String)budgetPrice)) {
                    procurementplandetailVO.setErrorMsg("\u9884\u7b97\u91d1\u989d\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u9884\u7b97\u91d1\u989d\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    procurementplandetailVO.setBudgetPrice(new BigDecimal(budgetPrice));
                }
                if (!TextUtils.isEmpty((CharSequence)profitEstimates) && !NumberUtil.isNumber((String)profitEstimates)) {
                    procurementplandetailVO.setErrorMsg("\u5229\u6da6\u9884\u4f30\u7387\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u5229\u6da6\u9884\u4f30\u7387\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    procurementplandetailVO.setProfitEstimates(new BigDecimal(profitEstimates));
                }
                if (TextUtils.isEmpty((CharSequence)tenderingMethods)) {
                    procurementplandetailVO.setErrorMsg("\u62db\u6807\u65b9\u5f0f\u5fc5\u586b\u9879\uff01");
                    errorsMsgBuilder.append("\u62db\u6807\u65b9\u5f0f\u5fc5\u586b\u9879");
                } else {
                    if (tenderingMethods.equals("\u516c\u5f00")) {
                        tenderingMethods = "1";
                    } else if (tenderingMethods.equals("\u9080\u8bf7")) {
                        tenderingMethods = "2";
                    } else if (tenderingMethods.equals("\u72ec\u5bb6\u8bae\u6807")) {
                        tenderingMethods = "3";
                    } else {
                        procurementplandetailVO.setErrorMsg("\u62db\u6807\u65b9\u5f0f\u683c\u5f0f\u9519\u8bef\uff01");
                        errorsMsgBuilder.append("\u62db\u6807\u65b9\u5f0f\u683c\u5f0f\u9519\u8bef");
                    }
                    procurementplandetailVO.setTenderingMethods(tenderingMethods);
                }
                if (StringUtils.isBlank((CharSequence)cycle)) {
                    procurementplandetailVO.setErrorMsg("\u5de5\u671f/\u4f9b\u8d27/\u79df\u8d41\u5468\u671f\u5fc5\u586b\u9879");
                    errorsMsgBuilder.append("\u5de5\u671f/\u4f9b\u8d27/\u79df\u8d41\u5468\u671f\u5fc5\u586b\u9879\uff01");
                } else {
                    procurementplandetailVO.setCycle(cycle);
                }
                if (!TextUtils.isEmpty((CharSequence)quantity) && !NumberUtil.isNumber((String)quantity)) {
                    procurementplandetailVO.setErrorMsg("\u5206\u4f9b\u65b9\u6570\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u5206\u4f9b\u65b9\u6570\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    procurementplandetailVO.setQuantity(StringUtils.isNotBlank((CharSequence)quantity) ? new BigDecimal(quantity) : null);
                }
                if (errorsMsgBuilder.length() > 0) {
                    procurementplandetailVO.setErrorMsg(errorsMsgBuilder.toString());
                    errorList.add(procurementplandetailVO);
                    continue;
                }
                successList.add(procurementplandetailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        ProcurementplandetailVO resVo = new ProcurementplandetailVO();
        json.put("total", (Object)resVo);
        return CommonResponse.success((Object)json);
    }

    public static Date DoubleToDate(Double dVal) {
        Date tDate = new Date();
        long localOffset = tDate.getTimezoneOffset() * 60000;
        tDate.setTime((long)((dVal - 25569.0) * 24.0 * 3600.0 * 1000.0 + (double)localOffset));
        return tDate;
    }

    @RequestMapping(value={"/excelExportProcurementplandetailFromDatabase"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportProcurementplandetailFromDatabase(@RequestBody ProcurementplandetailVO procurementplandetailVO, HttpServletResponse response) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"mid", (Object)procurementplandetailVO.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.service.list((Wrapper)queryWrapper);
        List ProcurementplanVOList = BeanMapper.mapList((Iterable)list, ProcurementplandetailVO.class);
        if (ProcurementplanVOList != null && ProcurementplanVOList.size() > 0) {
            for (int i = 0; i < ProcurementplanVOList.size(); ++i) {
                ProcurementplandetailVO procurementplandetail = (ProcurementplandetailVO)((Object)ProcurementplanVOList.get(i));
                if (procurementplandetail.getScheduleTenderTimes() != null) {
                    procurementplandetail.setScheduleTenderTimesShow(DateUtils.dateSimple(procurementplandetail.getScheduleTenderTimes()));
                }
                if (procurementplandetail.getPlannedStartDate() != null) {
                    procurementplandetail.setPlannedStartDateShow(DateUtils.dateSimple(procurementplandetail.getPlannedStartDate()));
                }
                if (procurementplandetail.getPlannedCompletionDate() != null) {
                    procurementplandetail.setPlannedCompletionDateShow(DateUtils.dateSimple(procurementplandetail.getPlannedCompletionDate()));
                }
                String me = procurementplandetail.getTenderingMethods();
                if (procurementplandetail.getTenderingMethods() == null) continue;
                if (me.equals("1")) {
                    procurementplandetail.setMethods("\u516c\u5f00");
                    continue;
                }
                if (me.equals("2")) {
                    procurementplandetail.setMethods("\u9080\u8bf7");
                    continue;
                }
                if (!me.equals("3")) continue;
                procurementplandetail.setMethods("\u72ec\u5bb6\u8bae\u6807");
            }
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", ProcurementplanVOList);
        ExcelExport.getInstance().export("Procurementplandetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExportProcurementplandetailFromPage"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportProcurementplandetailFromPage(@RequestBody List<ProcurementplandetailVO> list, HttpServletResponse response) {
        ArrayList<ProcurementplandetailVO> concatList = new ArrayList<ProcurementplandetailVO>();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                ProcurementplandetailVO procurementplandetailVO = list.get(i);
                if (procurementplandetailVO.getScheduleTenderTimes() != null) {
                    procurementplandetailVO.setScheduleTenderTimesShow(DateUtils.dateSimple(procurementplandetailVO.getScheduleTenderTimes()));
                }
                if (procurementplandetailVO.getPlannedStartDate() != null) {
                    procurementplandetailVO.setPlannedStartDateShow(DateUtils.dateSimple(procurementplandetailVO.getPlannedStartDate()));
                }
                if (procurementplandetailVO.getPlannedCompletionDate() != null) {
                    procurementplandetailVO.setPlannedCompletionDateShow(DateUtils.dateSimple(procurementplandetailVO.getPlannedCompletionDate()));
                }
                String me = procurementplandetailVO.getTenderingMethods();
                if (procurementplandetailVO.getTenderingMethods() != null) {
                    if (me.equals("1")) {
                        procurementplandetailVO.setMethods("\u516c\u5f00");
                    } else if (me.equals("2")) {
                        procurementplandetailVO.setMethods("\u9080\u8bf7");
                    } else if (me.equals("3")) {
                        procurementplandetailVO.setMethods("\u72ec\u5bb6\u8bae\u6807");
                    }
                }
                concatList.add(procurementplandetailVO);
            }
        }
        List<ProcurementplandetailVO> allList = this.handleList(list, concatList);
        HashMap<String, List<ProcurementplandetailVO>> beans = new HashMap<String, List<ProcurementplandetailVO>>();
        beans.put("records", allList);
        ExcelExport.getInstance().export("Procurementplandetail-export.xlsx", beans, response);
    }

    private List<ProcurementplandetailVO> handleList(List<ProcurementplandetailVO> list, List<ProcurementplandetailVO> concatList) {
        if (list == null || list.size() == 0) {
            return concatList;
        }
        for (int i = 0; i < list.size(); ++i) {
            ProcurementplandetailVO procurementplandetailVO = list.get(i);
            List<ProcurementplandetailVO> children = procurementplandetailVO.getChildren();
            if (children == null || children.size() <= 0) continue;
            concatList.addAll(children);
            this.handleList(children, concatList);
        }
        return concatList;
    }
}

