/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.material.bean.MaterialapproachEntity;
import com.ejianc.business.material.bean.MaterialapproachdetailEntity;
import com.ejianc.business.material.service.IMaterialapproachService;
import com.ejianc.business.material.service.IMaterialapproachdetailService;
import com.ejianc.business.material.utils.DateUtils;
import com.ejianc.business.material.vo.MaterialapproachReportVO;
import com.ejianc.foundation.material.vo.MaterialapproachVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"materialapproach"})
public class MaterialapproachController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IMaterialapproachService service;
    @Autowired
    private IMaterialapproachdetailService detailService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<MaterialapproachVO> saveOrUpdate(@RequestBody MaterialapproachVO saveorUpdateVO) {
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)this.service.saveOrUpdate(saveorUpdateVO));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MaterialapproachVO> queryDetail(Long id) {
        MaterialapproachEntity entity = (MaterialapproachEntity)((Object)this.service.selectById(id));
        MaterialapproachVO vo = (MaterialapproachVO)BeanMapper.map((Object)((Object)entity), MaterialapproachVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryReport"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<MaterialapproachReportVO>> queryReport(Long projectId, String materialCode) {
        ArrayList<MaterialapproachReportVO> resList = new ArrayList<MaterialapproachReportVO>();
        QueryWrapper detailQueryWrapper = new QueryWrapper();
        detailQueryWrapper.eq((Object)"dr", (Object)0);
        detailQueryWrapper.eq((Object)"project_id", (Object)projectId);
        detailQueryWrapper.eq((Object)"material_code", (Object)materialCode);
        List detailEntityList = this.detailService.list((Wrapper)detailQueryWrapper);
        for (MaterialapproachdetailEntity item : detailEntityList) {
            String projectName = item.getProjectName();
            String name = item.getName();
            BigDecimal enterCount = item.getEnterCount();
            MaterialapproachReportVO reportVO = new MaterialapproachReportVO();
            reportVO.setId(IdWorker.getId());
            reportVO.setProjectId(projectId);
            reportVO.setProjectName(projectName);
            reportVO.setMaterialName(name);
            reportVO.setMaterialCode(materialCode);
            reportVO.setEnterCount(enterCount);
            reportVO.setSpec(item.getSpec());
            Long mid = item.getMid();
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"dr", (Object)0);
            queryWrapper.eq((Object)"id", (Object)mid);
            List mList = this.service.list((Wrapper)queryWrapper);
            Integer billState = 0;
            if (mList != null && mList.size() > 0) {
                MaterialapproachEntity entity = (MaterialapproachEntity)((Object)mList.get(0));
                String billCode = entity.getBillCode();
                reportVO.setBillCode(billCode);
                reportVO.setMaterialapproachId(mid);
                billState = entity.getBillState();
            }
            if (billState != 1 && billState != 3) continue;
            resList.add(reportVO);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", resList);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MaterialapproachVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MaterialapproachVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MaterialapproachVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("bill_code");
        fuzzyFields.add("agent_name");
        fuzzyFields.add("agentdep_name");
        fuzzyFields.add("contract_name");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        List list = this.service.queryList(param);
        List materialapproachVOList = BeanMapper.mapList((Iterable)list, MaterialapproachVO.class);
        for (int i = 0; i < materialapproachVOList.size(); ++i) {
            String billStateStr;
            MaterialapproachVO materialapproachVO = (MaterialapproachVO)materialapproachVOList.get(i);
            materialapproachVO.setNum(String.valueOf(i + 1));
            if (materialapproachVO.getCreateTime() != null) {
                materialapproachVO.setCreateTimeShow(DateUtils.dateSimple2(materialapproachVO.getCreateTime()));
            }
            if (materialapproachVO.getBillTime() != null) {
                materialapproachVO.setBillTimeShow(DateUtils.dateSimple2(materialapproachVO.getBillTime()));
            }
            if (materialapproachVO.getEnterTime() != null) {
                materialapproachVO.setEnterTimeShow(DateUtils.dateSimple2(materialapproachVO.getEnterTime()));
            }
            if ((billStateStr = materialapproachVO.getBillState().toString()) != null) {
                if ("0".equals(billStateStr)) {
                    billStateStr = "\u81ea\u7531\u6001";
                } else if ("1".equals(billStateStr)) {
                    billStateStr = "\u5df2\u63d0\u4ea4";
                } else if ("2".equals(billStateStr) || "5".equals(billStateStr)) {
                    billStateStr = "\u5ba1\u6279\u4e2d";
                } else if ("3".equals(billStateStr)) {
                    billStateStr = "\u5ba1\u6279\u901a\u8fc7";
                } else if ("4".equals(billStateStr)) {
                    billStateStr = "\u9a73\u56de";
                }
                materialapproachVO.setBillStateStr(billStateStr);
            }
            if (null == materialapproachVO.getCheckType()) continue;
            if (1 == materialapproachVO.getCheckType()) {
                materialapproachVO.setCheckTypeName("\u666e\u901a\u9a8c\u6536");
                continue;
            }
            if (2 != materialapproachVO.getCheckType()) continue;
            materialapproachVO.setCheckTypeName("\u96f6\u661f\u6750\u6599\u9a8c\u6536");
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", materialapproachVOList);
        ExcelExport.getInstance().export("Materialapproach-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refMaterialapproachData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<MaterialapproachVO>> refMaterialapproachData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("bill_code");
        fuzzyFields.add("agent_name");
        fuzzyFields.add("agentdep_name");
        fuzzyFields.add("contract_name");
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            String status;
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.get((Object)"checkFlag") != null) {
                ArrayList<Integer> checkTypeList;
                String checkFlag = _con.get((Object)"checkFlag").toString();
                if (checkFlag.equals("0")) {
                    checkTypeList = new ArrayList<Integer>();
                    checkTypeList.add(2);
                    param.getParams().put("checkType", new Parameter("not_in", checkTypeList));
                }
                if (checkFlag.equals("1")) {
                    checkTypeList = new ArrayList();
                    checkTypeList.add(2);
                    param.getParams().put("checkType", new Parameter("in", checkTypeList));
                }
            }
            if (_con.get((Object)"status") != null && (status = _con.get((Object)"status").toString()).equals("0")) {
                param.getParams().put("notStorageNum", new Parameter("gt", (Object)new BigDecimal(0.0)));
            }
            if (_con.get((Object)"contractId") != null) {
                param.getParams().put("contractId", new Parameter("eq", _con.get((Object)"contractId")));
            }
            if (_con.get((Object)"projectId") != null) {
                param.getParams().put("projectId", new Parameter("eq", _con.get((Object)"projectId")));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MaterialapproachVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/validatePlan"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> validatePlan(@RequestBody MaterialapproachVO vo) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)this.service.validatePlan(vo));
    }
}

