/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.material.bean.CheckDetailEntity;
import com.ejianc.business.material.bean.CheckEntity;
import com.ejianc.business.material.bean.FlowmeterEntity;
import com.ejianc.business.material.bean.StoreEntity;
import com.ejianc.business.material.mapper.CheckMapper;
import com.ejianc.business.material.service.ICheckService;
import com.ejianc.business.material.service.IFlowmeterService;
import com.ejianc.business.material.service.IStoreService;
import com.ejianc.business.material.utils.DetailIndexExcelReader;
import com.ejianc.foundation.material.vo.CheckDetailVO;
import com.ejianc.foundation.material.vo.CheckVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="checkService")
public class CheckServiceImpl
extends BaseServiceImpl<CheckMapper, CheckEntity>
implements ICheckService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IStoreService storeService;
    @Autowired
    private IFlowmeterService flowmeterService;
    @Autowired
    private ICheckService service;
    @Autowired
    private IShareMaterialApi shareMaterialApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "ZJKJMAT_CHECK";

    @Override
    public CheckVO saveOrUpdate(CheckVO checkVO) {
        CheckEntity entity = (CheckEntity)((Object)BeanMapper.map((Object)checkVO, CheckEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)checkVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        CheckVO vo = (CheckVO)BeanMapper.map((Object)((Object)entity), CheckVO.class);
        return vo;
    }

    @Override
    public CheckVO queryFlowByMonth(Long projectId, Long id, String checkMonth) {
        CommonResponse materialVO;
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(CheckEntity::getProjectId, (Object)projectId);
        queryWrapper.ne(null != id, BaseEntity::getId, (Object)id);
        queryWrapper.notIn(CheckEntity::getBillState, new Object[]{1, 3});
        if (this.count((Wrapper)queryWrapper) > 0) {
            throw new BusinessException("\u672c\u9879\u76ee\u5b58\u5728\u672a\u751f\u6548\u76d8\u70b9\u5355\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\u76d8\u70b9\u5355\uff01");
        }
        queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(CheckEntity::getProjectId, (Object)projectId);
        queryWrapper.ne(null != id, BaseEntity::getId, (Object)id);
        queryWrapper.orderByDesc(CheckEntity::getCheckMonth);
        queryWrapper.last("limit 1");
        CheckEntity lastCheckEntity = (CheckEntity)((Object)this.getOne((Wrapper)queryWrapper, false));
        HashMap<String, CheckDetailEntity> lastMap = new HashMap<String, CheckDetailEntity>();
        HashMap<String, CheckDetailEntity> waitAddMap = new HashMap<String, CheckDetailEntity>();
        Date date = null;
        try {
            date = new SimpleDateFormat("yyyy-MM").parse(checkMonth);
        }
        catch (ParseException e) {
            throw new BusinessException("\u672c\u9879\u76ee\u6240\u9009\u6708\u4efd\u683c\u5f0f\u9519\u8bef\uff01");
        }
        if (null != lastCheckEntity) {
            if (lastCheckEntity.getCheckMonth().compareTo(date) >= 0) {
                throw new BusinessException("\u672c\u9879\u76ee\u6240\u9009\u6708\u4efd\u5df2\u5b58\u5728\u540e\u7eed\u76d8\u70b9\u6570\u636e\uff01");
            }
            lastCheckEntity = (CheckEntity)((Object)this.selectById(lastCheckEntity.getId()));
            for (CheckDetailEntity detailEntity : lastCheckEntity.getDetailList()) {
                String key = detailEntity.getSourceId() + "@" + detailEntity.getMaterialId();
                lastMap.put(key, detailEntity);
                if (!ComputeUtil.isGreaterThan((BigDecimal)detailEntity.getCheckNum(), (BigDecimal)BigDecimal.ZERO)) continue;
                waitAddMap.put(key, detailEntity);
            }
        }
        CheckVO checkVO = new CheckVO();
        checkVO.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        LambdaQueryWrapper storeQuery = new LambdaQueryWrapper();
        storeQuery.eq(StoreEntity::getProjectId, (Object)projectId);
        storeQuery.eq(StoreEntity::getStoreType, (Object)0);
        List storeEntities = this.storeService.list((Wrapper)storeQuery);
        if (!CollectionUtils.isNotEmpty((Collection)storeEntities)) {
            throw new BusinessException("\u672c\u9879\u76ee\u8fd8\u672a\u5efa\u7acb\u6210\u54c1\u5e93\uff01");
        }
        checkVO.setStoreId(((StoreEntity)((Object)storeEntities.get(0))).getId());
        checkVO.setStoreName(((StoreEntity)((Object)storeEntities.get(0))).getName());
        ArrayList<String> accessTypeList = new ArrayList<String>();
        accessTypeList.add("\u6210\u54c1\u51fa\u5e93");
        accessTypeList.add("\u6210\u54c1\u9000\u5e93");
        accessTypeList.add("\u76f4\u5165\u76f4\u51fa\u9000\u4f9b\u5e94\u5546");
        LambdaQueryWrapper flowQuery = new LambdaQueryWrapper();
        flowQuery.eq(FlowmeterEntity::getStoreType, (Object)0);
        flowQuery.eq(FlowmeterEntity::getProjectId, (Object)projectId);
        flowQuery.eq(FlowmeterEntity::getStoreId, (Object)checkVO.getStoreId());
        flowQuery.in(FlowmeterEntity::getBillStatus, new Object[]{1, 3});
        flowQuery.in(FlowmeterEntity::getAccessType, accessTypeList);
        String beginDate = lastCheckEntity == null ? "1990-01-01" : this.getNextMonth(lastCheckEntity.getCheckMonth()) + "-01";
        String endDate = checkMonth + "-31";
        flowQuery.between(FlowmeterEntity::getTime, (Object)beginDate, (Object)endDate);
        List flowmeterEntities = this.flowmeterService.list((Wrapper)flowQuery);
        if (CollectionUtils.isNotEmpty((Collection)flowmeterEntities)) {
            HashMap<String, CheckDetailVO> map = new HashMap<String, CheckDetailVO>();
            for (FlowmeterEntity flowEntity : flowmeterEntities) {
                String flowTime;
                materialVO = this.shareMaterialApi.queryMaterialByCode(flowEntity.getMaterialCode());
                if (flowEntity.getSpecialModel() == null) {
                    flowEntity.setSpecialModel(((MaterialVO)materialVO.getData()).getSpec());
                }
                if (flowEntity.getMeasurementUnit() == null) {
                    flowEntity.setMeasurementUnit(((MaterialVO)materialVO.getData()).getUnitName());
                }
                if (null != lastCheckEntity && !(flowTime = new SimpleDateFormat("yyyy-MM").format(flowEntity.getTime())).contains(checkMonth)) {
                    throw new BusinessException("\u672c\u9879\u76ee\u8fd8\u6709[" + flowTime + "]\u6708\u4efd\u7684\u6d41\u6c34\u672a\u7ed3\u5b58!");
                }
                if ("\u6210\u54c1\u9000\u5e93".equals(flowEntity.getAccessType()) || "\u76f4\u5165\u76f4\u51fa\u9000\u4f9b\u5e94\u5546".equals(flowEntity.getAccessType())) {
                    flowEntity.setMid(flowEntity.getOutId());
                }
                String key = flowEntity.getMid() + "@" + flowEntity.getMaterialId();
                CheckDetailVO detailVO = null;
                if (!map.containsKey(key)) {
                    detailVO = (CheckDetailVO)BeanMapper.map((Object)((Object)flowEntity), CheckDetailVO.class);
                    detailVO.setSourceId(flowEntity.getMid());
                    detailVO.setCreateTime(null);
                    detailVO.setCreateUserCode(null);
                    detailVO.setUpdateTime(null);
                    detailVO.setUpdateUserCode(null);
                    detailVO.setVersion(Integer.valueOf(1));
                    detailVO.setId(null);
                    detailVO.setOutTime(flowEntity.getTime());
                    detailVO.setMaterialSpec(flowEntity.getSpecialModel());
                    detailVO.setMaterialUnit(flowEntity.getMeasurementUnit());
                    detailVO.setCheckPrice(flowEntity.getUnitPriceExcluetax());
                    detailVO.setCheckTaxPrice(flowEntity.getUnitPriceIncluetax());
                } else {
                    detailVO = (CheckDetailVO)map.get(key);
                }
                detailVO.setFlowNum(ComputeUtil.safeAdd((BigDecimal)detailVO.getFlowNum(), (BigDecimal)flowEntity.getQuantity()));
                detailVO.setFlowMny(ComputeUtil.safeAdd((BigDecimal)flowEntity.getAmountExcluetax(), (BigDecimal)detailVO.getFlowMny()));
                detailVO.setFlowTaxMny(ComputeUtil.safeAdd((BigDecimal)flowEntity.getAmountIncluetax(), (BigDecimal)detailVO.getFlowTaxMny()));
                BigDecimal flowTaxPrice = ComputeUtil.safeDiv((BigDecimal)detailVO.getFlowTaxMny(), (BigDecimal)detailVO.getFlowNum());
                BigDecimal flowPrice = ComputeUtil.safeDiv((BigDecimal)detailVO.getFlowMny(), (BigDecimal)detailVO.getFlowNum());
                detailVO.setFlowPrice(flowPrice);
                detailVO.setFlowTaxPrice(flowTaxPrice);
                detailVO.setCheckPrice(flowPrice);
                detailVO.setCheckTaxPrice(flowTaxPrice);
                detailVO.setUsePrice(flowPrice);
                detailVO.setUseTaxPrice(flowTaxPrice);
                detailVO.setMaterialSpec(flowEntity.getSpecialModel());
                detailVO.setMaterialUnit(flowEntity.getMeasurementUnit());
                if (lastMap.containsKey(key)) {
                    CheckDetailEntity detailEntity = (CheckDetailEntity)((Object)lastMap.get(key));
                    detailVO.setLastCheckNum(detailEntity.getCheckNum());
                    detailVO.setLastCheckPrice(detailEntity.getCheckPrice());
                    detailVO.setLastCheckTaxPrice(detailEntity.getCheckTaxPrice());
                    detailVO.setLastCheckMny(detailEntity.getCheckMny());
                    detailVO.setLastCheckTaxMny(detailEntity.getCheckTaxMny());
                    detailVO.setMaterialSpec(flowEntity.getSpecialModel());
                    detailVO.setMaterialUnit(flowEntity.getMeasurementUnit());
                    if (waitAddMap.containsKey(key)) {
                        waitAddMap.remove(key);
                    }
                } else {
                    detailVO.setLastCheckNum(BigDecimal.ZERO);
                    detailVO.setLastCheckPrice(BigDecimal.ZERO);
                    detailVO.setLastCheckTaxPrice(BigDecimal.ZERO);
                    detailVO.setLastCheckMny(BigDecimal.ZERO);
                    detailVO.setLastCheckTaxMny(BigDecimal.ZERO);
                }
                map.put(key, detailVO);
            }
            if (!map.isEmpty()) {
                checkVO.setDetailList(new ArrayList(map.values()));
            }
        }
        if (!waitAddMap.isEmpty()) {
            List detailList = checkVO.getDetailList();
            for (CheckDetailEntity detailEntity : waitAddMap.values()) {
                CheckDetailVO detailVO = (CheckDetailVO)BeanMapper.map((Object)((Object)detailEntity), CheckDetailVO.class);
                detailVO.setCreateTime(null);
                detailVO.setCreateUserCode(null);
                detailVO.setUpdateTime(null);
                detailVO.setUpdateUserCode(null);
                detailVO.setVersion(Integer.valueOf(1));
                detailVO.setRowState("add");
                detailVO.setId(null);
                detailVO.setLastCheckNum(detailVO.getCheckNum());
                detailVO.setLastCheckPrice(detailVO.getCheckPrice());
                detailVO.setLastCheckMny(detailVO.getCheckMny());
                detailVO.setLastCheckTaxMny(detailVO.getCheckTaxMny());
                detailVO.setFlowNum(null);
                detailVO.setFlowPrice(null);
                detailVO.setFlowTaxPrice(null);
                detailVO.setFlowMny(null);
                detailVO.setFlowTaxMny(null);
                detailVO.setCheckNum(null);
                detailVO.setCheckMny(null);
                detailVO.setCheckTaxMny(null);
                detailVO.setUseNum(null);
                detailVO.setUseMny(null);
                detailVO.setUseTaxMny(null);
                detailList.add(detailVO);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)checkVO.getDetailList())) {
            Collections.sort(checkVO.getDetailList(), new Comparator<CheckDetailVO>(){

                @Override
                public int compare(CheckDetailVO s1, CheckDetailVO s2) {
                    return s2.getOutTime().compareTo(s1.getOutTime());
                }
            });
        }
        for (CheckDetailVO vo : checkVO.getDetailList()) {
            vo.setCheckNum(BigDecimal.ZERO);
            BigDecimal useNum = ComputeUtil.safeSub((BigDecimal)ComputeUtil.safeAdd((BigDecimal)vo.getLastCheckNum(), (BigDecimal)vo.getFlowNum()), (BigDecimal)vo.getCheckNum());
            vo.setUseNum(this.parseNullValue(useNum));
            vo.setUseMny(ComputeUtil.safeSub((BigDecimal)ComputeUtil.safeAdd((BigDecimal)vo.getLastCheckMny(), (BigDecimal)vo.getFlowMny()), (BigDecimal)vo.getCheckMny()));
            vo.setUseTaxMny(ComputeUtil.safeSub((BigDecimal)ComputeUtil.safeAdd((BigDecimal)vo.getLastCheckTaxMny(), (BigDecimal)vo.getFlowTaxMny()), (BigDecimal)vo.getCheckTaxMny()));
            materialVO = this.shareMaterialApi.queryMaterialByCode(vo.getMaterialCode());
            if (vo.getMaterialSpec() != null) continue;
            vo.setMaterialSpec(((MaterialVO)materialVO.getData()).getSpec());
            vo.setMaterialUnit(((MaterialVO)materialVO.getData()).getUnitName());
        }
        return checkVO;
    }

    @Override
    public Map<String, CheckDetailVO> queryCheckByMonth(Long projectId, String checkMonth) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(CheckEntity::getProjectId, (Object)projectId);
        queryWrapper.apply("DATE_FORMAT(check_month, '%Y-%m') = '" + checkMonth + "'", new Object[0]);
        CheckEntity checkEntity = (CheckEntity)((Object)this.getOne((Wrapper)queryWrapper, false));
        if (null == checkEntity || !BillStateEnum.PASSED_STATE.getBillStateCode().equals(checkEntity.getBillState()) && !BillStateEnum.COMMITED_STATE.getBillStateCode().equals(checkEntity.getBillState())) {
            return null;
        }
        CheckEntity entity = (CheckEntity)((Object)this.selectById(checkEntity.getId()));
        HashMap<String, CheckDetailVO> map = new HashMap<String, CheckDetailVO>();
        if (CollectionUtils.isNotEmpty(entity.getDetailList())) {
            for (CheckDetailEntity detailEntity : entity.getDetailList()) {
                CheckDetailVO detailVO = null;
                if (!map.containsKey(String.valueOf(detailEntity.getMaterialCategoryId()))) {
                    detailVO = (CheckDetailVO)BeanMapper.map((Object)((Object)detailEntity), CheckDetailVO.class);
                } else {
                    detailVO = (CheckDetailVO)map.get(String.valueOf(detailEntity.getMaterialCategoryId()));
                    detailVO.setUseNum(ComputeUtil.safeAdd((BigDecimal)this.parseNullValue(detailVO.getUseNum()), (BigDecimal)this.parseNullValue(detailEntity.getUseNum())));
                    detailVO.setUseMny(ComputeUtil.safeAdd((BigDecimal)this.parseNullValue(detailVO.getUseMny()), (BigDecimal)this.parseNullValue(detailEntity.getUseMny())));
                    detailVO.setUsePrice(ComputeUtil.safeDiv((BigDecimal)this.parseNullValue(detailVO.getUseMny()), (BigDecimal)this.parseNullValue(detailVO.getUseNum())));
                }
                map.put(String.valueOf(detailEntity.getMaterialCategoryId()), detailVO);
            }
        }
        return map;
    }

    private BigDecimal parseNullValue(BigDecimal value) {
        return value == null ? BigDecimal.ZERO : value;
    }

    @Override
    public void updateSettlementState(Long projectId, Integer state, String checkMonth) {
        this.logger.info("updateSettlementState\u8fdb\u6765\u4e86:" + projectId + "@state" + state + "checkMonth" + checkMonth);
        this.logger.info(new Date().toString());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM");
        Date date = null;
        try {
            date = simpleDateFormat.parse(checkMonth);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        LambdaQueryWrapper lambdaCheck = Wrappers.lambdaQuery();
        lambdaCheck.eq(CheckEntity::getProjectId, (Object)projectId);
        lambdaCheck.eq(CheckEntity::getCheckMonth, (Object)date);
        List checkEntityList = super.list((Wrapper)lambdaCheck);
        for (CheckEntity checkEntity : checkEntityList) {
            checkEntity.setIsSettlement(state);
        }
        super.updateBatchById((Collection)checkEntityList);
        this.logger.info("checkEntityList" + JSONObject.toJSONString((Object)checkEntityList));
        this.logger.info("updateSettlementState\u7ed3\u675f\u4e86" + new Date().toString());
    }

    @Override
    public CommonResponse<JSONObject> excelImportInfo(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        List<List<List<String>>> resList = DetailIndexExcelReader.readExcel(mf);
        List<List<String>> result = resList.get(0);
        if (result.size() > 0 && result.get(0).size() < 20) {
            return CommonResponse.error((String)"\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        ArrayList<CheckDetailVO> successList = new ArrayList<CheckDetailVO>();
        ArrayList<CheckDetailVO> errorList = new ArrayList<CheckDetailVO>();
        if (result != null && result.size() > 0) {
            ArrayList<CheckDetailVO> detailVoList = new ArrayList<CheckDetailVO>();
            boolean importFlag = true;
            for (int i = 0; i < result.size(); ++i) {
                List<String> datas = result.get(i);
                CheckDetailVO vo = new CheckDetailVO();
                boolean flag = false;
                String warnType = "";
                String billCode = datas.get(0);
                String materialCode = datas.get(5);
                String checkNum = datas.get(15);
                Long id = IdWorker.getId();
                vo.setId(id);
                if (StringUtils.isEmpty((CharSequence)billCode)) {
                    vo.setBillCode(null);
                    warnType = warnType + "[\u5355\u53f7\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    vo.setBillCode(billCode);
                }
                if (StringUtils.isEmpty((CharSequence)materialCode)) {
                    vo.setMaterialCode(null);
                    warnType = warnType + "[\u7269\u8d44\u7f16\u7801\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    CommonResponse materialVO = this.shareMaterialApi.queryMaterialByCode(materialCode);
                    if (materialVO.getData() != null) {
                        vo.setMaterialCode(materialCode);
                        vo.setMaterialSpec(((MaterialVO)materialVO.getData()).getSpec());
                        vo.setMaterialUnit(((MaterialVO)materialVO.getData()).getUnitName());
                    } else {
                        vo.setMaterialCode(null);
                        warnType = warnType + "[\u7269\u8d44\u7f16\u7801\u4e0d\u6b63\u786e]";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)checkNum)) {
                    vo.setCheckNum(null);
                    warnType = warnType + "[\u672c\u6708\u7ed3\u5b58\u6570\u91cf\u4e3a\u7a7a]";
                    flag = true;
                } else {
                    try {
                        vo.setCheckNum(new BigDecimal(checkNum));
                    }
                    catch (Exception e) {
                        vo.setCheckNum(null);
                        warnType = warnType + "[\u672c\u6708\u7ed3\u5b58\u6570\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570]";
                        flag = true;
                    }
                }
                vo.setImportFlag(Boolean.valueOf(!flag));
                if (importFlag) {
                    importFlag = !flag;
                }
                vo.setWarnType(warnType);
                detailVoList.add(vo);
            }
            for (CheckDetailVO vo : detailVoList) {
                if (vo.getImportFlag().booleanValue()) {
                    if (!importFlag) continue;
                    successList.add(vo);
                    continue;
                }
                errorList.add(vo);
            }
            if (errorList.size() > 0) {
                resp.put("successList", null);
                resp.put("successNum", (Object)0);
                resp.put("errorNum", (Object)errorList.size());
                if (errorList.size() > 100) {
                    resp.put("errorList", errorList.subList(0, 100));
                } else {
                    resp.put("errorList", errorList);
                }
            } else {
                resp.put("successList", successList);
                resp.put("errorList", null);
                resp.put("successNum", (Object)successList.size());
                resp.put("errorNum", (Object)0);
            }
        }
        return CommonResponse.success((Object)resp);
    }

    private String getNextMonth(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, cal.getActualMaximum(5));
        cal.add(2, 1);
        Date nextMonthDate = cal.getTime();
        return sdf.format(nextMonthDate);
    }
}

