/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.material.bean.DeliveryrecordEntity;
import com.ejianc.business.material.bean.DeliveryrecorddetailEntity;
import com.ejianc.business.material.bean.FlowmeterEntity;
import com.ejianc.business.material.mapper.DeliveryrecordMapper;
import com.ejianc.business.material.service.IDeliveryrecordService;
import com.ejianc.business.material.service.IDeliveryrecorddetailService;
import com.ejianc.business.material.service.IFlowmeterService;
import com.ejianc.business.material.service.IRealtimebalanceService;
import com.ejianc.business.material.service.impl.DeliveryrecordBpmServiceImpl;
import com.ejianc.business.material.service.impl.MaterialWarehousingBpmServiceImpl;
import com.ejianc.business.material.vo.DeliveryrecordReportVO;
import com.ejianc.business.material.vo.DeliveryrecordSubVO;
import com.ejianc.business.material.vo.DeliveryrecordVO;
import com.ejianc.business.material.vo.SupDeliveryrecordVO;
import com.ejianc.business.material.vo.SupDeliveryrecorddetailVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="deliveryrecordService")
public class DeliveryrecordServiceImpl
extends BaseServiceImpl<DeliveryrecordMapper, DeliveryrecordEntity>
implements IDeliveryrecordService {
    @Autowired
    private DeliveryrecordMapper deliveryrecordMapper;
    @Autowired
    private IFlowmeterService flowmeterService;
    @Autowired
    private JedisPool jedisPool;
    private static final String BILL_CODE = "HZBT202208000016";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private DeliveryrecordBpmServiceImpl deliveryrecordBpmService;
    @Autowired
    private MaterialWarehousingBpmServiceImpl materialWarehousingBpmService;
    @Autowired
    private IDeliveryrecorddetailService deliveryrecorddetailService;
    @Autowired
    private IRealtimebalanceService realtimebalanceService;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Value(value="${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;
    @Autowired
    private IProSupplierApi proSupplierApi;
    private static final String BILL_TYPE = "HZBT202208000016";
    private final String OPERATE = "DELIVERY_RECORD_SYNC";
    private final String PUSH_BILL_SERVER_URL = "/zjkj-supbusiness-web/openapi/deliveryrecord/saveOrUpdate";

    @Override
    public List<DeliveryrecordSubVO> selectSub(String materialCode, String projectId) {
        List<DeliveryrecordSubVO> list = this.deliveryrecordMapper.selectSub(materialCode, projectId);
        return list;
    }

    @Override
    public List<DeliveryrecordReportVO> subDetail(Long projectId, String materialCode, String supplierName) {
        List<DeliveryrecordReportVO> deliveryrecordReportVOS = this.deliveryrecordMapper.subDetail(projectId, materialCode, supplierName);
        return deliveryrecordReportVOS;
    }

    @Override
    @Transactional
    public DeliveryrecordVO saveOrUpdate(DeliveryrecordVO saveorUpdateVO) {
        DeliveryrecordEntity entity = (DeliveryrecordEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), DeliveryrecordEntity.class));
        List<DeliveryrecorddetailEntity> deliveryrecorddetailList = entity.getDeliveryrecorddetailEntities();
        BigDecimal outMny = deliveryrecorddetailList.stream().map(DeliveryrecorddetailEntity::getAmountExcluetax).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal outMnyTax = deliveryrecorddetailList.stream().map(DeliveryrecorddetailEntity::getAmountIncluetax).reduce(BigDecimal.ZERO, BigDecimal::add);
        entity.setOutMny(outMny);
        entity.setOutMnyTax(outMnyTax);
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode("HZBT202208000016", InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setDeliveryType(1);
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        List<DeliveryrecorddetailEntity> deliveryrecorddetailEntities = entity.getDeliveryrecorddetailEntities();
        for (DeliveryrecorddetailEntity deliveryrecorddetail : deliveryrecorddetailEntities) {
            if ("del".equals(deliveryrecorddetail.getRowState())) continue;
            deliveryrecorddetail.setProjectId(entity.getProjectId());
            deliveryrecorddetail.setStoreId(entity.getStoreId());
            deliveryrecorddetail.setPickingTime(entity.getPickingTime());
            deliveryrecorddetail.setProjectName(entity.getProjectName());
            deliveryrecorddetail.setTenantId(entity.getTenantId());
            deliveryrecorddetail.setOrgId(entity.getOrgId());
            deliveryrecorddetail.setUnitId(entity.getPickingunitId());
            deliveryrecorddetail.setUnitName(entity.getPickingUnit());
            deliveryrecorddetail.setProjectDepartmentId(entity.getProjectDepartmentId());
        }
        List<DeliveryrecorddetailEntity> deliveryrecorddetailEntityList = entity.getDeliveryrecorddetailEntities();
        if ((entity.getDeliveryTypes() == 1 || entity.getDeliveryTypes() == 5 || entity.getDeliveryTypes() == 6 || entity.getDeliveryTypes() == 7) && com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(deliveryrecorddetailEntityList)) {
            List deliveryDetailIds = deliveryrecorddetailEntityList.stream().map(DeliveryrecorddetailEntity::getDeliveryDetailId).collect(Collectors.toList());
            LambdaQueryWrapper lambdaWareDetail = Wrappers.lambdaQuery();
            lambdaWareDetail.in(DeliveryrecorddetailEntity::getDeliveryDetailId, deliveryDetailIds);
            if (saveorUpdateVO.getId() != null) {
                lambdaWareDetail.ne(DeliveryrecorddetailEntity::getMid, (Object)entity.getId());
            }
            List warehousingdetailEntityList = this.deliveryrecorddetailService.list((Wrapper)lambdaWareDetail);
            Map<Long, BigDecimal> numMap = new HashMap();
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)warehousingdetailEntityList)) {
                numMap = warehousingdetailEntityList.stream().filter(s -> s.getDeliveryQuantity().compareTo(BigDecimal.ZERO) == -1).collect(Collectors.groupingBy(DeliveryrecorddetailEntity::getDeliveryDetailId, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getDeliveryQuantity()).reduce(BigDecimal.ZERO, BigDecimal::add))));
            }
            for (DeliveryrecorddetailEntity deliveryrecorddetailEntity : deliveryrecorddetailEntityList) {
                BigDecimal allZy;
                BigDecimal num = BigDecimal.ZERO;
                BigDecimal numDelivery = BigDecimal.ZERO;
                BigDecimal numAll = BigDecimal.ZERO;
                if (numMap.containsKey(deliveryrecorddetailEntity.getDeliveryDetailId())) {
                    num = numMap.get(deliveryrecorddetailEntity.getDeliveryDetailId());
                }
                if (entity.getDeliveryTypes() == 1 || entity.getDeliveryTypes() == 5 || entity.getDeliveryTypes() == 6) {
                    numDelivery = deliveryrecorddetailEntity.getDeliveryNum();
                    numAll = deliveryrecorddetailEntity.getDeliveryQuantity();
                }
                if (entity.getDeliveryTypes() == 7) {
                    numDelivery = deliveryrecorddetailEntity.getDeliveryQuantity();
                    numAll = deliveryrecorddetailEntity.getNotReturnedQuantity();
                }
                if ((allZy = numDelivery.add(num).multiply(new BigDecimal(-1.0))).compareTo(numAll) != 1) continue;
                throw new BusinessException("\u7269\u8d44\u7f16\u53f7:" + deliveryrecorddetailEntity.getMaterialCode() + ",\u7269\u8d44\u540d\u79f0:" + deliveryrecorddetailEntity.getMaterialName() + "\u8d85\u8fc7\u5269\u4f59\u53ef\u9000\u5e93\u6570\u91cf,\u4e0d\u80fd\u4fdd\u5b58!");
            }
        }
        super.saveOrUpdate((Object)entity, false);
        ArrayList<FlowmeterEntity> flowmeterList = new ArrayList<FlowmeterEntity>();
        LambdaQueryWrapper lambdaFlower = Wrappers.lambdaQuery();
        lambdaFlower.eq(FlowmeterEntity::getMid, (Object)entity.getId());
        this.flowmeterService.remove((Wrapper)lambdaFlower);
        if ((entity.getDeliveryTypes() == 0 || entity.getDeliveryTypes() == 4) && com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(deliveryrecorddetailEntityList)) {
            ArrayList realList = new ArrayList();
            for (DeliveryrecorddetailEntity deliveryrecorddetailEntity : deliveryrecorddetailEntityList) {
                FlowmeterEntity flowmeterEntity = this.deliveryrecordBpmService.createrFlowmeter(entity, deliveryrecorddetailEntity, 0, null);
                flowmeterList.add(flowmeterEntity);
            }
            List materialIds = deliveryrecorddetailEntityList.stream().map(DeliveryrecorddetailEntity::getMaterialId).collect(Collectors.toList());
            LambdaQueryWrapper lambdaFlow = Wrappers.lambdaQuery();
            lambdaFlow.eq(FlowmeterEntity::getStoreId, (Object)entity.getStoreId());
            lambdaFlow.in(FlowmeterEntity::getMaterialId, materialIds);
            if (saveorUpdateVO.getId() != null) {
                lambdaFlow.ne(FlowmeterEntity::getMid, (Object)saveorUpdateVO.getId());
            }
            List flowmeterEntityList = this.flowmeterService.list((Wrapper)lambdaFlow);
            Map<Long, BigDecimal> numInMap = flowmeterEntityList.stream().filter(s -> s.getOperationType().equals("\u5165\u5e93")).collect(Collectors.groupingBy(FlowmeterEntity::getMaterialId, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getQuantity()).reduce(BigDecimal.ZERO, BigDecimal::add))));
            Map<Long, BigDecimal> numOutMap = flowmeterEntityList.stream().filter(s -> s.getOperationType().equals("\u51fa\u5e93")).collect(Collectors.groupingBy(FlowmeterEntity::getMaterialId, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getQuantity()).reduce(BigDecimal.ZERO, BigDecimal::add))));
            BigDecimal inNum = BigDecimal.ZERO;
            BigDecimal outNum = BigDecimal.ZERO;
            for (DeliveryrecorddetailEntity deliveryrecorddetailEntity : deliveryrecorddetailEntityList) {
                inNum = BigDecimal.ZERO;
                outNum = BigDecimal.ZERO;
                if (numInMap.containsKey(deliveryrecorddetailEntity.getMaterialId())) {
                    inNum = numInMap.get(deliveryrecorddetailEntity.getMaterialId());
                }
                if (numOutMap.containsKey(deliveryrecorddetailEntity.getMaterialId())) {
                    outNum = numOutMap.get(deliveryrecorddetailEntity.getMaterialId());
                }
                BigDecimal subtract = inNum.subtract(outNum);
                if (deliveryrecorddetailEntity.getDeliveryQuantity().compareTo(subtract) != 1) continue;
                throw new BusinessException("\u7269\u8d44\u7f16\u53f7:" + deliveryrecorddetailEntity.getMaterialCode() + ",\u7269\u8d44\u540d\u79f0:" + deliveryrecorddetailEntity.getMaterialName() + "\u5e93\u5b58\u4e0d\u8db3\uff0c\u4e0d\u80fd\u51fa\u5e93!");
            }
            this.flowmeterService.saveBatch(flowmeterList);
            this.realtimebalanceService.updateRealtimeBalance(entity.getStoreId());
        }
        DeliveryrecordVO vo = (DeliveryrecordVO)((Object)BeanMapper.map((Object)((Object)entity), DeliveryrecordVO.class));
        return vo;
    }

    @Override
    @Transactional
    public void delete(List<DeliveryrecordVO> vos) {
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        LambdaQueryWrapper lambdaDelivery = Wrappers.lambdaQuery();
        lambdaDelivery.in(BaseEntity::getId, ids);
        List deliveryrecordEntities = super.list((Wrapper)lambdaDelivery);
        LambdaQueryWrapper lambdaFlower = Wrappers.lambdaQuery();
        lambdaFlower.in(FlowmeterEntity::getMid, ids);
        this.flowmeterService.remove((Wrapper)lambdaFlower);
        for (DeliveryrecordEntity deliveryrecordEntity : deliveryrecordEntities) {
            if (deliveryrecordEntity.getDeliveryTypes() != 0 && deliveryrecordEntity.getDeliveryTypes() != 4) continue;
            this.realtimebalanceService.updateRealtimeBalance(deliveryrecordEntity.getStoreId());
        }
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean delSupDeliveryrecord(Long billId, String dataInfo, String url, RequestMethod method, String supplierId, String operate, String billTypeCode) {
        Boolean locked = false;
        Boolean syncFlag = false;
        String key = billTypeCode + "::" + billId.toString();
        Jedis jedis = this.jedisPool.getResource();
        try {
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)operate, (int)600);
            if (!locked.booleanValue()) {
                this.releaseLock(jedis, false, key, operate);
                this.logger.error("\u5355\u636e{}\u63a8\u9001\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25-{}\uff01", (Object)billId, (Object)locked);
                Boolean bl = false;
                return bl;
            }
            CommonResponse syncReqResp = this.systemDataPushService.exchangeDataWithEachLinkSystem(url, method, dataInfo, supplierId);
            if (syncReqResp.isSuccess()) {
                CommonResponse billPushResp = (CommonResponse)JSONObject.parseObject((String)((String)syncReqResp.getData()), CommonResponse.class);
                if (billPushResp.isSuccess()) {
                    syncFlag = true;
                } else {
                    this.logger.error("\u4f9b\u65b9id-{}\u5904\u7406\u63a8\u9001\u5355\u636eid-{}\u5931\u8d25, {}", new Object[]{supplierId, billId, billPushResp.getMsg()});
                }
            } else {
                this.logger.error("\u4f9b\u65b9id-{}\u5904\u7406\u63a8\u9001\u5355\u636eid-{}\u5931\u8d25, {}", new Object[]{supplierId, billId, syncReqResp.getMsg()});
            }
        }
        catch (Exception e) {
            this.logger.error("\u63a8\u9001\u53d1\u8d27\u5355\u5355\u636eid-{}\u7ed9\u4f9b\u65b9id-{} \u5f02\u5e38\uff0c", new Object[]{billId, supplierId, e});
        }
        finally {
            this.releaseLock(jedis, locked, key, operate);
        }
        return syncFlag;
    }

    @Override
    public boolean pushBillToSupCenter(DeliveryrecordEntity materialPlanEntity, String billTypeCode) {
        boolean syncFlag;
        block14: {
            boolean locked = false;
            syncFlag = false;
            Jedis jedis = this.jedisPool.getResource();
            String key = billTypeCode + "::" + materialPlanEntity.getId().toString();
            CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
            if (!ejcCloudSystemCode.isSuccess()) {
                this.logger.error("\u63a8\u9001\u9886\u6599\u8ba1\u5212\u5355\u636e-{}\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25,{}", (Object)materialPlanEntity.getId(), (Object)ejcCloudSystemCode.getMsg());
                return false;
            }
            materialPlanEntity.setSystemId((String)ejcCloudSystemCode.getData());
            materialPlanEntity.setSourceId(materialPlanEntity.getId());
            try {
                locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"DELIVERY_RECORD_SYNC", (int)600);
                if (!locked) {
                    this.logger.error("\u5355\u636e\u63a8\u9001\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25\uff01");
                    this.releaseLock(jedis, false, key, "DELIVERY_RECORD_SYNC");
                    boolean bl = false;
                    return bl;
                }
                HashMap<String, String> paramMap = new HashMap<String, String>();
                SupDeliveryrecordVO supMaterialPlanVO = (SupDeliveryrecordVO)BeanMapper.map((Object)((Object)materialPlanEntity), SupDeliveryrecordVO.class);
                List supMaterialPlanDetailVOS = BeanMapper.mapList(materialPlanEntity.getDeliveryrecorddetailEntities(), SupDeliveryrecorddetailVO.class);
                supMaterialPlanVO.setDeliveryrecorddetailEntities(supMaterialPlanDetailVOS);
                supMaterialPlanVO.setId(null);
                paramMap.put("deliveryrecord", JSONObject.toJSONString((Object)supMaterialPlanVO));
                CommonResponse fileResp = this.attachmentApi.queryListBySourceId(materialPlanEntity.getId(), "HZBT202208000016", "zjkj-material", null);
                if (fileResp.isSuccess()) {
                    HashMap files = new HashMap();
                    List fileList = (List)fileResp.getData();
                    ArrayList<Long> fileIds = new ArrayList<Long>();
                    for (AttachmentVO attach : fileList) {
                        fileIds.add(attach.getId());
                    }
                    if (CollectionUtils.isNotEmpty((Collection)fileList)) {
                        Map fileMap = FileUtil.getInstance().batchDownFileFlow(fileIds, true);
                        fileMap.keySet().stream().forEach(fileKey -> {
                            HashMap file = new HashMap(1);
                            file.put((String)fileKey, fileMap.get(fileKey));
                            files.put("file", file);
                        });
                    }
                    this.logger.info("\u5411\u4f9b\u5e94\u5546-{}\u63a8\u9001\u9886\u6599\u5355\u5355\u636e\u53c2\u6570-{}", (Object)materialPlanEntity.getPickingunitId(), (Object)JSONObject.toJSONString(paramMap));
                    CommonResponse syncReqResp = this.systemDataPushService.exchangeDataAndFilesWithEachLinkSystem("/zjkj-supbusiness-web/openapi/deliveryrecord/saveOrUpdate", paramMap, materialPlanEntity.getPickingunitId().toString(), files);
                    if (syncReqResp.isSuccess()) {
                        JSONObject jsonObject = JSONObject.parseObject((String)((String)syncReqResp.getData()));
                        if (StringUtils.isNotEmpty((CharSequence)((CharSequence)syncReqResp.getData())) && jsonObject.containsKey((Object)"code")) {
                            CommonResponse billPushResp = (CommonResponse)JSONObject.parseObject((String)((String)syncReqResp.getData()), CommonResponse.class);
                            if (billPushResp.isSuccess()) {
                                syncFlag = true;
                                break block14;
                            }
                            this.logger.error("\u4f9b\u65b9id-{}\u5904\u7406\u63a8\u9001\u9886\u6599\u5355\u5355\u636eid-{}\u5931\u8d25, {}", new Object[]{materialPlanEntity.getPickingunitId(), materialPlanEntity.getId(), billPushResp.getMsg()});
                            throw new BusinessException(billPushResp.getMsg());
                        }
                        throw new BusinessException();
                    }
                    this.logger.error("\u53d1\u9001\u8bf7\u6c42\u63a8\u9001\u9886\u6599\u5355\u5355\u636eid-{}\u7ed9\u4f9b\u65b9id-{}\u5931\u8d25, {}", new Object[]{materialPlanEntity.getId(), materialPlanEntity.getPickingunitId(), syncReqResp.getMsg()});
                    throw new BusinessException(syncReqResp.getMsg());
                }
                this.logger.error("\u83b7\u53d6\u9886\u6599\u5355\u636eid-{}\u5bf9\u5e94\u9644\u4ef6\u4fe1\u606f\u5931\u8d25, {}", (Object)materialPlanEntity.getId(), (Object)fileResp.getMsg());
                throw new BusinessException(fileResp.getMsg());
            }
            catch (Exception e) {
                this.logger.error("\u63a8\u9001\u9886\u6599\u5355\u636eid-{}\u7ed9\u4f9b\u65b9id-{} \u5f02\u5e38\uff0c", new Object[]{materialPlanEntity.getId(), materialPlanEntity.getPickingunitId(), e});
                throw new BusinessException("\u63a8\u9001\u4f9b\u65b9\u5f02\u5e38!");
            }
            finally {
                this.releaseLock(jedis, locked, key, "DELIVERY_RECORD_SYNC");
            }
        }
        return syncFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock((Jedis)jedis, (String)key, (String)OPERATE);
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }
}

