/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.controller.api;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.material.bean.StoreBalanceEntity;
import com.ejianc.business.material.service.IStoreBalanceService;
import com.ejianc.foundation.material.vo.CostanalysistaxVO;
import com.ejianc.foundation.material.vo.CostanalysistaxdataVO;
import com.ejianc.foundation.material.vo.StoreBalanceDetailVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"api/storeBalance"})
public class StoreBalanceApiController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IStoreBalanceService service;

    @RequestMapping(value={"/queryOutStore"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<StoreBalanceDetailVO> queryOutStore(@RequestParam(value="projectId") Long projectId, @RequestParam(value="month") String month, @RequestParam(value="materialCategoryCode") String materialCategoryCode) {
        if (projectId == null) {
            return CommonResponse.error((String)"\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (month == null) {
            return CommonResponse.error((String)"\u6708\u4efd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (materialCategoryCode == null) {
            return CommonResponse.error((String)"\u7269\u8d44\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        StoreBalanceDetailVO storeBalanceDetailVO = this.service.queryStoreBalanceMonth(projectId, month, materialCategoryCode);
        return CommonResponse.success((Object)storeBalanceDetailVO);
    }

    @RequestMapping(value={"queryCostanalysisTax"}, method={RequestMethod.GET})
    @ResponseBody
    private CommonResponse<CostanalysistaxVO> queryCostanalysisTax(@RequestParam(value="projectId") Long projectId, @RequestParam String time) {
        CostanalysistaxVO costanalysistaxVO = new CostanalysistaxVO();
        ArrayList<CostanalysistaxdataVO> costanalysistaxdataVOList = new ArrayList<CostanalysistaxdataVO>();
        if (time == null || time.length() < 7) {
            throw new BusinessException("\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QueryWrapper queryWrapperPur = new QueryWrapper();
        String start = time.substring(0, 7) + "-01";
        Calendar cal = Calendar.getInstance();
        cal.set(1, Integer.parseInt(time.substring(0, 4)));
        cal.set(2, Integer.parseInt(time.substring(5, 7)) - 1);
        cal.set(5, cal.getActualMaximum(5));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String end = sdf.format(cal.getTime());
        queryWrapperPur.eq((Object)"project_id", (Object)projectId);
        queryWrapperPur.le((Object)"month", (Object)end);
        queryWrapperPur.ge((Object)"month", (Object)start);
        queryWrapperPur.eq((Object)"dr", (Object)0);
        List listPur = this.service.list((Wrapper)queryWrapperPur);
        CostanalysistaxdataVO costanalysistaxdataVOPur = new CostanalysistaxdataVO();
        costanalysistaxdataVOPur.setBillName("\u7269\u8d44\u7ed3\u5b58");
        if (listPur.size() > 0) {
            costanalysistaxdataVOPur.setProjectId(((StoreBalanceEntity)((Object)listPur.get(0))).getProjectId());
            costanalysistaxdataVOPur.setProjectName(((StoreBalanceEntity)((Object)listPur.get(0))).getProjectName());
            SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd");
            String sDate = sdf.format(((StoreBalanceEntity)((Object)listPur.get(0))).getMonth());
            costanalysistaxdataVOPur.setJcDate(sDate);
            Date month = ((StoreBalanceEntity)((Object)listPur.get(0))).getMonth();
            BigDecimal taxSettlementAmount = ((StoreBalanceEntity)((Object)listPur.get(0))).getOutstoreAmountTaxTotal();
            BigDecimal settlementAmount = ((StoreBalanceEntity)((Object)listPur.get(0))).getOutstoreAmountUntaxTotal();
            costanalysistaxdataVOPur.setAmount(settlementAmount);
            costanalysistaxdataVOPur.setAmountTax(taxSettlementAmount);
            BigDecimal taxPur = taxSettlementAmount.subtract(settlementAmount);
            if (settlementAmount.equals(taxSettlementAmount)) {
                costanalysistaxdataVOPur.setTax(new BigDecimal("0.00"));
            } else {
                costanalysistaxdataVOPur.setTax(taxPur);
            }
            costanalysistaxdataVOPur.setRate(taxPur.divide(settlementAmount, 2, 4));
        } else {
            costanalysistaxdataVOPur.setAmount(new BigDecimal("0.00"));
            costanalysistaxdataVOPur.setAmountTax(new BigDecimal("0.00"));
            costanalysistaxdataVOPur.setTax(new BigDecimal("0.00"));
            costanalysistaxdataVOPur.setRate(new BigDecimal("0.00"));
        }
        costanalysistaxdataVOList.add(costanalysistaxdataVOPur);
        BigDecimal greaterTax = new BigDecimal("0.00");
        BigDecimal lessAndEqualsTax = new BigDecimal("0.00");
        for (int i = 0; costanalysistaxdataVOList.size() > i; ++i) {
            if (((CostanalysistaxdataVO)costanalysistaxdataVOList.get(i)).getRate().compareTo(new BigDecimal("0.03")) == 1) {
                greaterTax = greaterTax.add(((CostanalysistaxdataVO)costanalysistaxdataVOList.get(i)).getTax());
                continue;
            }
            lessAndEqualsTax = lessAndEqualsTax.add(((CostanalysistaxdataVO)costanalysistaxdataVOList.get(i)).getTax());
        }
        costanalysistaxVO.setGreaterTax(greaterTax);
        costanalysistaxVO.setLessAndEqualsTax(lessAndEqualsTax);
        costanalysistaxVO.setDataSource(costanalysistaxdataVOList);
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f", (Object)costanalysistaxVO);
    }

    @RequestMapping(value={"/queryMaterialConsumeMonth"}, method={RequestMethod.GET})
    @ResponseBody
    private CommonResponse<Map<String, StoreBalanceDetailVO>> queryMaterialConsumeMonth(@RequestParam(value="projectId") Long projectId, @RequestParam(value="month") String month) {
        HashMap<String, StoreBalanceDetailVO> map = new HashMap<String, StoreBalanceDetailVO>();
        List<StoreBalanceDetailVO> storeBalanceDetailVOS = this.service.queryMaterialConsumeMonth(projectId, month);
        if (!storeBalanceDetailVOS.isEmpty()) {
            for (StoreBalanceDetailVO vo : storeBalanceDetailVOS) {
                map.put(vo.getMaterialCategoryCode(), vo);
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f", map);
    }

    @RequestMapping(value={"/updateSettlementState"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> updateMidSettlementState(Long projectId, Integer state, String monthStr) {
        this.service.updateSettlementState(projectId, state, monthStr);
        return CommonResponse.success((String)"\u66f4\u65b0\u5f52\u96c6\u72b6\u6001\u6210\u529f");
    }

    @RequestMapping(value={"/queryIsSettlement"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> queryIsSettlement(Long projectId, String monthStr) {
        this.service.queryIsSettlement(projectId, monthStr);
        return CommonResponse.success();
    }
}

