/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.material.bean.RealtimebalanceEntity;
import com.ejianc.business.material.bean.StoreEntity;
import com.ejianc.business.material.service.IMaterialWarehousingService;
import com.ejianc.business.material.service.IRealtimebalanceService;
import com.ejianc.business.material.service.IStoreService;
import com.ejianc.business.material.utils.PageUtil;
import com.ejianc.business.material.vo.MaterialWarehousingdetailVO;
import com.ejianc.business.material.vo.StoreVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"store"})
public class StoreController {
    @Autowired
    IStoreService storeService;
    @Autowired
    IMaterialWarehousingService materialWarehousingService;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IRealtimebalanceService realtimebalanceService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<StoreVO> saveOrUpdate(@RequestBody StoreVO vo) {
        StoreEntity entity = (StoreEntity)((Object)BeanMapper.map((Object)((Object)vo), StoreEntity.class));
        if (entity.getStoreType() == 0) {
            entity.setIsInfluenceCost(0);
        } else {
            entity.setIsInfluenceCost(1);
        }
        LambdaQueryWrapper storeScheme = Wrappers.lambdaQuery();
        if (vo.getId() != null) {
            storeScheme.ne(BaseEntity::getId, (Object)vo.getId());
        }
        storeScheme.eq(StoreEntity::getProjectId, (Object)vo.getProjectId());
        storeScheme.eq(StoreEntity::getStoreType, (Object)vo.getStoreType());
        List storeEntityList = this.storeService.list((Wrapper)storeScheme);
        if (CollectionUtils.isNotEmpty((Collection)storeEntityList)) {
            throw new BusinessException("\u540c\u4e00\u4e2a\u9879\u76ee\u4e0b\u53ea\u80fd\u65b0\u589e\u4e00\u79cd\u7c7b\u578b\u7684\u4ed3\u5e93!");
        }
        this.storeService.saveOrUpdate((Object)entity, false);
        StoreVO backVo = (StoreVO)((Object)BeanMapper.map((Object)((Object)entity), StoreVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)backVo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<StoreVO> queryDetail(Long id) {
        StoreEntity entity = (StoreEntity)((Object)this.storeService.selectById(id));
        StoreVO vo = (StoreVO)((Object)BeanMapper.map((Object)((Object)entity), StoreVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/storematerialList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> storematerialList(@RequestBody QueryParam params) {
        if (params.getParams().get("storeId") == null) {
            return CommonResponse.error((String)"\u4ed3\u5e93id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List fuzzyFields = params.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("materialCode");
        fuzzyFields.add("materialCategoryCode");
        fuzzyFields.add("materialCategoryName");
        Long storeId = Long.parseLong(((Parameter)params.getParams().get("storeId")).getValue().toString());
        Integer type = Integer.parseInt(((Parameter)params.getParams().get("type")).getValue().toString());
        params.getParams().remove("type");
        params.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.realtimebalanceService.queryPage(params, false);
        List realtimebalanceEntities = page.getRecords();
        List<RealtimebalanceEntity> realtimeBalance = this.realtimebalanceService.getRealtimeBalance(storeId, type, realtimebalanceEntities);
        JSONObject pageData = new JSONObject();
        pageData.put("current", (Object)("" + params.getPageIndex()));
        pageData.put("size", (Object)("" + params.getPageSize()));
        pageData.put("records", new ArrayList());
        pageData.put("total", (Object)"0");
        pageData.put("pages", (Object)"0");
        if (CollectionUtils.isNotEmpty(realtimeBalance)) {
            int total = realtimeBalance.size();
            JSONArray jsonArray = JSONArray.parseArray((String)JSONArray.toJSONString(realtimeBalance));
            JSONArray records = PageUtil.listToPage(jsonArray, params.getPageIndex(), params.getPageSize());
            int pages = PageUtil.getPages(total, params.getPageSize());
            pageData.put("records", (Object)records);
            pageData.put("total", (Object)("" + total));
            pageData.put("pages", (Object)("" + pages));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelStoreMaterialList"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelStoreMaterialList(@RequestBody Map<String, Object> params, HttpServletResponse response) {
        if (params.get("storeId") == null) {
            throw new BusinessException("\u4ed3\u5e93id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long storeId = Long.parseLong(params.get("storeId").toString());
        Integer type = Integer.parseInt(params.get("type").toString());
        String projectId = params.get("projectId").toString();
        String searchText = null;
        QueryParam param = new QueryParam();
        param.setPageIndex(0);
        param.setPageSize(10000);
        if (params.get("searchText") != null) {
            searchText = params.get("searchText").toString();
            param.getParams().put("materialName", new Parameter("eq", (Object)searchText));
        }
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (storeId != null) {
            param.getParams().put("storeId", new Parameter("eq", (Object)storeId));
        }
        if (projectId != null && !projectId.isEmpty()) {
            param.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        }
        IPage page = this.realtimebalanceService.queryPage(param, false);
        List realtimebalanceEntities = page.getRecords();
        List<RealtimebalanceEntity> realtimeBalance = this.realtimebalanceService.getRealtimeBalance(storeId, type, realtimebalanceEntities);
        HashMap<String, List<RealtimebalanceEntity>> beans = new HashMap<String, List<RealtimebalanceEntity>>();
        beans.put("records", realtimeBalance);
        String fileName = "storeMaterialExport.xlsx";
        ExcelExport.getInstance().export(fileName, beans, response);
    }

    private String getText(String str, String pat, int num) {
        Pattern pattern = Pattern.compile(pat);
        Matcher findMatcher = pattern.matcher(str);
        int number = 0;
        while (findMatcher.find() && ++number != num) {
        }
        int i = findMatcher.start();
        return str.substring(0, i);
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<StoreVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContext = this.sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        IPage<StoreVO> page = this.storeService.queryForList(param, false);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", page);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/queryPrint"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryPrint(Long id) {
        JSONObject json = new JSONObject();
        json.put("store", this.storeService.selectById(id));
        return CommonResponse.success((String)"\u67e5\u8be2\u6253\u5370\u6570\u636e\u6210\u529f\uff01", (Object)json);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<StoreVO> vos) {
        return this.storeService.delete(vos);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.setPageIndex(0);
        queryParam.setPageSize(10000);
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        UserContext userContext = this.sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            queryParam.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            queryParam.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        IPage<StoreVO> voPage = this.storeService.queryForList(queryParam, false);
        List list = voPage.getRecords();
        for (StoreVO storeVO : list) {
            if (storeVO.getStoreType() != null) {
                if (storeVO.getStoreType() == 0) {
                    storeVO.setStoreTypeName("\u6210\u54c1\u5e93");
                }
                if (storeVO.getStoreType() == 1) {
                    storeVO.setStoreTypeName("\u5e9f\u65e7\u7269\u8d44\u5e93");
                }
                if (storeVO.getStoreType() == 2) {
                    storeVO.setStoreTypeName("\u8d44\u4ea7\u5e93");
                }
            }
            if (storeVO.getState() == null) continue;
            if (storeVO.getState().equals("0")) {
                storeVO.setStateName("\u505c\u7528");
            }
            if (!storeVO.getState().equals("1")) continue;
            storeVO.setStateName("\u542f\u7528");
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("storeListExport.xlsx", beans, response);
    }

    @RequestMapping(value={"/queryRefList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<StoreVO>> queryRefList(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String searchText, @RequestParam(required=false) String condition, @RequestParam(required=false) String searchObject) {
        Long orgId = null;
        QueryParam param = new QueryParam();
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            JSONObject json = JSONObject.parseObject((String)condition);
            if (json.get((Object)"orgId") != null) {
                orgId = Long.parseLong(json.get((Object)"orgId").toString());
                if (null != json.get((Object)"selfAndUnderData")) {
                    param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
                } else {
                    param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
                }
            } else {
                return CommonResponse.error((String)"condition\u6761\u4ef6\u7f3a\u5c11orgId\uff01");
            }
            if (null != json.get((Object)"sort")) {
                Map sort = (Map)JSONObject.parseObject((String)json.getString("sort"), Map.class);
                for (String key : sort.keySet()) {
                    param.getOrderMap().put(key, sort.get(key).toString());
                }
            }
        } else {
            return CommonResponse.error((String)"\u7f3a\u5c11condition\u6761\u4ef6");
        }
        if (StringUtils.isNotBlank((CharSequence)searchObject)) {
            JSONObject search = JSONObject.parseObject((String)searchObject);
            for (String key : search.keySet()) {
                param.getParams().put(key, new Parameter("like", (Object)search.get((Object)key).toString()));
            }
        }
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            param.setSearchText(searchText);
            List fuzzyFields = param.getFuzzyFields();
            fuzzyFields.add("name");
            fuzzyFields.add("projectName");
            fuzzyFields.add("orgName");
        }
        param.getParams().put("state", new Parameter("eq", (Object)1));
        return CommonResponse.success((String)"\u67e5\u8be2\u4ed3\u5e93\u6570\u636e\u6210\u529f\uff01", this.storeService.queryForList(param, false));
    }

    @RequestMapping(value={"/calculateCanUseNum"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> calculateCanUseNum(@RequestParam Long inStoreSubId, @RequestParam Long materialId, @RequestParam Long outSubId) {
        return CommonResponse.success((String)"\u8ba1\u7b97\u53ef\u7528\u5e93\u5b58\u6210\u529f\uff01", (Object)this.storeService.calculateCanUseNum(inStoreSubId, materialId, outSubId).toString());
    }

    @RequestMapping(value={"/queryNewestStoreByOrgId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<StoreVO> queryNewestStoreByOrgId(@RequestParam Long orgId) {
        return CommonResponse.success((String)"\u67e5\u8be2\u7ec4\u7ec7\u6700\u65b0\u4ed3\u5e93\u6210\u529f\uff01", (Object)((Object)this.storeService.queryNewestStoreByOrgId(orgId)));
    }

    @RequestMapping(value={"/refCanUseNumData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<MaterialWarehousingdetailVO>> refCanUseNumData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchText, String searchObject) throws ParseException {
        if (StringUtils.isBlank((CharSequence)condition)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u6761\u4ef6condition\u4e0d\u80fd\u4e3a\u7a7a");
        }
        JSONObject con = JSONObject.parseObject((String)condition);
        String storeIdStr = con.getString("storeId");
        Long storeId = null;
        if (StringUtils.isBlank((CharSequence)storeIdStr)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u6761\u4ef6\u3010\u4ed3\u5e93\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        storeId = Long.parseLong(storeIdStr);
        String outDate = con.getString("outDate");
        if (StringUtils.isBlank((CharSequence)outDate)) {
            return CommonResponse.error((String)"\u67e5\u8be2\u6761\u4ef6\u3010\u51fa\u5e93\u65e5\u671f\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        queryParam.getParams().put("storeId", new Parameter("eq", (Object)storeId));
        queryParam.getParams().put("puinTime", new Parameter("le", (Object)outDate));
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("materialCategoryName");
        fuzzyFields.add("materialName");
        fuzzyFields.add("materialSpec");
        fuzzyFields.add("materialUnit");
        Page pageVo = new Page();
        IPage<MaterialWarehousingdetailVO> entityPage = this.materialWarehousingService.queryStoreCanUseNumPageData(searchText, searchObject, outDate, storeId, pageNumber, pageSize);
        if (entityPage != null) {
            ArrayList voList = new ArrayList();
            entityPage.getRecords().forEach(e -> {
                MaterialWarehousingdetailVO vo = (MaterialWarehousingdetailVO)((Object)((Object)BeanMapper.map((Object)e, MaterialWarehousingdetailVO.class)));
                vo.setCanUseNumber(this.storeService.calculateCanUseNum(vo.getId(), vo.getMaterialId(), null));
                voList.add(vo);
            });
            pageVo.setRecords(voList);
            pageVo.setSize((long)queryParam.getPageSize());
            pageVo.setCurrent(entityPage.getCurrent());
            pageVo.setPages(entityPage.getPages());
            pageVo.setTotal(entityPage.getTotal());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u51fa\u5e93\u53ef\u7528\u7269\u8d44\u53c2\u7167\u6210\u529f\uff01", entityPage);
    }

    @RequestMapping(value={"/refStore"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<StoreVO>> refStore(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.get((Object)"projectId") != null) {
                param.getParams().put("projectId", new Parameter("eq", _con.get((Object)"projectId")));
            }
            if (_con.get((Object)"type") != null) {
                String[] type = _con.get((Object)"type").toString().split(",");
                List<String> list = Arrays.asList(type);
                param.getParams().put("store_type", new Parameter("in", list));
            }
            if (_con.get((Object)"isInfluenceCost") != null) {
                param.getParams().put("isInfluenceCost", new Parameter("eq", _con.get((Object)"isInfluenceCost")));
            }
        }
        IPage page = this.storeService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), StoreVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

