package com.ejianc.business.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.material.bean.*;
import com.ejianc.business.material.mapper.CheckMapper;
import com.ejianc.business.material.service.ICheckService;
import com.ejianc.business.material.service.IFlowmeterService;
import com.ejianc.business.material.service.IStoreService;
import com.ejianc.business.material.utils.DetailIndexExcelReader;
import com.ejianc.business.material.vo.ImportErrorVo;
import com.ejianc.foundation.material.vo.CheckDetailVO;
import com.ejianc.foundation.material.vo.CheckVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 物资结存(新)
 *
 * @author generator
 *
 */
@Service("checkService")
public class CheckServiceImpl extends BaseServiceImpl<CheckMapper, CheckEntity> implements ICheckService{

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IStoreService storeService;
    @Autowired
    private IFlowmeterService flowmeterService;
    @Autowired
    private ICheckService service;
    @Autowired
    private IShareMaterialApi shareMaterialApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String BILL_CODE = "ZJKJMAT_CHECK";

    @Override
    public CheckVO saveOrUpdate(CheckVO checkVO) {
        CheckEntity entity = BeanMapper.map(checkVO, CheckEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), checkVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        CheckVO vo = BeanMapper.map(entity, CheckVO.class);
        return vo;
    }

    @Override
    public CheckVO queryFlowByMonth(Long projectId, Long id, String checkMonth) {
        LambdaQueryWrapper<CheckEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(CheckEntity::getProjectId, projectId);
        queryWrapper.ne(null != id , CheckEntity::getId, id);
        queryWrapper.notIn(CheckEntity::getBillState, 1,3);
        if (count(queryWrapper) > 0) {
            throw new BusinessException("本项目存在未生效盘点单，不允许新增盘点单！");
        }
        queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(CheckEntity::getProjectId, projectId);
        queryWrapper.ne(null != id , CheckEntity::getId, id);
        queryWrapper.orderByDesc(CheckEntity::getCheckMonth);
        queryWrapper.last("limit 1");
        CheckEntity lastCheckEntity = getOne(queryWrapper, false);
        Map<String, CheckDetailEntity> lastMap = new HashMap<>();
        Map<String, CheckDetailEntity> waitAddMap = new HashMap<>();
        Date  date = null;
        try {
            date = new SimpleDateFormat("yyyy-MM").parse(checkMonth);
        } catch (ParseException e) {
            throw new BusinessException("本项目所选月份格式错误！");
        }
        if (null != lastCheckEntity) {
            if (lastCheckEntity.getCheckMonth().compareTo(date) >= 0) {
                throw new BusinessException("本项目所选月份已存在后续盘点数据！");
            }else {
                lastCheckEntity = selectById(lastCheckEntity.getId());
                for (CheckDetailEntity detailEntity : lastCheckEntity.getDetailList()) {
                    String key = detailEntity.getSourceId() + "@" + detailEntity.getMaterialId();
                    lastMap.put(key, detailEntity);
                    if (ComputeUtil.isGreaterThan(detailEntity.getCheckNum(), BigDecimal.ZERO)) {
                        waitAddMap.put(key, detailEntity);
                    }
                }
            }
        }


        CheckVO checkVO = new CheckVO();
        checkVO.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        LambdaQueryWrapper<StoreEntity> storeQuery = new LambdaQueryWrapper<>();
        storeQuery.eq(StoreEntity::getProjectId, projectId);
        storeQuery.eq(StoreEntity::getStoreType, 0);
        List<StoreEntity> storeEntities = storeService.list(storeQuery);
        if (CollectionUtils.isNotEmpty(storeEntities)) {
            checkVO.setStoreId(storeEntities.get(0).getId());
            checkVO.setStoreName(storeEntities.get(0).getName());
        }else{
            throw new BusinessException("本项目还未建立成品库！");
        }

        List<String> accessTypeList = new ArrayList<>();
//        accessTypeList.add("入库");
        accessTypeList.add("成品出库");
        accessTypeList.add("成品退库");
        accessTypeList.add("直入直出退供应商");
        LambdaQueryWrapper<FlowmeterEntity> flowQuery = new LambdaQueryWrapper<>();
        flowQuery.eq(FlowmeterEntity::getStoreType, 0);
        flowQuery.eq(FlowmeterEntity::getProjectId, projectId);
        flowQuery.eq(FlowmeterEntity::getStoreId, checkVO.getStoreId());
        flowQuery.in(FlowmeterEntity::getBillStatus, 1,3);
        flowQuery.in(FlowmeterEntity::getAccessType, accessTypeList);
        String beginDate = lastCheckEntity == null ? "1990-01-01" : getNextMonth(lastCheckEntity.getCheckMonth()) + "-01";
        String endDate = checkMonth + "-31";
        flowQuery.between(FlowmeterEntity::getTime, beginDate, endDate);
        List<FlowmeterEntity> flowmeterEntities = flowmeterService.list(flowQuery);
        if (CollectionUtils.isNotEmpty(flowmeterEntities)) {
            Map<String, CheckDetailVO> map = new HashMap<>();
            for (FlowmeterEntity flowEntity : flowmeterEntities) {
                CommonResponse<MaterialVO> materialVO = shareMaterialApi.queryMaterialByCode(flowEntity.getMaterialCode());
                if (flowEntity.getSpecialModel() == null) {
                    flowEntity.setSpecialModel(materialVO.getData().getSpec());
                }
                if (flowEntity.getMeasurementUnit() == null) {
                    flowEntity.setMeasurementUnit(materialVO.getData().getUnitName());
                }
                if(null != lastCheckEntity){
                    String flowTime = new SimpleDateFormat("yyyy-MM").format(flowEntity.getTime());
                    if (!flowTime.contains(checkMonth)) {
                        throw new BusinessException("本项目还有[" + flowTime + "]月份的流水未结存!");
                    }
                }
                if("成品退库".equals(flowEntity.getAccessType()) || "直入直出退供应商".equals(flowEntity.getAccessType())){
                    flowEntity.setMid(flowEntity.getOutId());
                }
                String key =  flowEntity.getMid() + "@" + flowEntity.getMaterialId();
                CheckDetailVO detailVO = null;
                if (!map.containsKey(key)) {
                    detailVO = BeanMapper.map(flowEntity, CheckDetailVO.class);
                    detailVO.setSourceId(flowEntity.getMid());
                    detailVO.setCreateTime(null);
                    detailVO.setCreateUserCode(null);
                    detailVO.setUpdateTime(null);
                    detailVO.setUpdateUserCode(null);
                    detailVO.setVersion(1);
                    detailVO.setId(null);
                    detailVO.setOutTime(flowEntity.getTime());
                    detailVO.setMaterialSpec(flowEntity.getSpecialModel());
                    detailVO.setMaterialUnit(flowEntity.getMeasurementUnit());
                    //本期盘点
                    detailVO.setCheckPrice(flowEntity.getUnitPriceExcluetax());
                    detailVO.setCheckTaxPrice(flowEntity.getUnitPriceIncluetax());
//                    //本期领用取流水
//                    detailVO.setFlowPrice(flowEntity.getUnitPriceExcluetax());
//                    detailVO.setFlowTaxPrice(flowEntity.getUnitPriceIncluetax());
                    //本期消耗
//                    detailVO.setUsePrice(flowEntity.getUnitPriceExcluetax());
//                    detailVO.setUseTaxPrice(flowEntity.getUnitPriceIncluetax());
                }else{
                    detailVO = map.get(key);
                }
                detailVO.setFlowNum(ComputeUtil.safeAdd(detailVO.getFlowNum(), flowEntity.getQuantity()));
                detailVO.setFlowMny(ComputeUtil.safeAdd(flowEntity.getAmountExcluetax(), detailVO.getFlowMny()));
                detailVO.setFlowTaxMny(ComputeUtil.safeAdd(flowEntity.getAmountIncluetax(), detailVO.getFlowTaxMny()));
                //反算本期领用取流水单价
                BigDecimal flowTaxPrice = ComputeUtil.safeDiv(detailVO.getFlowTaxMny(), detailVO.getFlowNum());
                BigDecimal flowPrice = ComputeUtil.safeDiv(detailVO.getFlowMny(), detailVO.getFlowNum());
                detailVO.setFlowPrice(flowPrice);
                detailVO.setFlowTaxPrice(flowTaxPrice);

                //本期盘点
                detailVO.setCheckPrice(flowPrice);
                detailVO.setCheckTaxPrice(flowTaxPrice);

                //本期消耗
                detailVO.setUsePrice(flowPrice);
                detailVO.setUseTaxPrice(flowTaxPrice);

                detailVO.setMaterialSpec(flowEntity.getSpecialModel());
                detailVO.setMaterialUnit(flowEntity.getMeasurementUnit());
                if (lastMap.containsKey(key)) {
                    CheckDetailEntity detailEntity = lastMap.get(key);
                    detailVO.setLastCheckNum(detailEntity.getCheckNum());
                    detailVO.setLastCheckPrice(detailEntity.getCheckPrice());
                    detailVO.setLastCheckTaxPrice(detailEntity.getCheckTaxPrice());
                    detailVO.setLastCheckMny(detailEntity.getCheckMny());
                    detailVO.setLastCheckTaxMny(detailEntity.getCheckTaxMny());
                    detailVO.setMaterialSpec(flowEntity.getSpecialModel());
                    detailVO.setMaterialUnit(flowEntity.getMeasurementUnit());
                    if (waitAddMap.containsKey(key)) {
                        waitAddMap.remove(key);
                    }
                }else{
                    detailVO.setLastCheckNum(BigDecimal.ZERO);
                    detailVO.setLastCheckPrice(BigDecimal.ZERO);
                    detailVO.setLastCheckTaxPrice(BigDecimal.ZERO);
                    detailVO.setLastCheckMny(BigDecimal.ZERO);
                    detailVO.setLastCheckTaxMny(BigDecimal.ZERO);
                }
                map.put(key, detailVO);
            }
            if (!map.isEmpty()) {
                checkVO.setDetailList(new ArrayList<>(map.values()));
            }
        }
        if (!waitAddMap.isEmpty()) {
            List<CheckDetailVO> detailList = checkVO.getDetailList();
            for (CheckDetailEntity detailEntity : waitAddMap.values()) {
                CheckDetailVO detailVO = BeanMapper.map(detailEntity, CheckDetailVO.class);
                detailVO.setCreateTime(null);
                detailVO.setCreateUserCode(null);
                detailVO.setUpdateTime(null);
                detailVO.setUpdateUserCode(null);
                detailVO.setVersion(1);
                detailVO.setRowState("add");
                detailVO.setId(null);
                detailVO.setLastCheckNum(detailVO.getCheckNum());
                detailVO.setLastCheckPrice(detailVO.getCheckPrice());
                detailVO.setLastCheckMny(detailVO.getCheckMny());
                detailVO.setLastCheckTaxMny(detailVO.getCheckTaxMny());
                detailVO.setFlowNum(null);
                detailVO.setFlowPrice(null);
                detailVO.setFlowTaxPrice(null);
                detailVO.setFlowMny(null);
                detailVO.setFlowTaxMny(null);
                detailVO.setCheckNum(null);
                detailVO.setCheckMny(null);
                detailVO.setCheckTaxMny(null);
                detailVO.setUseNum(null);
                detailVO.setUseMny(null);
                detailVO.setUseTaxMny(null);
                detailList.add(detailVO);
            }
        }

        if (CollectionUtils.isNotEmpty(checkVO.getDetailList())) {
            Collections.sort(checkVO.getDetailList(), new Comparator<CheckDetailVO>() {
                @Override
                public int compare(CheckDetailVO s1, CheckDetailVO s2) {
                    return s2.getOutTime().compareTo(s1.getOutTime());
                }
            });
        }
        for(CheckDetailVO vo : checkVO.getDetailList()){
            vo.setCheckNum(BigDecimal.ZERO);
            BigDecimal useNum = ComputeUtil.safeSub(ComputeUtil.safeAdd(vo.getLastCheckNum(), vo.getFlowNum()), vo.getCheckNum());
            vo.setUseNum(parseNullValue(useNum));
            vo.setUseMny(ComputeUtil.safeSub(ComputeUtil.safeAdd(vo.getLastCheckMny(), vo.getFlowMny()),vo.getCheckMny()));
            vo.setUseTaxMny(ComputeUtil.safeSub(ComputeUtil.safeAdd(vo.getLastCheckTaxMny(), vo.getFlowTaxMny()),vo.getCheckTaxMny()));


//            vo.setUseMny(ComputeUtil.safeMultiply(vo.getUseNum(), vo.getCheckPrice()));
//            vo.setUseTaxMny(ComputeUtil.safeMultiply(vo.getUseNum(), vo.getCheckTaxPrice()));
            CommonResponse<MaterialVO> materialVO = shareMaterialApi.queryMaterialByCode(vo.getMaterialCode());
            if (vo.getMaterialSpec() == null) {
                vo.setMaterialSpec(materialVO.getData().getSpec());
                vo.setMaterialUnit(materialVO.getData().getUnitName());
            }
        }


        return checkVO;
    }

    @Override
    public Map<String, CheckDetailVO> queryCheckByMonth(Long projectId, String checkMonth) {
        LambdaQueryWrapper<CheckEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(CheckEntity::getProjectId, projectId);
        queryWrapper.apply("DATE_FORMAT(check_month, '%Y-%m') = '" + checkMonth + "'");
        CheckEntity checkEntity = getOne(queryWrapper, false);
        if (null == checkEntity  || (!BillStateEnum.PASSED_STATE.getBillStateCode().equals(checkEntity.getBillState())) && !BillStateEnum.COMMITED_STATE.getBillStateCode().equals(checkEntity.getBillState())) {
            return null;
        }
        CheckEntity entity = selectById(checkEntity.getId());
        Map<String, CheckDetailVO> map = new HashMap<>();
        if (CollectionUtils.isNotEmpty(entity.getDetailList())) {
            for (CheckDetailEntity detailEntity : entity.getDetailList()) {
                CheckDetailVO detailVO = null;
                if (!map.containsKey(String.valueOf(detailEntity.getMaterialCategoryId()))) {
                    detailVO = BeanMapper.map(detailEntity, CheckDetailVO.class);
                }else{
                    detailVO = map.get(String.valueOf(detailEntity.getMaterialCategoryId()));
                    detailVO.setUseNum(ComputeUtil.safeAdd(parseNullValue(detailVO.getUseNum()), parseNullValue(detailEntity.getUseNum())));
                    detailVO.setUseMny(ComputeUtil.safeAdd(parseNullValue(detailVO.getUseMny()), parseNullValue(detailEntity.getUseMny())));
                    detailVO.setUsePrice(ComputeUtil.safeDiv(parseNullValue(detailVO.getUseMny()), parseNullValue(detailVO.getUseNum())));
                }
                map.put(String.valueOf(detailEntity.getMaterialCategoryId()), detailVO);
            }
        }
        return map;
    }
    private BigDecimal parseNullValue(BigDecimal value) {
        return value == null ? BigDecimal.ZERO : value;
    }

    @Override
    public void updateSettlementState(Long projectId, Integer state, String checkMonth) {
        logger.info("updateSettlementState进来了:"+projectId+"@"+"state"+state+"checkMonth"+checkMonth);
        logger.info(new Date().toString());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM");
        Date date = null;
        try {
            date = simpleDateFormat.parse(checkMonth);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        LambdaQueryWrapper<CheckEntity> lambdaCheck = Wrappers.<CheckEntity>lambdaQuery();
        lambdaCheck.eq(CheckEntity::getProjectId,projectId);
        lambdaCheck.eq(CheckEntity::getCheckMonth,date);
        List<CheckEntity> checkEntityList = super.list(lambdaCheck);
        for (CheckEntity checkEntity : checkEntityList) {
            checkEntity.setIsSettlement(state);
        }

        super.updateBatchById(checkEntityList);

        logger.info("checkEntityList"+JSONObject.toJSONString(checkEntityList));
        logger.info("updateSettlementState结束了"+new Date().toString());
    }

    @Override
    public CommonResponse<JSONObject> excelImportInfo(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }

        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error("文件格式不合法！");
        } else {
            List<List<List<String>>> resList = DetailIndexExcelReader.readExcel(mf);
            List<List<String>> result = resList.get(0);
            if (result.size() > 0 && result.get(0).size() < 20) {
                return CommonResponse.error("数据不完整，请下载最新模板！");
            }
            List<CheckDetailVO> successList = new ArrayList<>();
            List<CheckDetailVO> errorList = new ArrayList<>();
            if (result != null && result.size() > 0) {
                List<CheckDetailVO> detailVoList = new ArrayList<>();
                boolean importFlag = true;
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    CheckDetailVO vo = new CheckDetailVO();
                    boolean flag = false;
                    String warnType = "";

                    String billCode = datas.get(0);
                    String materialCode = datas.get(5);
                    String checkNum = datas.get(15);

                    Long id = IdWorker.getId();
                    vo.setId(id);

                    if (StringUtils.isEmpty(billCode)) {//单号为空
                        vo.setBillCode(null);
                        warnType = warnType + "[单号为空]";
                        flag = true;
                    } else {
                        vo.setBillCode(billCode);
                    }
                    if (StringUtils.isEmpty(materialCode)) {//物资编码为空
                        vo.setMaterialCode(null);
                        warnType = warnType + "[物资编码为空]";
                        flag = true;
                    } else {
                        CommonResponse<MaterialVO> materialVO = shareMaterialApi.queryMaterialByCode(materialCode);
                        if (materialVO.getData() != null) {
                            vo.setMaterialCode(materialCode);
                            vo.setMaterialSpec(materialVO.getData().getSpec());
                            vo.setMaterialUnit(materialVO.getData().getUnitName());
                        } else {
                            vo.setMaterialCode(null);
                            warnType = warnType + "[物资编码不正确]";
                            flag = true;
                        }
                    }

                    if (StringUtils.isEmpty(checkNum)) {
                        vo.setCheckNum(null);
                        warnType = warnType + "[本月结存数量为空]";
                        flag = true;
                    } else {
                        try {
                            vo.setCheckNum(new BigDecimal(checkNum));
                        } catch (Exception e) {
                            vo.setCheckNum(null);
                            warnType = warnType + "[本月结存数量只能为数字或小数]";
                            flag = true;
                        }
                    }
                    vo.setImportFlag(!flag);// true=可以导入，false=不可导入
                    if (importFlag) {// 如果能导入
                        importFlag = !flag;
                    }
                    vo.setWarnType(warnType);
                    detailVoList.add(vo);
                }
                for (CheckDetailVO vo : detailVoList) {
                    if (vo.getImportFlag()) {
                        if (importFlag) {
                            successList.add(vo);
                        }
                    } else {
                        errorList.add(vo);
                    }
                }
                if (errorList.size() > 0) {
                    resp.put("successList", null);
                    resp.put("successNum", 0);
                    resp.put("errorNum", errorList.size());
                    if (errorList.size() > 100) {
                        resp.put("errorList", errorList.subList(0, 100));
                    } else {
                        resp.put("errorList", errorList);
                    }
                }else{
                    resp.put("successList", successList);
                    resp.put("errorList", null);
                    resp.put("successNum", successList.size());
                    resp.put("errorNum", 0);
                }
            }
        }
        return CommonResponse.success(resp);
    }

    @Override
    public CommonResponse<String> getCheckFlag(Long projectId, String checkMonth) {
        logger.info("getCheckFlag进来了:"+projectId+"@"+"checkMonth"+checkMonth);
        LambdaQueryWrapper<CheckEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(CheckEntity::getProjectId, projectId);
        queryWrapper.apply("DATE_FORMAT(check_month, '%Y-%m') = '" + checkMonth + "'");
        CheckEntity checkEntity = getOne(queryWrapper, false);
        if (null == checkEntity  || (!BillStateEnum.PASSED_STATE.getBillStateCode().equals(checkEntity.getBillState())) && !BillStateEnum.COMMITED_STATE.getBillStateCode().equals(checkEntity.getBillState())) {
           throw new BusinessException("该项目本月还未做物资剩余数量盘点表数据！");
        }
        //
        LambdaQueryWrapper<CheckEntity> query = new LambdaQueryWrapper<CheckEntity>()
                .eq(CheckEntity::getProjectId, projectId)
                .apply("DATE_FORMAT(check_month, '%Y-%m') < '" + checkMonth + "'")
                .and(qw -> qw.isNull(CheckEntity::getIsSettlement)
                        .or().eq(CheckEntity::getIsSettlement, 0));
        int count = service.count(query);
        logger.info("count"+count);
        if (count > 0) throw new BusinessException("物资剩余数量盘点表有往期未归集的数据");
        return CommonResponse.success("成功");
    }

    private String getNextMonth(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(Calendar.DAY_OF_MONTH, cal.getActualMaximum(Calendar.DAY_OF_MONTH));
        cal.add(Calendar.MONTH, 1);
        Date nextMonthDate = cal.getTime();
        return sdf.format(nextMonthDate);
    }
}
