package com.ejianc.business.material.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.material.bean.MaterialapproachEntity;
import com.ejianc.business.material.bean.MaterialapproachdetailEntity;
import com.ejianc.business.material.service.IMaterialapproachService;
import com.ejianc.business.material.service.IMaterialapproachdetailService;
import com.ejianc.business.material.utils.DateUtils;
import com.ejianc.business.material.vo.MaterialapproachReportVO;
import com.ejianc.foundation.material.vo.MaterialapproachVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 物资（周转）进场验证记录
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("materialapproach")
public class MaterialapproachController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IMaterialapproachService service;
    @Autowired
    private IMaterialapproachdetailService detailService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<MaterialapproachVO> saveOrUpdate(@RequestBody MaterialapproachVO saveorUpdateVO) {
    	return CommonResponse.success("保存或修改单据成功！", service.saveOrUpdate(saveorUpdateVO));
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MaterialapproachVO> queryDetail(Long id) {
    	MaterialapproachEntity entity = service.selectById(id);
    	MaterialapproachVO vo = BeanMapper.map(entity, MaterialapproachVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    @RequestMapping(value = "/queryReport", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<MaterialapproachReportVO>> queryReport(Long projectId, String materialCode) {
        List<MaterialapproachReportVO> resList = new ArrayList<>();
        QueryWrapper<MaterialapproachdetailEntity> detailQueryWrapper = new QueryWrapper<>();
        detailQueryWrapper.eq("dr", 0);
        detailQueryWrapper.eq("project_id", projectId);
        detailQueryWrapper.eq("material_code", materialCode);
        List<MaterialapproachdetailEntity> detailEntityList = detailService.list(detailQueryWrapper);

        for (MaterialapproachdetailEntity item:
                detailEntityList) {
            String projectName = item.getProjectName();//项目名称
            String name = item.getName();//料具名称
            BigDecimal enterCount = item.getEnterCount();//进场数量
            MaterialapproachReportVO reportVO = new MaterialapproachReportVO();
            reportVO.setId(IdWorker.getId());
            reportVO.setProjectId(projectId);
            reportVO.setProjectName(projectName);
            reportVO.setMaterialName(name);
            reportVO.setMaterialCode(materialCode);
            reportVO.setEnterCount(enterCount);
            reportVO.setSpec(item.getSpec());

            Long mid = item.getMid();
            QueryWrapper<MaterialapproachEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("dr", 0);
            queryWrapper.eq("id", mid);
            List<MaterialapproachEntity> mList = service.list(queryWrapper);
            Integer billState = 0;
            if(mList != null && mList.size() > 0){
                MaterialapproachEntity entity = mList.get(0);
                String billCode = entity.getBillCode();
                reportVO.setBillCode(billCode);
                reportVO.setMaterialapproachId(mid);
                billState = entity.getBillState();
            }
            if(billState == 1 || billState ==3){
                resList.add(reportVO);
            }
        }

        return CommonResponse.success("查询成功", resList);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MaterialapproachVO> vos) {
        service.removeByIds(vos.stream().map(MaterialapproachVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MaterialapproachVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }

        IPage<MaterialapproachEntity> page = service.queryPage(param,false);
        IPage<MaterialapproachVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), MaterialapproachVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("bill_code");
        fuzzyFields.add("agent_name");
        fuzzyFields.add("agentdep_name");
        fuzzyFields.add("contract_name");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        List<MaterialapproachEntity> list = service.queryList(param);

        //时间转换
        List<MaterialapproachVO> materialapproachVOList = BeanMapper.mapList(list, MaterialapproachVO.class);
        for (int i = 0; i < materialapproachVOList.size(); i++) {
            MaterialapproachVO materialapproachVO = materialapproachVOList.get(i);
            materialapproachVO.setNum(String.valueOf(i + 1));
            if (materialapproachVO.getCreateTime() != null) {
                materialapproachVO.setCreateTimeShow(DateUtils.dateSimple2(materialapproachVO.getCreateTime()));
            }
            if (materialapproachVO.getBillTime()!=null){
                materialapproachVO.setBillTimeShow(DateUtils.dateSimple2(materialapproachVO.getBillTime()));
            }
            if (materialapproachVO.getEnterTime()!=null){
                materialapproachVO.setEnterTimeShow(DateUtils.dateSimple2(materialapproachVO.getEnterTime()));
            }

            String billStateStr = materialapproachVO.getBillState().toString();
            if (billStateStr != null){
                if("0".equals(billStateStr)){//自由态
                    billStateStr = "自由态";
                }else if("1".equals(billStateStr)){//已提交
                    billStateStr = "已提交";
                }else if("2".equals(billStateStr) || "5".equals(billStateStr)){//审批中
                    billStateStr = "审批中";
                }else if("3".equals(billStateStr)){//审批通过
                    billStateStr = "审批通过";
                }else if("4".equals(billStateStr)){//驳回
                    billStateStr = "驳回";
                }

                materialapproachVO.setBillStateStr(billStateStr);
            }

            if (null != materialapproachVO.getCheckType()) {
                if (1 == materialapproachVO.getCheckType()) {
                    materialapproachVO.setCheckTypeName("普通验收");
                }else if (2 == materialapproachVO.getCheckType()) {
                    materialapproachVO.setCheckTypeName("零星材料验收");
                }
            }
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", materialapproachVOList);
        ExcelExport.getInstance().export("Materialapproach-export.xlsx", beans, response);

    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refMaterialapproachData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<MaterialapproachVO>> refMaterialapproachData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("bill_code");
        fuzzyFields.add("agent_name");
        fuzzyFields.add("agentdep_name");
        fuzzyFields.add("contract_name");
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        //审批通过
        param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        param.getOrderMap().put("createTime",QueryParam.DESC);

        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if(_con.get("checkFlag") != null){
                String checkFlag = _con.get("checkFlag").toString();
                if(checkFlag.equals("0")){
                    List<Integer> checkTypeList = new ArrayList<>();
                    checkTypeList.add(2);
//                    checkTypeList.add(3);
                    param.getParams().put("checkType", new Parameter(QueryParam.NOT_IN,checkTypeList));
                }
                if(checkFlag.equals("1")){
                    List<Integer> checkTypeList = new ArrayList<>();
                    checkTypeList.add(2);
                    param.getParams().put("checkType", new Parameter(QueryParam.IN,checkTypeList));
                }
            }
            if(_con.get("status") != null){
                String status = _con.get("status").toString();
                if(status.equals("0")){
                    param.getParams().put("notStorageNum", new Parameter(QueryParam.GT,new BigDecimal(0.00)));
                }
            }
            if(_con.get("contractId")!=null){
                param.getParams().put("contractId", new Parameter(QueryParam.EQ, _con.get("contractId")));
            }
            if(_con.get("projectId")!=null){
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, _con.get("projectId")));
            }
        }

        IPage<MaterialapproachEntity> page = service.queryPage(param,false);
        IPage<MaterialapproachVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MaterialapproachVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @Description validatePlan 校验进场数量不能超过计划数量（项目+物料汇总）
     * @param vo
     */
    @RequestMapping(value = "/validatePlan", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> validatePlan(@RequestBody MaterialapproachVO vo) {
        return CommonResponse.success("查询成功！", service.validatePlan(vo));
    }
}
