package com.ejianc.business.material.controller.api;

import com.ejianc.business.material.service.ICheckService;
import com.ejianc.foundation.material.vo.CheckDetailVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.util.Map;

/**
 * 物资结存
 *
 * @author generator
 */
@Controller
@RequestMapping("api/check")
public class CheckApiController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ICheckService checkService;

    /**
     * 根据项目id和月度查询物资结存本月消耗
     * @param projectId 项目id
     * @param checkMonth     月份
     * @return
     */
    @RequestMapping(value = "/queryCheckByMonth", method = RequestMethod.GET)
    @ResponseBody
    private CommonResponse<Map<String, CheckDetailVO>> queryCheckByMonth(@RequestParam(value = "projectId") Long projectId, @RequestParam(value = "checkMonth") String checkMonth) {
        return CommonResponse.success("查询数据成功", checkService.queryCheckByMonth(projectId, checkMonth));
    }
    /**
     *校验
     * @param projectId 项目id
     * @param checkMonth     月份
     * @return
     */
//    @RequestMapping(value = "/getCheckFlag", method = RequestMethod.GET)
//    @ResponseBody
//    private CommonResponse<String> getCheckFlag(Long projectId, String checkMonth) {
//        logger.info("getCheckFlag进来了:"+projectId+"@"+"checkMonth"+checkMonth);
//        checkService.getCheckFlag(projectId, checkMonth);
//        return CommonResponse.success("查询成功");
//    }
    /**
     * @Description 月度成本分析物资结存单据更新归集状态字段
     *
     * @param projectId 项目id
     * @param state    归集状态
     * @param checkMonth 要归集单据数据的时间范围
     * @return com.ejianc.framework.core.response.CommonResponse
     * @createDate 2023/1/12
     * @author yupengjie
     **/
    @RequestMapping(value = "/getCheckFlag", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> getCheckFlag(Long projectId, String checkMonth){
        logger.info("getCheckFlag进来了:"+projectId+"@"+"checkMonth"+checkMonth);
        String checkFlag = checkService.getCheckFlag(projectId, checkMonth);
        return CommonResponse.success("更新归集状态成功");
    }
    /**
     * @Description 月度成本分析物资结存单据更新归集状态字段
     *
     * @param projectId 项目id
     * @param state    归集状态
     * @param checkMonth 要归集单据数据的时间范围
     * @return com.ejianc.framework.core.response.CommonResponse
     * @createDate 2023/1/12
     * @author yupengjie
     **/
    @RequestMapping(value = "/updateSettlementState", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> updateSettlementState(Long projectId, Integer state, String checkMonth){
        checkService.updateSettlementState(projectId, state, checkMonth);
        return CommonResponse.success("更新归集状态成功");
    }
}
