package com.ejianc.business.material.service;

import com.ejianc.business.material.vo.StoreBalanceVO;
import com.ejianc.foundation.material.vo.StoreBalanceDetailVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.material.bean.StoreBalanceEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 物资结存
 *
 * @author generator
 *
 */
public interface IStoreBalanceService extends IBaseService<StoreBalanceEntity> {
    StoreBalanceVO queryStoreBalanceByProjectId(Long projectId, String month,String storeId);
    StoreBalanceDetailVO queryStoreBalanceMonth(Long projectId, String month, String materialCategoryCode);

    /**
     * 根据项目和月度查询物资本月消耗
     * @param projectId  项目id
     * @param month      月度
     * @return
     */
    List<StoreBalanceDetailVO> queryMaterialConsumeMonth(@Param("projectId") Long projectId, @Param("month") String month);
    /***
     * @Description //TODO 更新单据的是否归集状态字段数据
     *
     * @param projectId 项目id
     * @param state 需要更新的是否归集状态
     * @param monthStr 月份时间范围
     * @return boolean
     * @createDate 2023/1/12
     * @author yupengjie
     **/
    boolean updateSettlementState(Long projectId,Integer state,String monthStr);
    /***
     * @Description //TODO 查询单据数据是否被月度成本分析归集
     *
     * @param projectId 项目id
     * @param monthStr  月份时间范围
     * @return boolean
     * @createDate 2023/1/12
     * @author yupengjie
     **/
    boolean queryIsSettlement(Long projectId,String monthStr);

    /**
     * @Description queryList 查询上个单据中 本月月结存数量大于0的数据
     * @param projectId
     * @Return List
     */
    List<com.ejianc.business.material.vo.StoreBalanceDetailVO> queryLastMonthList(Long projectId);
}
