package com.ejianc.business.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.material.bean.CheckEntity;
import com.ejianc.business.material.service.ICheckService;
import com.ejianc.framework.core.exception.BusinessException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("check")
public class CheckBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private ICheckService checkService;

	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		CheckEntity checkEntity = checkService.selectById(billId);
		if(	checkEntity.getIsSettlement() != null && checkEntity.getIsSettlement() == 1){
			return CommonResponse.error("该项目已被实际成本归集，不允许撤回！");
		}
		LambdaQueryWrapper<CheckEntity> queryWrapper = new LambdaQueryWrapper<>();
		queryWrapper = new LambdaQueryWrapper<>();
		queryWrapper.eq(CheckEntity::getProjectId, checkEntity.getProjectId());
		queryWrapper.ne(CheckEntity::getId, billId);
		queryWrapper.orderByDesc(CheckEntity::getCheckMonth);
		queryWrapper.last("limit 1");
		CheckEntity lastCheckEntity = checkService.getOne(queryWrapper, false);
		if (null != lastCheckEntity && lastCheckEntity.getCheckMonth().compareTo(checkEntity.getCheckMonth()) >= 0) {
			return CommonResponse.error("该项目后续月份已做过结存，不允许撤回！");
		}
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		CheckEntity checkEntity = checkService.selectById(billId);
		if(	checkEntity.getIsSettlement() != null && checkEntity.getIsSettlement() == 1){
			return CommonResponse.error("该项目已被实际成本归集，不允许撤回！");
		}
		LambdaQueryWrapper<CheckEntity> queryWrapper = new LambdaQueryWrapper<>();
		queryWrapper = new LambdaQueryWrapper<>();
		queryWrapper.eq(CheckEntity::getProjectId, checkEntity.getProjectId());
		queryWrapper.ne(CheckEntity::getId, billId);
		queryWrapper.orderByDesc(CheckEntity::getCheckMonth);
		queryWrapper.last("limit 1");
		CheckEntity lastCheckEntity = checkService.getOne(queryWrapper, false);
		if (null != lastCheckEntity && lastCheckEntity.getCheckMonth().compareTo(checkEntity.getCheckMonth()) >= 0) {
			return CommonResponse.error("该项目后续月份已做过结存，不允许撤回！");
		}

		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
