package com.ejianc.business.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.material.bean.*;
import com.ejianc.business.material.service.IDeviceexitrecordsService;
import com.ejianc.business.material.service.IDeviceexitrecordsdetailService;
import com.ejianc.business.material.service.IDeviceverificationrecordsService;
import com.ejianc.business.material.service.IDeviceverificationrecordsdetailService;
import com.ejianc.framework.core.exception.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.Iterator;
import java.util.stream.Collectors;

@Service("deviceexitrecords")
public class DeviceexitrecordsBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private IDeviceexitrecordsService IDeviceexitrecordsService;
	@Autowired
	private IDeviceexitrecordsdetailService deviceexitrecordsdetailService;
	@Autowired
	private IDeviceverificationrecordsService deviceverificationrecordsService;
	@Autowired
	private IDeviceverificationrecordsdetailService deviceverificationrecordsdetailService;

	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	@Transactional(rollbackFor = Exception.class)
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//logger.info("设备退场提交进来啦--------------");
		////设备退场单数据
		//DeviceexitrecordsEntity deviceexitrecordsEntity = IDeviceexitrecordsService.selectById(billId);
		//BigDecimal bigDecimal = new BigDecimal(BigInteger.ZERO);
		////设备进场单数据
		//DeviceverificationrecordsEntity deviceverificationrecordsEntity = deviceverificationrecordsService.selectById(deviceexitrecordsEntity.getEnterId());
		//if(deviceexitrecordsEntity.getDeviceexitrecordsdetailEntities().size() > 0){
		//	logger.info("设备退场子表提交进来啦--------------");
		//	for(DeviceexitrecordsdetailEntity entity : deviceexitrecordsEntity.getDeviceexitrecordsdetailEntities()){
		//		for(DeviceverificationrecordsdetailEntity item : deviceverificationrecordsEntity.getDeviceverificationrecordsdetailEntities()){
		//			if(entity.getEnterDetailId().equals(item.getId())){
		//				if(entity.getExitCount().compareTo(item.getNotExitingCount()) > 0){
		//					throw new BusinessException("设备编码:" + entity.getEquipmentCode() + "退场数量不允许大于设备进场单的未退场数量!");
		//				}else{
		//					bigDecimal = bigDecimal.add(entity.getExitCount());
		//					item.setNotExitingCount(item.getNotExitingCount().subtract(entity.getExitCount()));
		//				}
		//			}
		//		}
		//	}
		//	deviceverificationrecordsEntity.setNotExitingCount(deviceverificationrecordsEntity.getNotExitingCount().subtract(bigDecimal));
		//	deviceverificationrecordsService.saveOrUpdate(deviceverificationrecordsEntity,false);
		//	logger.info("设备退场子表提交结束啦--------------");
		//}
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		logger.info("设备退场撤回进来啦--------------");
		//设备退场单数据
		DeviceexitrecordsEntity deviceexitrecordsEntity = IDeviceexitrecordsService.selectById(billId);
		BigDecimal bigDecimal = new BigDecimal(BigInteger.ZERO);
		//设备进场单数据
		DeviceverificationrecordsEntity deviceverificationrecordsEntity = deviceverificationrecordsService.selectById(deviceexitrecordsEntity.getEnterId());
		if(deviceexitrecordsEntity.getDeviceexitrecordsdetailEntities().size() > 0){
			logger.info("设备退场子表撤回进来啦--------------");
			for(DeviceexitrecordsdetailEntity entity : deviceexitrecordsEntity.getDeviceexitrecordsdetailEntities()){
				for(DeviceverificationrecordsdetailEntity item : deviceverificationrecordsEntity.getDeviceverificationrecordsdetailEntities()){
					if(entity.getEnterDetailId().equals(item.getId())){
						bigDecimal = bigDecimal.add(entity.getExitCount());
						item.setNotExitingCount(item.getNotExitingCount().add(entity.getExitCount()));
					}
				}
			}
			deviceverificationrecordsEntity.setNotExitingCount(deviceverificationrecordsEntity.getNotExitingCount().add(bigDecimal));
			deviceverificationrecordsService.saveOrUpdate(deviceverificationrecordsEntity,false);
			logger.info("设备退场子表撤回结束啦--------------");
		}
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//回写主表
		DeviceexitrecordsEntity deviceexitrecordsEntity = IDeviceexitrecordsService.selectById(billId);
		deviceexitrecordsEntity.setApproveTime(new Date());
		IDeviceexitrecordsService.updateById(deviceexitrecordsEntity);
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("设备退场弃审进来啦--------------");
		//设备退场单数据
		DeviceexitrecordsEntity deviceexitrecordsEntity = IDeviceexitrecordsService.selectById(billId);
		BigDecimal bigDecimal = new BigDecimal(BigInteger.ZERO);
		//设备进场单数据
		DeviceverificationrecordsEntity deviceverificationrecordsEntity = deviceverificationrecordsService.selectById(deviceexitrecordsEntity.getEnterId());
		if(deviceexitrecordsEntity.getDeviceexitrecordsdetailEntities().size() > 0){
			logger.info("设备退场子表弃审进来啦--------------");
			for(DeviceexitrecordsdetailEntity entity : deviceexitrecordsEntity.getDeviceexitrecordsdetailEntities()){
				for(DeviceverificationrecordsdetailEntity item : deviceverificationrecordsEntity.getDeviceverificationrecordsdetailEntities()){
					if(entity.getEnterDetailId().equals(item.getId())){
						bigDecimal = bigDecimal.add(entity.getExitCount());
						item.setNotExitingCount(item.getNotExitingCount().add(entity.getExitCount()));
					}
				}
			}
			deviceverificationrecordsEntity.setNotExitingCount(deviceverificationrecordsEntity.getNotExitingCount().add(bigDecimal));
			deviceverificationrecordsService.saveOrUpdate(deviceverificationrecordsEntity,false);
			logger.info("设备退场子表弃审结束啦--------------");
		}
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//回写主表
		DeviceexitrecordsEntity deviceexitrecordsEntity = IDeviceexitrecordsService.selectById(billId);
		deviceexitrecordsEntity.setApproveTime(null);
		IDeviceexitrecordsService.updateById(deviceexitrecordsEntity);
		//TODO
		return CommonResponse.success();
	}

}
