package com.ejianc.business.material.utils;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DateUtils {
    public static String dateSimple(Date date){
        SimpleDateFormat sDateFormat=new SimpleDateFormat("yyyy-MM-dd");
        String formatDate = sDateFormat.format(date);
        return formatDate;

    }

    public static String dateSimple2(Date date){
        SimpleDateFormat sDateFormat=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String formatDate = sDateFormat.format(date);
        return formatDate;

    }
    public static String dateSimple3(Date date){
        SimpleDateFormat sDateFormat=new SimpleDateFormat("yyyy-MM");
        String formatDate = sDateFormat.format(date);
        return formatDate;

    }

    public static String dateSimple4(String date){
        DateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.CHINA);
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        try {
            Date formatDate = format.parse(date);
            SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM");
            String resDate = sdf1.format(formatDate);
            return resDate;
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String dateSimple5(String date){
        DateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.CHINA);
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        try {
            Date formatDate = format.parse(date);
            SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd");
            String resDate = sdf1.format(formatDate);
            return resDate;
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Date Date(String days) throws ParseException {
        SimpleDateFormat sDateFormat=new SimpleDateFormat("yyyy-MM-dd");
        String dateStr = ExcelDoubleToDate(days);
        Date date=sDateFormat.parse(dateStr);
        return date;
    }
    public static String ExcelDoubleToDate(String strDate) {
        if(strDate.length() == 5){
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                Date tDate = DoubleToDate(Double.parseDouble(strDate));
                return sdf.format(tDate);
            }catch (Exception e){
                e.printStackTrace();
                return strDate;
            }
        }
        return strDate;
    }

    //解析Excel日期格式
    public static Date DoubleToDate(Double dVal) {
        Date tDate = new Date();
        long localOffset = tDate.getTimezoneOffset() * 60000; //系统时区偏移 1900/1/1 到 1970/1/1 的 25569 天
        tDate.setTime((long) ((dVal - 25569) * 24 * 3600 * 1000 + localOffset));

        return tDate;
    }

    /**
     * 获取某月第一天
     * @param month
     * @return
     */
    public static Date getFirstDayOfMonth(int year, int month) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        // 设置年度
        calendar.set(Calendar.YEAR, year);
        // 设置月份
        calendar.set(Calendar.MONTH, month - 1);
        // 获取某月最小天数
        int firstDay = calendar.getActualMinimum(Calendar.DAY_OF_MONTH);
        // 设置日历中月份的最小天数
        calendar.set(Calendar.DAY_OF_MONTH, firstDay);
        // 格式化日期
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String firstDayStr = sdf.format(calendar.getTime())+" 00:00:00";

        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = sdf1.parse(firstDayStr);

        return date;
    }

    /**
     * 获取某月最后一天
     * @param year
     * @param month
     * @return
     */
    public static Date getLastDayOfMonth(int year, int month) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        // 设置月份
        calendar.set(Calendar.MONTH, month - 1);
        // 获取某月最大天数
        int lastDay=0;
        //2月的平年瑞年天数
        if(month==2) {
            lastDay = calendar.getLeastMaximum(Calendar.DAY_OF_MONTH);
        }else {
            lastDay = calendar.getActualMaximum(Calendar.DAY_OF_MONTH);
        }
        // 设置日历中月份的最大天数
        calendar.set(Calendar.DAY_OF_MONTH, lastDay);
        // 格式化日期
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String lastDayStr = sdf.format(calendar.getTime())+" 23:59:59";

        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = sdf1.parse(lastDayStr);
        return date;
    }

    public static boolean grepDate(String date){
        date = ExcelDoubleToDate(date);
        String rexp1 = "((\\d{2}(([02468][048])|([13579][26]))[\\-]((((0?[13578])|(1[02]))[\\-]((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-]((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-]((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-]((((0?[13578])|(1[02]))[\\-]((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-]((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-]((0?[1-9])|(1[0-9])|(2[0-8]))))))";
        Pattern compile = Pattern.compile(rexp1);
        Matcher matcher = compile.matcher(date);
        // 字符串是否与正则表达式相匹配
        boolean rs = matcher.matches();
        return rs;
    }
}
