package com.ejianc.business.material.excel;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.material.bean.SurplusmaterialrecordtailEntity;
import com.ejianc.business.material.service.ISurplusmaterialrecordtailService;
import com.ejianc.business.material.vo.SurplusmaterialrecordtailVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
/**
 * 剩余/废旧物资处理记录子表导入导出
 */
@Controller
@RequestMapping("surplusmaterialrecordtailExport")
public class ExcelSurplusmaterialrecordtailController {
    private static final long   serialVersionUID= 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISurplusmaterialrecordtailService service;
    /**
     * 导出模板下载
     */
    @RequestMapping(value = "/downloadSurplusmaterialrecordtail")
    @ResponseBody
    public void downloadSurplusmaterialrecordtail (HttpServletRequest request, HttpServletResponse response){
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "Surplusmaterialrecordtail-import.xlsx", "计划成本-指标分析明细清单模板");
    }
    /**
     * 从Excel导入
     */
    @RequestMapping(value = "/excelImportSurplusmaterialrecordtail", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportSurplusmaterialrecordtail(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<SurplusmaterialrecordtailVO> successList = new ArrayList<>();
        List<SurplusmaterialrecordtailVO> errorList = new ArrayList<>();
        Map<String, SurplusmaterialrecordtailVO> map = new HashMap<>();
        DateFormat sdf=new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if(isFailed) {
            return CommonResponse.error("文件格式不合法");
        }else{
            List<List<String>> result = ExcelReader.readExcel(mf);
            if(result != null && result.size() > 0) {
                for(int i=1;i<result.size();i++) {
                    List<String> datas = result.get(i);
                    StringBuilder errorsMsgBuilder = new StringBuilder();
                    String materialCode = datas.get(0);
                    String materialName = datas.get(1);
                    String materialUnit = datas.get(2);
                    String tareWeight = datas.get(3);
                    String grossWeight = datas.get(4);
                    String suttle = datas.get(5);
                    String unitPrice = datas.get(6);
                    String money = datas.get(7);
                    String careNumber = datas.get(8);
                    //循环进来TPID
                    SurplusmaterialrecordtailVO SurplusmaterialrecordtailVO = new SurplusmaterialrecordtailVO();
                    SurplusmaterialrecordtailVO.setId(IdWorker.getId());//id
                    //三目判断值是否空
                    SurplusmaterialrecordtailVO.setMaterialCode(StringUtils.isNotBlank(materialCode) ? materialCode : null);//物资编码
                    SurplusmaterialrecordtailVO.setMaterialName(StringUtils.isNotBlank(materialName) ? materialName : null);
                    SurplusmaterialrecordtailVO.setMaterialUnit(StringUtils.isNotBlank(materialUnit) ? materialUnit : null);
                    SurplusmaterialrecordtailVO.setCareNumber(StringUtils.isNotBlank(careNumber) ? careNumber : null);
                    //必填项校验
                    if (materialName == null || TextUtils.isEmpty(materialName)) {
                        SurplusmaterialrecordtailVO.setErrorMsg("物资名称不能为空！");
                        errorsMsgBuilder.append("物资名称不能为空！");
                    }
                    if (materialCode == null || TextUtils.isEmpty(materialCode)) {
                        SurplusmaterialrecordtailVO.setErrorMsg("物资编码不能为空！");
                        errorsMsgBuilder.append("物资编码不能为空！");
                    }
                    //格式校验
                    if (!TextUtils.isEmpty(tareWeight) && !NumberUtil.isNumber(tareWeight)) {
                        SurplusmaterialrecordtailVO.setErrorMsg("皮重不正确！");
                        errorsMsgBuilder.append("皮重格式不正确！");
                    } else {
                        SurplusmaterialrecordtailVO.setTareWeight(StringUtils.isNotBlank(tareWeight) ? new BigDecimal(tareWeight) : null);
                    }
                    if (!TextUtils.isEmpty(grossWeight) && !NumberUtil.isNumber(grossWeight)) {
                        SurplusmaterialrecordtailVO.setErrorMsg("毛重格式不正确！");
                        errorsMsgBuilder.append("毛重格式不正确！");
                    } else {
                        SurplusmaterialrecordtailVO.setGrossWeight(StringUtils.isNotBlank(grossWeight) ? new BigDecimal(grossWeight) : null); //
                    }

                    if (!TextUtils.isEmpty(suttle) && !NumberUtil.isNumber(suttle)) {
                        SurplusmaterialrecordtailVO.setErrorMsg("净重不正确！");
                        errorsMsgBuilder.append("净重格式不正确！");
                    } else {
                        SurplusmaterialrecordtailVO.setSuttle(StringUtils.isNotBlank(suttle) ? new BigDecimal(suttle) : null);
                    }
                    if (!TextUtils.isEmpty(unitPrice) && !NumberUtil.isNumber(unitPrice)) {
                        SurplusmaterialrecordtailVO.setErrorMsg("单价格式不正确！");
                        errorsMsgBuilder.append("单价格式不正确！");
                    } else {
                        SurplusmaterialrecordtailVO.setUnitPrice(StringUtils.isNotBlank(unitPrice) ? new BigDecimal(unitPrice) : null); //
                    }
                    if (!TextUtils.isEmpty(money) && !NumberUtil.isNumber(money)) {
                        SurplusmaterialrecordtailVO.setErrorMsg("金额不正确！");
                        errorsMsgBuilder.append("金额格式不正确！");
                    } else {
                        SurplusmaterialrecordtailVO.setMoney(StringUtils.isNotBlank(money) ? new BigDecimal(money) : null);
                    }


                    if(errorsMsgBuilder.length() > 0){
                        errorList.add(SurplusmaterialrecordtailVO);
                    }else {
                        successList.add(SurplusmaterialrecordtailVO);
                    }
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());

        SurplusmaterialrecordtailVO resVo = new SurplusmaterialrecordtailVO();
//        json.put("total", resList);
        json.put("total", resVo);
        return CommonResponse.success(json);
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportSurplusmaterialrecordtailFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportSurplusmaterialrecordtailFromDatabase(@RequestBody SurplusmaterialrecordtailVO SurplusmaterialrecordtailVO, HttpServletResponse response) {
        QueryWrapper<SurplusmaterialrecordtailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", SurplusmaterialrecordtailVO.getId());
        queryWrapper.eq("dr", 0);
        List<SurplusmaterialrecordtailEntity> list = service.list(queryWrapper);
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Surplusmaterialrecordtail-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportSurplusmaterialrecordtailFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportSurplusmaterialrecordtailFromPage(@RequestBody List<SurplusmaterialrecordtailVO> list, HttpServletResponse response) {
        List<SurplusmaterialrecordtailVO> concatList = new ArrayList<>();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                SurplusmaterialrecordtailVO SurplusmaterialrecordtailVO = list.get(i);
                concatList.add(SurplusmaterialrecordtailVO);
            }
        }

        //children拍平
        List<SurplusmaterialrecordtailVO> allList = handleList(list, concatList);

        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", allList);
        ExcelExport.getInstance().export("Surplusmaterialrecordtail-export.xlsx", beans, response);
    }

    /**
     * 导出页面数据处理children
     *
     * @param list
     */
    private List<SurplusmaterialrecordtailVO> handleList(List<SurplusmaterialrecordtailVO> list, List<SurplusmaterialrecordtailVO> concatList) {
        if (list == null || list.size() == 0) {
            return concatList;
        }

        for (int i = 0; i < list.size(); i++) {
            SurplusmaterialrecordtailVO SurplusmaterialrecordtailVO = list.get(i);
            List<SurplusmaterialrecordtailVO> children = SurplusmaterialrecordtailVO.getChildren();
            if (children != null && children.size() > 0) {
                concatList.addAll(children);
                handleList(children, concatList);
            }
        }

        return concatList;
    }
}
