package com.ejianc.business.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.material.bean.*;
import com.ejianc.business.material.service.*;
import com.ejianc.business.material.vo.MaterialWarehousingVO;
import com.ejianc.business.material.vo.MaterialWarehousingdetailVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.material.mapper.MaterialWarehousingMapper;
import org.springframework.transaction.annotation.Transactional;

import java.awt.*;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 物资验收入库单
 *
 * @author generator
 *
 */
@Service("materialWarehousingService")
public class MaterialWarehousingServiceImpl extends BaseServiceImpl<MaterialWarehousingMapper, MaterialWarehousingEntity> implements IMaterialWarehousingService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "WZ_YS";//此处需要根据实际修改
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IMaterialWarehousingService materialWarehousingService;
    @Autowired
    private IMaterialWarehousingdetailService materialWarehousingdetailService;
    @Autowired
    private IFlowmeterService flowmeterService;
    @Autowired
    private IRealtimebalanceService realtimebalanceService;
    @Autowired
    private IDeliveryrecordService deliveryrecordService;
    @Autowired
    private MaterialWarehousingBpmServiceImpl materialWarehousingBpmService;
    @Autowired
    private DeliveryrecordBpmServiceImpl deliveryrecordBpmServiceImpl;
    @Autowired
    private ICheckService checkService;
    @Autowired
    private IMaterialapproachService materialapproachService;

    @Autowired
    private MaterialWarehousingMapper materialWarehousingMapper;

    @Override
    public IPage<MaterialWarehousingdetailVO> queryStoreCanUseNumPageData(String searchText, String searchObject, String outDate, Long storeId, Integer pageNum, Integer pageSize) {
        IPage<MaterialWarehousingdetailVO> page = new Page<>();
        page.setCurrent(pageNum);
        page.setPages(pageSize);
        page.setSize(pageSize);
        String materialTypeName="";
        String materialName="";
        String materialSpec="";
        String materialUnit="";
        if(StringUtils.isNotBlank(searchObject)){
            JSONObject search = JSONObject.parseObject(searchObject);
            if(search.get("materialName")!=null){
                materialName = search.get("materialName").toString();
            }
        }

        Long count = materialWarehousingMapper.queryStoreCanUseNumPageDataCount(searchText, outDate, storeId, materialTypeName,materialName,materialSpec,materialUnit);
        page.setTotal(count);
        List<MaterialWarehousingdetailVO> records =
                materialWarehousingMapper.queryStoreCanUseNumPageData(searchText, outDate, storeId, (pageNum - 1) * pageSize, pageSize, materialTypeName,materialName,materialSpec,materialUnit);
        page.setRecords(records);
        return page;
    }

    @Override
    public IPage<MaterialWarehousingdetailVO> storematerialList(Long storeId, String searchText, Integer pageNumber, Integer pageSize) {
        IPage<MaterialWarehousingdetailVO> page = new Page<>();
        Long count = materialWarehousingMapper.countStorematerialList(storeId, searchText);
        if (count > 0) {
            Integer startLine = null;
            if (pageNumber != null) {
                startLine = ((pageNumber > 0 ? pageNumber : 1) - 1) * pageSize;
                page.setCurrent(pageNumber);
                page.setSize(pageSize);
            }
            List<MaterialWarehousingdetailVO> list = materialWarehousingMapper.storematerialList(storeId, searchText, startLine, pageSize);
            page.setRecords(list);
        }
        page.setTotal(count);
        return page;
    }

    @Override
    public BigDecimal countAmount(QueryParam param) {
        return null;
    }

    @Override
    public MaterialWarehousingVO censusStorematerial(Long storeIid) {
        return null;
    }

    @Override
    public IPage<MaterialWarehousingVO> queryUsableSubMaterialList(String searchText, String outDate, Long storeId, Integer pageNumber, Integer pageSize, List<Long> materialIds, HashMap<String, String> map) {
        return null;
    }

    @Override
    public List<MaterialWarehousingVO> querySubMaterialStoreInfo(Long storeId, Date checkDate, Long materialId, double inventory) {
        return null;
    }

    @Override
    public boolean aggPush(MaterialWarehousingEntity materialWarehousingEntity) {
        logger.info("---------进来啦--------");
        //查询入库单和入库单子表信息

        logger.info("---------进来啦--------");
        //查询入库单和入库单子表信息
        List<MaterialWarehousingdetailEntity> materialWarehousingdetailEntities = materialWarehousingEntity.getMaterialWarehousingdetailEntities();
        List<FlowmeterEntity> list = new ArrayList<>();//出入库流水记录表
        List<RealtimebalanceEntity> realList = new ArrayList<>();//修改实时物资结存
        List<RealtimebalanceEntity> realList1 = new ArrayList<>();//新增实时物资结存
        DeliveryrecordEntity deliveryrecordEntity = new DeliveryrecordEntity();//出库单主表
        List<DeliveryrecorddetailEntity> detailList = new ArrayList<>();//出库单子表
        BigDecimal bigDecimal = new BigDecimal(0.00);//入库时汇总出库数量
        BigDecimal bigDecimal1 = new BigDecimal(0.00);//当直入直出时汇总出库数量
        //判断如果是直入直出的情况需要直接生成出库单
        if(materialWarehousingEntity.getWarehousingType() == 0 && materialWarehousingEntity.getAcceptanceType() != null && materialWarehousingEntity.getAcceptanceType().equals("直入直出")){
            deliveryrecordEntity.setProjectId(materialWarehousingEntity.getProjectId());
            deliveryrecordEntity.setProjectName(materialWarehousingEntity.getProjectName());
            deliveryrecordEntity.setStoreId(materialWarehousingEntity.getStoreId());
            deliveryrecordEntity.setStoreName(materialWarehousingEntity.getStoreName());
            deliveryrecordEntity.setProjectDepartmentId(materialWarehousingEntity.getProjectDepartmentId());
            deliveryrecordEntity.setProjectdeptId(materialWarehousingEntity.getAgentId());
            deliveryrecordEntity.setProjectdept(materialWarehousingEntity.getAgentName());
            deliveryrecordEntity.setBillsTime(materialWarehousingEntity.getBillsTime());
            deliveryrecordEntity.setBrands(materialWarehousingEntity.getBrands());
            deliveryrecordEntity.setPickingTime(materialWarehousingEntity.getPuinTime());
            deliveryrecordEntity.setPickingunitId(materialWarehousingEntity.getSubContractId());
            deliveryrecordEntity.setPickingUnit(materialWarehousingEntity.getSubContract());
            deliveryrecordEntity.setReceivingPurpose("项目使用");
            deliveryrecordEntity.setOrgId(materialWarehousingEntity.getOrgId());
            deliveryrecordEntity.setOrgName(materialWarehousingEntity.getOrgName());
            deliveryrecordEntity.setDeliveryType(0);
            deliveryrecordEntity.setDeliveryTypes(0);
            deliveryrecordEntity.setWarehousingId(materialWarehousingEntity.getId());
            deliveryrecordEntity.setBillState(3);
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                //  entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                deliveryrecordEntity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        if(materialWarehousingEntity.getWarehousingType() == 0 && materialWarehousingdetailEntities != null && materialWarehousingdetailEntities.size() > 0){
            logger.info("---------不为空--------");
            //循环子表
            for(MaterialWarehousingdetailEntity entity : materialWarehousingEntity.getMaterialWarehousingdetailEntities()){
                if(materialWarehousingEntity.getWarehousingType() == 0){
                    logger.info("入库子表进来了!");
                    bigDecimal = bigDecimal.add(entity.getQuantity());
                    entity.setNotReturnedQuantity(entity.getQuantity());
                    materialWarehousingdetailService.updateById(entity);
                    logger.info("入库子表修改啦!");
                }
                //出库子表
                DeliveryrecorddetailEntity deliveryrecorddetailEntity = new DeliveryrecorddetailEntity();
                if(materialWarehousingEntity.getWarehousingType() == 0 && materialWarehousingEntity.getAcceptanceType() != null && materialWarehousingEntity.getAcceptanceType().equals("直入直出")){//直入直出时才生成子表信息
                    deliveryrecorddetailEntity.setMaterialCategoryId(entity.getMaterialCategoryId());
                    deliveryrecorddetailEntity.setMaterialCategoryCode(entity.getMaterialCategoryCode());
                    deliveryrecorddetailEntity.setMaterialCategoryName(entity.getMaterialCategoryName());
                    deliveryrecorddetailEntity.setMaterialId(entity.getMaterialId());
                    deliveryrecorddetailEntity.setMaterialCode(entity.getMaterialCode());
                    deliveryrecorddetailEntity.setMaterialName(entity.getMaterialName());
                    deliveryrecorddetailEntity.setDeliveryQuantity(entity.getQuantity());
                    deliveryrecorddetailEntity.setSpecialModel(entity.getSpecialModel());
                    deliveryrecorddetailEntity.setMeasurementUnit(entity.getUnit());
                    deliveryrecorddetailEntity.setProjectId(entity.getProjectId());
                    deliveryrecorddetailEntity.setProjectName(entity.getProjectName());
                    deliveryrecorddetailEntity.setStoreId(entity.getStoreId());
                    deliveryrecorddetailEntity.setStoreName(entity.getStoreName());
                    deliveryrecorddetailEntity.setOrgId(entity.getOrgId());
                    deliveryrecorddetailEntity.setOrgName(entity.getOrgName());
                    deliveryrecorddetailEntity.setPickingTime(deliveryrecordEntity.getPickingTime());
                    deliveryrecorddetailEntity.setProjectName(entity.getProjectName());
                    deliveryrecorddetailEntity.setTenantId(entity.getTenantId());
                    deliveryrecorddetailEntity.setOrgId(entity.getOrgId());
                    deliveryrecorddetailEntity.setUnitId(deliveryrecordEntity.getPickingunitId());
                    deliveryrecorddetailEntity.setUnitName(deliveryrecordEntity.getPickingUnit());
                    deliveryrecorddetailEntity.setProjectDepartmentId(entity.getProjectDepartmentId());
                    deliveryrecorddetailEntity.setNotReturnedQuantity(deliveryrecorddetailEntity.getDeliveryQuantity());//直入直出时未退库数量=出库数量
                    bigDecimal1 = bigDecimal1.add(deliveryrecorddetailEntity.getDeliveryQuantity());//未出库数量总数
                }

                //出入库流水表 只有入库审批通过推流水
                if(materialWarehousingEntity.getWarehousingType() == 0){
                    FlowmeterEntity flowmeterEntity = materialWarehousingBpmService.createrFlowmeter(materialWarehousingEntity, entity);
                    list.add(flowmeterEntity);
                }

                //实时物资结存表
                QueryWrapper<RealtimebalanceEntity> queryWrapper1 = new QueryWrapper<>();
                queryWrapper1.eq("project_id",materialWarehousingEntity.getProjectId());
                queryWrapper1.eq("material_code",entity.getMaterialCode());
                queryWrapper1.eq("material_category_code",entity.getMaterialCategoryCode());
                queryWrapper1.eq("store_id",materialWarehousingEntity.getStoreId());
                RealtimebalanceEntity realtimebalanceEntity = realtimebalanceService.getOne(queryWrapper1);
                if(realtimebalanceEntity != null){
                    realtimebalanceEntity.setQuantity(realtimebalanceEntity.getQuantity().add(entity.getQuantity()));
                    realtimebalanceEntity.setAmountIncluetax(realtimebalanceEntity.getAmountIncluetax().add(entity.getAmountIncluetax()));
                    realtimebalanceEntity.setAmountExcluetax(realtimebalanceEntity.getAmountExcluetax().add(entity.getAmountExcluetax()));
                    if(realtimebalanceEntity.getQuantity().compareTo(BigDecimal.ZERO) != 0){
                        realtimebalanceEntity.setUnitPriceIncluetax(realtimebalanceEntity.getAmountIncluetax().divide(realtimebalanceEntity.getQuantity(),8,BigDecimal.ROUND_HALF_UP));
                        realtimebalanceEntity.setUnitPriceExcluetax(realtimebalanceEntity.getAmountExcluetax().divide(realtimebalanceEntity.getQuantity(),8,BigDecimal.ROUND_HALF_UP));
                    }else{
                        realtimebalanceEntity.setUnitPriceIncluetax(new BigDecimal(0.00));
                        realtimebalanceEntity.setUnitPriceExcluetax(new BigDecimal(0.00));
                    }
                    realList.add(realtimebalanceEntity);
                    //直入直出
                    if(materialWarehousingEntity.getWarehousingType() == 0 && materialWarehousingEntity.getAcceptanceType() != null && materialWarehousingEntity.getAcceptanceType().equals("直入直出")){
                        deliveryrecorddetailEntity.setUnitPriceIncluetax(realtimebalanceEntity.getUnitPriceIncluetax());
                        deliveryrecorddetailEntity.setUnitPriceExcluetax(realtimebalanceEntity.getUnitPriceExcluetax());
                        deliveryrecorddetailEntity.setAmountIncluetax(deliveryrecorddetailEntity.getDeliveryQuantity().multiply(deliveryrecorddetailEntity.getUnitPriceIncluetax()));
                        deliveryrecorddetailEntity.setAmountExcluetax(deliveryrecorddetailEntity.getDeliveryQuantity().multiply(deliveryrecorddetailEntity.getUnitPriceExcluetax()));
                    }
                }else{
                    RealtimebalanceEntity realtimebalanceEntity1 = new RealtimebalanceEntity();
                    realtimebalanceEntity1.setProjectId(materialWarehousingEntity.getProjectId());
                    realtimebalanceEntity1.setProjectName(materialWarehousingEntity.getProjectName());
                    realtimebalanceEntity1.setMaterialId(entity.getMaterialId());
                    realtimebalanceEntity1.setMaterialCode(entity.getMaterialCode());
                    realtimebalanceEntity1.setMaterialName(entity.getMaterialName());
                    realtimebalanceEntity1.setMaterialCategoryId(entity.getMaterialCategoryId());
                    realtimebalanceEntity1.setMaterialCategoryCode(entity.getMaterialCategoryCode());
                    realtimebalanceEntity1.setMaterialCategoryName(entity.getMaterialCategoryName());
                    realtimebalanceEntity1.setStoreId(materialWarehousingEntity.getStoreId());
                    realtimebalanceEntity1.setStoreName(materialWarehousingEntity.getStoreName());
                    realtimebalanceEntity1.setQuantity(entity.getQuantity());
                    realtimebalanceEntity1.setUnitPriceIncluetax(entity.getUnitPriceIncluetax());
                    realtimebalanceEntity1.setUnitPriceExcluetax(entity.getUnitPriceExcluetax());
                    realtimebalanceEntity1.setAmountIncluetax(entity.getAmountIncluetax());
                    realtimebalanceEntity1.setAmountExcluetax(entity.getAmountExcluetax());
                    realtimebalanceEntity1.setOrgId(materialWarehousingEntity.getOrgId());
                    realtimebalanceEntity1.setOrgName(materialWarehousingEntity.getOrgName());
                    realtimebalanceEntity1.setMeasurementUnit(entity.getUnit());
                    realtimebalanceEntity1.setSpecialModel(entity.getSpecialModel());
                    realtimebalanceEntity1.setProjectDepartmentId(materialWarehousingEntity.getProjectDepartmentId());
                    realList1.add(realtimebalanceEntity1);
                    if(materialWarehousingEntity.getWarehousingType() == 0 && materialWarehousingEntity.getAcceptanceType() != null && materialWarehousingEntity.getAcceptanceType().equals("直入直出")){//直入直出
                        deliveryrecorddetailEntity.setUnitPriceIncluetax(entity.getUnitPriceIncluetax());
                        deliveryrecorddetailEntity.setUnitPriceExcluetax(entity.getUnitPriceExcluetax());
                        deliveryrecorddetailEntity.setAmountIncluetax(entity.getAmountIncluetax());
                        deliveryrecorddetailEntity.setAmountExcluetax(entity.getAmountExcluetax());
                    }
                }
                if(materialWarehousingEntity.getWarehousingType() == 0 && materialWarehousingEntity.getAcceptanceType() != null && materialWarehousingEntity.getAcceptanceType().equals("直入直出")){//直入直出
                    detailList.add(deliveryrecorddetailEntity);
                }
            }
            if(list.size() > 0){
                flowmeterService.saveBatch(list,list.size());//保存出入库流水表 只有入库得时候 审批通过入
                realtimebalanceService.updateRealtimeBalance(materialWarehousingEntity.getStoreId());
            }

            if(materialWarehousingEntity.getWarehousingType() == 1){
                flowmeterService.updateFlow(materialWarehousingEntity.getId(),new Date(),1);
            }

			/*if(realList.size() > 0){
				realtimebalanceService.updateBatchById(realList,realList.size());//修改实时物资结存
			}
			if(realList1.size() > 0){
				realtimebalanceService.saveBatch(realList1,realList1.size());//保存实时物资结存
			}*/
            if(materialWarehousingEntity.getWarehousingType() == 0 ){
                logger.info("入库主表进来啦！");
                materialWarehousingEntity.setNotReturnedQuantity(bigDecimal);
                materialWarehousingService.updateById(materialWarehousingEntity);
                logger.info("入库主表修改啦！");
            }
            deliveryrecordEntity.setDeliveryrecorddetailEntities(detailList);
            //直入直出生成出库单,并且生成出库流水记录和修改实时物资结存
            if(materialWarehousingEntity.getWarehousingType() == 0 && materialWarehousingEntity.getAcceptanceType() != null && materialWarehousingEntity.getAcceptanceType().equals("直入直出")){
                deliveryrecordEntity.setNotDeliveryQuantity(bigDecimal1);
                boolean success = deliveryrecordService.saveOrUpdate(deliveryrecordEntity,false);
                //直入直出修改主表未退库数量
//				materialWarehousingEntity.setNotReturnedQuantity(bigDecimal);
//				materialWarehousingService.updateById(materialWarehousingEntity);
                if(success == true){
                    List<FlowmeterEntity> list1 = new ArrayList<>();//出入库流水记录表
                    List<RealtimebalanceEntity> realList2 = new ArrayList<>();//修改实时物资结存
                    List<DeliveryrecorddetailEntity> deliveryrecorddetailEntity = deliveryrecordEntity.getDeliveryrecorddetailEntities();
                    if(deliveryrecorddetailEntity.size() > 0 && deliveryrecorddetailEntity != null){
                        for(DeliveryrecorddetailEntity entity : deliveryrecorddetailEntity){
                            //实时物资结存
                            QueryWrapper<RealtimebalanceEntity> queryWrapper = new QueryWrapper<>();
                            queryWrapper.eq("project_id",deliveryrecordEntity.getProjectId());
                            queryWrapper.eq("material_code",entity.getMaterialCode());
                            queryWrapper.eq("material_category_code",entity.getMaterialCategoryCode());
                            queryWrapper.eq("store_id",deliveryrecordEntity.getStoreId());
                            RealtimebalanceEntity realtimebalanceEntity1 = realtimebalanceService.getOne(queryWrapper);
                            if(realtimebalanceEntity1 != null){
                                if(realtimebalanceEntity1.getQuantity().compareTo(BigDecimal.ZERO) == 0 || realtimebalanceEntity1.getQuantity().compareTo(entity.getDeliveryQuantity()) < 0){
                                    throw new BusinessException("物资编号:" + entity.getMaterialCode() + ",物资名称:" + entity.getMaterialName() + "库存不足，不能出库!");
                                }else{
                                    FlowmeterEntity flowmeterEntity = deliveryrecordBpmServiceImpl.createrFlowmeter(deliveryrecordEntity,entity,1,new Date());
                                    //出入库流水表
                                    list1.add(flowmeterEntity);
                                    realtimebalanceEntity1.setQuantity(realtimebalanceEntity1.getQuantity().subtract(entity.getDeliveryQuantity()));
                                    realtimebalanceEntity1.setAmountIncluetax(realtimebalanceEntity1.getAmountIncluetax().subtract(entity.getAmountIncluetax()));
                                    realtimebalanceEntity1.setAmountExcluetax(realtimebalanceEntity1.getAmountExcluetax().subtract(entity.getAmountExcluetax()));
                                    if(realtimebalanceEntity1.getQuantity().compareTo(BigDecimal.ZERO) != 0){
                                        realtimebalanceEntity1.setUnitPriceIncluetax(realtimebalanceEntity1.getAmountIncluetax().divide(realtimebalanceEntity1.getQuantity(),8,BigDecimal.ROUND_HALF_UP));
                                        realtimebalanceEntity1.setUnitPriceExcluetax(realtimebalanceEntity1.getAmountExcluetax().divide(realtimebalanceEntity1.getQuantity(),8,BigDecimal.ROUND_HALF_UP));
                                    }else{
                                        realtimebalanceEntity1.setUnitPriceIncluetax(new BigDecimal(0.00));
                                        realtimebalanceEntity1.setUnitPriceExcluetax(new BigDecimal(0.00));
                                    }
                                    realList2.add(realtimebalanceEntity1);
                                }
                            }else{
                                throw new BusinessException("该物资编号:" + entity.getMaterialCode() + ",物资名称:" + entity.getMaterialName() + "没有库存，无法出库!" );
                            }
                        }
                    }
                    if(list1.size() > 0){
                        logger.info("出库记录--------出入库流水表保存");
                        flowmeterService.saveBatch(list1,list1.size());
                        realtimebalanceService.updateRealtimeBalance(materialWarehousingEntity.getStoreId());
                    }
					/*if(realList2.size() > 0){
						realtimebalanceService.updateBatchById(realList2,realList2.size());//修改实时物资结存表
					}*/
                }

            }
        }


        if(materialWarehousingEntity.getWarehousingType() == 1){
            flowmeterService.updateFlow(materialWarehousingEntity.getId(),new Date(),1);
        }
        return true;
    }

    @Override
    @Transactional
    public MaterialWarehousingVO saveOrUpdate(MaterialWarehousingVO saveorUpdateVO) {

        //检验数量不能大于计划量
//        if (saveorUpdateVO.getWarehousingType() == 0 && saveorUpdateVO.getSubContractId() != null){
//            List<MaterialWarehousingdetailVO> materialWarehousingdetailEntities = saveorUpdateVO.getMaterialWarehousingdetailEntities();
//
//            if (CollectionUtils.isNotEmpty(materialWarehousingdetailEntities)){
//                for (MaterialWarehousingdetailVO materialWarehousingdetailVO : materialWarehousingdetailEntities){
//                    if (ComputeUtil.isGreaterThan(materialWarehousingdetailVO.getQuantity(),materialWarehousingdetailVO.getPlanSurplusNum())){
//                        String  s = "["+materialWarehousingdetailVO.getMaterialCode()+"]" + "[" + materialWarehousingdetailVO.getMaterialName() +"]:入库量超可领料计划量,不能保存!";
//                        throw new BusinessException(s);
//                    }
//                }
//            }
//
//        }



        MaterialWarehousingEntity entity = BeanMapper.map(saveorUpdateVO, MaterialWarehousingEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        int flag = 0;
        List<MaterialWarehousingdetailEntity> materialWarehousingdetailEntity = entity.getMaterialWarehousingdetailEntities();
        if(entity.getWarehousingType() == 1){
            for(MaterialWarehousingdetailEntity materialWarehousingdetailEntity1 : materialWarehousingdetailEntity){
                if( materialWarehousingdetailEntity1.getQuantity().compareTo(new BigDecimal("0")) == 0 ||  materialWarehousingdetailEntity1.getQuantity().compareTo(new BigDecimal("0")) > 0 ){
//                    flag = 1;
                    throw new BusinessException("材料编码:"+materialWarehousingdetailEntity1.getMaterialCode()+"数量不能大于等于0,请您修改后重试！");
                }
            }
        }
//        if(flag == 1){
//            throw new BusinessException("明细数量大于等于零，不允许保存！");
//        }

        //保存检验 例子: 如果有5月份的盘点表(包括自由态), 那么做入库单时就只能录入5月份之后的数据, 之前的月份不能再录入入库单
        if(entity.getWarehousingType() == 0){
            String puinTime = new SimpleDateFormat("yyyy-MM").format(entity.getPuinTime());
            LambdaQueryWrapper<CheckEntity> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(CheckEntity::getProjectId, entity.getProjectId());
            queryWrapper.eq(CheckEntity::getStoreId, entity.getStoreId());
            queryWrapper.apply("DATE_FORMAT(check_month, '%Y-%m') >= '" + puinTime + "'");
            List<CheckEntity> checkEntities = checkService.list(queryWrapper);
            if(CollectionUtils.isNotEmpty(checkEntities)){
                throw new BusinessException("所选入库日期当期或之后已经生成领用物资剩余数量盘点表,不能新增!");
            }
        }

        //保存校验 不能超进场数量 保存就占用
        //查询所有状态的进场验收数量,编辑保存时去掉本身
        if (entity.getWarehousingType() == 0){
            if (CollectionUtils.isNotEmpty(materialWarehousingdetailEntity)) {
                List<Long> approachDetailIds = materialWarehousingdetailEntity.stream().map(MaterialWarehousingdetailEntity::getApproachDetailId).collect(Collectors.toList());
                LambdaQueryWrapper<MaterialWarehousingdetailEntity> lambdaWareDetail = Wrappers.<MaterialWarehousingdetailEntity>lambdaQuery();
                lambdaWareDetail.in(MaterialWarehousingdetailEntity::getApproachDetailId,approachDetailIds);
                if (entity.getId() != null){
                    lambdaWareDetail.ne(MaterialWarehousingdetailEntity::getMid,entity.getId());
                }
                List<MaterialWarehousingdetailEntity> warehousingdetailEntityList = materialWarehousingdetailService.list(lambdaWareDetail);
                Map<Long, BigDecimal> numMap = new HashMap<>();
                if (CollectionUtils.isNotEmpty(warehousingdetailEntityList)){
                    numMap = warehousingdetailEntityList.stream().filter(s->s.getQuantity().compareTo(BigDecimal.ZERO) == 1).collect(Collectors.groupingBy(MaterialWarehousingdetailEntity::getApproachDetailId,
                            Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getQuantity()).reduce(BigDecimal.ZERO, BigDecimal::add))));
                }

                for (MaterialWarehousingdetailEntity materialWareEntity : materialWarehousingdetailEntity){
                    BigDecimal num = BigDecimal.ZERO;
                    if (numMap.containsKey(materialWareEntity.getApproachDetailId())){
                        num = numMap.get(materialWareEntity.getApproachDetailId());
                    }
                    BigDecimal allZy = materialWareEntity.getQuantity().add(num);
                    if(allZy.compareTo(materialWareEntity.getEnterCount()) ==1){
                        throw new BusinessException("物资编号:" + materialWareEntity.getMaterialCode() + ",物资名称:" + materialWareEntity.getMaterialName() + "超过剩余可进场数量,不能保存!");
                    }
                }
            }
        }



        for (MaterialWarehousingdetailEntity item : materialWarehousingdetailEntity) {
            if("del".equals(item.getRowState())){
                continue;
            }
            if(entity.getWarehousingType() == 1){//退库

                //校验是否超出剩余库存
                //通过流水校验
                //汇总数据
                List<Long> materialIds = entity.getMaterialWarehousingdetailEntities().stream().map(MaterialWarehousingdetailEntity::getMaterialId).collect(Collectors.toList());
                LambdaQueryWrapper<FlowmeterEntity> lambdaFlow = Wrappers.<FlowmeterEntity>lambdaQuery();
                lambdaFlow.eq(FlowmeterEntity::getStoreId, entity.getStoreId());
                lambdaFlow.in(FlowmeterEntity::getMaterialId, materialIds);
                if (saveorUpdateVO.getId() != null) {
                    lambdaFlow.ne(FlowmeterEntity::getMid, saveorUpdateVO.getId());
                }
                List<FlowmeterEntity> flowmeterEntityList = flowmeterService.list(lambdaFlow);
                Map<Long, BigDecimal> numInMap = flowmeterEntityList.stream().filter(s -> s.getOperationType().equals("入库")).collect(Collectors.groupingBy(FlowmeterEntity::getMaterialId,
                        Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getQuantity()).reduce(BigDecimal.ZERO, BigDecimal::add))));
                Map<Long, BigDecimal> numOutMap = flowmeterEntityList.stream().filter(s -> s.getOperationType().equals("出库")).collect(Collectors.groupingBy(FlowmeterEntity::getMaterialId,
                        Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getQuantity()).reduce(BigDecimal.ZERO, BigDecimal::add))));
                BigDecimal inNum = BigDecimal.ZERO;
                BigDecimal outNum = BigDecimal.ZERO;
                for (MaterialWarehousingdetailEntity materialWarehousingdetailEntity1 : entity.getMaterialWarehousingdetailEntities()){
                    inNum = BigDecimal.ZERO;
                    outNum = BigDecimal.ZERO;
                    if (numInMap.containsKey(materialWarehousingdetailEntity1.getMaterialId())){
                        inNum = numInMap.get(materialWarehousingdetailEntity1.getMaterialId());
                    }
                    if (numOutMap.containsKey(materialWarehousingdetailEntity1.getMaterialId())){
                        outNum = numOutMap.get(materialWarehousingdetailEntity1.getMaterialId());
                    }
                    BigDecimal subtract = inNum.subtract(outNum);
                    BigDecimal qaty = new BigDecimal("-1");
                    if ((materialWarehousingdetailEntity1.getQuantity()).multiply(qaty).compareTo(subtract) == 1){
                        throw new BusinessException("物资编号:" + materialWarehousingdetailEntity1.getMaterialCode() + ",物资名称:" + materialWarehousingdetailEntity1.getMaterialName() + "库存不足，不能退供应商!");
                    }
                }
            }
            //方便报表查询
            item.setProjectId(entity.getProjectId());
            item.setStoreId(entity.getStoreId());
            item.setPuinTime(entity.getPuinTime());
            item.setProjectName(entity.getProjectName());
            item.setSupplierName(entity.getSupplierName());
            item.setTenantId(entity.getTenantId());
            item.setOrgId(entity.getOrgId());
            item.setProjectDepartmentId(entity.getProjectDepartmentId());
        }
        super.saveOrUpdate(entity, false);
        //退库
        if(entity.getWarehousingType() == 1){
            //先删后增
            LambdaQueryWrapper<FlowmeterEntity> lambdaFlower = Wrappers.<FlowmeterEntity>lambdaQuery();
            lambdaFlower.eq(FlowmeterEntity::getMid,entity.getId());
            flowmeterService.remove(lambdaFlower);

            MaterialWarehousingEntity materialWarehousingEntity = entity;
            List<MaterialWarehousingdetailEntity> materialWarehousingdetailEntities = entity.getMaterialWarehousingdetailEntities();
            List<FlowmeterEntity> list = new ArrayList<>();//出入库流水记录表
            List<RealtimebalanceEntity> realList = new ArrayList<>();//修改实时物资结存
            BigDecimal bigDecimal = new BigDecimal(0.00);//当退供应商时汇总出库数量
            if(materialWarehousingdetailEntities != null && materialWarehousingdetailEntities.size() > 0){
                logger.info("---------不为空--------");
                for(MaterialWarehousingdetailEntity detailEntity : materialWarehousingdetailEntities){
                    if(materialWarehousingEntity.getWarehousingType() == 1){//退库
                        bigDecimal = bigDecimal.add(detailEntity.getQuantity());
                        MaterialWarehousingdetailEntity byId = materialWarehousingdetailService.getById(detailEntity.getWarehouseingDetailId());//退供应商时选中的出库单子表数据
                        byId.setNotReturnedQuantity(byId.getNotReturnedQuantity().subtract(detailEntity.getQuantity().multiply(new BigDecimal(-1.00))));
                        materialWarehousingdetailService.updateById(byId);
                        logger.info("提交退供应商子表修改啦!");
                        //实时物资结存表
                        QueryWrapper<RealtimebalanceEntity> queryWrapper1 = new QueryWrapper<>();
                        queryWrapper1.eq("project_id",materialWarehousingEntity.getProjectId());
                        queryWrapper1.eq("material_code",detailEntity.getMaterialCode());
                        queryWrapper1.eq("material_category_code",detailEntity.getMaterialCategoryCode());
                        queryWrapper1.eq("store_id",materialWarehousingEntity.getStoreId());
                        RealtimebalanceEntity realtimebalanceEntity = realtimebalanceService.getOne(queryWrapper1);
                        //出入库流水
                        FlowmeterEntity flowmeterEntity = materialWarehousingBpmService.createrFlowmeter(materialWarehousingEntity, detailEntity);
                        list.add(flowmeterEntity);

                        realtimebalanceEntity.setQuantity(realtimebalanceEntity.getQuantity().add(detailEntity.getQuantity()));
                        realtimebalanceEntity.setAmountIncluetax(realtimebalanceEntity.getAmountIncluetax().add(detailEntity.getAmountIncluetax()));
                        realtimebalanceEntity.setAmountExcluetax(realtimebalanceEntity.getAmountExcluetax().add(detailEntity.getAmountExcluetax()));
                        if(realtimebalanceEntity.getQuantity().compareTo(BigDecimal.ZERO) != 0){
                            realtimebalanceEntity.setUnitPriceIncluetax(realtimebalanceEntity.getAmountIncluetax().divide(realtimebalanceEntity.getQuantity(),8,BigDecimal.ROUND_HALF_UP));
                            realtimebalanceEntity.setUnitPriceExcluetax(realtimebalanceEntity.getAmountExcluetax().divide(realtimebalanceEntity.getQuantity(),8,BigDecimal.ROUND_HALF_UP));
                        }else{
                            realtimebalanceEntity.setUnitPriceIncluetax(new BigDecimal(0.00));
                            realtimebalanceEntity.setUnitPriceExcluetax(new BigDecimal(0.00));
                        }
                        realList.add(realtimebalanceEntity);
                    }/*else {//入库
                    logger.info("入库提交回写验证单进来啦");
                    //根据入库单主表中的进场单id和入库单子表中的材料编码 查询进场单子表信息
                    QueryWrapper<MaterialapproachdetailEntity> queryWrapper = new QueryWrapper<>();
                    queryWrapper.eq("mid", materialWarehousingEntity.getMaterialapproachId());
                    queryWrapper.eq("material_code", detailEntity.getMaterialCode());
                    List<MaterialapproachdetailEntity> materialapproachdetailEntities = materialapproachdetailService.list(queryWrapper);
                    if (materialapproachdetailEntities != null && materialapproachdetailEntities.size() > 0) {
                        MaterialapproachdetailEntity materialapproachdetailEntity = materialapproachdetailEntities.get(0);
                        //未入库数量 = 进场单子表中的未入库数量-入库单子表数量
                        BigDecimal notStorageNum = materialapproachdetailEntity.getNotStorageNum();
                        BigDecimal quantity = detailEntity.getQuantity();
                        if (notStorageNum != null && quantity != null) {
                            BigDecimal notStorageNumRes = notStorageNum.subtract(quantity);
                            materialapproachdetailEntity.setNotStorageNum(notStorageNumRes);
                            materialapproachdetailService.updateById(materialapproachdetailEntity);
                            MaterialapproachEntity materialapproachEntity = materialapproachService.getById(materialWarehousingEntity.getMaterialapproachId());
                            materialapproachEntity.setNotStorageNum(materialapproachEntity.getNotStorageNum().subtract(quantity));
                            materialapproachService.updateById(materialapproachEntity);
                            logger.info("入库提交回写验证单修改啦");
                        }
                    }
                }*/
                }
                if(list.size() > 0){
                    flowmeterService.saveBatch(list,list.size());//保存出入库流水表
                    realtimebalanceService.updateRealtimeBalance(entity.getStoreId());
                }
            /*if(realList.size() > 0){
                realtimebalanceService.updateBatchById(realList,realList.size());//修改实时物资结存
            }*/
               /* if(materialWarehousingEntity.getWarehousingType() == 1) {//退库
                    MaterialWarehousingEntity byId = materialWarehousingService.getById(materialWarehousingEntity.getWarehouseingId());//入库单信息
                    byId.setNotReturnedQuantity(byId.getNotReturnedQuantity().subtract(bigDecimal.multiply(new BigDecimal(-1.00))));
                    materialWarehousingService.updateById(byId);
                    logger.info("提交退供应商主表修改啦!");
                }*/
            }

        }
        //this.aggPush(entity);
        MaterialWarehousingVO vo = BeanMapper.map(entity, MaterialWarehousingVO.class);

        if(entity.getWarehousingType() == 0){
            MaterialapproachEntity materialapproachEntity = materialapproachService.selectById(entity.getMaterialapproachId());
            materialapproachEntity.setUseFlag(1);
            materialapproachService.updateById(materialapproachEntity);
        }

        return vo;
    }



}
