package com.ejianc.business.material.vo;

import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;


/**
 * 物资验收入库单子表
 *
 * @author generator
 *
 */
public class MaterialWarehousingReportVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String billCode; // 单据编号
    private Long materialwarehousingId; // 入库单id
    private String materialCode; // 材料编码
    private String materialName; // 物资名称
    private String specialModel; // 规格型号
    private BigDecimal quantity; // 数量
    private BigDecimal amountIncluetax; // 金额（含税）
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private String supplierName; // 供应商名称
    private String orgName; // 组织名称

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getMaterialwarehousingId() {
        return materialwarehousingId;
    }

    public void setMaterialwarehousingId(Long materialwarehousingId) {
        this.materialwarehousingId = materialwarehousingId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public BigDecimal getCanUseNumber() {
        return canUseNumber;
    }

    public void setCanUseNumber(BigDecimal canUseNumber) {
        this.canUseNumber = canUseNumber;
    }

    /**
     * 库存可用数量(用于实时计算，不存数据库)
     */
    private BigDecimal canUseNumber;

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }



    /**
     * 材料编码
     */
    public String getMaterialCode() {
        return materialCode;
    }

    /**
     * 材料编码
     */
    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    /**
     * 物资名称
     */
    public String getMaterialName() {
        return materialName;
    }

    /**
     * 物资名称
     */
    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    /**
     * 规格型号
     */
    public String getSpecialModel() {
        return specialModel;
    }

    /**
     * 规格型号
     */
    public void setSpecialModel(String specialModel) {
        this.specialModel = specialModel;
    }

    /**
     * 数量
     */
    public BigDecimal getQuantity() {
        return quantity;
    }

    /**
     * 数量
     */
    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    /**
     * 金额（含税）
     */
    public BigDecimal getAmountIncluetax() {
        return amountIncluetax;
    }

    /**
     * 金额（含税）
     */
    public void setAmountIncluetax(BigDecimal amountIncluetax) {
        this.amountIncluetax = amountIncluetax;
    }


    /**
     * 项目id
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目id
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
}
