package com.ejianc.business.material.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.material.vo.TenderDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 废旧物资处置招标结果记录
 * 
 * @author generator
 * 
 */
public class TenderVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private String projectCode; // 项目编码
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private Long projectDepartmentId; // 项目部id
    private String projectDepartmentName; // 项目部name
    private Long approveId; // 处置审批表id
    private String approveName; // 处置审批表name
    private String remarks; // 说明
    private Long agentId; // 经办人
    private String agentName; // 经办人姓名
    private Long deptId; // 经办部门id
    private String deptName; // 经办部门名称
    private Long contractId; // 集采合同id
    private String contractName; // 集采合同name
    private Integer purchaseFlag; // 是否选用集采 0-否,1-是
    private Integer talkFlag; // 是否为议价 0-否,1-是
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date tenderDate; // 招标日期
    private Long supplierId; // 供应商id
    private String supplierName; // 供应商name
    private Long materialId; // 物资id
    private String materialName; // 物资名称
    private String materialCode; // 物资code
    private Long materialCategoryId; // 物资分类id
    private String materialCategoryName; // 物资分类名称
    private String materialCategoryCode; // 物资分类code
    private String materialSpec; // 规格型号
    private String materialUnit; // 单位
    private BigDecimal temporaryNum; // 暂估处置数量
    private BigDecimal temporaryPrice; // 暂估处置单价
    private BigDecimal temporaryMny; // 暂估处置金额
    private BigDecimal dealNum; // 处置金额
    private BigDecimal dealPrice; // 中标单价
    private BigDecimal dealMny; // 处置金额
    private Long approveDetailId; // 审批子表id
    private String tenderSupplierName; // 中标供应商


    private List<TenderDetailVO> tenderDetailList = new ArrayList<>(); // 废旧物资处置招标结果记录-子表

    public String getTenderSupplierName() {
        return tenderSupplierName;
    }

    public void setTenderSupplierName(String tenderSupplierName) {
        this.tenderSupplierName = tenderSupplierName;
    }

    public Long getApproveDetailId() {
        return approveDetailId;
    }

    public void setApproveDetailId(Long approveDetailId) {
        this.approveDetailId = approveDetailId;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode = "ejc-zjkj-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }


    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    public String getProjectDepartmentName() {
        return projectDepartmentName;
    }

    public void setProjectDepartmentName(String projectDepartmentName) {
        this.projectDepartmentName = projectDepartmentName;
    }
    @ReferSerialTransfer(referCode="SurplusmaterialapproveRef")
    public Long getApproveId() {
        return approveId;
    }
    @ReferDeserialTransfer
    public void setApproveId(Long approveId) {
        this.approveId = approveId;
    }
    public String getApproveName() {
        return approveName;
    }

    public void setApproveName(String approveName) {
        this.approveName = approveName;
    }
    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @ReferSerialTransfer(referCode = "idm-user")
    public Long getAgentId() {
        return agentId;
    }
    @ReferDeserialTransfer
    public void setAgentId(Long agentId) {
        this.agentId = agentId;
    }
    public String getAgentName() {
        return agentName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }
    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    /**
     * 合同id
     */
    @ReferSerialTransfer(referCode = "ejc-zjkj-outcontract")
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同id
     */
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Integer getPurchaseFlag() {
        return purchaseFlag;
    }

    public void setPurchaseFlag(Integer purchaseFlag) {
        this.purchaseFlag = purchaseFlag;
    }
    public Integer getTalkFlag() {
        return talkFlag;
    }

    public void setTalkFlag(Integer talkFlag) {
        this.talkFlag = talkFlag;
    }
    public Date getTenderDate() {
        return tenderDate;
    }

    public void setTenderDate(Date tenderDate) {
        this.tenderDate = tenderDate;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    public Long getMaterialCategoryId() {
        return materialCategoryId;
    }

    public void setMaterialCategoryId(Long materialCategoryId) {
        this.materialCategoryId = materialCategoryId;
    }
    public String getMaterialCategoryName() {
        return materialCategoryName;
    }

    public void setMaterialCategoryName(String materialCategoryName) {
        this.materialCategoryName = materialCategoryName;
    }
    public String getMaterialCategoryCode() {
        return materialCategoryCode;
    }

    public void setMaterialCategoryCode(String materialCategoryCode) {
        this.materialCategoryCode = materialCategoryCode;
    }
    public String getMaterialSpec() {
        return materialSpec;
    }

    public void setMaterialSpec(String materialSpec) {
        this.materialSpec = materialSpec;
    }
    public String getMaterialUnit() {
        return materialUnit;
    }

    public void setMaterialUnit(String materialUnit) {
        this.materialUnit = materialUnit;
    }
    public BigDecimal getTemporaryNum() {
        return temporaryNum;
    }

    public void setTemporaryNum(BigDecimal temporaryNum) {
        this.temporaryNum = temporaryNum;
    }
    public BigDecimal getTemporaryPrice() {
        return temporaryPrice;
    }

    public void setTemporaryPrice(BigDecimal temporaryPrice) {
        this.temporaryPrice = temporaryPrice;
    }
    public BigDecimal getTemporaryMny() {
        return temporaryMny;
    }

    public void setTemporaryMny(BigDecimal temporaryMny) {
        this.temporaryMny = temporaryMny;
    }
    public BigDecimal getDealNum() {
        return dealNum;
    }

    public void setDealNum(BigDecimal dealNum) {
        this.dealNum = dealNum;
    }
    public BigDecimal getDealPrice() {
        return dealPrice;
    }

    public void setDealPrice(BigDecimal dealPrice) {
        this.dealPrice = dealPrice;
    }
    public BigDecimal getDealMny() {
        return dealMny;
    }

    public void setDealMny(BigDecimal dealMny) {
        this.dealMny = dealMny;
    }
    
     public List<TenderDetailVO> getTenderDetailList() {
        return tenderDetailList;
     }

     public void setTenderDetailList(List<TenderDetailVO> tenderDetailList) {
        this.tenderDetailList = tenderDetailList;
     }
}
