/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.material.bean.DeliveryrecordEntity;
import com.ejianc.business.material.bean.DeliveryrecorddetailEntity;
import com.ejianc.business.material.bean.FlowmeterEntity;
import com.ejianc.business.material.bean.MaterialWarehousingEntity;
import com.ejianc.business.material.bean.MaterialWarehousingdetailEntity;
import com.ejianc.business.material.bean.MaterialapproachEntity;
import com.ejianc.business.material.bean.MaterialapproachdetailEntity;
import com.ejianc.business.material.service.IDeliveryrecordService;
import com.ejianc.business.material.service.IDeliveryrecorddetailService;
import com.ejianc.business.material.service.IFlowmeterService;
import com.ejianc.business.material.service.IMaterialWarehousingService;
import com.ejianc.business.material.service.IMaterialWarehousingdetailService;
import com.ejianc.business.material.service.IMaterialapproachService;
import com.ejianc.business.material.service.IMaterialapproachdetailService;
import com.ejianc.business.material.service.IRealtimebalanceService;
import com.ejianc.business.material.utils.DateUtils;
import com.ejianc.business.material.vo.DeliveryrecorddetailVO;
import com.ejianc.business.material.vo.MaterialWarehousingReportVO;
import com.ejianc.business.material.vo.MaterialWarehousingVO;
import com.ejianc.business.material.vo.MaterialWarehousingdetailVO;
import com.ejianc.foundation.material.vo.MaterialapproachdetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.outcontract.api.IOutcontractApi;
import com.ejianc.foundation.outcontract.vo.OutcontractMaterialVO;
import com.ejianc.foundation.outcontract.vo.OutcontractVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import com.ejianc.wzxt.plan.api.IPlanApi;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"materialWarehousing"})
public class MaterialWarehousingController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Qualifier(value="com.ejianc.foundation.outcontract.api.IOutcontractApi")
    @Autowired
    private IOutcontractApi outcontractApi;
    @Autowired
    private IDeliveryrecorddetailService deliveryrecorddetailService;
    @Autowired
    private IDeliveryrecordService deliveryrecordService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IMaterialWarehousingdetailService detailService;
    private static final String BILL_CODE = "WZ_YS";
    @Autowired
    private IMaterialWarehousingService service;
    @Autowired
    private IMaterialapproachdetailService materialapproachdetailService;
    @Autowired
    private IFlowmeterService flowmeterService;
    @Autowired
    private IRealtimebalanceService realtimebalanceService;
    @Autowired
    private IMaterialapproachService materialapproachService;
    @Autowired
    private IPlanApi planApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<MaterialWarehousingVO> saveOrUpdate(@RequestBody MaterialWarehousingVO saveorUpdateVO) {
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)this.service.saveOrUpdate(saveorUpdateVO)));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MaterialWarehousingVO> queryDetail(Long id) {
        MaterialWarehousingEntity entity = (MaterialWarehousingEntity)((Object)this.service.selectById(id));
        MaterialWarehousingVO vo = (MaterialWarehousingVO)((Object)BeanMapper.map((Object)((Object)entity), MaterialWarehousingVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/updateRealtimeBalance"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MaterialWarehousingVO> updateRealtimeBalance(Long storeId) {
        this.realtimebalanceService.updateRealtimeBalance(storeId);
        return CommonResponse.success((String)"\u66f4\u65b0\u5b9e\u65f6\u7269\u8d44\u7ed3\u5b58\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MaterialWarehousingVO> vos) {
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        LambdaQueryWrapper lambdaDelivery = Wrappers.lambdaQuery();
        lambdaDelivery.in(BaseEntity::getId, ids);
        List deliveryrecordEntities = this.service.list((Wrapper)lambdaDelivery);
        LambdaQueryWrapper lambdaFlower = Wrappers.lambdaQuery();
        lambdaFlower.in(FlowmeterEntity::getMid, ids);
        this.flowmeterService.remove((Wrapper)lambdaFlower);
        for (MaterialWarehousingEntity materialWarehousingEntity : deliveryrecordEntities) {
            this.realtimebalanceService.updateRealtimeBalance(materialWarehousingEntity.getStoreId());
        }
        List wareIds = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(wareIds)) {
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.in(BaseEntity::getId, wareIds);
            List materialWarehousingEntities = this.service.list((Wrapper)lambda);
            List materialapproachIds = materialWarehousingEntities.stream().filter(s -> s.getWarehousingType() == 0).map(MaterialWarehousingEntity::getMaterialapproachId).distinct().collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(materialapproachIds)) {
                LambdaQueryWrapper lambdaware = Wrappers.lambdaQuery();
                lambdaware.notIn(BaseEntity::getId, wareIds);
                lambdaware.in(MaterialWarehousingEntity::getMaterialapproachId, materialapproachIds);
                List materialWarehousingList = this.service.list((Wrapper)lambdaware);
                if (CollectionUtils.isNotEmpty((Collection)materialWarehousingList)) {
                    List materialapproachAllIds = materialWarehousingList.stream().filter(s -> s.getWarehousingType() == 0).map(MaterialWarehousingEntity::getMaterialapproachId).distinct().collect(Collectors.toList());
                    List updateIds = materialapproachIds.stream().filter(s -> !materialapproachAllIds.contains(s)).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(updateIds)) {
                        LambdaQueryWrapper lambdaappach = Wrappers.lambdaQuery();
                        lambdaappach.in(BaseEntity::getId, updateIds);
                        List list = this.materialapproachService.list((Wrapper)lambdaappach);
                        list.stream().forEach(s -> s.setUseFlag(0));
                        if (CollectionUtils.isNotEmpty((Collection)list)) {
                            this.materialapproachService.updateBatchById(list);
                        }
                    }
                } else {
                    LambdaQueryWrapper lambdaappach = Wrappers.lambdaQuery();
                    lambdaappach.in(BaseEntity::getId, materialapproachIds);
                    List list = this.materialapproachService.list((Wrapper)lambdaappach);
                    list.stream().forEach(s -> s.setUseFlag(0));
                    if (CollectionUtils.isNotEmpty((Collection)list)) {
                        this.materialapproachService.updateBatchById(list);
                    }
                }
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MaterialWarehousingVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("subContract");
        fuzzyFields.add("acceptanceType");
        fuzzyFields.add("supplierName");
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MaterialWarehousingVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        List list = this.service.queryList(param);
        List warehousingVOS = BeanMapper.mapList((Iterable)list, MaterialWarehousingVO.class);
        for (int i = 0; i < warehousingVOS.size(); ++i) {
            String billStateStr;
            MaterialWarehousingVO materialWarehousingVO = (MaterialWarehousingVO)((Object)warehousingVOS.get(i));
            materialWarehousingVO.setNum(String.valueOf(i + 1));
            if (materialWarehousingVO.getCreateTime() != null) {
                materialWarehousingVO.setCreateTimeShow(DateUtils.dateSimple2(materialWarehousingVO.getCreateTime()));
            }
            if ((billStateStr = materialWarehousingVO.getBillState().toString()) != null) {
                if ("0".equals(billStateStr)) {
                    billStateStr = "\u81ea\u7531\u6001";
                } else if ("1".equals(billStateStr)) {
                    billStateStr = "\u5df2\u63d0\u4ea4";
                } else if ("2".equals(billStateStr) || "5".equals(billStateStr)) {
                    billStateStr = "\u5ba1\u6279\u4e2d";
                } else if ("3".equals(billStateStr)) {
                    billStateStr = "\u5ba1\u6279\u901a\u8fc7";
                } else if ("4".equals(billStateStr)) {
                    billStateStr = "\u9a73\u56de";
                }
                materialWarehousingVO.setBillStateStr(billStateStr);
            }
            if (materialWarehousingVO.getWarehousingType() == 0) {
                materialWarehousingVO.setWarehousingTypeName("\u5165\u5e93");
            }
            if (materialWarehousingVO.getWarehousingType() != 1) continue;
            materialWarehousingVO.setWarehousingTypeName("\u9000\u4f9b\u5e94\u5546");
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", warehousingVOS);
        ExcelExport.getInstance().export("MaterialWarehousing-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refMaterialWarehousingData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<MaterialWarehousingVO>> refMaterialWarehousingData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            ArrayList<Integer> billState = new ArrayList<Integer>();
            billState.add(1);
            billState.add(3);
            ArrayList<String> acceptanceType = new ArrayList<String>();
            acceptanceType.add("\u76f4\u5165\u76f4\u51fa");
            acceptanceType.add("\u9a8c\u6536\u5165\u5e93");
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.get((Object)"status") != null && _con.get((Object)"status").equals("0")) {
                param.getParams().put("acceptanceType", new Parameter("eq", (Object)"\u76f4\u5165\u76f4\u51fa"));
                param.getParams().put("notReturnedQuantity", new Parameter("gt", (Object)BigDecimal.ZERO));
                param.getParams().put("billState", new Parameter("in", billState));
            }
            if (_con.get((Object)"status") != null && _con.get((Object)"status").equals("1")) {
                param.getParams().put("warehousingType", new Parameter("eq", (Object)0));
                param.getParams().put("acceptanceType", new Parameter("in", acceptanceType));
                param.getParams().put("notReturnedQuantity", new Parameter("gt", (Object)BigDecimal.ZERO));
                param.getParams().put("billState", new Parameter("in", billState));
            }
            if (_con.get((Object)"contractId") != null) {
                param.getParams().put("contractId", new Parameter("eq", _con.get((Object)"contractId")));
            }
            if (_con.get((Object)"projectId") != null) {
                param.getParams().put("projectId", new Parameter("eq", _con.get((Object)"projectId")));
            }
            if (_con.get((Object)"orgId") != null) {
                UserContext userContextCache = this.sessionManager.getUserContext();
                String authOrgIds = userContextCache.getAuthOrgIds();
                List orgVOList = null;
                orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(Long.valueOf(Long.parseLong(_con.get((Object)"orgId").toString()))), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
                ArrayList commonOrgIds = new ArrayList();
                ArrayList departmentIds = new ArrayList();
                orgVOList.stream().forEach(org -> {
                    if (5 == org.getOrgType()) {
                        departmentIds.add(org.getId());
                    } else {
                        commonOrgIds.add(org.getId());
                    }
                });
                if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                    param.getParams().put("orgId", new Parameter("in", commonOrgIds));
                } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                    param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
                }
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MaterialWarehousingVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryContract"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> queryContract(Long id, Long contractId) {
        List entityList;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.eq((Object)"contract_id", (Object)contractId);
        if (id != null && id != 0L) {
            queryWrapper.ne((Object)"id", (Object)id);
        }
        if ((entityList = this.service.list((Wrapper)queryWrapper)) != null && entityList.size() > 0) {
            return CommonResponse.error((String)"\u8be5\u9879\u76ee\u4e0b\u5df2\u7ecf\u5b58\u5728\u5408\u540c\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e");
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)"0");
    }

    @RequestMapping(value={"getMaterialPLanById"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<DeliveryrecorddetailVO>> getMaterialPLanById(@RequestParam(value="projectId") Long projectId, @RequestParam(value="subContractId") Long subContractId) {
        Map<Long, BigDecimal> pLanByProjectIdMap = new HashMap();
        Map<Object, Object> numMap = new HashMap();
        ArrayList list = new ArrayList();
        CommonResponse materialPLanByProjectId = this.planApi.getMaterialPLanByProjectId(projectId, subContractId);
        if (!materialPLanByProjectId.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u8ba1\u5212\u4fe1\u606f\u5931\u8d25");
        }
        pLanByProjectIdMap = (Map)materialPLanByProjectId.getData();
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapper.eq(DeliveryrecordEntity::getProjectId, (Object)projectId);
        lambdaQueryWrapper.eq(DeliveryrecordEntity::getPickingunitId, (Object)subContractId);
        lambdaQueryWrapper.eq(DeliveryrecordEntity::getSelfState, (Object)"\u5426");
        lambdaQueryWrapper.in(DeliveryrecordEntity::getBillState, new Object[]{1, 3});
        List deliveryrecordEntities = this.deliveryrecordService.list((Wrapper)lambdaQueryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)deliveryrecordEntities)) {
            List ids = deliveryrecordEntities.stream().map(BaseEntity::getId).collect(Collectors.toList());
            LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
            lambdaQuery.in(DeliveryrecorddetailEntity::getMid, ids);
            List deliveryrecorddetailEntities = this.deliveryrecorddetailService.list((Wrapper)lambdaQuery);
            if (CollectionUtils.isNotEmpty((Collection)deliveryrecorddetailEntities)) {
                numMap = deliveryrecorddetailEntities.stream().collect(Collectors.groupingBy(DeliveryrecorddetailEntity::getMaterialId, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getDeliveryQuantity()).reduce(BigDecimal.ZERO, BigDecimal::add))));
            }
        }
        if (!pLanByProjectIdMap.isEmpty()) {
            HashMap finalNumMap = numMap;
            pLanByProjectIdMap.forEach((key, value) -> {
                DeliveryrecorddetailVO deliveryrecorddetailVO = new DeliveryrecorddetailVO();
                deliveryrecorddetailVO.setMaterialId((Long)key);
                deliveryrecorddetailVO.setPlanNum((BigDecimal)value);
                if (finalNumMap.containsKey(key)) {
                    BigDecimal outNum = (BigDecimal)finalNumMap.get(key);
                    deliveryrecorddetailVO.setPlanSurplusNum(ComputeUtil.safeSub((BigDecimal)deliveryrecorddetailVO.getPlanNum(), (BigDecimal)outNum));
                } else {
                    deliveryrecorddetailVO.setPlanSurplusNum(deliveryrecorddetailVO.getPlanNum());
                }
                list.add(deliveryrecorddetailVO);
            });
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", list);
    }

    @RequestMapping(value={"/queryMaterialapproach"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<MaterialapproachdetailVO>> queryMaterialapproach(Long id, Long materialapproachId, Long contractId) {
        this.logger.info("111111111materialapproachEntity.getProjectId()");
        MaterialapproachEntity materialapproachEntity = (MaterialapproachEntity)((Object)this.materialapproachService.selectById(materialapproachId));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"mid", (Object)materialapproachId);
        List materialapproachdetailEntityList = this.materialapproachdetailService.list((Wrapper)queryWrapper);
        List<Object> materialapproachdetailEntities = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)materialapproachdetailEntityList)) {
            List materialWarehousingdetailEntities;
            List approachIds = materialapproachdetailEntityList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            LambdaQueryWrapper houseDetailScheme = Wrappers.lambdaQuery();
            houseDetailScheme.in(MaterialWarehousingdetailEntity::getApproachDetailId, approachIds);
            if (id != null) {
                houseDetailScheme.ne(MaterialWarehousingdetailEntity::getMid, (Object)id);
            }
            if (CollectionUtils.isNotEmpty((Collection)(materialWarehousingdetailEntities = this.detailService.list((Wrapper)houseDetailScheme)))) {
                Map<Long, BigDecimal> checkMap = materialWarehousingdetailEntities.stream().filter(s -> s.getQuantity().compareTo(BigDecimal.ZERO) == 1).collect(Collectors.groupingBy(MaterialWarehousingdetailEntity::getApproachDetailId, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getQuantity()).reduce(BigDecimal.ZERO, BigDecimal::add))));
                for (MaterialapproachdetailEntity materialapproachdetailEntity : materialapproachdetailEntityList) {
                    if (checkMap.containsKey(materialapproachdetailEntity.getId())) {
                        BigDecimal checkNum = checkMap.get(materialapproachdetailEntity.getId());
                        materialapproachdetailEntity.setNotStorageNum(materialapproachdetailEntity.getVerificationCount().subtract(checkNum));
                        continue;
                    }
                    materialapproachdetailEntity.setNotStorageNum(materialapproachdetailEntity.getVerificationCount());
                }
            }
            materialapproachdetailEntities = materialapproachdetailEntityList.stream().filter(it -> it.getNotStorageNum().compareTo(BigDecimal.ZERO) == 1).collect(Collectors.toList());
        }
        List vo = BeanMapper.mapList(materialapproachdetailEntities, MaterialapproachdetailVO.class);
        Map pLanByProjectIdMap = new HashMap();
        Map<Object, Object> numMap = new HashMap();
        if (materialapproachEntity.getSubcontractorId() != null) {
            this.logger.info("materialapproachEntity.getProjectId():" + materialapproachEntity.getProjectId() + "----" + materialapproachEntity.getSubcontractorId());
            CommonResponse materialPLanByProjectId = this.planApi.getMaterialPLanByProjectId(materialapproachEntity.getProjectId(), materialapproachEntity.getSubcontractorId());
            if (!materialPLanByProjectId.isSuccess()) {
                throw new BusinessException("\u83b7\u53d6\u8ba1\u5212\u4fe1\u606f\u5931\u8d25");
            }
            this.logger.info("pLanByProjectIdMap" + JSONObject.toJSONString((Object)materialPLanByProjectId));
            pLanByProjectIdMap = (Map)materialPLanByProjectId.getData();
            this.logger.info("pLanByProjectIdMap" + JSONObject.toJSONString(pLanByProjectIdMap));
            LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
            lambdaQueryWrapper.eq(DeliveryrecordEntity::getProjectId, (Object)materialapproachEntity.getProjectId());
            lambdaQueryWrapper.eq(DeliveryrecordEntity::getPickingunitId, (Object)materialapproachEntity.getSubcontractorId());
            lambdaQueryWrapper.eq(DeliveryrecordEntity::getSelfState, (Object)"\u5426");
            lambdaQueryWrapper.in(DeliveryrecordEntity::getBillState, new Object[]{1, 3});
            List deliveryrecordEntities = this.deliveryrecordService.list((Wrapper)lambdaQueryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)deliveryrecordEntities)) {
                List ids = deliveryrecordEntities.stream().map(BaseEntity::getId).collect(Collectors.toList());
                LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
                lambdaQuery.in(DeliveryrecorddetailEntity::getMid, ids);
                List deliveryrecorddetailEntities = this.deliveryrecorddetailService.list((Wrapper)lambdaQuery);
                if (CollectionUtils.isNotEmpty((Collection)deliveryrecorddetailEntities)) {
                    numMap = deliveryrecorddetailEntities.stream().collect(Collectors.groupingBy(DeliveryrecorddetailEntity::getMaterialId, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getDeliveryQuantity()).reduce(BigDecimal.ZERO, BigDecimal::add))));
                }
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)vo)) {
            for (MaterialapproachdetailVO materialapproachdetailVO : vo) {
                materialapproachdetailVO.setPlanNum(BigDecimal.ZERO);
                materialapproachdetailVO.setPlanSurplusNum(BigDecimal.ZERO);
                if (!pLanByProjectIdMap.containsKey(materialapproachdetailVO.getMaterialId())) continue;
                this.logger.info("1111111111");
                BigDecimal planNum = (BigDecimal)pLanByProjectIdMap.get(materialapproachdetailVO.getMaterialId());
                materialapproachdetailVO.setPlanNum(planNum);
                if (numMap.containsKey(materialapproachdetailVO.getMaterialId())) {
                    BigDecimal outNum = (BigDecimal)numMap.get(materialapproachdetailVO.getMaterialId());
                    materialapproachdetailVO.setPlanSurplusNum(ComputeUtil.safeSub((BigDecimal)materialapproachdetailVO.getPlanNum(), (BigDecimal)outNum));
                    continue;
                }
                materialapproachdetailVO.setPlanSurplusNum(materialapproachdetailVO.getPlanNum());
            }
        }
        if (contractId != null) {
            CommonResponse outcontractVOCommonResponse = this.outcontractApi.queryDetail(contractId);
            this.logger.info("\u63a5\u53e3\u8fd4\u56de\u6570\u636e=" + outcontractVOCommonResponse.getMsg() + "\u72b6\u6001=" + outcontractVOCommonResponse.getCode());
            if (outcontractVOCommonResponse.getCode() == 0 && ((OutcontractVO)outcontractVOCommonResponse.getData()).getOutcontractMaterialList().size() > 0) {
                for (MaterialapproachdetailVO entity : vo) {
                    for (OutcontractMaterialVO list : ((OutcontractVO)outcontractVOCommonResponse.getData()).getOutcontractMaterialList()) {
                        if (!entity.getName().equals(list.getMaterialName()) || !entity.getMaterialCode().equals(list.getMaterialCode()) || !entity.getMaterialClassCode().equals(list.getMaterialCategoryCode())) continue;
                        entity.setUnitPriceIncluetax(list.getTaxUnitPrice());
                        entity.setTaxRate(list.getTaxRate());
                        if (entity.getUnitPriceIncluetax() != null) {
                            entity.setAmountIncluetax(entity.getNotStorageNum().multiply(entity.getUnitPriceIncluetax()));
                        }
                        if (entity.getUnitPriceIncluetax() == null || entity.getTaxRate() == null) continue;
                        entity.setUnitPriceEncluetax(entity.getUnitPriceIncluetax().multiply(entity.getTaxRate().divide(new BigDecimal(100), 8, 4)));
                        entity.setAmountEncluetax(entity.getNotStorageNum().multiply(entity.getUnitPriceEncluetax()));
                    }
                }
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryReport"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<MaterialWarehousingReportVO>> queryReport(String supplierName, Long projectId, String materialCode) {
        ArrayList<MaterialWarehousingReportVO> resList = new ArrayList<MaterialWarehousingReportVO>();
        QueryWrapper detailQueryWrapper = new QueryWrapper();
        detailQueryWrapper.eq((Object)"dr", (Object)0);
        if (supplierName != null) {
            detailQueryWrapper.eq((Object)"supplier_name", (Object)supplierName);
        }
        detailQueryWrapper.eq((Object)"project_id", (Object)projectId);
        detailQueryWrapper.eq((Object)"material_code", (Object)materialCode);
        List detailEntityList = this.detailService.list((Wrapper)detailQueryWrapper);
        for (MaterialWarehousingdetailEntity item : detailEntityList) {
            String supName = item.getSupplierName();
            String projectName = item.getProjectName();
            String name = item.getMaterialName();
            BigDecimal enterCount = item.getQuantity();
            BigDecimal money = item.getAmountIncluetax();
            MaterialWarehousingReportVO reportVO = new MaterialWarehousingReportVO();
            reportVO.setId(IdWorker.getId());
            reportVO.setProjectId(projectId);
            reportVO.setProjectName(projectName);
            reportVO.setMaterialName(name);
            reportVO.setMaterialCode(materialCode);
            reportVO.setSupplierName(supName);
            reportVO.setSpecialModel(item.getSpecialModel());
            reportVO.setAmountIncluetax(money);
            reportVO.setQuantity(enterCount);
            Long mid = item.getMid();
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"dr", (Object)0);
            queryWrapper.eq((Object)"id", (Object)mid);
            List mList = this.service.list((Wrapper)queryWrapper);
            Integer billState = 0;
            if (mList != null && mList.size() > 0) {
                MaterialWarehousingEntity entity = (MaterialWarehousingEntity)((Object)mList.get(0));
                String billCode = entity.getBillCode();
                reportVO.setBillCode(billCode);
                reportVO.setMaterialwarehousingId(mid);
                billState = entity.getBillState();
            }
            if (billState != 1 && billState != 3) continue;
            resList.add(reportVO);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", resList);
    }

    @RequestMapping(value={"/queryOrg"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse queryOutStore() {
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        QueryParam param = new QueryParam();
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)param);
    }

    @RequestMapping(value={"/queryWarehousDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<MaterialWarehousingdetailVO>> queryWarehousDetail(Long warehousId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"mid", (Object)warehousId);
        queryWrapper.gt((Object)"not_returned_quantity", (Object)BigDecimal.ZERO);
        List list = this.detailService.list((Wrapper)queryWrapper);
        for (MaterialWarehousingdetailEntity entity : list) {
            entity.setWarehouseingDetailId(entity.getId());
            entity.setId(IdWorker.getId());
            entity.setQuantity(entity.getQuantity().multiply(new BigDecimal(-1.0)));
            entity.setAmountIncluetax(entity.getAmountIncluetax().multiply(new BigDecimal(-1.0)));
            entity.setAmountExcluetax(entity.getAmountExcluetax().multiply(new BigDecimal(-1.0)));
        }
        List list1 = BeanMapper.mapList((Iterable)list, MaterialWarehousingdetailVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)list1);
    }
}

