/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.material.bean.StoreBalanceEntity;
import com.ejianc.business.material.mapper.StoreBalanceMapper;
import com.ejianc.business.material.service.IStoreBalanceService;
import com.ejianc.business.material.vo.StoreBalanceVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"storeBalance"})
public class StoreBalanceController
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "material-storebalance";
    @Autowired
    private IStoreBalanceService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private StoreBalanceMapper storeBalanceMapper;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<StoreBalanceVO> saveOrUpdate(@RequestBody StoreBalanceVO saveOrUpdateVO) {
        StoreBalanceEntity entity = (StoreBalanceEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), StoreBalanceEntity.class));
        if (entity.getId() != null ? this.queryFlag(entity.getProjectId(), entity.getStoreId(), entity.getMonth(), entity.getId()) != false : this.queryFlag(entity.getProjectId(), entity.getStoreId(), entity.getMonth(), null) != false) {
            throw new BusinessException("\u540c\u4e00\u4e2a\u9879\u76ee\uff0c\u540c\u4e00\u4e2a\u4ed3\u5e93\uff0c\u540c\u4e00\u7ed3\u5b58\u6708\u4efd\uff0c\u53ea\u5141\u8bb8\u5f55\u5165\u4e00\u6b21\uff01");
        }
        if (entity.getId() != null ? this.queryTop(entity.getProjectId(), entity.getStoreId(), entity.getMonth(), entity.getId()) != false : this.queryTop(entity.getProjectId(), entity.getStoreId(), entity.getMonth(), null) != false) {
            throw new BusinessException("\u4e0a\u671f\u6709\u672a\u5ba1\u6279\u901a\u8fc7\uff0c\u4e0d\u5141\u8bb8\u505a\u4e0b\u4e00\u671f\uff01");
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        StoreBalanceVO vo = (StoreBalanceVO)((Object)BeanMapper.map((Object)((Object)entity), StoreBalanceVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<StoreBalanceVO> queryDetail(Long id) {
        StoreBalanceEntity entity = (StoreBalanceEntity)((Object)this.service.selectById(id));
        StoreBalanceVO vo = (StoreBalanceVO)((Object)BeanMapper.map((Object)((Object)entity), StoreBalanceVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<StoreBalanceVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (StoreBalanceVO storeBalanceVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<StoreBalanceVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), StoreBalanceVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        List list = this.service.queryList(param);
        for (StoreBalanceEntity storeBalanceEntity : list) {
            String billStateStr = storeBalanceEntity.getBillState().toString();
            if (billStateStr == null) continue;
            if ("0".equals(billStateStr)) {
                billStateStr = "\u81ea\u7531\u6001";
            } else if ("1".equals(billStateStr)) {
                billStateStr = "\u5df2\u63d0\u4ea4";
            } else if ("2".equals(billStateStr) || "5".equals(billStateStr)) {
                billStateStr = "\u5ba1\u6279\u4e2d";
            } else if ("3".equals(billStateStr)) {
                billStateStr = "\u5ba1\u6279\u901a\u8fc7";
            } else if ("4".equals(billStateStr)) {
                billStateStr = "\u9a73\u56de";
            }
            storeBalanceEntity.setBillStateName(billStateStr);
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("StoreBalance-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refStoreBalanceData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<StoreBalanceVO>> refStoreBalanceData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), StoreBalanceVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryStoreBalanceByProjectId"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<StoreBalanceVO> queryStoreBalanceByProjectId(@RequestBody Map<String, Object> params) {
        if (params.get("projectId") == null) {
            return CommonResponse.error((String)"\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (params.get("month") == null) {
            return CommonResponse.error((String)"\u7ed3\u5b58\u6708\u4efd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (params.get("storeId") == null) {
            return CommonResponse.error((String)"\u4ed3\u5e93\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long projectId = Long.parseLong(params.get("projectId").toString());
        String month = params.get("month").toString();
        String storeId = params.get("storeId").toString();
        StoreBalanceVO storeBalanceVO = this.service.queryStoreBalanceByProjectId(projectId, month, storeId);
        return CommonResponse.success((Object)((Object)storeBalanceVO));
    }

    public Boolean queryFlag(Long projectId, Long storeId, Date month, Long id) {
        List storeBalanceEntities;
        LambdaQueryWrapper lambdaFlower = Wrappers.lambdaQuery();
        lambdaFlower.eq(StoreBalanceEntity::getProjectId, (Object)projectId);
        lambdaFlower.eq(StoreBalanceEntity::getStoreId, (Object)storeId);
        lambdaFlower.eq(StoreBalanceEntity::getMonth, (Object)month);
        if (id != null) {
            lambdaFlower.ne(BaseEntity::getId, (Object)id);
        }
        if ((storeBalanceEntities = this.service.list((Wrapper)lambdaFlower)).size() > 0) {
            return true;
        }
        return false;
    }

    public Boolean queryTop(Long projectId, Long storeId, Date month, Long id) {
        List storeBalanceEntities;
        LambdaQueryWrapper lambdaFlower = Wrappers.lambdaQuery();
        lambdaFlower.eq(StoreBalanceEntity::getProjectId, (Object)projectId);
        lambdaFlower.eq(StoreBalanceEntity::getStoreId, (Object)storeId);
        lambdaFlower.lt(StoreBalanceEntity::getMonth, (Object)month);
        lambdaFlower.ne(StoreBalanceEntity::getBillState, (Object)1);
        lambdaFlower.ne(StoreBalanceEntity::getBillState, (Object)3);
        if (id != null) {
            lambdaFlower.ne(BaseEntity::getId, (Object)id);
        }
        if ((storeBalanceEntities = this.service.list((Wrapper)lambdaFlower)).size() > 0) {
            return true;
        }
        return false;
    }

    public Boolean queryDate(Long projectId, Long storeId, Date month) {
        StoreBalanceVO storeBalanceVO = this.storeBalanceMapper.queryMoth(projectId, storeId);
        if (storeBalanceVO != null) {
            if (storeBalanceVO.getMonth().toString().compareTo(month.toString()) > 0) {
                return true;
            }
            return false;
        }
        return false;
    }
}

