package com.ejianc.business.material.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.material.service.IReturnService;
import com.ejianc.business.material.vo.ReturnVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * 退场台账
 * @author biying
 */

@Controller
@RequestMapping("return")
public class ReturnController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IReturnService service;

    @Autowired
    private IOrgApi iOrgApi;


    /**
     * 查询列表数据
     * @return
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ReturnVO>> queryReportList(@RequestBody QueryParam param) {
        List<ReturnVO> vo = new ArrayList<>();
        List<ReturnVO> returnVoIpage = service.selectAll();
        for (ReturnVO returnVO : returnVoIpage){
            returnVO.setId(IdWorker.getId());
            returnVO.setProjectId(returnVO.getProjectId());
            returnVO.setMaterialCode(returnVO.getMaterialCode());
            returnVO.setProjectName(returnVO.getProjectName());
            returnVO.setName(returnVO.getName());
            returnVO.setSpec(returnVO.getSpec());
            returnVO.setReturnCount(returnVO.getReturnCount());
            returnVO.setLostCount(returnVO.getLostCount());
            returnVO.setMaintainCount(returnVO.getMaintainCount());
//            returnVO.setCreateUserCode(returnVO.getCreateUserCode());
            vo.add(returnVO);
        }

        IPage<ReturnVO> pageData = new Page<>(param.getPageIndex(), param.getPageSize(), returnVoIpage.size());
        pageData.setRecords(returnVoIpage);

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

}
