package com.ejianc.business.material.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.material.bean.StoreBalanceEntity;
import com.ejianc.business.material.service.IStoreBalanceService;
import com.ejianc.foundation.material.vo.CostanalysistaxVO;
import com.ejianc.foundation.material.vo.CostanalysistaxdataVO;
import com.ejianc.foundation.material.vo.StoreBalanceDetailVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 物资结存
 *
 * @author generator
 */
@Controller
@RequestMapping("api/storeBalance")
public class StoreBalanceApiController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IStoreBalanceService service;

    /**
     * @param projectId
     * @param month
     * @param materialCategoryCode
     * @return
     */
    @RequestMapping(value = "/queryOutStore", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<StoreBalanceDetailVO> queryOutStore(@RequestParam(value = "projectId") Long projectId, @RequestParam(value = "month") String month, @RequestParam(value = "materialCategoryCode") String materialCategoryCode) {
        if (projectId == null) {
            return CommonResponse.error("项目id不能为空");
        }

        if (month == null) {
            return CommonResponse.error("月份不能为空");
        }

        if (materialCategoryCode == null) {
            return CommonResponse.error("物资分类编码不能为空");
        }

        StoreBalanceDetailVO storeBalanceDetailVO = service.queryStoreBalanceMonth(projectId, month, materialCategoryCode);
        return CommonResponse.success(storeBalanceDetailVO);
    }

    /**
     * 成本管理-项目成本月度分析报告-税金
     *
     * @param projectId
     * @param time
     * @return
     */
    @RequestMapping(value = "queryCostanalysisTax", method = RequestMethod.GET)
    @ResponseBody
    private CommonResponse<CostanalysistaxVO> queryCostanalysisTax(@RequestParam(value = "projectId") Long projectId, @RequestParam String time) {

        CostanalysistaxVO costanalysistaxVO = new CostanalysistaxVO();
        List<CostanalysistaxdataVO> costanalysistaxdataVOList = new ArrayList<>();

        if (time == null || time.length() < 7) {
            throw new BusinessException("日期不能为空");
        }

        //物资结存
        QueryWrapper<StoreBalanceEntity> queryWrapperPur = new QueryWrapper<>();
        //当月第一天
        String start = time.substring(0, 7) + "-01";
        //当月最后一天
//        String end = "2022-06-30";

        Calendar cal = Calendar.getInstance();
        cal.set(Calendar.YEAR, Integer.parseInt(time.substring(0, 4)));
        cal.set(Calendar.MONTH, Integer.parseInt(time.substring(5, 7)) - 1);
        cal.set(Calendar.DAY_OF_MONTH, cal.getActualMaximum(Calendar.DAY_OF_MONTH));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String end = sdf.format(cal.getTime());
        queryWrapperPur.eq("project_id", projectId);
        queryWrapperPur.le("month", end);
        queryWrapperPur.ge("month", start);
        queryWrapperPur.eq("dr", 0);
        List<StoreBalanceEntity> listPur = service.list(queryWrapperPur);
        CostanalysistaxdataVO costanalysistaxdataVOPur = new CostanalysistaxdataVO();
        costanalysistaxdataVOPur.setBillName("物资结存");
        if (listPur.size() > 0) {
            costanalysistaxdataVOPur.setProjectId(listPur.get(0).getProjectId());//项目id

            costanalysistaxdataVOPur.setProjectName(listPur.get(0).getProjectName());//项目名称

            SimpleDateFormat sdf1=new SimpleDateFormat("yyyy-MM-dd");
            String sDate=sdf.format(listPur.get(0).getMonth());
            costanalysistaxdataVOPur.setJcDate(sDate);//结存月份

             Date month = listPur.get(0).getMonth();
            //本月消耗金额(含税)
            BigDecimal taxSettlementAmount = listPur.get(0).getOutstoreAmountTaxTotal();
            //本月结算金额(除税)
            BigDecimal settlementAmount = listPur.get(0).getOutstoreAmountUntaxTotal();
            //除税额:本月结算金额(除税)
            costanalysistaxdataVOPur.setAmount(settlementAmount);
            //含税额：本月结算金额(含税)
            costanalysistaxdataVOPur.setAmountTax(taxSettlementAmount);
            BigDecimal taxPur = taxSettlementAmount.subtract(settlementAmount);
            if (settlementAmount.equals(taxSettlementAmount)) {
                costanalysistaxdataVOPur.setTax(new BigDecimal("0.00"));
            } else {
                //税金:本月结算金额(含税)-本月结算金额(除税)
                costanalysistaxdataVOPur.setTax(taxPur);
            }
            //税率:（本月结算金额(含税)-本月结算金额(除税)）/本月结算金额(除税)
            costanalysistaxdataVOPur.setRate(taxPur.divide(settlementAmount, 2, BigDecimal.ROUND_HALF_UP));
        } else {
            costanalysistaxdataVOPur.setAmount(new BigDecimal("0.00"));
            costanalysistaxdataVOPur.setAmountTax(new BigDecimal("0.00"));
            costanalysistaxdataVOPur.setTax(new BigDecimal("0.00"));
            costanalysistaxdataVOPur.setRate(new BigDecimal("0.00"));
        }
        costanalysistaxdataVOList.add(costanalysistaxdataVOPur);

        BigDecimal greaterTax = new BigDecimal("0.00");
        BigDecimal lessAndEqualsTax = new BigDecimal("0.00");
        for (int i = 0; costanalysistaxdataVOList.size() > i; i++) {
            if (costanalysistaxdataVOList.get(i).getRate().compareTo(new BigDecimal("0.03")) == 1) {
                greaterTax = greaterTax.add(costanalysistaxdataVOList.get(i).getTax());
            } else {
                lessAndEqualsTax = lessAndEqualsTax.add(costanalysistaxdataVOList.get(i).getTax());
            }
        }
        costanalysistaxVO.setGreaterTax(greaterTax);
        costanalysistaxVO.setLessAndEqualsTax(lessAndEqualsTax);
        costanalysistaxVO.setDataSource(costanalysistaxdataVOList);
        return CommonResponse.success("查询数据成功", costanalysistaxVO);
    }

    /**
     * 根据项目id和月度查询物资结存本月消耗
     * @param projectId 项目id
     * @param month     月份
     * @return
     */
    @RequestMapping(value = "/queryMaterialConsumeMonth", method = RequestMethod.GET)
    @ResponseBody
    private CommonResponse<Map<String,StoreBalanceDetailVO>> queryMaterialConsumeMonth(@RequestParam(value = "projectId") Long projectId, @RequestParam(value = "month") String month) {
        Map<String,StoreBalanceDetailVO> map = new HashMap<>();
        List<StoreBalanceDetailVO> storeBalanceDetailVOS = service.queryMaterialConsumeMonth(projectId, month);
        if (!storeBalanceDetailVOS.isEmpty()){
            for (StoreBalanceDetailVO vo : storeBalanceDetailVOS) {
                map.put(vo.getMaterialCategoryCode(),vo);
            }
        }
        return CommonResponse.success("查询数据成功", map);
    }
    /**
     * @Description //TODO 月度成本分析物资结存单据更新归集状态字段
     *
     * @param projectId 项目id
     * @param state    归集状态
     * @param monthStr 要归集单据数据的时间范围
     * @return com.ejianc.framework.core.response.CommonResponse
     * @createDate 2023/1/12
     * @author yupengjie
     **/
    @RequestMapping(value = "/updateSettlementState", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> updateMidSettlementState(Long projectId, Integer state, String monthStr){
        service.updateSettlementState(projectId,state,monthStr);
        return CommonResponse.success("更新归集状态成功");
    }
    /**
     * @Description //TODO 查询校验物资结存单据是否存在往期单据中未归集的数据
     * 
     * @param projectId 项目id
     * @param monthStr 要归集单据数据的时间范围
     * @return com.ejianc.framework.core.response.CommonResponse
     * @createDate 2023/1/12
     * @author yupengjie
     **/
    @RequestMapping(value = "/queryIsSettlement", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> queryIsSettlement(Long projectId, String monthStr){
        service.queryIsSettlement(projectId,monthStr);
        return CommonResponse.success();
    }
}
