package com.ejianc.business.material.excel;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.material.bean.MaterialsreturndetailEntity;
import com.ejianc.business.material.service.IMaterialsreturndetailService;
import com.ejianc.business.material.vo.MaterialsreturndetailVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * 物资（周转）退场验证记录子表导入导出
 */
@Controller
@RequestMapping("materialsreturndetailExport")
public class ExcelMaterialsreturndetailController {
    private static final long   serialVersionUID= 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IMaterialsreturndetailService service;
    /**
     * 导出模板下载
     */
    @RequestMapping(value = "/downloadMaterialsreturndetail")
    @ResponseBody
    public void downloadMaterialsreturndetail (HttpServletRequest request, HttpServletResponse response){
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "Materialsreturndetail-import.xlsx", "物资退场验证记录明细");
    }
    /**
     * 从Excel导入
     */
    @RequestMapping(value = "/excelImportMaterialsreturndetail", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportMaterialsreturndetail(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<MaterialsreturndetailVO> successList = new ArrayList<>();
        List<MaterialsreturndetailVO> errorList = new ArrayList<>();
        Map<String, MaterialsreturndetailVO> map = new HashMap<>();
        DateFormat sdf=new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if(isFailed) {
            return CommonResponse.error("文件格式不合法");
        }else{
            List<List<String>> result = ExcelReader.readExcel(mf);
            if(result != null && result.size() > 0) {
                for(int i=1;i<result.size();i++) {
                    List<String> datas = result.get(i);
                    StringBuilder errorsMsgBuilder = new StringBuilder();

                    String materialClassCode = datas.get(0);
                    String materialClassName = datas.get(1);
                    String materialCode = datas.get(2);
                    String name = datas.get(3);
                    String spec = datas.get(4);
                    String unit = datas.get(5);
                    String returnCount = datas.get(6);//
                    String lostCount = datas.get(7);//
                    String maintainCount = datas.get(8);//
                    String remarks = datas.get(9);
                    //循环进来TPID
                    MaterialsreturndetailVO MaterialsreturndetailVO = new MaterialsreturndetailVO();
                    MaterialsreturndetailVO.setId(IdWorker.getId());//id
                    //三目判断值是否空
                    MaterialsreturndetailVO.setMaterialClassCode(StringUtils.isNotBlank(materialClassCode) ? materialClassCode : null);
                    MaterialsreturndetailVO.setMaterialClassName(StringUtils.isNotBlank(materialClassName) ? materialClassName : null);
                    MaterialsreturndetailVO.setMaterialCode(StringUtils.isNotBlank(materialCode) ? name : null);
                    MaterialsreturndetailVO.setName(StringUtils.isNotBlank(name) ? name : null);
                    MaterialsreturndetailVO.setSpec(StringUtils.isNotBlank(spec) ? spec : null);
                    MaterialsreturndetailVO.setUnit(StringUtils.isNotBlank(unit) ? unit : null);
                    MaterialsreturndetailVO.setRemarks(StringUtils.isNotBlank(remarks) ? remarks : null); // 备注
                    //必填项校验
                    if (name == null || TextUtils.isEmpty(name)) {
                        MaterialsreturndetailVO.setErrorMsg("物资名称不能为空！");
                        errorsMsgBuilder.append("物资名称不能为空！");
                    }

                    //格式校验
                    if (!TextUtils.isEmpty(returnCount) && !NumberUtil.isNumber(returnCount)) {
                        MaterialsreturndetailVO.setErrorMsg("退场数量格式不正确！");
                        errorsMsgBuilder.append("退场数量格式不正确！");
                    } else {
                        MaterialsreturndetailVO.setReturnCount(StringUtils.isNotBlank(returnCount) ? new BigDecimal(returnCount) : null); //退场数量
                    }
                    if (!TextUtils.isEmpty(lostCount) && !NumberUtil.isNumber(lostCount)) {
                        MaterialsreturndetailVO.setErrorMsg("丢失数量格式不正确！");
                        errorsMsgBuilder.append("丢失数量格式不正确！");
                    } else {
                        MaterialsreturndetailVO.setLostCount(StringUtils.isNotBlank(lostCount) ? new BigDecimal(lostCount) : null); //丢失数量
                    }
                    if (!TextUtils.isEmpty(maintainCount) && !NumberUtil.isNumber(maintainCount)) {
                        MaterialsreturndetailVO.setErrorMsg("维修数量格式不正确！");
                        errorsMsgBuilder.append("维修数量格式不正确！");
                    } else {
                        MaterialsreturndetailVO.setLostCount(StringUtils.isNotBlank(maintainCount) ? new BigDecimal(maintainCount) : null); //维修数量
                    }
                    if(errorsMsgBuilder.length() > 0){
                        errorList.add(MaterialsreturndetailVO);
                    }else {
                        successList.add(MaterialsreturndetailVO);
                    }
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());

        MaterialsreturndetailVO resVo = new MaterialsreturndetailVO();
//        json.put("total", resList);
        json.put("total", resVo);
        return CommonResponse.success(json);
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportMaterialsreturndetailFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportMaterialsreturndetailFromDatabase(@RequestBody MaterialsreturndetailVO MaterialsreturndetailVO, HttpServletResponse response) {
        QueryWrapper<MaterialsreturndetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", MaterialsreturndetailVO.getId());
        queryWrapper.eq("dr", 0);
        List<MaterialsreturndetailEntity> list = service.list(queryWrapper);
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Materialsreturndetail-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportMaterialsreturndetailFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportMaterialsreturndetailFromPage(@RequestBody List<MaterialsreturndetailVO> list, HttpServletResponse response) {
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Materialsreturndetail-export.xlsx", beans, response);
    }
}
