package com.ejianc.business.material.excel;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.material.bean.ProcurementplandetailEntity;
import com.ejianc.business.material.bean.SurplusmaterialapprovetailEntity;
import com.ejianc.business.material.service.IProcurementplandetailService;
import com.ejianc.business.material.service.ISurplusmaterialapprovetailService;
import com.ejianc.business.material.utils.DateUtils;
import com.ejianc.business.material.vo.ProcurementplanVO;
import com.ejianc.business.material.vo.ProcurementplandetailVO;
import com.ejianc.business.material.vo.SurplusmaterialapprovetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;


/**
 * 项目总采购计划子表导入导出
 */
@Controller
@RequestMapping("procurementplandetailExport")
public class ExcelProcurementplandetailController {
    private static final long   serialVersionUID= 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IProcurementplandetailService service;
    /**
     * 导入模板下载
     */
    @RequestMapping(value = "/downloadProcurementplandetail")
    @ResponseBody
    public void downloadProcurementplandetail (HttpServletRequest request, HttpServletResponse response){
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "Procurementplandetail-import.xlsx", "项目总采购计划明细模板");
    }
    /**
     * 从Excel导入
     */
    @RequestMapping(value = "/excelImportProcurementplandetail", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportProcurementplandetail(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<ProcurementplandetailVO> successList = new ArrayList<>();
        List<ProcurementplandetailVO> errorList = new ArrayList<>();
        Map<String, ProcurementplandetailVO> map = new HashMap<>();
        DateFormat sdf=new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if(isFailed) {
            return CommonResponse.error("文件格式不合法");
        }else{
            List<List<String>> result = ExcelReader.readExcel(mf);
            if(result != null && result.size() > 0) {
                for(int i=1;i<result.size();i++) {
                    List<String> datas = result.get(i);
                    StringBuilder errorsMsgBuilder = new StringBuilder();

                    String itemCode = datas.get(0);//物料编码
                    String itemName = datas.get(1);//物料名称
                    String unit = datas.get(2);//计量单位
                    String model = datas.get(3);//规格型号
                    String category = datas.get(4);//采购类别
                    String purchaseQuantity = datas.get(5); // 采购数量
                    String budgetPrice = datas.get(6); //预算价
                    String profitEstimates = datas.get(7); //利润预估率
                    String tenderingMethods = datas.get(8);// 分供方招标方式
                    String cycle = datas.get(9);// 工期/供货/租赁周期
                    String scheduleTenderTimes = datas.get(10);// 计划招标时间
                    String plannedStartDate = datas.get(11);// 计划开工日期
                    String plannedCompletionDate = datas.get(12); // 计划完工日期
                    String quantity = datas.get(13); //拟选择分供方数量
                    //循环进来TPID
                    ProcurementplandetailVO procurementplandetailVO = new ProcurementplandetailVO();
                    procurementplandetailVO.setId(IdWorker.getId());//id
//
                    //格式校验
                    if(StringUtils.isBlank(itemCode)){
                        procurementplandetailVO.setErrorMsg("物料编码必填项");
                        errorsMsgBuilder.append("物料编码必填项！");
                    }else{
                        procurementplandetailVO.setItemCode(itemCode);
                    }

                    if(StringUtils.isBlank(itemName)){
                        procurementplandetailVO.setErrorMsg("物料名称必填项");
                        errorsMsgBuilder.append("物料名称必填项！");
                    }else{
                        procurementplandetailVO.setItemName(itemName);
                    }

                    if(StringUtils.isBlank(unit)){
                        procurementplandetailVO.setErrorMsg("计量单位必填项");
                        errorsMsgBuilder.append("计量单位必填项！");
                    }else{
                        procurementplandetailVO.setUnit(unit);
                    }

                    if(StringUtils.isBlank(model)){
                        procurementplandetailVO.setErrorMsg("规格型号必填项");
                        errorsMsgBuilder.append("规格型号必填项！");
                    }else{
                        procurementplandetailVO.setModel(model);
                    }

                    if(StringUtils.isBlank(category)){
                        procurementplandetailVO.setErrorMsg("采购类别必填项");
                        errorsMsgBuilder.append("采购类别必填项！");
                    }else{
                        procurementplandetailVO.setCategory(category);
                    }

                    if(!StringUtils.isBlank(scheduleTenderTimes)){
                        if(DateUtils.grepDate(scheduleTenderTimes)){
                            procurementplandetailVO.setScheduleTenderTimes(DateUtils.Date(scheduleTenderTimes)); // 计划招标时间
                        }else {
                            procurementplandetailVO.setErrorMsg("计划招标时间格式不正确！");
                            errorsMsgBuilder.append("计划招标时间格式不正确！");
                        }
                    }

                    if(!StringUtils.isBlank(plannedStartDate)){
                        if(DateUtils.grepDate(plannedStartDate)){
                            procurementplandetailVO.setPlannedStartDate(DateUtils.Date(plannedStartDate)); // 计划开工日期
                        }else {
                            procurementplandetailVO.setErrorMsg("计划开工日期格式不正确！");
                            errorsMsgBuilder.append("计划开工日期格式不正确！");
                        }
                    }

                    if(!StringUtils.isBlank(plannedCompletionDate)){
                        if(DateUtils.grepDate(plannedCompletionDate)){
                            procurementplandetailVO.setPlannedCompletionDate(DateUtils.Date(plannedCompletionDate)); // 计划完工日期
                        }else {
                            procurementplandetailVO.setErrorMsg("计划完工日期格式不正确！");
                            errorsMsgBuilder.append("计划完工日期格式不正确！");
                        }
                    }

                    if (!TextUtils.isEmpty(purchaseQuantity) && !NumberUtil.isNumber(purchaseQuantity)) {
                        procurementplandetailVO.setErrorMsg("采购数量格式不正确！");
                        errorsMsgBuilder.append("采购数量格式不正确！");
                    } else {
                        procurementplandetailVO.setPurchaseQuantity(StringUtils.isNotBlank(purchaseQuantity) ? new BigDecimal(purchaseQuantity) : null); // 分供方数量
                    }

                    if (!TextUtils.isEmpty(budgetPrice) && !NumberUtil.isNumber(budgetPrice)) {
                        procurementplandetailVO.setErrorMsg("预算金额格式不正确！");
                        errorsMsgBuilder.append("预算金额格式不正确！");
                    } else {
                        procurementplandetailVO.setBudgetPrice(new BigDecimal(budgetPrice)); //预算价（万元）
                    }

                    if (!TextUtils.isEmpty(profitEstimates) && !NumberUtil.isNumber(profitEstimates)) {
                        procurementplandetailVO.setErrorMsg("利润预估率格式不正确！");
                        errorsMsgBuilder.append("利润预估率格式不正确！");
                    } else {
                        procurementplandetailVO.setProfitEstimates(new BigDecimal(profitEstimates)); // 利润预估率
                    }

                    if (TextUtils.isEmpty(tenderingMethods)) {
                        procurementplandetailVO.setErrorMsg("招标方式必填项！");
                        errorsMsgBuilder.append("招标方式必填项");
                    } else {
                        if(tenderingMethods.equals("公开")){
                            tenderingMethods = "1";
                        }else if(tenderingMethods.equals("邀请")){
                            tenderingMethods = "2";
                        }else if(tenderingMethods.equals("独家议标")){
                            tenderingMethods = "3";
                        }else{
                            procurementplandetailVO.setErrorMsg("招标方式格式错误！");
                            errorsMsgBuilder.append("招标方式格式错误");
                        }
                        procurementplandetailVO.setTenderingMethods(tenderingMethods); // 分供方招标方式
                    }

                    if(StringUtils.isBlank(cycle)){
                        procurementplandetailVO.setErrorMsg("工期/供货/租赁周期必填项");
                        errorsMsgBuilder.append("工期/供货/租赁周期必填项！");
                    }else{
                        procurementplandetailVO.setCycle(cycle);
                    }

                    if (!TextUtils.isEmpty(quantity) && !NumberUtil.isNumber(quantity)) {
                        procurementplandetailVO.setErrorMsg("分供方数量格式不正确！");
                        errorsMsgBuilder.append("分供方数量格式不正确！");
                    } else {
                        procurementplandetailVO.setQuantity(StringUtils.isNotBlank(quantity) ? new BigDecimal(quantity) : null); // 分供方数量
                    }

                    if(errorsMsgBuilder.length() > 0){
                        procurementplandetailVO.setErrorMsg(errorsMsgBuilder.toString());
                        errorList.add(procurementplandetailVO);
                    }else {
                        successList.add(procurementplandetailVO);
                    }
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());

        ProcurementplandetailVO resVo = new ProcurementplandetailVO();
//        json.put("total", resList);
        json.put("total", resVo);
        return CommonResponse.success(json);
    }
    /*
     * 解析Excel日期格式
     */
    public static Date DoubleToDate(Double dVal) {
        Date tDate = new Date();
        long localOffset = tDate.getTimezoneOffset() * 60000; // 系统时区偏移 1900/1/1
        // 到 1970/1/1 的
        // 25569 天
        tDate.setTime((long) ((dVal - 25569) * 24 * 3600 * 1000 + localOffset));

        return tDate;
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportProcurementplandetailFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportProcurementplandetailFromDatabase(@RequestBody ProcurementplandetailVO procurementplandetailVO, HttpServletResponse response) {
        QueryWrapper<ProcurementplandetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", procurementplandetailVO.getId());
        queryWrapper.eq("dr", 0);
        List<ProcurementplandetailEntity> list = service.list(queryWrapper);
        List<ProcurementplandetailVO> ProcurementplanVOList = BeanMapper.mapList(list, ProcurementplandetailVO.class);
        if (ProcurementplanVOList != null && ProcurementplanVOList.size() > 0) {
            for (int i = 0; i < ProcurementplanVOList.size(); i++) {
                ProcurementplandetailVO procurementplandetail = ProcurementplanVOList.get(i);
                if(procurementplandetail.getScheduleTenderTimes() != null){
                    procurementplandetail.setScheduleTenderTimesShow(DateUtils.dateSimple(procurementplandetail.getScheduleTenderTimes()));
                }
                if(procurementplandetail.getPlannedStartDate() != null){
                    procurementplandetail.setPlannedStartDateShow(DateUtils.dateSimple(procurementplandetail.getPlannedStartDate()));
                }
                if(procurementplandetail.getPlannedCompletionDate() != null){
                    procurementplandetail.setPlannedCompletionDateShow(DateUtils.dateSimple(procurementplandetail.getPlannedCompletionDate()));
                }
                String me = procurementplandetail.getTenderingMethods();
                if(procurementplandetail.getTenderingMethods() != null){
                    if(me.equals("1")){
                        procurementplandetail.setMethods("公开");
                    }else if(me.equals("2")){
                        procurementplandetail.setMethods("邀请");
                    }else if(me.equals("3")){
                        procurementplandetail.setMethods("独家议标");
                    }
                }
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", ProcurementplanVOList);
        ExcelExport.getInstance().export("Procurementplandetail-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportProcurementplandetailFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportProcurementplandetailFromPage(@RequestBody List<ProcurementplandetailVO> list, HttpServletResponse response) {
        List<ProcurementplandetailVO> concatList = new ArrayList<>();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                ProcurementplandetailVO procurementplandetailVO = list.get(i);
                if(procurementplandetailVO.getScheduleTenderTimes() != null){
                    procurementplandetailVO.setScheduleTenderTimesShow(DateUtils.dateSimple(procurementplandetailVO.getScheduleTenderTimes()));
                }
                if(procurementplandetailVO.getPlannedStartDate() != null){
                    procurementplandetailVO.setPlannedStartDateShow(DateUtils.dateSimple(procurementplandetailVO.getPlannedStartDate()));
                }
                if(procurementplandetailVO.getPlannedCompletionDate() != null){
                    procurementplandetailVO.setPlannedCompletionDateShow(DateUtils.dateSimple(procurementplandetailVO.getPlannedCompletionDate()));
                }
                String me = procurementplandetailVO.getTenderingMethods();
                if(procurementplandetailVO.getTenderingMethods() != null){
                    if(me.equals("1")){
                        procurementplandetailVO.setMethods("公开");
                    }else if(me.equals("2")){
                        procurementplandetailVO.setMethods("邀请");
                    }else if(me.equals("3")){
                        procurementplandetailVO.setMethods("独家议标");
                    }
                }
                concatList.add(procurementplandetailVO);
            }
        }

        //children拍平
        List<ProcurementplandetailVO> allList = handleList(list, concatList);

        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", allList);
        ExcelExport.getInstance().export("Procurementplandetail-export.xlsx", beans, response);
    }

    /**
     * 导出页面数据处理children
     *
     * @param list
     */
    private List<ProcurementplandetailVO> handleList(List<ProcurementplandetailVO> list, List<ProcurementplandetailVO> concatList) {
        if (list == null || list.size() == 0) {
            return concatList;
        }

        for (int i = 0; i < list.size(); i++) {
            ProcurementplandetailVO procurementplandetailVO = list.get(i);
            List<ProcurementplandetailVO> children = procurementplandetailVO.getChildren();
            if (children != null && children.size() > 0) {
                concatList.addAll(children);
                handleList(children, concatList);
            }
        }

        return concatList;
    }
}

