package com.ejianc.business.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.material.bean.*;
import com.ejianc.business.material.service.*;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.number.MathUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

@Service("materialWarehousing")
public class MaterialWarehousingBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());
	private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改
	@Autowired
	private IBillCodeApi billCodeApi;
	@Autowired
	private IMaterialWarehousingService materialWarehousingService;
	@Autowired
	private IMaterialWarehousingdetailService materialWarehousingdetailService;
	@Autowired
	private IMaterialapproachdetailService materialapproachdetailService;
	@Autowired
	private IMaterialapproachService materialapproachService;
	@Autowired
	private IFlowmeterService flowmeterService;
	@Autowired
	private IRealtimebalanceService realtimebalanceService;
	@Autowired
	private IDeliveryrecordService deliveryrecordService;
	@Autowired
	private IDeliveryrecorddetailService deliveryrecorddetailService;
	@Autowired
	private DeliveryrecordBpmServiceImpl deliveryrecordBpmServiceImpl;

	@Autowired
	private StoreService storeService;
	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	@Transactional(rollbackFor = Exception.class)
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		logger.info("---------入库--------");
		//查询入库单和入库单子表信息
		MaterialWarehousingEntity materialWarehousingEntity = materialWarehousingService.selectById(billId);
		List<MaterialWarehousingdetailEntity> materialWarehousingdetailEntities = materialWarehousingEntity.getMaterialWarehousingdetailEntities();
		BigDecimal bigDecimal = new BigDecimal(0.00);//当退供应商时汇总出库数量
		if(materialWarehousingdetailEntities != null && materialWarehousingdetailEntities.size() > 0){
			logger.info("---------不为空--------");
			for(MaterialWarehousingdetailEntity entity : materialWarehousingdetailEntities){
				if(materialWarehousingEntity.getWarehousingType() == 0){//入库
					logger.info("入库提交回写验证单进来啦");
					//根据入库单主表中的进场单id和入库单子表中的材料编码 查询进场单子表信息
					QueryWrapper<MaterialapproachdetailEntity> queryWrapper = new QueryWrapper<>();
					queryWrapper.eq("mid", materialWarehousingEntity.getMaterialapproachId());
//					queryWrapper.eq("material_code", entity.getMaterialCode());
					queryWrapper.eq("material_id", entity.getMaterialId());
					List<MaterialapproachdetailEntity> materialapproachdetailEntities = materialapproachdetailService.list(queryWrapper);
					if (materialapproachdetailEntities != null && materialapproachdetailEntities.size() > 0) {
						MaterialapproachdetailEntity materialapproachdetailEntity = materialapproachdetailEntities.get(0);
						//未入库数量 = 进场单子表中的未入库数量-入库单子表数量
						BigDecimal notStorageNum = materialapproachdetailEntity.getNotStorageNum();
						BigDecimal quantity = entity.getQuantity();
						if (notStorageNum != null && quantity != null) {
							BigDecimal notStorageNumRes = notStorageNum.subtract(quantity);
							materialapproachdetailEntity.setNotStorageNum(notStorageNumRes);
							materialapproachdetailService.updateById(materialapproachdetailEntity);
							MaterialapproachEntity materialapproachEntity = materialapproachService.getById(materialWarehousingEntity.getMaterialapproachId());
							materialapproachEntity.setNotStorageNum(materialapproachEntity.getNotStorageNum().subtract(quantity));
							materialapproachService.updateById(materialapproachEntity);
							logger.info("入库提交回写验证单修改啦");
						}
					}
				}
			}

			if(materialWarehousingEntity.getWarehousingType() == 1) {//退库
				MaterialWarehousingEntity byId = materialWarehousingService.getById(materialWarehousingEntity.getWarehouseingId());//入库单信息
				byId.setNotReturnedQuantity(byId.getNotReturnedQuantity().subtract(bigDecimal.multiply(new BigDecimal(-1.00))));
				materialWarehousingService.updateById(byId);
				logger.info("提交退供应商主表修改啦!");
			}
		}
		//TODO
		return CommonResponse.success();
	}


	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	@Transactional(rollbackFor = Exception.class)
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		logger.info("退供应商撤回--------------");
		//查询入库单和入库单子表信息
		MaterialWarehousingEntity materialWarehousingEntity = materialWarehousingService.selectById(billId);
		List<MaterialWarehousingdetailEntity> materialWarehousingdetailEntities = materialWarehousingEntity.getMaterialWarehousingdetailEntities();
		List<FlowmeterEntity> list = new ArrayList<>();//出入库流水表
		List<RealtimebalanceEntity> entityList = new ArrayList<>();//实时物资结存
		BigDecimal bigDecimal = new BigDecimal(0.00);//当退供应商时汇总出库数量
		if(materialWarehousingdetailEntities != null && materialWarehousingdetailEntities.size() > 0){
			for(MaterialWarehousingdetailEntity entity : materialWarehousingdetailEntities){
				if(materialWarehousingEntity.getWarehousingType() == 1){//退供应商
					bigDecimal = bigDecimal.add(entity.getQuantity());
					MaterialWarehousingdetailEntity byId = materialWarehousingdetailService.getById(entity.getWarehouseingDetailId());//退供应商时选中的出库单子表数据
					byId.setNotReturnedQuantity(byId.getNotReturnedQuantity().add(entity.getQuantity().multiply(new BigDecimal(-1.00))));
					materialWarehousingdetailService.updateById(byId);
					logger.info("撤回退供应商子表修改啦!");

					QueryWrapper<FlowmeterEntity> queryWrapper = new QueryWrapper<>();
					queryWrapper.eq("detail_id",entity.getId());
					FlowmeterEntity flowmeterEntity = flowmeterService.getOne(queryWrapper);
					list.add(flowmeterEntity);
					QueryWrapper<RealtimebalanceEntity> queryWrapper1 = new QueryWrapper<>();
					queryWrapper1.eq("project_id",materialWarehousingEntity.getProjectId());
					queryWrapper1.eq("material_category_code",entity.getMaterialCategoryCode());
					queryWrapper1.eq("material_code",entity.getMaterialCode());
					queryWrapper1.eq("store_id",entity.getStoreId());
					RealtimebalanceEntity realtimebalanceEntity = realtimebalanceService.getOne(queryWrapper1);
					realtimebalanceEntity.setQuantity(realtimebalanceEntity.getQuantity().subtract(entity.getQuantity()));
					realtimebalanceEntity.setAmountIncluetax(realtimebalanceEntity.getAmountIncluetax().subtract(entity.getAmountIncluetax()));
					realtimebalanceEntity.setAmountExcluetax(realtimebalanceEntity.getAmountExcluetax().subtract(entity.getAmountExcluetax()));
					if(realtimebalanceEntity.getQuantity().compareTo(BigDecimal.ZERO) != 0){
						realtimebalanceEntity.setUnitPriceIncluetax(realtimebalanceEntity.getAmountIncluetax().divide(realtimebalanceEntity.getQuantity(),8,BigDecimal.ROUND_HALF_UP));
						realtimebalanceEntity.setUnitPriceExcluetax(realtimebalanceEntity.getAmountExcluetax().divide(realtimebalanceEntity.getQuantity(),8,BigDecimal.ROUND_HALF_UP));
					}else{
						realtimebalanceEntity.setUnitPriceIncluetax(new BigDecimal(0.00));
						realtimebalanceEntity.setUnitPriceExcluetax(new BigDecimal(0.00));
					}
					entityList.add(realtimebalanceEntity);
				}else{//入库
					//根据入库单主表中的进场单id和入库单子表中的材料编码 查询进场单子表信息
					QueryWrapper<MaterialapproachdetailEntity> queryWrapper = new QueryWrapper<>();
					queryWrapper.eq("mid", materialWarehousingEntity.getMaterialapproachId());
					queryWrapper.eq("material_code", entity.getMaterialCode());
					List<MaterialapproachdetailEntity> materialapproachdetailEntities = materialapproachdetailService.list(queryWrapper);
					if (materialapproachdetailEntities != null && materialapproachdetailEntities.size() > 0) {
						MaterialapproachdetailEntity materialapproachdetailEntity = materialapproachdetailEntities.get(0);
						//未入库数量 = 进场单子表中的未入库数量-入库单子表数量
						BigDecimal notStorageNum = materialapproachdetailEntity.getNotStorageNum();
						BigDecimal quantity = entity.getQuantity();
						if (notStorageNum != null && quantity != null) {
							BigDecimal notStorageNumRes = notStorageNum.add(quantity);
							materialapproachdetailEntity.setNotStorageNum(notStorageNumRes);
						}

						materialapproachdetailService.updateById(materialapproachdetailEntity);

						MaterialapproachEntity materialapproachEntity = materialapproachService.getById(materialWarehousingEntity.getMaterialapproachId());
						materialapproachEntity.setNotStorageNum(materialapproachEntity.getNotStorageNum().add(quantity));
						materialapproachService.updateById(materialapproachEntity);
					}

				}
			}
			if(list.size() > 0){
				flowmeterService.removeByIds(list.stream().map(FlowmeterEntity::getId).collect(Collectors.toList()),true);//删除出入库流水记录表
			}
			if(entityList.size() > 0){
				realtimebalanceService.updateBatchById(entityList,entityList.size());//修改实时物资结存表
			}

			if(materialWarehousingEntity.getWarehousingType() == 1){
				MaterialWarehousingEntity byId1 = materialWarehousingService.getById(materialWarehousingEntity.getWarehouseingId());//入库单数据
				byId1.setNotReturnedQuantity(byId1.getNotReturnedQuantity().add(bigDecimal.multiply(new BigDecimal(-1.00))));
				materialWarehousingService.updateById(byId1);
				logger.info("撤回退供应商主表修改啦!");
			}
		}

		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	@Transactional
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("---------进来啦--------");
		//查询入库单和入库单子表信息
		MaterialWarehousingEntity materialWarehousingEntity = materialWarehousingService.selectById(billId);
		List<MaterialWarehousingdetailEntity> materialWarehousingdetailEntities = materialWarehousingEntity.getMaterialWarehousingdetailEntities();
		List<FlowmeterEntity> list = new ArrayList<>();//出入库流水记录表
		List<RealtimebalanceEntity> realList = new ArrayList<>();//修改实时物资结存
//		List<RealtimebalanceEntity> realList1 = new ArrayList<>();//新增实时物资结存
		DeliveryrecordEntity deliveryrecordEntity = new DeliveryrecordEntity();//出库单主表
		List<DeliveryrecorddetailEntity> detailList = new ArrayList<>();//出库单子表
		BigDecimal bigDecimal = new BigDecimal(0.00);//入库时汇总出库数量
		BigDecimal bigDecimal1 = new BigDecimal(0.00);//当直入直出时汇总出库数量
		//判断如果是直入直出的情况需要直接生成出库单
		if(materialWarehousingEntity.getWarehousingType() == 0 && materialWarehousingEntity.getAcceptanceType() != null && materialWarehousingEntity.getAcceptanceType().equals("直入直出")){
			deliveryrecordEntity.setProjectId(materialWarehousingEntity.getProjectId());
			deliveryrecordEntity.setProjectName(materialWarehousingEntity.getProjectName());
			deliveryrecordEntity.setStoreId(materialWarehousingEntity.getStoreId());
			deliveryrecordEntity.setStoreName(materialWarehousingEntity.getStoreName());
			deliveryrecordEntity.setProjectDepartmentId(materialWarehousingEntity.getProjectDepartmentId());
			deliveryrecordEntity.setProjectdeptId(materialWarehousingEntity.getAgentId());
			deliveryrecordEntity.setProjectdept(materialWarehousingEntity.getAgentName());
			deliveryrecordEntity.setBillsTime(materialWarehousingEntity.getBillsTime());
			deliveryrecordEntity.setBrands(materialWarehousingEntity.getBrands());
			deliveryrecordEntity.setPickingTime(materialWarehousingEntity.getPuinTime());
			deliveryrecordEntity.setPickingunitId(materialWarehousingEntity.getSubContractId());
			deliveryrecordEntity.setPickingUnit(materialWarehousingEntity.getSubContract());
			deliveryrecordEntity.setSignStatus(1);
			deliveryrecordEntity.setReceivingPurpose("项目使用");
			deliveryrecordEntity.setOrgId(materialWarehousingEntity.getOrgId());
			deliveryrecordEntity.setOrgName(materialWarehousingEntity.getOrgName());
			deliveryrecordEntity.setDeliveryType(0);
			if(storeService.queryStoreType(materialWarehousingEntity.getStoreId()) == 0){
				deliveryrecordEntity.setDeliveryTypes(0);
			}
			if(storeService.queryStoreType(materialWarehousingEntity.getStoreId()) == 2){
				deliveryrecordEntity.setDeliveryTypes(4);
			}

			deliveryrecordEntity.setAcceptanceType("直入直出");
			deliveryrecordEntity.setWarehousingId(materialWarehousingEntity.getId());
			deliveryrecordEntity.setBillState(3);
			deliveryrecordEntity.setStoreType(storeService.queryStoreType(materialWarehousingEntity.getStoreId()));
			CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
			if(billCode.isSuccess()) {
				deliveryrecordEntity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
			}else{
				throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
			}
		}
		//实时物资结存表
		QueryWrapper<RealtimebalanceEntity> queryWrapper1 = new QueryWrapper<>();
		queryWrapper1.eq("project_id",materialWarehousingEntity.getProjectId());
		queryWrapper1.eq("store_id",materialWarehousingEntity.getStoreId());
		List<RealtimebalanceEntity> realtimebalanceEntities = realtimebalanceService.list(queryWrapper1);
		Map<String, List<RealtimebalanceEntity>> realMap = new HashMap<>();
		if(CollectionUtils.isNotEmpty(realtimebalanceEntities)){
			realMap = realtimebalanceEntities.stream().collect(
					Collectors.groupingBy(
							s -> s.getProjectId()+'-'+s.getMaterialCode()+'-' +s.getMaterialCategoryCode() +'-'+ s.getStoreId()
					));
		}

		if(materialWarehousingEntity.getWarehousingType() == 0 && materialWarehousingdetailEntities != null && materialWarehousingdetailEntities.size() > 0){
			logger.info("---------不为空--------");
			//循环子表
			for(MaterialWarehousingdetailEntity entity : materialWarehousingEntity.getMaterialWarehousingdetailEntities()){
				if(materialWarehousingEntity.getWarehousingType() == 0){
					logger.info("入库子表进来了!");
					bigDecimal = bigDecimal.add(entity.getQuantity());
					entity.setNotReturnedQuantity(entity.getQuantity());
				}

				//出库子表
				DeliveryrecorddetailEntity deliveryrecorddetailEntity = new DeliveryrecorddetailEntity();
				if(materialWarehousingEntity.getWarehousingType() == 0 && materialWarehousingEntity.getAcceptanceType() != null && materialWarehousingEntity.getAcceptanceType().equals("直入直出")){//直入直出时才生成子表信息
					deliveryrecorddetailEntity.setMaterialCategoryId(entity.getMaterialCategoryId());
					deliveryrecorddetailEntity.setMaterialCategoryCode(entity.getMaterialCategoryCode());
					deliveryrecorddetailEntity.setMaterialCategoryName(entity.getMaterialCategoryName());
					deliveryrecorddetailEntity.setMaterialId(entity.getMaterialId());
					deliveryrecorddetailEntity.setMaterialCode(entity.getMaterialCode());
					deliveryrecorddetailEntity.setMaterialName(entity.getMaterialName());
					deliveryrecorddetailEntity.setDeliveryQuantity(entity.getQuantity());
					deliveryrecorddetailEntity.setSpecialModel(entity.getSpecialModel());
					deliveryrecorddetailEntity.setMeasurementUnit(entity.getUnit());
					deliveryrecorddetailEntity.setProjectId(entity.getProjectId());
					deliveryrecorddetailEntity.setProjectName(entity.getProjectName());
					deliveryrecorddetailEntity.setStoreId(entity.getStoreId());
					deliveryrecorddetailEntity.setStoreName(entity.getStoreName());
					deliveryrecorddetailEntity.setOrgId(entity.getOrgId());
					deliveryrecorddetailEntity.setOrgName(entity.getOrgName());
					deliveryrecorddetailEntity.setPickingTime(deliveryrecordEntity.getPickingTime());
					deliveryrecorddetailEntity.setProjectName(entity.getProjectName());
					deliveryrecorddetailEntity.setTenantId(entity.getTenantId());
//					deliveryrecorddetailEntity.setOrgId(entity.getOrgId());
					deliveryrecorddetailEntity.setUnitId(deliveryrecordEntity.getPickingunitId());
					deliveryrecorddetailEntity.setUnitName(deliveryrecordEntity.getPickingUnit());
					deliveryrecorddetailEntity.setProjectDepartmentId(entity.getProjectDepartmentId());
					deliveryrecorddetailEntity.setNotReturnedQuantity(deliveryrecorddetailEntity.getDeliveryQuantity());//直入直出时未退库数量=出库数量
					deliveryrecorddetailEntity.setPlanNum(entity.getPlanNum());
					deliveryrecorddetailEntity.setPlanSurplusNum(entity.getPlanSurplusNum());
					bigDecimal1 = bigDecimal1.add(deliveryrecorddetailEntity.getDeliveryQuantity());//未出库数量总数
				}

				//出入库流水表 只有入库审批通过推流水
				if(materialWarehousingEntity.getWarehousingType() == 0){
					FlowmeterEntity flowmeterEntity = this.createrFlowmeter(materialWarehousingEntity, entity);
					list.add(flowmeterEntity);
				}

				String key = materialWarehousingEntity.getProjectId()+'-'+entity.getMaterialCode()+'-' +entity.getMaterialCategoryCode() +'-'+ materialWarehousingEntity.getStoreId();
				if(realMap.containsKey(key)){
					RealtimebalanceEntity realtimebalanceEntity = realMap.get(key).stream().findFirst().get();
					logger.info("realtimebalanceEntity"+realtimebalanceEntity.getQuantity());

					BigDecimal quantity = ComputeUtil.safeAdd(realtimebalanceEntity.getQuantity(),(entity.getQuantity()));
//					realtimebalanceEntity.setQuantity();
					BigDecimal amountIncluetax = ComputeUtil.safeAdd(realtimebalanceEntity.getAmountIncluetax(),(entity.getAmountIncluetax()));
					BigDecimal amountExcluetax = ComputeUtil.safeAdd(realtimebalanceEntity.getAmountExcluetax(),(entity.getAmountExcluetax()));
					//					realtimebalanceEntity.setAmountIncluetax();
//					realtimebalanceEntity.setAmountExcluetax();
					BigDecimal unitPriceIncluetax = BigDecimal.ZERO;
					BigDecimal unitPriceExcluetax = BigDecimal.ZERO;
					if(quantity.compareTo(BigDecimal.ZERO) != 0){
						unitPriceIncluetax = amountIncluetax.divide(quantity,8,BigDecimal.ROUND_HALF_UP);
//						realtimebalanceEntity.setUnitPriceIncluetax();
						unitPriceExcluetax = amountExcluetax.divide(quantity,8,BigDecimal.ROUND_HALF_UP);
//						realtimebalanceEntity.setUnitPriceExcluetax();
					}
//					realList.add(realtimebalanceEntity);
					//直入直出
					if(materialWarehousingEntity.getWarehousingType() == 0 && materialWarehousingEntity.getAcceptanceType() != null && materialWarehousingEntity.getAcceptanceType().equals("直入直出")){
						deliveryrecorddetailEntity.setUnitPriceIncluetax(unitPriceIncluetax);
						deliveryrecorddetailEntity.setUnitPriceExcluetax(unitPriceExcluetax);
						deliveryrecorddetailEntity.setAmountIncluetax(deliveryrecorddetailEntity.getDeliveryQuantity().multiply(deliveryrecorddetailEntity.getUnitPriceIncluetax()));
						deliveryrecorddetailEntity.setAmountExcluetax(deliveryrecorddetailEntity.getDeliveryQuantity().multiply(deliveryrecorddetailEntity.getUnitPriceExcluetax()));
					}
				}else{
					if(materialWarehousingEntity.getWarehousingType() == 0 && materialWarehousingEntity.getAcceptanceType() != null && materialWarehousingEntity.getAcceptanceType().equals("直入直出")){//直入直出
						deliveryrecorddetailEntity.setUnitPriceIncluetax(entity.getUnitPriceIncluetax());
						deliveryrecorddetailEntity.setUnitPriceExcluetax(entity.getUnitPriceExcluetax());
						deliveryrecorddetailEntity.setAmountIncluetax(entity.getAmountIncluetax());
						deliveryrecorddetailEntity.setAmountExcluetax(entity.getAmountExcluetax());
					}
				}
				if(materialWarehousingEntity.getWarehousingType() == 0 && materialWarehousingEntity.getAcceptanceType() != null && materialWarehousingEntity.getAcceptanceType().equals("直入直出")){//直入直出
					detailList.add(deliveryrecorddetailEntity);
				}
			}

			if(materialWarehousingEntity.getWarehousingType() == 0){
				List<MaterialWarehousingdetailEntity> materialWarehousingdetailEntities1 = materialWarehousingEntity.getMaterialWarehousingdetailEntities();
				materialWarehousingdetailService.updateBatchById(materialWarehousingdetailEntities1);
			}
			if(list.size() > 0){
				flowmeterService.saveBatch(list,list.size());//保存出入库流水表 只有入库得时候 审批通过入

				flowmeterService.updateFlow(materialWarehousingEntity.getId(),new Date(),1);
				realtimebalanceService.updateRealtimeBalance(materialWarehousingEntity.getStoreId());
			}

			if(materialWarehousingEntity.getWarehousingType() == 0 ){
				materialWarehousingEntity.setNotReturnedQuantity(bigDecimal);
				materialWarehousingService.updateById(materialWarehousingEntity);
			}
			deliveryrecordEntity.setDeliveryrecorddetailEntities(detailList);
			//直入直出生成出库单,并且生成出库流水记录和修改实时物资结存
			if(materialWarehousingEntity.getWarehousingType() == 0 && materialWarehousingEntity.getAcceptanceType() != null && materialWarehousingEntity.getAcceptanceType().equals("直入直出")){
				deliveryrecordEntity.setNotDeliveryQuantity(bigDecimal1);
				BigDecimal outMnyTax = new BigDecimal("0");//出库金额含税 amountIncluetax
				BigDecimal outMny = new BigDecimal("0");//出库金额无税  amountExcluetax
				for(DeliveryrecorddetailEntity deliveryrecorddetailEntity : deliveryrecordEntity.getDeliveryrecorddetailEntities()){
					outMnyTax = ComputeUtil.safeAdd(outMnyTax,deliveryrecorddetailEntity.getAmountIncluetax());
					outMny = ComputeUtil.safeAdd(outMny,deliveryrecorddetailEntity.getAmountExcluetax());
				}
				deliveryrecordEntity.setOutMnyTax(outMnyTax);
				deliveryrecordEntity.setOutMny(outMny);
				boolean success = deliveryrecordService.saveOrUpdate(deliveryrecordEntity,false);
				//直入直出修改主表未退库数量
				if(success == true){
					List<FlowmeterEntity> list1 = new ArrayList<>();//出入库流水记录表
					List<RealtimebalanceEntity> realList2 = new ArrayList<>();//修改实时物资结存
					List<DeliveryrecorddetailEntity> deliveryrecorddetailEntity = deliveryrecordEntity.getDeliveryrecorddetailEntities();
					if(deliveryrecorddetailEntity.size() > 0 && deliveryrecorddetailEntity != null){
						for(DeliveryrecorddetailEntity entity : deliveryrecorddetailEntity){
								FlowmeterEntity flowmeterEntity = deliveryrecordBpmServiceImpl.createrFlowmeter(deliveryrecordEntity,entity,1,new Date());
								//出入库流水表
								list1.add(flowmeterEntity);
							}
					}
					if(list1.size() > 0){
						logger.info("出库记录--------出入库流水表保存");
						flowmeterService.saveBatch(list1,list1.size());
						flowmeterService.updateFlow(deliveryrecordEntity.getId(),new Date(),1);
						realtimebalanceService.updateRealtimeBalance(materialWarehousingEntity.getStoreId());
					}
				}

			}
		}

		if(materialWarehousingEntity.getWarehousingType() == 1){
			flowmeterService.updateFlow(billId,new Date(),1);
		}

		//推送供方领料单签字数据
//		if (materialWarehousingEntity.getWarehousingType() == 0 && materialWarehousingEntity.getAcceptanceType().equals("直入直出") && materialWarehousingEntity.getSelfState().equals("否")){
//			//推送供方平台
//			deliveryrecordService.pushBillToSupCenter(deliveryrecordEntity,billTypeCode);
//
//		}
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.error("该功能不支持！");
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	@Transactional(rollbackFor = Exception.class)
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("---------进来啦--------");
		//查询入库单和入库单子表信息
		MaterialWarehousingEntity materialWarehousingEntity = materialWarehousingService.selectById(billId);
		List<MaterialWarehousingdetailEntity> materialWarehousingdetailEntities = materialWarehousingEntity.getMaterialWarehousingdetailEntities();
		List<FlowmeterEntity> list = new ArrayList<>();//出入库流水表
		List<RealtimebalanceEntity> entityList = new ArrayList<>();//实时物资结存
		BigDecimal bigDecimal = new BigDecimal(0.00);
		if(materialWarehousingdetailEntities != null && materialWarehousingdetailEntities.size() > 0){
			logger.info("子表不为空!");
			for(MaterialWarehousingdetailEntity entity : materialWarehousingEntity.getMaterialWarehousingdetailEntities()){
				if(materialWarehousingEntity.getWarehousingType() == 0){//入库
					logger.info("弃审入库子表进来啦!");
					bigDecimal = bigDecimal.add(entity.getQuantity());
					entity.setNotReturnedQuantity(entity.getNotReturnedQuantity().subtract(entity.getQuantity()));
					materialWarehousingdetailService.updateById(entity);
					logger.info("弃审入库子表修改啦!");
					//根据入库单主表中的进场单id和入库单子表中的材料编码 查询进场单子表信息
					QueryWrapper<MaterialapproachdetailEntity> queryWrapper = new QueryWrapper<>();
					queryWrapper.eq("mid", materialWarehousingEntity.getMaterialapproachId());
					queryWrapper.eq("material_code", entity.getMaterialCode());
					List<MaterialapproachdetailEntity> materialapproachdetailEntities = materialapproachdetailService.list(queryWrapper);
					if (materialapproachdetailEntities != null && materialapproachdetailEntities.size() > 0) {
						MaterialapproachdetailEntity materialapproachdetailEntity = materialapproachdetailEntities.get(0);
						//未入库数量 = 进场单子表中的未入库数量-入库单子表数量
						BigDecimal notStorageNum = materialapproachdetailEntity.getNotStorageNum();
						BigDecimal quantity = entity.getQuantity();
						if (notStorageNum != null && quantity != null) {
							BigDecimal notStorageNumRes = notStorageNum.add(quantity);
							materialapproachdetailEntity.setNotStorageNum(notStorageNumRes);
						}

						materialapproachdetailService.updateById(materialapproachdetailEntity);

						MaterialapproachEntity materialapproachEntity = materialapproachService.getById(materialWarehousingEntity.getMaterialapproachId());
						materialapproachEntity.setNotStorageNum(materialapproachEntity.getNotStorageNum().add(quantity));
						materialapproachService.updateById(materialapproachEntity);
					}
				}

				if(materialWarehousingEntity.getWarehousingType() == 1){//退供应商
					logger.info("弃审退供应商子表进来啦!");
					bigDecimal = bigDecimal.add(entity.getQuantity());
					MaterialWarehousingdetailEntity byId = materialWarehousingdetailService.getById(entity.getWarehouseingDetailId());//选中退供应商时带出的入库单子表
					byId.setNotReturnedQuantity(byId.getNotReturnedQuantity().add(entity.getQuantity().multiply(new BigDecimal(-1.00))));
					materialWarehousingdetailService.updateById(byId);
					logger.info("弃审退供应商子表修改啦!");
				}
				QueryWrapper<FlowmeterEntity> queryWrapper = new QueryWrapper<>();
				queryWrapper.eq("detail_id",entity.getId());
				FlowmeterEntity flowmeterEntity = flowmeterService.getOne(queryWrapper);
				list.add(flowmeterEntity);
				QueryWrapper<RealtimebalanceEntity> queryWrapper1 = new QueryWrapper<>();
				queryWrapper1.eq("project_id",materialWarehousingEntity.getProjectId());
				queryWrapper1.eq("material_category_code",entity.getMaterialCategoryCode());
				queryWrapper1.eq("material_code",entity.getMaterialCode());
				queryWrapper1.eq("store_id",entity.getStoreId());
				RealtimebalanceEntity realtimebalanceEntity = realtimebalanceService.getOne(queryWrapper1);
				realtimebalanceEntity.setQuantity(realtimebalanceEntity.getQuantity().subtract(entity.getQuantity()));
				realtimebalanceEntity.setAmountIncluetax(realtimebalanceEntity.getAmountIncluetax().subtract(entity.getAmountIncluetax()));
				realtimebalanceEntity.setAmountExcluetax(realtimebalanceEntity.getAmountExcluetax().subtract(entity.getAmountExcluetax()));
				if(realtimebalanceEntity.getQuantity().compareTo(BigDecimal.ZERO) != 0){
					realtimebalanceEntity.setUnitPriceIncluetax(realtimebalanceEntity.getAmountIncluetax().divide(realtimebalanceEntity.getQuantity(),8,BigDecimal.ROUND_HALF_UP));
					realtimebalanceEntity.setUnitPriceExcluetax(realtimebalanceEntity.getAmountExcluetax().divide(realtimebalanceEntity.getQuantity(),8,BigDecimal.ROUND_HALF_UP));
				}else{
					realtimebalanceEntity.setUnitPriceIncluetax(new BigDecimal(0.00));
					realtimebalanceEntity.setUnitPriceExcluetax(new BigDecimal(0.00));
				}
				entityList.add(realtimebalanceEntity);
			}
			if(materialWarehousingEntity.getWarehousingType() == 0){//入库
				logger.info("弃审入库主表进来啦！");
				materialWarehousingEntity.setNotReturnedQuantity(materialWarehousingEntity.getNotReturnedQuantity().subtract(bigDecimal));
				materialWarehousingService.updateById(materialWarehousingEntity);
				logger.info("弃审入库主表修改啦！");
			}
			if(materialWarehousingEntity.getWarehousingType() == 1){//退供应商
				logger.info("弃审退供应商主表进来啦！");
				MaterialWarehousingEntity byId = materialWarehousingService.getById(materialWarehousingEntity.getWarehouseingId());//选中入库单主表数据
				byId.setNotReturnedQuantity(byId.getNotReturnedQuantity().add(bigDecimal.multiply(new BigDecimal(-1.00))));
				materialWarehousingService.updateById(byId);
				logger.info("弃审退供应商主表修改啦！");
			}
			if(list.size() > 0){
				if (materialWarehousingEntity.getWarehousingType() == 1){
					flowmeterService.updateFlow(billId,null,0);
				}else{
					flowmeterService.removeByIds(list.stream().map(FlowmeterEntity::getId).collect(Collectors.toList()),true);//删除入库流水记录表
					realtimebalanceService.updateRealtimeBalance(materialWarehousingEntity.getStoreId());

				}
			}
		/*	if(entityList.size() > 0){
				realtimebalanceService.updateBatchById(entityList,entityList.size());//修改实时物资结存表
			}*/


			//如果是直入直出删除出库单
			if(materialWarehousingEntity.getAcceptanceType() != null && materialWarehousingEntity.getAcceptanceType().equals("直入直出")){
				List<FlowmeterEntity> list1 = new ArrayList<>();
				List<RealtimebalanceEntity> realtimebalanceList = new ArrayList<>();
				QueryWrapper<DeliveryrecordEntity> queryWrapper = new QueryWrapper<>();
				queryWrapper.eq("warehousing_id",materialWarehousingEntity.getId());
				List<DeliveryrecordEntity> deliveryrecordEntity = deliveryrecordService.list(queryWrapper);
				for(DeliveryrecordEntity deliveryrecord : deliveryrecordEntity){
					QueryWrapper<DeliveryrecorddetailEntity> queryWrapper1 = new QueryWrapper<>();
					queryWrapper1.eq("mid",deliveryrecord.getId());
					List<DeliveryrecorddetailEntity> list2 = deliveryrecorddetailService.list(queryWrapper1);
					for(DeliveryrecorddetailEntity deliveryrecorddetailEntity : list2){
						QueryWrapper<FlowmeterEntity> queryWrapper2 = new QueryWrapper<>();
						queryWrapper2.eq("detail_id",deliveryrecorddetailEntity.getId());
						FlowmeterEntity flowmeterEntity = flowmeterService.getOne(queryWrapper2);
						list1.add(flowmeterEntity);
						QueryWrapper<RealtimebalanceEntity> queryWrapper3 = new QueryWrapper<>();
						queryWrapper3.eq("project_id",materialWarehousingEntity.getProjectId());
						queryWrapper3.eq("material_category_code",deliveryrecorddetailEntity.getMaterialCategoryCode());
						queryWrapper3.eq("material_code",deliveryrecorddetailEntity.getMaterialCode());
						queryWrapper3.eq("store_id",deliveryrecorddetailEntity.getStoreId());
						RealtimebalanceEntity realtimebalanceEntity = realtimebalanceService.getOne(queryWrapper3);
						realtimebalanceEntity.setQuantity(realtimebalanceEntity.getQuantity().add(deliveryrecorddetailEntity.getDeliveryQuantity()));
						realtimebalanceEntity.setAmountIncluetax(realtimebalanceEntity.getAmountIncluetax().add(deliveryrecorddetailEntity.getAmountIncluetax()));
						realtimebalanceEntity.setAmountExcluetax(realtimebalanceEntity.getAmountExcluetax().add(deliveryrecorddetailEntity.getAmountExcluetax()));
						if(realtimebalanceEntity.getQuantity().compareTo(BigDecimal.ZERO) != 0){
							realtimebalanceEntity.setUnitPriceIncluetax(realtimebalanceEntity.getAmountIncluetax().divide(realtimebalanceEntity.getQuantity(),8,BigDecimal.ROUND_HALF_UP));
							realtimebalanceEntity.setUnitPriceExcluetax(realtimebalanceEntity.getAmountExcluetax().divide(realtimebalanceEntity.getQuantity(),8,BigDecimal.ROUND_HALF_UP));
						}else{
							realtimebalanceEntity.setUnitPriceIncluetax(new BigDecimal(0.00));
							realtimebalanceEntity.setUnitPriceExcluetax(new BigDecimal(0.00));
						}
						realtimebalanceList.add(realtimebalanceEntity);
					}
				}
				if(deliveryrecordEntity.size() > 0 && deliveryrecordEntity != null){
					deliveryrecordService.removeByIds(deliveryrecordEntity.stream().map(DeliveryrecordEntity::getId).collect(Collectors.toList()),true);
				}
				if(list1.size() > 0){
					flowmeterService.removeByIds(list1.stream().map(FlowmeterEntity::getId).collect(Collectors.toList()),true);//删除出入库流水记录表
					realtimebalanceService.updateRealtimeBalance(materialWarehousingEntity.getStoreId());

				}

				/*if(realtimebalanceList.size() > 0){
					realtimebalanceService.updateBatchById(realtimebalanceList,realtimebalanceList.size());//修改实时物资结存表
				}*/
				materialWarehousingEntity.setNotReturnedQuantity(null);//将未退库数量清空
				materialWarehousingService.updateById(materialWarehousingEntity);
			}

		}
		//TODO
		return CommonResponse.success();
	}

		public FlowmeterEntity createrFlowmeter(MaterialWarehousingEntity materialWarehousingEntity,MaterialWarehousingdetailEntity entity){
			FlowmeterEntity flowmeterEntity = new FlowmeterEntity();
			flowmeterEntity.setMid(materialWarehousingEntity.getId());
			flowmeterEntity.setDetailId(entity.getId());
			flowmeterEntity.setBillCode(materialWarehousingEntity.getBillCode());
			flowmeterEntity.setProjectId(materialWarehousingEntity.getProjectId());
			flowmeterEntity.setProjectName(materialWarehousingEntity.getProjectName());
			flowmeterEntity.setStoreId(materialWarehousingEntity.getStoreId());
			flowmeterEntity.setStoreName(materialWarehousingEntity.getStoreName());
			flowmeterEntity.setSupplierName(materialWarehousingEntity.getSupplierName());
			flowmeterEntity.setMaterialId(entity.getMaterialId());
			flowmeterEntity.setMaterialCode(entity.getMaterialCode());
			flowmeterEntity.setMaterialName(entity.getMaterialName());
			flowmeterEntity.setMaterialCategoryId(entity.getMaterialCategoryId());
			flowmeterEntity.setMaterialCategoryCode(entity.getMaterialCategoryCode());
			flowmeterEntity.setMaterialCategoryName(entity.getMaterialCategoryName());
			flowmeterEntity.setBillTime(entity.getCreateTime());
			flowmeterEntity.setStoreType(storeService.queryStoreType(materialWarehousingEntity.getStoreId()));
			flowmeterEntity.setSubUnitId(materialWarehousingEntity.getSubContractId());
			flowmeterEntity.setSubUnitName(materialWarehousingEntity.getSubContract());
			flowmeterEntity.setStoreType(storeService.queryStoreType(materialWarehousingEntity.getStoreId()));
			if(materialWarehousingEntity.getWarehousingType() == 0){
				flowmeterEntity.setOperationType("入库");
				flowmeterEntity.setAccessType("入库");
				flowmeterEntity.setBillStatus(1);
				flowmeterEntity.setQuantity(entity.getQuantity());
				flowmeterEntity.setAmountIncluetax(entity.getAmountIncluetax());
				flowmeterEntity.setAmountExcluetax(entity.getAmountExcluetax());
			}else{
				flowmeterEntity.setOperationType("入库");
				flowmeterEntity.setAccessType("退供应商");
				flowmeterEntity.setBillStatus(0);
				flowmeterEntity.setQuantity(entity.getQuantity());
				flowmeterEntity.setAmountIncluetax(entity.getAmountIncluetax());
				flowmeterEntity.setAmountExcluetax(entity.getAmountExcluetax());
			}
			flowmeterEntity.setUnitPriceIncluetax(entity.getUnitPriceIncluetax());
			flowmeterEntity.setUnitPriceExcluetax(entity.getUnitPriceExcluetax());
			flowmeterEntity.setTime(materialWarehousingEntity.getPuinTime());
			flowmeterEntity.setOrgId(materialWarehousingEntity.getOrgId());
			flowmeterEntity.setOrgName(materialWarehousingEntity.getOrgName());
			flowmeterEntity.setMeasurementUnit(entity.getUnit());
			flowmeterEntity.setSpecialModel(entity.getSpecialModel());
			flowmeterEntity.setBillType(0);
			flowmeterEntity.setProjectDepartmentId(materialWarehousingEntity.getProjectDepartmentId());
			return flowmeterEntity;
		}

}
